/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.dialogues;

import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ActorsAndGoalsViewer;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.EditUseCaseAdapter;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.GoalWrapper;
import com.arcway.cockpit.usecasemodule.client.messages.Actor;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

class GoalTableContentProvider
implements IStructuredContentProvider,
ICheckStateListener {
    private final List<GoalWrapper> goals;
    private final Set<Actor> actors;
    private GoalWrapper mainGoal;
    private final GoalWrapper originalMainGoal;
    private final Set<GoalWrapper> addedGoals;
    private final Set<Actor> addedActors;
    private final Set<GoalWrapper> removedGoals;
    private final Set<GoalWrapper> modifiedGoals;
    private final CheckboxTableViewer viewer;
    private final ActorsAndGoalsViewer actorsAndGoalsViewer;
    private final EditUseCaseAdapter useCaseAdapter;
    private final boolean enabled;

    public GoalTableContentProvider(List<GoalWrapper> goals, GoalWrapper p_mainGoal, ActorsAndGoalsViewer actorsAndGoalsViewer, EditUseCaseAdapter useCaseAdapter, boolean enabled) {
        this.goals = goals;
        this.addedGoals = new HashSet<GoalWrapper>();
        this.removedGoals = new HashSet<GoalWrapper>();
        this.modifiedGoals = new HashSet<GoalWrapper>();
        this.mainGoal = p_mainGoal;
        this.originalMainGoal = p_mainGoal;
        this.viewer = actorsAndGoalsViewer.getViewer();
        this.viewer.setContentProvider((IContentProvider)this);
        this.viewer.setInput(this.goals);
        this.viewer.addCheckStateListener((ICheckStateListener)this);
        for (GoalWrapper goal : goals) {
            if (!goal.goal.isMainActor()) continue;
            this.viewer.setChecked((Object)goal, true);
            this.mainGoal = goal;
            break;
        }
        this.actors = new HashSet<Actor>();
        for (GoalWrapper goalWrapper : goals) {
            this.actors.add(goalWrapper.actor);
        }
        this.addedActors = new HashSet<Actor>();
        this.actorsAndGoalsViewer = actorsAndGoalsViewer;
        this.useCaseAdapter = useCaseAdapter;
        actorsAndGoalsViewer.initialized();
        this.enabled = enabled;
    }

    public void addActor(Actor actor) {
        this.addedActors.add(actor);
        this.actors.add(actor);
        this.actorsAndGoalsViewer.actorAdded();
    }

    public void addGoal(GoalWrapper newGoal) {
        this.addActor(newGoal.actor);
        this.goals.add(newGoal);
        if (!this.removedGoals.remove(newGoal)) {
            this.addedGoals.add(newGoal);
        }
        this.viewer.add((Object)newGoal);
        if (this.goals.size() == 1 || newGoal.isMainActor) {
            newGoal.isMainActor = true;
            this.viewer.setChecked((Object)newGoal, true);
            this.mainGoal = newGoal;
            for (GoalWrapper goal : this.goals) {
                if (!goal.isMainActor || goal == newGoal) continue;
                goal.isMainActor = false;
                this.viewer.setChecked((Object)goal, false);
            }
        }
        this.useCaseAdapter.addGoalWrapper(newGoal);
    }

    public void removeGoal(GoalWrapper goalWrapper) {
        this.goals.remove(goalWrapper);
        if (!this.addedGoals.remove(goalWrapper)) {
            this.removedGoals.add(goalWrapper);
        }
        this.modifiedGoals.remove(goalWrapper);
        this.actors.remove((Object)goalWrapper.actor);
        this.addedActors.remove((Object)goalWrapper.actor);
        this.viewer.remove((Object)goalWrapper);
        this.useCaseAdapter.removeGoalWrapper(goalWrapper);
    }

    public void modifyGoal(GoalWrapper goalWrapper) {
        if (!this.addedGoals.contains(goalWrapper)) {
            this.modifiedGoals.add(goalWrapper);
        }
        this.removedGoals.remove(goalWrapper);
        this.viewer.update((Object)goalWrapper, null);
    }

    public void setMainGoal(GoalWrapper newMainGoal) {
        if (this.mainGoal != null) {
            this.mainGoal.isMainActor = false;
        }
        if (newMainGoal != null) {
            newMainGoal.isMainActor = true;
        }
        this.mainGoal = newMainGoal;
        if (newMainGoal != null) {
            this.viewer.update((Object)newMainGoal, null);
        }
    }

    public Object[] getElements(Object inputElement) {
        return ((List)inputElement).toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Collection<GoalWrapper> getAddedGoals() {
        return this.addedGoals;
    }

    public Collection<GoalWrapper> getModifiedGoals() {
        HashSet<GoalWrapper> _modifiedGoals = new HashSet<GoalWrapper>(this.modifiedGoals);
        if (this.mainGoal != null && this.originalMainGoal != null && !this.mainGoal.equals(this.originalMainGoal)) {
            if (!this.removedGoals.contains(this.originalMainGoal)) {
                _modifiedGoals.add(this.originalMainGoal);
            }
            if (!this.addedGoals.contains(this.mainGoal) && !this.removedGoals.contains(this.mainGoal)) {
                _modifiedGoals.add(this.mainGoal);
            }
        }
        return _modifiedGoals;
    }

    public Collection<GoalWrapper> getRemovedGoals() {
        return this.removedGoals;
    }

    public GoalWrapper getCurrentMainActorsGoal() {
        return this.mainGoal;
    }

    public Collection getCurrentlyShownGoals() {
        return (Collection)this.viewer.getInput();
    }

    public Collection<Actor> getActors() {
        return this.actors;
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        GoalWrapper goal = (GoalWrapper)event.getElement();
        if (!this.enabled) {
            this.viewer.setChecked((Object)goal, !event.getChecked());
            return;
        }
        if (!event.getChecked()) {
            this.viewer.setChecked((Object)goal, true);
        } else {
            if (this.mainGoal != null) {
                if (!goal.goal.equals((Object)this.mainGoal.goal)) {
                    this.mainGoal.isMainActor = false;
                    this.viewer.setChecked((Object)this.mainGoal, false);
                    this.mainGoal = goal;
                }
            } else {
                this.mainGoal = goal;
            }
            this.mainGoal.isMainActor = true;
            this.actorsAndGoalsViewer.checkStateChanged();
        }
    }

    public Set<Actor> getAddedActors() {
        return this.addedActors;
    }
}

