/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.dialogues;

import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.EmptyCellEditor;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ExtensionTableContentProvider;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ExtensionWrapper;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ScenarioWidgetCreator;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TableColumn;

public class ExtensionTableViewer
extends TableViewer {
    private static final int FIRST_COLUMN = 0;
    private static final int COLUMN_FORKING_STEP = 1;
    private static final int COLUMN_JOINING_STEP = 2;
    private static final int JOIN_BEFORE = 0;
    private static final int JOIN_AFTER = 1;
    private static final int JOIN_END_SUCCESS = 2;
    private static final int JOIN_END_FAILURE = 3;
    private static final String JOIN_BEFORE_MSG = Messages.getString("ExtensionTableViewer.Before");
    private static final String JOIN_AFTER_MSG = Messages.getString("ExtensionTableViewer.After");
    private static final String JOIN_END_SUCCESS_MSG = Messages.getString("ExtensionTableViewer.EndSucc");
    private static final String JOIN_END_FAILURE_MSG = Messages.getString("ExtensionTableViewer.EndFail");
    private static final String[] JOIN_MSGS = new String[]{JOIN_BEFORE_MSG, JOIN_AFTER_MSG, JOIN_END_SUCCESS_MSG, JOIN_END_FAILURE_MSG};
    private static final String firstColumnsProperty = "firstColumnsProperty";
    private static final String columnPropertyFork = "forkingStep";
    private static final String columnPropertyJoin = "joiningStep";
    private List<String> columnProperties;
    private CellEditor[] cellEditors;
    private List<ActionStep> actionSteps;
    private final ScenarioWidgetCreator scenarioWidget;
    private static final String ERR_MSG = Messages.getString("ExtensionTableViewer.Err");

    public ExtensionTableViewer(Composite parent, ScenarioWidgetCreator scenarioWidget, int style) {
        super(parent, style);
        assert (scenarioWidget != null) : "callback must not be null";
        this.actionSteps = Collections.emptyList();
        this.scenarioWidget = scenarioWidget;
        this.init();
    }

    private void init() {
        this.columnProperties = Arrays.asList(firstColumnsProperty, columnPropertyFork, columnPropertyJoin);
        TableColumn useCaseColumn = new TableColumn(this.getTable(), 16384, 0);
        useCaseColumn.setText(Messages.getString("ExtensionTableViewerFromScenario.ExtText"));
        useCaseColumn.setWidth(200);
        TableColumn forkingStepColumn = new TableColumn(this.getTable(), 16384, 1);
        forkingStepColumn.setText(Messages.getString("ExtensionTableViewer.ForkingStep"));
        forkingStepColumn.setWidth(100);
        TableColumn joiningStepColumn = new TableColumn(this.getTable(), 16384, 2);
        joiningStepColumn.setText(Messages.getString("ExtensionTableViewer.JoiningStep"));
        joiningStepColumn.setWidth(200);
        this.setColumnProperties(this.columnProperties.toArray(new String[3]));
        this.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.cellEditors = new CellEditor[3];
        this.cellEditors[0] = new EmptyCellEditor();
        this.cellEditors[1] = new ComboBoxCellEditor((Composite)this.getTable(), new String[0], 8);
        this.cellEditors[2] = new ComboBoxCellEditor((Composite)this.getTable(), JOIN_MSGS, 8);
        this.setCellEditors(this.cellEditors);
        this.setCellModifier(new CellModifier());
        this.getTable().setLinesVisible(true);
        this.getTable().setHeaderVisible(true);
    }

    private String[] getLabelsForForkingStepDropDown(List<ActionStep> actionSteps_) {
        String[] actionStepsStrings = new String[actionSteps_.size() - 1];
        if (actionStepsStrings.length > 0) {
            int i = 0;
            while (i < actionSteps_.size() - 1) {
                ActionStep step = actionSteps_.get(i + 1);
                actionStepsStrings[i] = this.scenarioWidget.getStepLabel(step);
                ++i;
            }
        }
        return actionStepsStrings;
    }

    void setActionSteps(List<ActionStep> actionSteps) {
        this.actionSteps = actionSteps;
        this.cellEditors[1] = new ComboBoxCellEditor((Composite)this.getTable(), this.getLabelsForForkingStepDropDown(actionSteps));
        this.setCellEditors(this.cellEditors);
    }

    public Collection getSelectedExtensions() {
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        return new ArrayList();
    }

    private void check(ExtensionWrapper extension) {
        boolean valid = true;
        ExtensionTableContentProvider contentProvider = (ExtensionTableContentProvider)this.getContentProvider();
        Collection<ExtensionWrapper> extensions = contentProvider.getCurrentlyShownExtensions();
        Iterator<ExtensionWrapper> i = extensions.iterator();
        while (valid && i.hasNext()) {
            ExtensionWrapper element = i.next();
            if (element == extension || !element.useCase.equals((Object)extension.useCase) || !element.forkingStep.equals((Object)extension.forkingStep)) continue;
            valid = false;
        }
        if (valid) {
            this.scenarioWidget.clearErrorMessage();
        } else {
            this.scenarioWidget.setErrMsg(ERR_MSG);
        }
    }

    class CellModifier
    implements ICellModifier {
        CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return ExtensionTableViewer.this.columnProperties.indexOf(property) > 0;
        }

        public Object getValue(Object element, String property) {
            ExtensionWrapper extension = (ExtensionWrapper)element;
            switch (ExtensionTableViewer.this.columnProperties.indexOf(property)) {
                case 1: {
                    return new Integer(ExtensionTableViewer.this.actionSteps.indexOf((Object)extension.forkingStep) - 1);
                }
                case 2: {
                    if (extension.joiningStep.getNumber().getValue() == extension.forkingStep.getNumber().getValue()) {
                        return new Integer(0);
                    }
                    if (extension.joiningStep.getStepType().getValue() == 1) {
                        if (extension.joinEndType == 0) {
                            return new Integer(2);
                        }
                        return new Integer(3);
                    }
                    return new Integer(1);
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value_) {
            Object value = value_;
            ExtensionWrapper extension = element instanceof Item ? (ExtensionWrapper)((Item)element).getData() : (ExtensionWrapper)element;
            switch (ExtensionTableViewer.this.columnProperties.indexOf(property)) {
                case 1: {
                    Object currentJoiningStepValue = this.getValue(extension, (String)ExtensionTableViewer.this.columnProperties.get(2));
                    extension.forkingStep = (ActionStep)((Object)ExtensionTableViewer.this.actionSteps.get((Integer)value + 1));
                    value = currentJoiningStepValue;
                }
                case 2: {
                    int joinIndex = 0;
                    int forkIndex = ExtensionTableViewer.this.actionSteps.indexOf((Object)extension.forkingStep);
                    switch ((Integer)value) {
                        case 0: {
                            joinIndex = forkIndex;
                            if (joinIndex != ExtensionTableViewer.this.actionSteps.size() - 1) break;
                            extension.joinEndType = 0;
                            break;
                        }
                        case 1: {
                            joinIndex = Math.min(forkIndex + 1, ExtensionTableViewer.this.actionSteps.size() - 1);
                            if (joinIndex != ExtensionTableViewer.this.actionSteps.size() - 1) break;
                            extension.joinEndType = 0;
                            break;
                        }
                        case 2: {
                            joinIndex = ExtensionTableViewer.this.actionSteps.size() - 1;
                            extension.joinEndType = 0;
                            break;
                        }
                        default: {
                            joinIndex = ExtensionTableViewer.this.actionSteps.size() - 1;
                            extension.joinEndType = 1;
                        }
                    }
                    extension.joiningStep = (ActionStep)((Object)ExtensionTableViewer.this.actionSteps.get(joinIndex));
                    break;
                }
            }
            ((ExtensionTableContentProvider)ExtensionTableViewer.this.getContentProvider()).modifyExtension(extension);
            ExtensionTableViewer.this.check(extension);
        }
    }

    private class LabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof ExtensionWrapper) {
                ExtensionWrapper extension = (ExtensionWrapper)element;
                switch (columnIndex) {
                    case 0: {
                        return extension.useCase.getDisplayRepresentation();
                    }
                    case 1: {
                        return ExtensionTableViewer.this.scenarioWidget.getStepLabel(extension.forkingStep);
                    }
                    case 2: {
                        if (extension.joiningStep.getStepType().getValue() == 1) {
                            if (extension.joinEndType == 0) {
                                return Messages.getString("ExtensionTableViewer.EndSucc");
                            }
                            return Messages.getString("ExtensionTableViewer.EndFail");
                        }
                        if (extension.joiningStep.getNumber().getValue() == extension.forkingStep.getNumber().getValue()) {
                            return Messages.getString("ExtensionTableViewer.Before");
                        }
                        return Messages.getString("ExtensionTableViewer.After");
                    }
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return true;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

