/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.dialogues;

import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ExtensionTableViewer;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ExtensionWrapper;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ScenarioWidgetCreator;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ExtensionTableContentProvider
implements IStructuredContentProvider {
    private final Collection<ExtensionWrapper> currentExtensions = new HashSet<ExtensionWrapper>();
    private final Set<ExtensionWrapper> addedExtensions = new HashSet<ExtensionWrapper>();
    private final Set<ExtensionWrapper> removedExtensions = new HashSet<ExtensionWrapper>();
    private final Set<ExtensionWrapper> modifiedExtensions = new HashSet<ExtensionWrapper>();
    private final ExtensionTableViewer viewer;
    private final ScenarioWidgetCreator scenarioWidget;

    public ExtensionTableContentProvider(ExtensionTableViewer viewer, ScenarioWidgetCreator scenarioWidget) {
        this.viewer = viewer;
        viewer.setContentProvider((IContentProvider)this);
        viewer.setInput(new LinkedList());
        this.scenarioWidget = scenarioWidget;
    }

    public void addExtension(ExtensionWrapper extension) {
        this.currentExtensions.add(extension);
        if (!this.removedExtensions.remove(extension)) {
            this.addedExtensions.add(extension);
        }
        this.viewer.add(extension);
        this.scenarioWidget.handleExtensionsChanged(this.getAllActionStepsWithUseCaseExtensions());
    }

    public void addCurrentExtensions(Collection<ExtensionWrapper> extensions) {
        this.currentExtensions.addAll(extensions);
        this.viewer.add(extensions.toArray());
        this.scenarioWidget.handleExtensionsChanged(this.getAllActionStepsWithUseCaseExtensions());
    }

    public void removeExtension(ExtensionWrapper extension) {
        this.currentExtensions.remove(extension);
        if (!this.addedExtensions.remove(extension)) {
            this.removedExtensions.add(extension);
        }
        this.modifiedExtensions.remove(extension);
        this.viewer.remove(extension);
        this.scenarioWidget.handleExtensionsChanged(this.getAllActionStepsWithUseCaseExtensions());
    }

    public void modifyExtension(ExtensionWrapper extension) {
        if (!this.addedExtensions.contains(extension)) {
            this.modifiedExtensions.add(extension);
        }
        this.viewer.update(extension, null);
        this.scenarioWidget.handleExtensionsChanged(this.getAllActionStepsWithUseCaseExtensions());
    }

    public Object[] getElements(Object inputElement) {
        return ((List)inputElement).toArray();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer_, Object oldInput, Object newInput) {
    }

    public void setActionSteps(List<ActionStep> actionSteps) {
        this.viewer.setActionSteps(actionSteps);
        this.recalculateJoiningSteps(actionSteps);
        this.scenarioWidget.handleExtensionsChanged(this.getAllActionStepsWithUseCaseExtensions());
    }

    private void recalculateJoiningSteps(List<ActionStep> actionSteps) {
        for (ExtensionWrapper extension : this.currentExtensions) {
            if (extension.joinEndType != 1) continue;
            int forkingStepIndex = actionSteps.indexOf((Object)extension.forkingStep);
            extension.joiningStep = actionSteps.get(forkingStepIndex + 1);
        }
    }

    private Set<ActionStep> getAllActionStepsWithUseCaseExtensions() {
        HashSet<ActionStep> stepsWithExtension = new HashSet<ActionStep>();
        for (ExtensionWrapper extension : this.currentExtensions) {
            stepsWithExtension.add(extension.forkingStep);
            stepsWithExtension.add(extension.joiningStep);
        }
        return stepsWithExtension;
    }

    public Collection<ExtensionWrapper> getAddedExtensions() {
        return this.addedExtensions;
    }

    public Collection<ExtensionWrapper> getModifiedExtensions() {
        return this.modifiedExtensions;
    }

    public Collection<ExtensionWrapper> getRemovedExtensions() {
        return this.removedExtensions;
    }

    public Collection<ExtensionWrapper> getCurrentlyShownExtensions() {
        return this.currentExtensions;
    }
}

