/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.dialogues;

import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccessWrapper;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.AdvancedCallback;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.CallbackBridge;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IEditDialogErrorCallback;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditAgentAdvanced;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataEditPropertyAdapter;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ActorsAndGoalsViewer;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.EditScenarioAdapter;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.GoalTableContentProvider;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.GoalWrapper;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ScenarioWidgetCreator;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Actor;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.Goal;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.cockpit.usecasemodule.client.messages.description.UseCaseDescription;
import com.arcway.lib.java.collections.CollectionUtils;
import com.arcway.lib.ui.IModificationProblem;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import de.plans.lib.util.gui.elements.IUIElement;
import de.plans.lib.util.gui.elements.UIETextDropDown;
import de.plans.lib.util.gui.elements.UIETextField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class EditUseCaseAdapter
extends ModuleDataEditPropertyAdapter
implements ModifyListener,
IEditDialogErrorCallback {
    private UseCase item;
    private Collection allIDs;
    private String oldID;
    private IModelController model;
    private UIETextField idField;
    private UIETextField nameField;
    private UIETextField scopeField;
    private UIETextDropDown levelDropdown;
    private UIETextDropDown priorityDropdown;
    private UIETextDropDown stateDropDown;
    private UIETextField notesField;
    private UIETextField initiatorField;
    private List<IUIElement> fields;
    int currentErrorPriority = -1;
    private static final String ERR_MSG_NON_UNIQUE = Messages.getString("EditUseCaseAdapter.ErrMsg.NonUnique");
    private static final int PRIO_NON_UNIQUE = 0;
    private Scenario mainScenario;
    private List<ActionStep> actionSteps = new LinkedList<ActionStep>();
    private Category category;
    private ScenarioWidgetCreator widgetCreator;
    private boolean initialized = false;
    private boolean dirty = false;
    private GoalTableContentProvider goalTableContentProvider;
    private GoalWrapper mainGoal;
    private ActorsAndGoalsViewer actorsAndGoalsViewer;
    private AdvancedCallback advancedCallback;
    private List<GoalWrapper> goalWrappers;
    private final Map<Goal, Goal> map_oldGoal_newGoal = new HashMap<Goal, Goal>();
    private boolean isConversionFromExtensionScenario = false;
    private LockAccess editLock;
    private boolean isNotYetCommittedUseCase;
    private Collection existingExtendingScenarios;
    private Collection<GoalWrapper> goalsUsedInExtendingScenarios;
    private LockAccess idLock;
    private boolean isExclusiveProjectLockConflicting = false;

    public EditUseCaseAdapter(Category category) {
        super(true);
        assert (category != null) : "category must not be null";
        this.category = category;
    }

    public EditUseCaseAdapter(Category category, Scenario mainScenario, List<GoalWrapper> goalWrappers, Collection existingExtendingScenarios) {
        this(category);
        assert (existingExtendingScenarios != null) : "existingExtendingScenarios must not be null";
        this.existingExtendingScenarios = existingExtendingScenarios;
        assert (mainScenario != null) : "mainScenario must not be null";
        this.mainScenario = mainScenario;
        this.goalWrappers = this.copyGoalWrappers(goalWrappers, this.map_oldGoal_newGoal);
        this.isConversionFromExtensionScenario = true;
    }

    public EditUseCaseAdapter() {
        super(false);
    }

    private void initFields() {
        this.idField = new UIETextField(UseCaseDescription.NAME_ID, this.item.getID().getValueRangeHelper());
        this.nameField = new UIETextField(UseCaseDescription.NAME_DESCRIPTION, this.item.getName().getValueRangeHelper());
        this.scopeField = new UIETextField(UseCaseDescription.NAME_SCOPE, this.item.getScope().getValueRangeHelper());
        this.levelDropdown = new UIETextDropDown(UseCaseDescription.NAME_LEVEL, this.item.getLevel().getValueRangeHelper(Locale.getDefault()));
        this.priorityDropdown = new UIETextDropDown(UseCaseDescription.NAME_PRIORITY, this.item.getPriority().getValueRangeHelper(Locale.getDefault()));
        this.stateDropDown = new UIETextDropDown(UseCaseDescription.NAME_STATE, this.item.getState().getValueRangeHelper(Locale.getDefault()));
        this.initiatorField = new UIETextField(UseCaseDescription.NAME_INITIATOR, this.item.getInitiator().getValueRangeHelper());
        this.notesField = new UIETextField(UseCaseDescription.NAME_NOTES, this.item.getNotes().getValueRangeHelper(), true);
        this.fields = new ArrayList<IUIElement>(9);
        this.fields.add((IUIElement)this.idField);
        this.fields.add((IUIElement)this.nameField);
        this.fields.add((IUIElement)this.scopeField);
        this.fields.add((IUIElement)this.levelDropdown);
        this.fields.add((IUIElement)this.priorityDropdown);
        this.fields.add((IUIElement)this.stateDropDown);
        this.fields.add((IUIElement)this.initiatorField);
        this.fields.add((IUIElement)this.notesField);
    }

    public String getDataTypeID() {
        return "ucm.useCase";
    }

    public IModuleDataTypeDescriptionForFrame getCockpitDataType() {
        return UseCaseDescription.MODULEDATATYPEDESCRIPTION_FORFRAME;
    }

    public Class getDataClass() {
        return UseCase.class;
    }

    public String getPropertyName() {
        return UseCaseDescription.MODULE_DATA_NAME;
    }

    protected ImageDescriptorRegistry getImageDescriptorRegistry() {
        return UseCaseModulePlugin.getDefault().getImageDescriptorRegistry();
    }

    public ImageDescriptor getPropertyImageDescriptor() {
        return UseCaseModulePlugin.getImageDescriptor("UseCase.gif");
    }

    public Composite createEditPage_internal(Composite parent) {
        TabFolder page = new TabFolder(parent, 0);
        GridData gd = new GridData(4, 4, true, true);
        page.setLayoutData((Object)gd);
        TabItem generalItem = new TabItem(page, 0);
        generalItem.setText(Messages.getString("EditUseCaseAdapter.USE_CASE-ATTRIBUTES"));
        Composite genComp = new Composite((Composite)page, 0);
        gd = new GridData(4, 4, true, true);
        genComp.setLayoutData((Object)gd);
        genComp.setLayout((Layout)new GridLayout());
        generalItem.setControl((Control)genComp);
        this.createGeneralPart(genComp);
        TabItem scenarioGeneralItem = new TabItem(page, 0);
        scenarioGeneralItem.setControl(this.widgetCreator.createGeneralPart((Composite)page));
        scenarioGeneralItem.setText(Messages.getString("EditUseCaseAdapter.scenarioGeneralItem.Title"));
        TabItem scenarioItem = new TabItem(page, 0);
        scenarioItem.setText(Messages.getString("EditUseCaseAdapter.MAIN_SCENARIO"));
        scenarioItem.setControl(this.createScenarioPart((Composite)page));
        this.connectCallbacks();
        this.setValues();
        this.setWidgetState();
        this.addListener();
        this.getCallback().setChangedStatus(false);
        return page;
    }

    private void connectCallbacks() {
        this.advancedCallback = new AdvancedCallback((IEditDialogErrorCallback)this);
        CallbackBridge scenarioCallback = new CallbackBridge((Object)this.widgetCreator, (IModuleDataEditAgentAdvanced)this.advancedCallback);
        CallbackBridge goalCallback = new CallbackBridge((Object)this.actorsAndGoalsViewer, (IModuleDataEditAgentAdvanced)this.advancedCallback);
        Object[] callers = new Object[]{this, scenarioCallback, goalCallback};
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        int[] priorities = nArray;
        String[] names = new String[]{Messages.getString("EditUseCaseAdapter.USE_CASE-ATTRIBUTES"), Messages.getString("ScenarioWidgetCreator.TabTitle.ActionSteps"), Messages.getString("EditUseCaseAdapter.actorsGroup.Title")};
        this.advancedCallback.init(callers, priorities, names);
        this.widgetCreator.setCallback((IEditDialogErrorCallback)scenarioCallback);
        this.actorsAndGoalsViewer.setCallback((IEditDialogErrorCallback)goalCallback);
    }

    private boolean initScenario() {
        if (this.isCreationDialogue() && !this.isConversionFromExtensionScenario) {
            this.mainScenario = new Scenario();
            this.mainScenario.setProjectUID(this.item.getProjectUID());
            ActionStep beginningStep = new ActionStep();
            beginningStep.setProjectUID(this.item.getProjectUID());
            beginningStep.getStepType().setValue(0);
            beginningStep.getTitle().setValue("[Virtual Action Step]");
            ActionStep finalStep = new ActionStep();
            finalStep.setProjectUID(this.item.getProjectUID());
            finalStep.getStepType().setValue(1);
            finalStep.getTitle().setValue("[Virtual Action Step]");
            this.actionSteps.add(beginningStep);
            this.actionSteps.add(finalStep);
            this.existingExtendingScenarios = new ArrayList();
        } else {
            if (!this.isConversionFromExtensionScenario) {
                this.mainScenario = ((ModelController)this.model).getMainScenario(this.item);
                this.existingExtendingScenarios = ((ModelController)this.model).getExtendingScenarios(this.mainScenario);
            }
            this.actionSteps = new LinkedList<ActionStep>(((ModelController)this.model).getActionSteps(this.mainScenario));
        }
        HashMap<ActionStep, GoalWrapper> map_Step_Goal = new HashMap<ActionStep, GoalWrapper>(this.actionSteps.size() - 2);
        for (ActionStep step : this.actionSteps) {
            if (step.getStepType().getValue() != 2) continue;
            Goal goal = (Goal)((Object)this.model.getLinkableObjects((IModuleData)step, "ActionStepGoal").iterator().next());
            Actor actor = (Actor)((Object)this.model.getLinkableObjects((IModuleData)goal, "GoalActor").iterator().next());
            if (this.isConversionFromExtensionScenario) {
                goal = this.map_oldGoal_newGoal.get((Object)goal);
            }
            GoalWrapper goalWrapper = new GoalWrapper(actor, goal);
            map_Step_Goal.put(step, goalWrapper);
        }
        this.widgetCreator = new ScenarioWidgetCreator(this.mainScenario, this.model, this.actionSteps, this.isCreationDialogue() && !this.isConversionFromExtensionScenario, (PermissionMgr)this.model.getPermissionMgr(), this.category, this.isCreationDialogue() ? null : this.item, this.isConversionFromExtensionScenario ? new ArrayList<GoalWrapper>() : new ArrayList<GoalWrapper>(this.goalWrappers), map_Step_Goal, this);
        return this.widgetCreator.init();
    }

    private List<GoalWrapper> copyGoalWrappers(List<GoalWrapper> oldGoals, Map<Goal, Goal> goalMapping) {
        ArrayList<GoalWrapper> newGoals = new ArrayList<GoalWrapper>(oldGoals.size());
        for (GoalWrapper oldGoal : oldGoals) {
            Goal newGoal = (Goal)oldGoal.goal.copy(false);
            goalMapping.put(oldGoal.goal, newGoal);
            Actor actor = oldGoal.actor;
            newGoals.add(new GoalWrapper(actor, newGoal));
        }
        return newGoals;
    }

    private void addListener() {
        for (IUIElement element : this.fields) {
            element.addModifyListener((ModifyListener)this);
        }
    }

    private void createWidget(IUIElement element, String name, Composite parent, int heightHint) {
        Composite composite = new Composite(parent, 0);
        if (heightHint > 0) {
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
        } else {
            composite.setLayoutData((Object)new GridData(768));
        }
        composite.setLayout((Layout)new GridLayout(1, false));
        this.createLabel(composite, String.valueOf(name) + ":", 1);
        Control widget = element.getControl(composite);
        GridData gridData = new GridData(4, 128, true, false);
        if (heightHint > 0) {
            gridData.heightHint = heightHint;
            gridData.grabExcessVerticalSpace = true;
        }
        widget.setLayoutData((Object)gridData);
    }

    private Control createGeneralPart(Composite parent) {
        Group generalPart = new Group(parent, 0);
        GridLayout gridLayout = new GridLayout(2, true);
        generalPart.setLayout((Layout)gridLayout);
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumWidth = 600;
        generalPart.setLayoutData((Object)gd);
        Composite categoryComposite = new Composite((Composite)generalPart, 0);
        categoryComposite.setLayout((Layout)new GridLayout(1, false));
        categoryComposite.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.createCategoryWidget(categoryComposite, 2, (IModuleData)this.item);
        this.createWidget((IUIElement)this.idField, UseCaseDescription.NAME_ID, (Composite)generalPart, 0);
        this.createWidget((IUIElement)this.levelDropdown, UseCaseDescription.NAME_LEVEL, (Composite)generalPart, 0);
        this.createWidget((IUIElement)this.scopeField, UseCaseDescription.NAME_SCOPE, (Composite)generalPart, 0);
        this.createWidget((IUIElement)this.priorityDropdown, UseCaseDescription.NAME_PRIORITY, (Composite)generalPart, 0);
        this.createWidget((IUIElement)this.nameField, UseCaseDescription.NAME_DESCRIPTION, (Composite)generalPart, 0);
        this.createWidget((IUIElement)this.stateDropDown, UseCaseDescription.NAME_STATE, (Composite)generalPart, 0);
        Composite initiatorComposite = new Composite((Composite)generalPart, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalIndent = -5;
        gridData.horizontalIndent = -5;
        initiatorComposite.setLayoutData((Object)gridData);
        initiatorComposite.setLayout((Layout)new GridLayout());
        this.createWidget((IUIElement)this.initiatorField, UseCaseDescription.NAME_INITIATOR, initiatorComposite, 0);
        this.createWidget((IUIElement)this.notesField, UseCaseDescription.NAME_NOTES, (Composite)generalPart, 100);
        this.createActorsAndGoals(generalPart);
        return generalPart;
    }

    private void createActorsAndGoals(Group generalPart) {
        Group actorsGroup = new Group((Composite)generalPart, 0);
        actorsGroup.setText(Messages.getString("EditUseCaseAdapter.actorsGroup.Title"));
        actorsGroup.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(4, 4, true, true);
        gridData.horizontalSpan = 2;
        actorsGroup.setLayoutData((Object)gridData);
        HashSet<Goal> goalsUsedInExtendingScenarios_raw = new HashSet<Goal>();
        for (Scenario scenario : this.existingExtendingScenarios) {
            goalsUsedInExtendingScenarios_raw.addAll(((ModelController)this.model).getAllUsedGoals(scenario));
        }
        this.goalsUsedInExtendingScenarios = new HashSet<GoalWrapper>(goalsUsedInExtendingScenarios_raw.size());
        for (Goal goal : goalsUsedInExtendingScenarios_raw) {
            Actor actor = ((ModelController)this.model).getActor(goal);
            if (this.isConversionFromExtensionScenario) {
                goal = this.map_oldGoal_newGoal.get((Object)goal);
            }
            this.goalsUsedInExtendingScenarios.add(new GoalWrapper(actor, goal));
        }
        HashSet<GoalWrapper> allUsedGoals = new HashSet<GoalWrapper>(this.goalsUsedInExtendingScenarios);
        if (!this.isCreationDialogue() || this.isConversionFromExtensionScenario) {
            for (Goal goal : ((ModelController)this.model).getAllUsedGoals(this.mainScenario)) {
                Actor actor = (Actor)((Object)this.model.getLinkableObjects((IModuleData)goal, "GoalActor").iterator().next());
                if (this.isConversionFromExtensionScenario) {
                    goal = this.map_oldGoal_newGoal.get((Object)goal);
                }
                allUsedGoals.add(new GoalWrapper(actor, goal));
            }
        }
        PermissionMgr permissionMgr = (PermissionMgr)this.model.getPermissionMgr();
        boolean enabled = this.isNotYetCommittedUseCase || this.editLock.hasLock() && permissionMgr.mayEditAttribute((IModuleData)this.item, (IModuleData)this.category, "ucm.step.Actor") && (this.isNotYetCommittedUseCase || this.editLock.hasLock());
        this.actorsAndGoalsViewer = new ActorsAndGoalsViewer((Composite)actorsGroup, this.model.getProjectUID(), this.model, this, enabled);
        this.goalTableContentProvider = new GoalTableContentProvider(this.isConversionFromExtensionScenario ? new LinkedList() : new ArrayList<GoalWrapper>(this.goalWrappers), this.isConversionFromExtensionScenario ? null : this.mainGoal, this.actorsAndGoalsViewer, this, enabled);
        this.actorsAndGoalsViewer.setUsedActors(allUsedGoals);
    }

    public void actorStateChanged(Collection<GoalWrapper> usedActors) {
        HashSet<GoalWrapper> actors = new HashSet<GoalWrapper>(usedActors);
        actors.addAll(this.goalsUsedInExtendingScenarios);
        this.actorsAndGoalsViewer.setUsedActors(actors);
    }

    private void initActorsAndGoals() {
        this.mainGoal = null;
        if (!this.isCreationDialogue()) {
            Collection goals = this.model.getModuleData((IModuleData)this.item, "GoalUseCase");
            this.goalWrappers = new ArrayList<GoalWrapper>(goals.size());
            for (Goal goal : goals) {
                Actor actor = (Actor)((Object)this.model.getLinkableObjects((IModuleData)goal, "GoalActor").iterator().next());
                GoalWrapper goalWrapper = new GoalWrapper(actor, goal);
                this.goalWrappers.add(goalWrapper);
                if (!goal.isMainActor()) continue;
                this.mainGoal = goalWrapper;
            }
        } else if (this.isConversionFromExtensionScenario) {
            Iterator<GoalWrapper> i = this.goalWrappers.iterator();
            while (i.hasNext() && this.mainGoal == null) {
                GoalWrapper goalWrapper = i.next();
                if (!goalWrapper.isMainActor) continue;
                this.mainGoal = goalWrapper;
            }
        } else {
            this.goalWrappers = new LinkedList<GoalWrapper>();
        }
        Collections.sort(this.goalWrappers, new Comparator<GoalWrapper>(){

            @Override
            public int compare(GoalWrapper g1, GoalWrapper g2) {
                return g1.actor.getDisplayRepresentation().compareTo(g2.actor.getDisplayRepresentation());
            }
        });
    }

    private Control createScenarioPart(Composite parent) {
        return this.widgetCreator.createControl(parent, this);
    }

    private void getValues() {
        this.widgetCreator.getValues();
        this.idField.getValue();
        this.nameField.getValue();
        this.scopeField.getValue();
        this.levelDropdown.getValue();
        this.priorityDropdown.getValue();
        this.priorityDropdown.getValue();
        this.stateDropDown.getValue();
        this.initiatorField.getValue();
        this.notesField.getValue();
    }

    private void setValues() {
        for (IUIElement element : this.fields) {
            element.setValue();
        }
        if (this.isConversionFromExtensionScenario) {
            for (GoalWrapper goal : this.goalWrappers) {
                this.goalTableContentProvider.addGoal(goal);
            }
            this.actorsAndGoalsViewer.check(null);
        }
        this.widgetCreator.setValues();
        this.initialized = true;
        this.dirty = false;
        this.getCallback().setChangedStatus(false);
        this.checkFields();
    }

    public void modifyText(ModifyEvent e) {
        this.checkFields();
        if (!this.dirty) {
            if (this.initialized) {
                this.dirty = true;
                this.getCallback().setChangedStatus(true);
            }
            this.widgetCreator.check();
            this.actorsAndGoalsViewer.check(null);
        }
    }

    private void checkFields() {
        if (!this.initialized) {
            return;
        }
        String errorMessage = "";
        this.currentErrorPriority = -1;
        if (errorMessage.length() == 0 && this.allIDs.contains(this.idField.getCurrentValue().trim())) {
            errorMessage = ERR_MSG_NON_UNIQUE;
        }
        if (errorMessage.length() == 0) {
            for (IUIElement element : this.fields) {
                String elementsMessage = element.checkCurrentValue();
                if (elementsMessage != null) {
                    errorMessage = elementsMessage;
                }
                if (errorMessage.length() > 0) break;
            }
        }
        if (errorMessage.length() > 0) {
            this.advancedCallback.setErrMsg(errorMessage, (Object)this);
        } else {
            this.advancedCallback.clearErrorMessage((Object)this);
        }
        if (this.isExclusiveProjectLockConflicting) {
            this.advancedCallback.setExclusiveProjectLockConflicting((Object)this);
        } else {
            this.advancedCallback.clearExclusiveProjectLockConflicting((Object)this);
        }
    }

    private void setWidgetState() {
        PermissionMgr permissionMgr = (PermissionMgr)this.model.getPermissionMgr();
        this.setCategoryEditable(this.isNotYetCommittedUseCase || this.editLock.hasLock() && permissionMgr.mayEditItemStructurally((IModuleData)this.item, (IModuleData)this.category));
        this.idField.setEditable(this.isNotYetCommittedUseCase || this.editLock.hasLock() && permissionMgr.mayEditAttribute((IModuleData)this.item, (IModuleData)this.category, "ucm.useCase.id"));
        this.nameField.setEditable(this.isNotYetCommittedUseCase || this.editLock.hasLock() && permissionMgr.mayEditAttribute((IModuleData)this.item, (IModuleData)this.category, "ucm.useCase.description"));
        this.scopeField.setEditable(permissionMgr.mayEditAttribute((IModuleData)this.item, (IModuleData)this.category, "ucm.useCase.scope") && (this.isNotYetCommittedUseCase || this.editLock.hasLock()));
        this.levelDropdown.setEnabled(permissionMgr.mayEditAttribute((IModuleData)this.item, (IModuleData)this.category, "ucm.useCase.level") && (this.isNotYetCommittedUseCase || this.editLock.hasLock()));
        this.priorityDropdown.setEnabled(permissionMgr.mayEditAttribute((IModuleData)this.item, (IModuleData)this.category, "ucm.useCase.priority") && (this.isNotYetCommittedUseCase || this.editLock.hasLock()));
        this.stateDropDown.setEnabled(permissionMgr.mayEditAttribute((IModuleData)this.item, (IModuleData)this.category, "ucm.useCase.state") && (this.isNotYetCommittedUseCase || this.editLock.hasLock()));
        this.notesField.setEditable(permissionMgr.mayEditAttribute((IModuleData)this.item, (IModuleData)this.category, "ucm.useCase.notes") && (this.isNotYetCommittedUseCase || this.editLock.hasLock()));
        this.initiatorField.setEditable(permissionMgr.mayEditAttribute((IModuleData)this.item, (IModuleData)this.category, "ucm.useCase.initiator") && (this.isNotYetCommittedUseCase || this.editLock.hasLock()));
        this.widgetCreator.setWidgetState(this);
    }

    public IModificationProblem setItems(IModuleData[] items, IModuleData[] parents) {
        if (items.length == 1) {
            IModuleData item0 = items[0];
            assert (item0 instanceof UseCase);
            this.item = (UseCase)item0;
            this.model = this.getModelController(item0);
            boolean bl = this.isNotYetCommittedUseCase = this.isCreationDialogue() || this.model.isNew((ICockpitProjectData)this.item);
            if (!this.isNotYetCommittedUseCase) {
                this.editLock = this.model.getLockMgr().acquireEditLock((ICockpitProjectData)item0, false);
                if (this.editLock.hasLock() && (item0 = this.model.getItem("ucm.useCase", item0.getUID())) == null) {
                    return this.getModificationProblemItemDeleted();
                }
            }
            if (!this.isCreationDialogue()) {
                this.category = (Category)((Object)this.model.getLinkableObjects(item0, "UseCaseCategory").iterator().next());
            }
            this.allIDs = this.getAllIDs();
            if (!this.isCreationDialogue()) {
                this.oldID = this.item.getID().getValue();
            } else {
                LockAccessWrapper lockAccessWrapper = new LockAccessWrapper();
                try {
                    this.oldID = this.model.generateNewID(this.item.getTypeDescription(), 0, (IModuleData)this.category, true, lockAccessWrapper);
                    this.item.getID().setValue(this.oldID);
                    this.idLock = lockAccessWrapper.getLockAccess();
                    this.isExclusiveProjectLockConflicting = false;
                }
                catch (EXCockpitLockDenied e) {
                    this.isExclusiveProjectLockConflicting = true;
                }
            }
            this.initFields();
            this.initActorsAndGoals();
            boolean success = this.initScenario();
            if (!success) {
                return this.getModificationProblemItemDeleted();
            }
        }
        return null;
    }

    private Set<String> getAllIDs() {
        Collection allUseCases = this.model.getAllItems("ucm.useCase");
        HashSet<String> returnIDs = new HashSet<String>(allUseCases.size());
        for (UseCase element : allUseCases) {
            returnIDs.add(element.getID().getDisplayStringRepresentation());
        }
        returnIDs.remove(this.item.getID().getDisplayStringRepresentation());
        return returnIDs;
    }

    public boolean isMultipleEditPossible() {
        return false;
    }

    protected IModelController getModelController(IModuleData p_item) {
        return UseCaseModulePlugin.getDefault().getProjectManager().getModelController(p_item.getProjectUID());
    }

    public void setErrMsg(String errorMessage) {
        if (!this.dirty) {
            this.getCallback().setCommitable(false);
        } else {
            this.getCallback().setErrMsg(errorMessage);
        }
    }

    public void clearErrorMessage() {
        this.getCallback().clearErrorMessage();
    }

    public void setChangedStatus(boolean hasChanged) {
    }

    public void setCommitable(boolean commitable) {
        this.getCallback().setCommitable(commitable);
    }

    public void addGoalWrapper(GoalWrapper goalWrapper) {
        this.widgetCreator.addGoalWrapper(goalWrapper);
    }

    public void removeGoalWrapper(GoalWrapper goalWrapper) {
        this.widgetCreator.removeGoalWrapper(goalWrapper);
    }

    public void setMessage(String message, int type) {
        if (type == 3) {
            this.setErrMsg(message);
        } else {
            this.getCallback().setMessage(message, type);
        }
    }

    public void actorsNamesChanged() {
        this.widgetCreator.actorsNamesChanged();
    }

    void actorsAvailable(boolean actorsAvailable) {
        this.widgetCreator.enablePlusButton(actorsAvailable);
    }

    public void cancelChanges1() {
        if (!this.isNotYetCommittedUseCase) {
            this.editLock.releaseLocks();
        }
        this.widgetCreator.cancelChanges();
    }

    public Collection<IModificationProblem> requestCommit() {
        String newID = this.idField.getCurrentValue().trim();
        if (!newID.equals(this.oldID)) {
            if (this.isCreationDialogue() && this.oldID != null) {
                this.idLock.releaseAllLocks();
            }
            AbstractLockManager lockManager = this.model.getLockMgr();
            this.idLock = lockManager.acquireUniqueIDLock(newID, "ucm.useCase");
            if (!this.idLock.hasLock()) {
                this.isExclusiveProjectLockConflicting = this.idLock.isExclusiveProjectLockConflicting();
                if (!this.isExclusiveProjectLockConflicting) {
                    return Arrays.asList(new ModificationProblem(Messages.getString("EditUseCaseAdapter.IDInUseErrText"), Messages.getString("EditUseCaseAdapter.UseCaseCantBesavedWithThisID")));
                }
                return Arrays.asList(new ModificationProblem(com.arcway.cockpit.modulelib2.client.Messages.getString((String)"CreationAction.ExclusiveProjectLock.Message"), com.arcway.cockpit.modulelib2.client.Messages.getString((String)"CreationAction.ExclusiveProjectLock.Title")));
            }
            this.isExclusiveProjectLockConflicting = false;
        }
        return Collections.EMPTY_LIST;
    }

    public void rollbackCommitRequest() {
        this.idLock.releaseLocks();
    }

    public void setDirty() {
        this.dirty = true;
        this.getCallback().setChangedStatus(true);
    }

    protected void doCommitChanges() {
        Actor oldActor;
        this.getValues();
        String newID = this.idField.getCurrentValue().trim();
        if (!this.isCreationDialogue() && !newID.equals(this.oldID)) {
            AbstractLockManager abstractLockManager = this.model.getLockMgr();
            abstractLockManager.releaseUniqueIdLock("ucm.useCase", this.oldID);
        }
        if (this.isCreationDialogue()) {
            this.model.addItem((IModuleData)this.item);
            this.model.createLink(this.category.getUID(), (IModuleData)this.item, "UseCaseCategory");
        } else {
            this.model.itemPropertiesModified((IModuleData)this.item, null);
        }
        for (Actor actor : this.goalTableContentProvider.getAddedActors()) {
            if (this.model.itemExists("ucm.Actor", actor.getUID())) continue;
            this.model.addItem((IModuleData)actor);
        }
        for (GoalWrapper goalWrapper : this.goalTableContentProvider.getAddedGoals()) {
            goalWrapper.goal.getMainActor().setValue(goalWrapper.isMainActor);
            this.model.addItem((IModuleData)goalWrapper.goal);
            this.model.createLink(goalWrapper.actor.getUID(), (IModuleData)goalWrapper.goal, "GoalActor");
            this.model.createLink(this.item.getUID(), (IModuleData)goalWrapper.goal, "GoalUseCase");
        }
        for (GoalWrapper goalWrapper : this.goalTableContentProvider.getModifiedGoals()) {
            goalWrapper.goal.getMainActor().setValue(goalWrapper.isMainActor);
            oldActor = (Actor)((Object)this.model.getLinkableObjects((IModuleData)goalWrapper.goal, "GoalActor").iterator().next());
            if (!oldActor.equals((Object)goalWrapper.actor)) {
                this.model.deleteLink(oldActor.getUID(), goalWrapper.goal.getUID(), "GoalActor");
                this.model.createLink(goalWrapper.actor.getUID(), (IModuleData)goalWrapper.goal, "GoalActor");
            }
            this.model.itemPropertiesModified((IModuleData)goalWrapper.goal, null);
        }
        EditScenarioAdapter.commitScenarioRelatedChanges(this.widgetCreator, this.mainScenario, this.isCreationDialogue() && !this.isConversionFromExtensionScenario, null, this.model);
        if (this.isCreationDialogue()) {
            if (this.isConversionFromExtensionScenario) {
                this.model.deleteLink((EOLink)this.model.getLinksForModuleDataItem((IModuleData)this.mainScenario, "ScenarioBeginningStep").iterator().next());
                this.model.deleteLink((EOLink)this.model.getLinksForModuleDataItem((IModuleData)this.mainScenario, "ScenarioFinalStep").iterator().next());
            }
            this.model.createLink(this.item.getUID(), (IModuleData)this.mainScenario, "MainScenarioUseCase");
        }
        for (GoalWrapper goalWrapper : this.goalTableContentProvider.getRemovedGoals()) {
            oldActor = (Actor)((Object)this.model.getLinkableObjects((IModuleData)goalWrapper.goal, "GoalActor").iterator().next());
            this.model.deleteLink(oldActor.getUID(), goalWrapper.goal.getUID(), "GoalActor");
            this.model.deleteItem((IModuleData)goalWrapper.goal);
        }
        if (this.isConversionFromExtensionScenario) {
            for (Map.Entry entry : this.map_oldGoal_newGoal.entrySet()) {
                Collection concernedActionSteps = CollectionUtils.getTypedCollection((Collection)this.model.getModuleData((IModuleData)entry.getKey(), "ActionStepGoal"), ActionStep.class);
                for (ActionStep concernedActionStep : concernedActionSteps) {
                    if (!((ModelController)this.model).getUseCase(concernedActionStep).equals((Object)this.item)) continue;
                    this.model.deleteLink(((Goal)((Object)entry.getKey())).getUID(), concernedActionStep.getUID(), "ActionStepGoal");
                    this.model.createLink(((Goal)((Object)entry.getValue())).getUID(), (IModuleData)concernedActionStep, "ActionStepGoal");
                }
            }
        }
    }

    protected IModelController getModel() {
        return this.model;
    }

    protected AbstractModulePlugin getPlugin() {
        return UseCaseModulePlugin.getDefault();
    }

    public ImageDescriptor getDialogImageDescriptor() {
        return UseCaseModulePlugin.getImageDescriptor("UseCase_big.gif");
    }

    public UseCase getUseCase() {
        return this.item;
    }
}

