/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.dialogues;

import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IEditDialogErrorCallback;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataEditPropertyAdapter;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ActionStepInEditDialogue;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ExtensionWrapper;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.GoalWrapper;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.ScenarioWidgetCreator;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Actor;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.Extension;
import com.arcway.cockpit.usecasemodule.client.messages.Goal;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.cockpit.usecasemodule.client.messages.description.ScenarioDescription;
import com.arcway.lib.java.collections.CollectionUtils;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.ui.IModificationProblem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Composite;

public class EditScenarioAdapter
extends ModuleDataEditPropertyAdapter
implements IEditDialogErrorCallback {
    private static final ILogger logger = Logger.getLogger(EditScenarioAdapter.class);
    private Scenario item;
    private ModelController model;
    private ScenarioWidgetCreator widgetCreator;
    private List<ActionStep> actionSteps;
    private Scenario parent;
    private ActionStep startingStep = null;
    private boolean isMainScenario;

    public EditScenarioAdapter(boolean isNew) {
        super(isNew);
    }

    public EditScenarioAdapter(Scenario parent, ActionStep extensionStartingStep) {
        super(true);
        assert (parent != null) : "parent must not be null";
        this.parent = parent;
        this.startingStep = extensionStartingStep;
        this.isMainScenario = false;
    }

    public String getDataTypeID() {
        return "ucm.Scenario";
    }

    public IModuleDataTypeDescriptionForFrame getCockpitDataType() {
        return ScenarioDescription.MODULEDATATYPEDESCRIPTION_FORFRAME;
    }

    public Class getDataClass() {
        return Scenario.class;
    }

    public String getPropertyName() {
        return ScenarioDescription.MODULE_DATA_NAME;
    }

    protected ImageDescriptorRegistry getImageDescriptorRegistry() {
        return UseCaseModulePlugin.getDefault().getImageDescriptorRegistry();
    }

    public ImageDescriptor getPropertyImageDescriptor() {
        return UseCaseModulePlugin.getImageDescriptor("Scenario.gif");
    }

    public Composite createEditPage_internal(Composite parentComposite) {
        Composite control = this.widgetCreator.createControl(parentComposite, this);
        this.widgetCreator.setValues();
        this.widgetCreator.setWidgetState(this);
        return control;
    }

    private boolean init() {
        UseCase useCase = null;
        useCase = !this.isCreationDialogue() ? this.model.getUseCase(this.item) : this.model.getUseCase(this.parent);
        Collection goals = this.model.getModuleData((IModuleData)useCase, "GoalUseCase");
        ArrayList<GoalWrapper> goalWrappers = new ArrayList<GoalWrapper>(goals.size());
        for (Goal goal : goals) {
            Actor actor = this.model.getActor(goal);
            goalWrappers.add(new GoalWrapper(actor, goal));
        }
        HashMap<ActionStep, GoalWrapper> map_step_goal = new HashMap<ActionStep, GoalWrapper>(this.actionSteps.size() - 2);
        for (ActionStep step : this.actionSteps) {
            if (step.getStepType().getValue() != 2) continue;
            Goal goal = (Goal)((Object)this.model.getLinkableObjects((IModuleData)step, "ActionStepGoal").iterator().next());
            Actor actor = (Actor)((Object)this.model.getLinkableObjects((IModuleData)goal, "GoalActor").iterator().next());
            GoalWrapper goalWrapper = new GoalWrapper(actor, goal);
            map_step_goal.put(step, goalWrapper);
        }
        Category category = this.isCreationDialogue() ? (Category)this.model.getParent((IModuleData)this.model.getUseCase(this.parent)) : (Category)this.model.getParent((IModuleData)this.model.getUseCase(this.item));
        this.widgetCreator = new ScenarioWidgetCreator(this.item, this.isMainScenario, (IModelController)this.model, this.actionSteps, this.isCreationDialogue(), (PermissionMgr)this.model.getPermissionMgr(), category, useCase, goalWrappers, map_step_goal);
        boolean success = this.widgetCreator.init();
        if (success) {
            this.widgetCreator.setCallback(this);
            if (this.isCreationDialogue()) {
                this.widgetCreator.setParentScenario(this.parent, this.startingStep);
            }
            return true;
        }
        return false;
    }

    public void setErrMsg(String errorMessage) {
        if (errorMessage.length() == 0) {
            this.getCallback().clearErrorMessage();
        }
        this.getCallback().setErrMsg(errorMessage);
    }

    public void clearErrorMessage() {
        this.getCallback().clearErrorMessage();
    }

    public void setChangedStatus(boolean hasChanged) {
        this.getCallback().setChangedStatus(hasChanged);
    }

    public IModificationProblem setItems(IModuleData[] items, IModuleData[] parents) {
        if (items.length == 1) {
            IModuleData item0 = items[0];
            assert (item0 instanceof Scenario);
            this.item = (Scenario)item0;
            this.model = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(item0.getProjectUID());
            if (this.isCreationDialogue()) {
                this.actionSteps = new LinkedList<ActionStep>();
                ActionStep beginningStep = new ActionStep();
                beginningStep.setProjectUID(item0.getProjectUID());
                beginningStep.getStepType().setValue(0);
                beginningStep.getTitle().setValue("[Virtual Action Step]");
                ActionStep finalStep = new ActionStep();
                finalStep.setProjectUID(item0.getProjectUID());
                finalStep.getStepType().setValue(1);
                finalStep.getTitle().setValue("[Virtual Action Step]");
                this.actionSteps.add(beginningStep);
                this.actionSteps.add(finalStep);
            } else {
                this.isMainScenario = this.model.getParent((IModuleData)this.item) instanceof UseCase;
                this.actionSteps = this.model.getActionSteps(this.item);
            }
            boolean success = this.init();
            if (!success) {
                return this.getModificationProblemItemDeleted();
            }
        }
        return null;
    }

    public boolean isMultipleEditPossible() {
        return false;
    }

    public void setCommitable(boolean commitable) {
        this.getCallback().setCommitable(commitable);
    }

    public void setMessage(String message, int type) {
        this.getCallback().setMessage(message, type);
    }

    public void cancelChanges1() {
        this.widgetCreator.cancelChanges();
    }

    public Collection<IModificationProblem> requestCommit() {
        if (this.widgetCreator.getIDLock()) {
            this.getCallback().setCommitable(true);
            return Collections.emptyList();
        }
        if (this.widgetCreator.isExclusiveProjectLockConflicting()) {
            this.getCallback().setCommitable(true);
            return Arrays.asList(new ModificationProblem(com.arcway.cockpit.modulelib2.client.Messages.getString((String)"CreationAction.ExclusiveProjectLock.Message"), com.arcway.cockpit.modulelib2.client.Messages.getString((String)"CreationAction.ExclusiveProjectLock.Title")));
        }
        this.getCallback().setCommitable(false);
        return Arrays.asList(new ModificationProblem(Messages.getString("EditScenarioAdapter.ErrText"), Messages.getString("EditScenarioAdapter.ScenarioCantBeSavedWithThisID")));
    }

    public void rollbackCommitRequest() {
        this.widgetCreator.releaseIDLock();
    }

    public void setDirty() {
        this.getCallback().setChangedStatus(true);
    }

    protected void doCommitChanges() {
        EditScenarioAdapter.commitScenarioRelatedChanges(this.widgetCreator, this.item, this.isCreationDialogue(), this.parent, (IModelController)this.model);
    }

    static void commitScenarioRelatedChanges(final ScenarioWidgetCreator widgetCreator_, final Scenario scenario, final boolean isNew, final Scenario parentScenario, final IModelController modelController) {
        modelController.executeTransaction(new Runnable(){

            @Override
            public void run() {
                widgetCreator_.releaseOldIDLock();
                widgetCreator_.getValues();
                if (isNew) {
                    modelController.addItem((IModuleData)scenario);
                } else {
                    modelController.itemPropertiesModified((IModuleData)scenario, null);
                }
                if (!widgetCreator_.isMainScenario()) {
                    Scenario actualParentScenario = isNew ? parentScenario : (Scenario)modelController.getParent(modelController.getParent((IModuleData)scenario));
                    LinkedList<ActionStep> parentsActionSteps = new LinkedList<ActionStep>(((ModelController)modelController).getActionSteps(actualParentScenario));
                    int newForkingStepIndex = widgetCreator_.getCurrentForkingStep() + 1;
                    ActionStep newForkingStep = parentsActionSteps.get(newForkingStepIndex);
                    if (isNew) {
                        modelController.createLink(newForkingStep.getUID(), (IModuleData)scenario, "ScenarioBeginningStep");
                    } else {
                        Collection oldForkingStepCollection = modelController.getLinkableObjects((IModuleData)scenario, "ScenarioBeginningStep");
                        ActionStep oldForkingStep = (ActionStep)((Object)oldForkingStepCollection.iterator().next());
                        if (!newForkingStep.equals((Object)oldForkingStep)) {
                            modelController.deleteLink(oldForkingStep.getUID(), scenario.getUID(), "ScenarioBeginningStep");
                            modelController.createLink(newForkingStep.getUID(), (IModuleData)scenario, "ScenarioBeginningStep");
                        }
                    }
                    int newJoiningType = widgetCreator_.getCurrentJoiningType();
                    ActionStep newJoiningStep = null;
                    switch (newJoiningType) {
                        case 0: {
                            newJoiningStep = newForkingStep;
                            break;
                        }
                        case 1: {
                            newJoiningStep = parentsActionSteps.get(newForkingStepIndex + 1);
                            break;
                        }
                        case 2: {
                            newJoiningStep = parentsActionSteps.getLast();
                            scenario.getSuccess().setValue(0);
                            break;
                        }
                        case 3: {
                            newJoiningStep = parentsActionSteps.getLast();
                            scenario.getSuccess().setValue(1);
                            break;
                        }
                        default: {
                            logger.error("Unknown joining type: " + newJoiningType);
                            if (!$assertionsDisabled) {
                                throw new AssertionError();
                            }
                            break;
                        }
                    }
                    if (isNew) {
                        modelController.createLink(newJoiningStep.getUID(), (IModuleData)scenario, "ScenarioFinalStep");
                    } else {
                        Collection joiningStepCollection = modelController.getLinkableObjects((IModuleData)scenario, "ScenarioFinalStep");
                        ActionStep oldJoiningStep = (ActionStep)((Object)joiningStepCollection.iterator().next());
                        if (!oldJoiningStep.equals((Object)newJoiningStep)) {
                            modelController.deleteLink(oldJoiningStep.getUID(), scenario.getUID(), "ScenarioFinalStep");
                            modelController.createLink(newJoiningStep.getUID(), (IModuleData)scenario, "ScenarioFinalStep");
                        }
                    }
                }
                ActionStep predecessor = null;
                for (ActionStepInEditDialogue step : widgetCreator_.getActionSteps()) {
                    ActionStep oldPredecessor;
                    Collection oldPredecessorCollection = modelController.getLinkableObjects((IModuleData)step.getActionStep(), "StepPreviousStep");
                    ActionStep actionStep = oldPredecessor = !oldPredecessorCollection.isEmpty() ? (ActionStep)((Object)oldPredecessorCollection.iterator().next()) : null;
                    if (step.getState() == 4 || oldPredecessor != null && !oldPredecessor.equals((Object)predecessor)) {
                        modelController.deleteLink(oldPredecessor.getUID(), step.getActionStep().getUID(), "StepPreviousStep");
                    }
                    if (step.getState() == 4) continue;
                    predecessor = step.getActionStep();
                }
                predecessor = null;
                for (ActionStepInEditDialogue step : widgetCreator_.getActionSteps()) {
                    Collection oldPredecessorCollection;
                    ActionStep oldPredecessor;
                    ActionStep successorOfForkingStep;
                    ActionStep forkingStep;
                    Goal oldGoal;
                    Collection oldGoalCollection = modelController.getLinkableObjects((IModuleData)step.getActionStep(), "ActionStepGoal");
                    Goal goal = oldGoal = !oldGoalCollection.isEmpty() ? (Goal)((Object)oldGoalCollection.iterator().next()) : null;
                    if (step.getState() == 4 || oldGoal != null && !oldGoal.equals((Object)step.getActorAndGoal().goal)) {
                        modelController.deleteLink(oldGoal.getUID(), step.getActionStep().getUID(), "ActionStepGoal");
                    }
                    if (isNew && (step.getState() == 1 || step.getState() == 5) || step.getState() == 3) {
                        modelController.addItem((IModuleData)step.getActionStep());
                        modelController.createLink(scenario.getUID(), (IModuleData)step.getActionStep(), "StepScenario");
                    } else if (step.getState() == 2) {
                        modelController.itemPropertiesModified((IModuleData)step.getActionStep(), null);
                    } else if (step.getState() == 4) {
                        modelController.deleteLink(scenario.getUID(), step.getActionStep().getUID(), "StepScenario");
                        modelController.deleteItem((IModuleData)step.getActionStep());
                    }
                    if (step.getState() == 2) {
                        Collection extensionScenarios = CollectionUtils.getTypedCollection((Collection)modelController.getModuleData((IModuleData)step.getActionStep(), "ScenarioFinalStep"), Scenario.class);
                        for (Scenario extendingScenario : extensionScenarios) {
                            forkingStep = (ActionStep)((Object)modelController.getLinkableObjects((IModuleData)extendingScenario, "ScenarioBeginningStep").iterator().next());
                            if (forkingStep.equals((Object)step.getActionStep()) || forkingStep.equals((Object)predecessor)) continue;
                            successorOfForkingStep = (ActionStep)((Object)modelController.getModuleData((IModuleData)forkingStep, "StepPreviousStep").iterator().next());
                            modelController.deleteLink(step.getActionStep().getUID(), extendingScenario.getUID(), "ScenarioFinalStep");
                            modelController.createLink(successorOfForkingStep.getUID(), (IModuleData)extendingScenario, "ScenarioFinalStep");
                        }
                    }
                    if (step.getState() == 2) {
                        Collection extensions = CollectionUtils.getTypedCollection((Collection)modelController.getModuleData((IModuleData)step.getActionStep(), "ExtensionFinalStep"), Extension.class);
                        for (Extension extension : extensions) {
                            forkingStep = (ActionStep)((Object)modelController.getLinkableObjects((IModuleData)extension, "ExtensionBeginningStep").iterator().next());
                            if (forkingStep.equals((Object)step.getActionStep()) || forkingStep.equals((Object)predecessor)) continue;
                            successorOfForkingStep = (ActionStep)((Object)modelController.getModuleData((IModuleData)forkingStep, "StepPreviousStep").iterator().next());
                            modelController.deleteLink(step.getActionStep().getUID(), extension.getUID(), "ExtensionFinalStep");
                            modelController.createLink(successorOfForkingStep.getUID(), (IModuleData)extension, "ExtensionFinalStep");
                        }
                    }
                    if (!(step.getState() != 2 && step.getState() != 3 || oldGoal != null && oldGoal.equals((Object)step.getActorAndGoal().goal))) {
                        modelController.createLink(step.getActorAndGoal().goal.getUID(), (IModuleData)step.getActionStep(), "ActionStepGoal");
                    }
                    ActionStep actionStep = oldPredecessor = !(oldPredecessorCollection = modelController.getLinkableObjects((IModuleData)step.getActionStep(), "StepPreviousStep")).isEmpty() ? (ActionStep)((Object)oldPredecessorCollection.iterator().next()) : null;
                    if (step.getState() == 4) continue;
                    if (!(step.getState() == 1 || oldPredecessor != null && oldPredecessor.equals((Object)predecessor))) {
                        modelController.createLink(predecessor.getUID(), (IModuleData)step.getActionStep(), "StepPreviousStep");
                    }
                    predecessor = step.getActionStep();
                }
                ((ModelController)modelController).recalculateScenarioOrder(scenario);
                for (ExtensionWrapper extension : widgetCreator_.getAddedExtensions()) {
                    Extension modelExtension = new Extension();
                    modelExtension.setProjectUID(modelController.getProjectUID());
                    modelExtension.getSuccess().setValue(extension.joinEndType);
                    modelController.addItem((IModuleData)modelExtension);
                    modelController.createLink(extension.forkingStep.getUID(), (IModuleData)modelExtension, "ExtensionBeginningStep");
                    modelController.createLink(extension.joiningStep.getUID(), (IModuleData)modelExtension, "ExtensionFinalStep");
                    modelController.createLink(modelExtension.getUID(), (IModuleData)extension.useCase, "UseCaseExtension");
                }
                for (ExtensionWrapper extension : widgetCreator_.getModifiedExtensions()) {
                    modelController.deleteLink((EOLink)modelController.getLinksForModuleDataItem((IModuleData)extension.modelExtension, "ExtensionBeginningStep").iterator().next());
                    modelController.deleteLink((EOLink)modelController.getLinksForModuleDataItem((IModuleData)extension.modelExtension, "ExtensionFinalStep").iterator().next());
                    modelController.deleteLink((EOLink)modelController.getLinksForLinkableObject(extension.modelExtension.getUID(), "UseCaseExtension").iterator().next());
                    extension.modelExtension.getSuccess().setValue(extension.joinEndType);
                    modelController.createLink(extension.forkingStep.getUID(), (IModuleData)extension.modelExtension, "ExtensionBeginningStep");
                    modelController.createLink(extension.joiningStep.getUID(), (IModuleData)extension.modelExtension, "ExtensionFinalStep");
                    modelController.createLink(extension.modelExtension.getUID(), (IModuleData)extension.useCase, "UseCaseExtension");
                    modelController.itemPropertiesModified((IModuleData)extension.modelExtension, null);
                }
                for (ExtensionWrapper extension : widgetCreator_.getRemovedExtensions()) {
                    modelController.deleteLink((EOLink)modelController.getLinksForModuleDataItem((IModuleData)extension.modelExtension, "ExtensionBeginningStep").iterator().next());
                    modelController.deleteLink((EOLink)modelController.getLinksForModuleDataItem((IModuleData)extension.modelExtension, "ExtensionFinalStep").iterator().next());
                    modelController.deleteLink((EOLink)modelController.getLinksForLinkableObject(extension.modelExtension.getUID(), "UseCaseExtension").iterator().next());
                    modelController.deleteItem((IModuleData)extension.modelExtension);
                }
            }
        });
    }

    protected IModelController getModel() {
        return this.model;
    }

    protected AbstractModulePlugin getPlugin() {
        return UseCaseModulePlugin.getDefault();
    }

    public ImageDescriptor getDialogImageDescriptor() {
        return UseCaseModulePlugin.getImageDescriptor("UseCase_big.gif");
    }
}

