/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.dialogues;

import com.arcway.cockpit.frame.client.project.core.framedata.ModificationProblem;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataEditPropertyAdapter;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.description.CategoryDescription;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.lib.util.gui.elements.UIETextDropDown;
import de.plans.lib.util.gui.elements.UIETextField;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class EditCategoryAdapter
extends ModuleDataEditPropertyAdapter
implements ModifyListener {
    private Group advancedGroup;
    private Button defaultButton;
    private Button prefixButton;
    private UIETextField idPrefix;
    private UIETextDropDown idPattern;
    private Label lblExample;
    private Category item;
    private UIETextField categoryNameField;
    private Collection<String> allCategoryNames;
    private String oldName;
    private IModelController model;
    private static final String ERR_MSG_NON_UNIQUE = Messages.getString("EditCategoryAdapter.ErrMsgNonUnique");
    private LockAccess editLock;
    private LockAccess idLock;
    private boolean isExclusiveProjectLockConflicting = false;

    public EditCategoryAdapter(boolean isNew) {
        super(isNew);
    }

    public String getDataTypeID() {
        return "ucm.category";
    }

    public IModuleDataTypeDescriptionForFrame getCockpitDataType() {
        return CategoryDescription.MODULEDATATYPEDESCRIPTION_FORFRAME;
    }

    public Class getDataClass() {
        return Category.class;
    }

    public String getPropertyName() {
        return CategoryDescription.MODULE_DATA_NAME;
    }

    protected ImageDescriptorRegistry getImageDescriptorRegistry() {
        return UseCaseModulePlugin.getDefault().getImageDescriptorRegistry();
    }

    public ImageDescriptor getPropertyImageDescriptor() {
        return UseCaseModulePlugin.getImageDescriptor("Category.gif");
    }

    public Composite createEditPage_internal(Composite parent) {
        this.categoryNameField = new UIETextField(CategoryDescription.NAME_CATEGORY, this.item.getName().getValueRangeHelper());
        this.idPrefix = new UIETextField(CategoryDescription.NAME_PREFIX, this.item.getPrefix().getValueRangeHelper());
        this.idPattern = new UIETextDropDown(CategoryDescription.NAME_PATTERN, this.item.getPattern().getValueRangeHelper(Locale.getDefault()));
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        page.setLayout((Layout)layout);
        this.createCategoryWidget(page, 2, (IModuleData)this.item);
        this.createLabel(String.valueOf(CategoryDescription.NAME_CATEGORY) + ":", 1, page);
        Control control = this.categoryNameField.getControl(page);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 1;
        control.setLayoutData((Object)gridData);
        this.advancedGroup = new Group(page, 16);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.advancedGroup.setLayoutData((Object)gridData);
        layout = new GridLayout(2, false);
        this.advancedGroup.setLayout((Layout)layout);
        Label prefixTextLabel = new Label((Composite)this.advancedGroup, 64);
        prefixTextLabel.setText(Messages.getString("EditCategoryAdapter.PREFIX_DESCRIPTION"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 2;
        prefixTextLabel.setLayoutData((Object)gridData);
        Composite buttonGroup = new Composite((Composite)this.advancedGroup, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        buttonGroup.setLayoutData((Object)gridData);
        GridLayout buttonGroupLayout = new GridLayout(2, false);
        buttonGroup.setLayout((Layout)buttonGroupLayout);
        this.defaultButton = new Button(buttonGroup, 16);
        this.defaultButton.setText(Messages.getString("EditCategoryAdapter.USE_DEFAULT_PREFIX"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.defaultButton.setLayoutData((Object)gridData);
        this.prefixButton = new Button(buttonGroup, 16);
        this.prefixButton.setText(Messages.getString("EditCategoryAdapter.SET_PREFIX"));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.prefixButton.setLayoutData((Object)gridData);
        Control widget = this.idPrefix.getControl(buttonGroup);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        widget.setLayoutData((Object)gridData);
        this.idPrefix.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditCategoryAdapter.this.updateIDExample();
            }
        });
        this.prefixButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditCategoryAdapter.this.idPrefix.setEnabled(true);
            }
        });
        this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditCategoryAdapter.this.idPrefix.setEnabled(false);
                EditCategoryAdapter.this.updateIDExample();
            }
        });
        if (this.item.isDefaultPrefix()) {
            this.defaultButton.setSelection(true);
            this.idPrefix.setEnabled(false);
        } else {
            this.prefixButton.setSelection(true);
            this.idPrefix.setEnabled(true);
        }
        Label patternTextLabel = new Label(buttonGroup, 0);
        patternTextLabel.setText(Messages.getString("EditCategoryAdapter.NUMBER_FORMAT"));
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 2;
        prefixTextLabel.setLayoutData((Object)gridData);
        widget = this.idPattern.getControl(buttonGroup);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        widget.setLayoutData((Object)gridData);
        this.idPattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditCategoryAdapter.this.updateIDExample();
            }
        });
        Label exampleTextLabel = new Label(buttonGroup, 0);
        exampleTextLabel.setText(Messages.getString("EditCategoryAdapter.EXAMPLE"));
        gridData = new GridData(768);
        exampleTextLabel.setLayoutData((Object)gridData);
        this.lblExample = new Label(buttonGroup, 0);
        gridData = new GridData(768);
        this.lblExample.setLayoutData((Object)gridData);
        this.setValues();
        this.categoryNameField.addModifyListener((ModifyListener)this);
        this.idPrefix.addModifyListener((ModifyListener)this);
        this.prefixButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditCategoryAdapter.this.handleModifications(true);
            }
        });
        this.defaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditCategoryAdapter.this.handleModifications(true);
            }
        });
        this.idPattern.addModifyListener((ModifyListener)this);
        this.handleModifications(false);
        this.setWidgetState();
        return page;
    }

    private void setWidgetState() {
        if (!this.isCreationDialogue()) {
            ModelController mc = (ModelController)this.model;
            PermissionMgr permissionMgr = (PermissionMgr)mc.getPermissionMgr();
            if (!this.editLock.hasLock()) {
                this.disableAll();
                return;
            }
            if (!permissionMgr.mayEditAttribute((IModuleData)this.item, (IModuleData)this.item, "ucm.category.category")) {
                this.categoryNameField.setEditable(false);
            }
            if (!permissionMgr.mayEditAttribute((IModuleData)this.item, (IModuleData)this.item, "useCase_defaultPrefixuseCase_rolePatternuseCase_prefix")) {
                this.defaultButton.setEnabled(false);
                this.prefixButton.setEnabled(false);
                this.idPrefix.setEnabled(false);
                this.idPattern.setEnabled(false);
            }
            if (permissionMgr.mayEditItemStructurally((IModuleData)this.item, null)) {
                this.setCategoryEditable(true);
            } else {
                this.setCategoryEditable(false);
            }
        }
    }

    private void disableAll() {
        this.categoryNameField.setEditable(false);
        this.defaultButton.setEnabled(false);
        this.prefixButton.setEnabled(false);
        this.idPrefix.setEditable(false);
        this.idPattern.setEnabled(false);
        this.getCallback().setCommitable(false);
        this.setCategoryEditable(false);
    }

    private void updateIDExample() {
        String prefix = this.defaultButton.getSelection() ? CategoryDescription.getGenericPrefix(this.categoryNameField.getCurrentValue()) : this.idPrefix.getCurrentValue();
        ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(this.item.getProjectUID());
        String pattern = this.idPattern.getCurrentValue();
        this.lblExample.setText(modelController.buildUseCaseID(prefix, pattern, 1));
    }

    private Set<String> getAllValues() {
        Collection allItems = this.model.getAllItems("ucm.category");
        HashSet<String> allValues = new HashSet<String>(allItems.size());
        for (Category element : allItems) {
            allValues.add(element.getName().getDisplayStringRepresentation());
        }
        allValues.remove(this.item.getName().getDisplayStringRepresentation());
        return allValues;
    }

    private void setValues() {
        this.categoryNameField.setValue();
        this.idPrefix.setValue();
        this.idPattern.setValue();
        this.initializePrefix();
    }

    private void initializePrefix() {
        ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(this.item.getProjectUID());
        this.idPrefix.forceText(this.item.getEffectivePrefix());
        this.lblExample.setText(modelController.buildUseCaseID(this.item.getEffectivePrefix(), this.item.getPattern().getDisplayStringRepresentation(), 1));
    }

    public IModificationProblem setItems(IModuleData[] items, IModuleData[] parents) {
        if (items.length == 1) {
            IModuleData givenItem = items[0];
            assert (givenItem instanceof Category);
            this.item = (Category)givenItem;
            this.model = this.getModelController(givenItem);
            this.allCategoryNames = this.getAllValues();
            this.oldName = this.item.getName().getDisplayStringRepresentation();
            if (!this.isCreationDialogue()) {
                this.editLock = this.model.getLockMgr().acquireEditLock((ICockpitProjectData)this.item, false);
                if (this.editLock.hasLock()) {
                    this.item = (Category)this.model.getItem("ucm.category", this.item.getUID());
                    if (this.item == null) {
                        return this.getModificationProblemItemDeleted();
                    }
                }
            }
        }
        return null;
    }

    public void modifyText(ModifyEvent e) {
        this.handleModifications(true);
    }

    private void handleModifications(boolean notAtInitialisation) {
        String check = this.categoryNameField.checkCurrentValue();
        if (check == null) {
            check = this.checkUniqueness();
        }
        if (check == null) {
            check = this.idPrefix.checkCurrentValue();
        }
        if (check == null) {
            check = this.idPattern.checkCurrentValue();
        }
        if (this.isExclusiveProjectLockConflicting) {
            if (notAtInitialisation) {
                this.getCallback().setErrMsg(com.arcway.cockpit.modulelib2.client.Messages.getString((String)"CreationAction.ExclusiveProjectLock.Message"));
                this.getCallback().setChangedStatus(true);
            } else {
                this.getCallback().setChangedStatus(false);
            }
        } else if (notAtInitialisation) {
            this.getCallback().setErrMsg(check);
            this.getCallback().setChangedStatus(true);
        } else {
            this.getCallback().setChangedStatus(false);
        }
        this.getCallback().setCommitable(check == null);
        this.updateIDExample();
    }

    private String checkUniqueness() {
        return this.allCategoryNames.contains(this.categoryNameField.getCurrentValue().trim()) ? ERR_MSG_NON_UNIQUE : null;
    }

    public boolean isMultipleEditPossible() {
        return false;
    }

    protected IModelController getModelController(IModuleData theItem) {
        return UseCaseModulePlugin.getDefault().getProjectManager().getModelController(theItem.getProjectUID());
    }

    public void cancelChanges1() {
        if (this.editLock != null) {
            this.editLock.releaseLocks();
        }
    }

    public Collection<IModificationProblem> requestCommit() {
        AbstractLockManager lockManager = this.model.getLockMgr();
        this.idLock = lockManager.acquireUniqueNameLock(this.categoryNameField.getCurrentValue().trim(), "ucm.category", null);
        if (!this.idLock.hasLock()) {
            this.isExclusiveProjectLockConflicting = this.idLock.isExclusiveProjectLockConflicting();
            if (!this.isExclusiveProjectLockConflicting) {
                return Collections.singleton(new ModificationProblem(Messages.getString("EditCategoryAdapter.ErrText"), Messages.getString("EditCategoryAdapter.UseCaseCategoryCantBeSavedWithThisID")));
            }
            this.getCallback().setCommitable(true);
            return Arrays.asList(new ModificationProblem(com.arcway.cockpit.modulelib2.client.Messages.getString((String)"CreationAction.ExclusiveProjectLock.Message"), com.arcway.cockpit.modulelib2.client.Messages.getString((String)"CreationAction.ExclusiveProjectLock.Title")));
        }
        this.getCallback().setCommitable(true);
        return Collections.emptyList();
    }

    public void rollbackCommitRequest() {
        if (this.idLock != null) {
            this.idLock.releaseLocks();
        }
        if (this.editLock != null) {
            this.editLock.releaseLocks();
        }
    }

    protected void doCommitChanges() {
        if (!this.isCreationDialogue() && !this.categoryNameField.getCurrentValue().trim().equals(this.oldName)) {
            AbstractLockManager lockManager = this.model.getLockMgr();
            lockManager.releaseUniqueIdLock("ucm.category", this.oldName);
        }
        this.idPrefix.getValue();
        this.idPattern.getValue();
        this.item.setPrefixDefault(this.defaultButton.getSelection());
        this.item.getName().setValueViaDisplayStringRepresentation(this.categoryNameField.getCurrentValue());
        if (this.isCreationDialogue()) {
            this.model.addItem((IModuleData)this.item);
        } else {
            this.model.itemPropertiesModified((IModuleData)this.item, null);
        }
    }

    protected IModelController getModel() {
        return this.model;
    }

    protected AbstractModulePlugin getPlugin() {
        return UseCaseModulePlugin.getDefault();
    }

    public ImageDescriptor getDialogImageDescriptor() {
        return UseCaseModulePlugin.getImageDescriptor("UseCase_big.gif");
    }
}

