/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.dialogues;

import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.AbstractListManagementDialog;
import com.arcway.cockpit.modulelib2.client.gui.AbstractNewItemDialog;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.messages.Actor;
import com.arcway.cockpit.usecasemodule.client.messages.description.ActorDescription;
import de.plans.lib.util.gui.elements.UIETextField;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.swt.widgets.Shell;

public class EditActorsDialogue
extends AbstractListManagementDialog {
    private static final String DIALOG_TITLE = Messages.getString("EditActorsDialogue.DialogTitle");
    private static final String DIALOG_MESSAGE = Messages.getString("EditActorsDialogue.DialogMessage");
    private static final String UNUSED_ITEMS_LABEL = Messages.getString("EditActorsDialogue.UnusedItemsLabel");
    private static final String USED_ITEMS_LABEL = Messages.getString("EditActorsDialogue.UsedItemsLabel");
    private static final String NEW_DIALOG_TITLE = Messages.getString("EditActorsDialogue.NewDialogTitle");
    private static final String NEW_DIALOG_MESSAGE = Messages.getString("EditActorsDialogue.NewDialogMessage");
    private static final String EDIT_DIALOG_TITLE = Messages.getString("EditActorsDialogue.EditDialogTitle");
    private static final String EDIT_DIALOG_MESSAGE = Messages.getString("EditActorsDialogue.EditDialogMessage");
    private static final String NEW_ITEM_LABEL = ActorDescription.MODULE_DATA_NAME;
    private static final String NEW_ITEM_EXISTS_ERROR = Messages.getString("EditActorsDialogue.NewItemExistsError");
    private Collection additionalActors;

    public EditActorsDialogue(Shell parentShell, IModelController modelController) {
        super(parentShell, modelController, "ucm.Actor", Arrays.asList("GoalActor"), DIALOG_TITLE, DIALOG_MESSAGE, UNUSED_ITEMS_LABEL, USED_ITEMS_LABEL);
    }

    public EditActorsDialogue(Shell parentShell, IModelController modelController, Collection additionalActors) {
        this(parentShell, modelController);
        this.additionalActors = additionalActors;
    }

    protected void initializeListUsedAndListUnused() {
        super.initializeListUsedAndListUnused();
        if (this.additionalActors != null) {
            for (IModuleData actor : this.additionalActors) {
                this.initiallyUnusedMap.remove(actor.getDisplayRepresentation());
                this.initiallyUsedMap.put(actor.getDisplayRepresentation(), actor);
            }
        }
    }

    protected AbstractNewItemDialog createNewListItemDialog(Shell shell, IModelController modelCtrl, Collection existingItems, IModuleData oldItem) {
        return new NewActorDialog(shell, modelCtrl, existingItems, oldItem);
    }

    public static class NewActorDialog
    extends AbstractNewItemDialog {
        public NewActorDialog(Shell parentShell, IModelController modelController, Collection existingItems, IModuleData oldItem) {
            super(parentShell, existingItems, oldItem == null ? NEW_DIALOG_TITLE : EDIT_DIALOG_TITLE, oldItem == null ? NEW_DIALOG_MESSAGE : EDIT_DIALOG_MESSAGE, NEW_ITEM_LABEL, NEW_ITEM_EXISTS_ERROR);
            this.item = new Actor();
            this.item.setProjectUID(modelController.getProjectUID());
            if (oldItem instanceof Actor) {
                ((Actor)this.item).getName().setValueViaDisplayStringRepresentation(oldItem.getDisplayRepresentation());
            }
            this.name = new UIETextField(ActorDescription.MODULE_DATA_NAME, ((Actor)this.item).getName().getValueRangeHelper());
        }

        protected void getValues() {
            this.name.getValue();
        }

        protected void setValues() {
            this.name.setValue();
        }
    }
}

