/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.dialogues;

import com.arcway.cockpit.frame.client.project.modules.IModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.AbstractModulePlugin;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataEditPropertyAdapter;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Actor;
import com.arcway.cockpit.usecasemodule.client.messages.Goal;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.cockpit.usecasemodule.client.messages.description.ActionStepDescription;
import com.arcway.lib.ui.IModificationProblem;
import de.plans.lib.util.gui.elements.UIETextField;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class EditActionStepAdapter
extends ModuleDataEditPropertyAdapter
implements ModifyListener {
    private ActionStep item;
    private ActionStep neighbour = null;
    private boolean before = false;
    private UIETextField actionStepDescriptionField;
    private UIETextField actionStepTitleField;
    private IModelController model;
    private LockAccess lock;
    private Goal[] goals;
    private String[] actorNames;
    private int oldGoalIndex = -1;
    private Combo actorsCombo;
    private UseCase useCase;

    public EditActionStepAdapter(ActionStep neighbour, boolean before) {
        super(true);
        this.neighbour = neighbour;
        this.before = before;
    }

    public EditActionStepAdapter(ActionStep neighbour, boolean before, UseCase useCase) {
        this(neighbour, before);
        this.useCase = useCase;
    }

    public EditActionStepAdapter(boolean isNew) {
        super(isNew);
        this.useCase = null;
    }

    public String getDataTypeID() {
        return "ucm.ActionStep";
    }

    public IModuleDataTypeDescriptionForFrame getCockpitDataType() {
        return ActionStepDescription.MODULEDATATYPEDESCRIPTION_FORFRAME;
    }

    public Class getDataClass() {
        return ActionStep.class;
    }

    public String getPropertyName() {
        return ActionStepDescription.MODULE_DATA_NAME;
    }

    protected ImageDescriptorRegistry getImageDescriptorRegistry() {
        return UseCaseModulePlugin.getDefault().getImageDescriptorRegistry();
    }

    public ImageDescriptor getPropertyImageDescriptor() {
        return UseCaseModulePlugin.getImageDescriptor("ActionStep.gif");
    }

    public Composite createEditPage_internal(Composite parent) {
        if (this.isCreationDialogue() && this.neighbour != null) {
            if (this.before) {
                this.item.getNumber().setValue(this.neighbour.getNumber().getValue());
            } else {
                this.item.getNumber().setValue(this.neighbour.getNumber().getValue() + 1);
            }
        }
        this.actionStepDescriptionField = new UIETextField(ActionStepDescription.NAME_DESCRIPTION, this.item.getDescription().getValueRangeHelper(), true);
        this.actionStepTitleField = new UIETextField(ActionStepDescription.NAME_DESCRIPTION, this.item.getTitle().getValueRangeHelper(), false);
        Composite page = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        page.setLayout((Layout)layout);
        this.createCategoryWidget(page, 2, (IModuleData)this.item);
        this.createLabel(String.valueOf(ActionStepDescription.MODULE_DATA_NAME) + ": " + this.calculateNumber(), 2, page);
        this.createLabel("Actor: ", 1, page);
        this.createLabel(String.valueOf(ActionStepDescription.NAME_TITLE) + ":", 1, page);
        this.actorsCombo = new Combo(page, 8);
        this.actorsCombo.setLayoutData((Object)new GridData(4, 0, false, false));
        Control control = this.actionStepTitleField.getControl(page);
        GridData gridData = new GridData(4, 0, true, false);
        control.setLayoutData((Object)gridData);
        this.createLabel(String.valueOf(ActionStepDescription.NAME_DESCRIPTION) + ":", 2, page);
        control = this.actionStepDescriptionField.getControl(page);
        gridData = new GridData(4, 0, true, true);
        gridData.heightHint = 80;
        gridData.verticalSpan = 3;
        gridData.horizontalSpan = 5;
        gridData.grabExcessVerticalSpace = false;
        control.setLayoutData((Object)gridData);
        this.actionStepDescriptionField.setValue();
        this.actionStepTitleField.setValue();
        this.actionStepDescriptionField.addModifyListener((ModifyListener)this);
        this.actionStepTitleField.addModifyListener((ModifyListener)this);
        this.actorsCombo.setItems(this.actorNames);
        this.actorsCombo.select(this.oldGoalIndex);
        this.setWidgetState();
        this.actorsCombo.addModifyListener((ModifyListener)this);
        this.check(false);
        return page;
    }

    private String calculateNumber() {
        if (this.isCreationDialogue()) {
            Scenario scenario = (Scenario)this.model.getParent((IModuleData)this.neighbour);
            String ID = ((ModelController)this.model).getFullScenarioPrefix(scenario);
            int number = this.neighbour.getNumber().getValue() + (this.before ? -1 : 1);
            return String.valueOf(ID) + number;
        }
        return ((ModelController)this.model).getFullScenarioPrefixPlusStepNumber(this.item);
    }

    private void initActors() {
        if (this.useCase == null) {
            this.useCase = this.isCreationDialogue() ? ((ModelController)this.model).getUseCase(this.neighbour) : ((ModelController)this.model).getUseCase(this.item);
        }
        Collection col = ((ModelController)this.model).getGoals(this.useCase);
        this.goals = col.toArray(new Goal[col.size()]);
        Arrays.sort(this.goals, new Comparator(){

            public int compare(Object o1, Object o2) {
                Goal g1 = (Goal)((Object)o1);
                Goal g2 = (Goal)((Object)o2);
                if (g1.isMainActor()) {
                    return -1;
                }
                if (g2.isMainActor()) {
                    return 1;
                }
                Actor a1 = (Actor)((Object)EditActionStepAdapter.this.model.getLinkableObjects((IModuleData)g1, "GoalActor").iterator().next());
                Actor a2 = (Actor)((Object)EditActionStepAdapter.this.model.getLinkableObjects((IModuleData)g2, "GoalActor").iterator().next());
                return a1.getName().getDisplayStringRepresentation().compareTo(a2.getName().getDisplayStringRepresentation());
            }
        });
        this.actorNames = new String[this.goals.length];
        int i = 0;
        while (i < this.goals.length) {
            Goal goal = this.goals[i];
            if (this.isCreationDialogue() && goal.isMainActor() || this.model.linkExists(goal.getUID(), (IModuleData)this.item, "ActionStepGoal")) {
                this.oldGoalIndex = i;
            }
            Actor actor = (Actor)((Object)this.model.getLinkableObjects((IModuleData)goal, "GoalActor").iterator().next());
            this.actorNames[i] = actor.getName().getDisplayStringRepresentation();
            ++i;
        }
        assert (this.oldGoalIndex >= 0);
    }

    private void setWidgetState() {
        ModelController mc = (ModelController)this.model;
        PermissionMgr permissionMgr = (PermissionMgr)mc.getPermissionMgr();
        ActionStep permissionStep = this.neighbour != null ? this.neighbour : this.item;
        Scenario permissionScenario = (Scenario)mc.getParent((IModuleData)permissionStep);
        UseCase permissionUseCase = mc.getUseCase(permissionScenario);
        if (this.isCreationDialogue() || this.lock.hasLock()) {
            if (!permissionMgr.mayEditAttribute((IModuleData)this.item, (IModuleData)permissionUseCase, "ucm.Step.Description")) {
                this.actionStepDescriptionField.setEditable(false);
            }
            if (!permissionMgr.mayEditAttribute((IModuleData)this.item, (IModuleData)permissionUseCase, "ucm.Step.Title")) {
                this.actionStepTitleField.setEditable(false);
            }
            if (!permissionMgr.mayEditAttribute((IModuleData)this.item, (IModuleData)permissionUseCase, "ucm.step.Actor")) {
                this.actorsCombo.setEnabled(false);
            }
            if (permissionMgr.mayEditItemStructurally((IModuleData)this.item, (IModuleData)permissionScenario)) {
                this.setCategoryEditable(true);
            } else {
                this.setCategoryEditable(false);
            }
        } else {
            this.disableAll();
        }
    }

    private void disableAll() {
        this.actionStepDescriptionField.setEditable(false);
        this.actionStepTitleField.setEditable(false);
        this.actorsCombo.setEnabled(false);
        this.getCallback().setCommitable(false);
        this.setCategoryEditable(false);
    }

    public void modifyText(ModifyEvent e) {
        this.check(true);
    }

    private void check(boolean modification) {
        String errorMessage = null;
        String actionStepDescriptionCheck = this.actionStepDescriptionField.checkCurrentValue();
        String actionStepTitleCheck = this.actionStepTitleField.checkCurrentValue();
        String actionStepTitle = this.actionStepTitleField.getCurrentValue();
        if (actionStepTitle.equals("")) {
            errorMessage = Messages.getString("EditActionStepAdapter.ErrMsgNonEmptyActionStep");
        }
        if (errorMessage == null && actionStepTitleCheck != null) {
            errorMessage = actionStepTitleCheck;
        }
        if (errorMessage == null && actionStepDescriptionCheck != null) {
            errorMessage = actionStepDescriptionCheck;
        }
        if (modification) {
            this.getCallback().setErrMsg(errorMessage);
            this.getCallback().setChangedStatus(true);
        } else {
            if (errorMessage != null) {
                this.getCallback().setCommitable(false);
            }
            this.getCallback().setChangedStatus(false);
        }
    }

    public IModificationProblem setItems(IModuleData[] items, IModuleData[] parents) {
        if (items.length == 1) {
            assert (items[0] instanceof ActionStep);
            this.useCase = null;
            this.item = (ActionStep)items[0];
            this.model = this.getModelController((IModuleData)this.item);
            this.initActors();
            if (!this.isCreationDialogue()) {
                AbstractLockManager lockManager = this.model.getLockMgr();
                ActionStep lockStep = this.neighbour != null ? this.neighbour : this.item;
                Scenario scenario = (Scenario)this.model.getParent((IModuleData)lockStep);
                this.lock = lockManager.acquireEditLock((ICockpitProjectData)scenario, false);
                if (this.lock.hasLock()) {
                    this.item = (ActionStep)this.model.getItem("ucm.ActionStep", this.item.getUID());
                    if ((scenario = (Scenario)this.model.getItem("ucm.Scenario", scenario.getUID())) == null) {
                        return this.getModificationProblemItemDeleted();
                    }
                }
            }
        }
        return null;
    }

    public boolean isMultipleEditPossible() {
        return false;
    }

    private IModelController getModelController(IModuleData p_item) {
        return UseCaseModulePlugin.getDefault().getProjectManager().getModelController(p_item.getProjectUID());
    }

    public void cancelChanges() {
        if (this.lock != null) {
            this.lock.releaseLocks();
        }
    }

    public void cancelChanges1() {
        if (this.lock != null) {
            this.lock.releaseLocks();
        }
    }

    public Collection<IModificationProblem> requestCommit() {
        return Collections.EMPTY_LIST;
    }

    public void rollbackCommitRequest() {
    }

    public boolean providesPropertiesFor(IModuleData moduleData) {
        return moduleData instanceof ActionStep && ((ActionStep)moduleData).getStepType().getValue() == 2;
    }

    protected void doCommitChanges() {
        this.actionStepDescriptionField.getValue();
        this.actionStepTitleField.getValue();
        if (this.isCreationDialogue()) {
            if (this.neighbour == null) {
                return;
            }
            Scenario scenario = (Scenario)this.model.getParent((IModuleData)this.neighbour);
            this.model.addItem((IModuleData)this.item);
            this.model.createLink(scenario.getUID(), (IModuleData)this.item, "StepScenario");
            if (this.before) {
                ActionStep stepBefore = (ActionStep)((Object)this.model.getLinkableObjects((IModuleData)this.neighbour, "StepPreviousStep").iterator().next());
                ((ModelController)this.model).addStep(this.item, stepBefore);
            } else {
                ((ModelController)this.model).addStep(this.item, this.neighbour);
            }
            Goal goal = this.goals[this.actorsCombo.getSelectionIndex()];
            this.model.createLink(goal.getUID(), (IModuleData)this.item, "ActionStepGoal");
        } else {
            Goal oldGoal;
            Goal newGoal = this.goals[this.actorsCombo.getSelectionIndex()];
            if (!newGoal.equals((Object)(oldGoal = this.goals[this.oldGoalIndex]))) {
                this.model.deleteLink(oldGoal.getUID(), this.item.getUID(), "ActionStepGoal");
                this.model.createLink(newGoal.getUID(), (IModuleData)this.item, "ActionStepGoal");
            }
            this.model.itemPropertiesModified((IModuleData)this.item, null);
        }
    }

    protected IModelController getModel() {
        return this.model;
    }

    protected AbstractModulePlugin getPlugin() {
        return UseCaseModulePlugin.getDefault();
    }

    public ImageDescriptor getDialogImageDescriptor() {
        return UseCaseModulePlugin.getImageDescriptor("UseCase_big.gif");
    }
}

