/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.dialogues;

import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IEditDialogErrorCallback;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.core.permissions.UseCasePermissionRootNode;
import com.arcway.cockpit.usecasemodule.client.gui.actions.ActionEditActors;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.EditUseCaseAdapter;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.EmptyCellEditor;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.GoalTableContentProvider;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.GoalWrapper;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.SelectGoalDialog;
import com.arcway.cockpit.usecasemodule.client.messages.Actor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ActorsAndGoalsViewer {
    private static final String ERROR_EMPTY_GOAL = Messages.getString("ActorsAndGoalsViewer.ErrMsgNoGoal");
    private static final String ERROR_EMPTY_VIEW = Messages.getString("ActorsAndGoalsViewer.ErrMsgNoActor");
    private static final String ERROR_NO_MAIN_ACTOR = Messages.getString("ActorsAndGoalsViewer.ErrNoMainActor");
    private CheckboxTableViewer viewer;
    private static final int MAIN_ACTOR_INDEX = 0;
    private static final int ACTOR_INDEX = 1;
    private static final int GOAL_INDEX = 2;
    private static final String MAIN_ACTOR_PROPERTY = "mainActor";
    private static final String ACTOR_PROPERTY = "actor";
    private static final String GOAL_PROPERTY = "goal";
    private IEditDialogErrorCallback callback = IEditDialogErrorCallback.DUMMY;
    private List columnProperties;
    private final String projectUID;
    private static final String[] COLUMN_PROPERTIES = new String[]{"mainActor", "actor", "goal"};
    private CellEditor[] cellEditors;
    private Button removeButton;
    private final IModelController modelController;
    private Button addButton;
    private Collection usedActors;
    private final EditUseCaseAdapter useCaseAdapter;
    private final boolean enabled;

    public ActorsAndGoalsViewer(Composite parent, String projectUID, IModelController modelController, EditUseCaseAdapter useCaseAdapter, boolean enabled) {
        this.useCaseAdapter = useCaseAdapter;
        this.modelController = modelController;
        this.projectUID = projectUID;
        this.enabled = enabled;
        this.init(parent);
    }

    private void init(Composite _parent) {
        Composite parent = new Composite(_parent, 0);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        parent.setLayout((Layout)new GridLayout(2, false));
        Table table = new Table(parent, 68386);
        Composite buttonComposite = new Composite(parent, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 0, false, false));
        buttonComposite.setLayout((Layout)new GridLayout());
        TableColumn mainActorColumn = new TableColumn(table, 0x1000000);
        mainActorColumn.setText(Messages.getString("ActorsAndGoalsViewer.MainActorColumnTitle"));
        mainActorColumn.setWidth(50);
        TableColumn actorColumn = new TableColumn(table, 16384);
        actorColumn.setText(Messages.getString("ActorsAndGoalsViewer.ActorTitle"));
        actorColumn.setWidth(100);
        TableColumn goalColumn = new TableColumn(table, 16384);
        goalColumn.setText(Messages.getString("ActorsAndGoalsViewer.GoalTitle"));
        goalColumn.setWidth(300);
        this.viewer = new CheckboxTableViewer(table);
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.columnProperties = Arrays.asList(COLUMN_PROPERTIES);
        this.viewer.setColumnProperties(COLUMN_PROPERTIES);
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        if (this.enabled) {
            this.cellEditors = new CellEditor[3];
            this.cellEditors[0] = new CheckboxCellEditor((Composite)this.viewer.getTable());
            this.cellEditors[1] = new EmptyCellEditor();
            this.cellEditors[2] = new TextCellEditor((Composite)this.viewer.getTable());
            this.cellEditors[2].setValidator(new ICellEditorValidator(){

                public String isValid(Object value) {
                    if ("".equals(value)) {
                        return ERROR_EMPTY_GOAL;
                    }
                    return null;
                }
            });
            this.viewer.setCellEditors(this.cellEditors);
        }
        this.viewer.setCellModifier((ICellModifier)new CellModifier());
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        this.addButton = new Button(buttonComposite, 8);
        this.addButton.setText(Messages.getString("ActorsAndGoalsViewer.addButtonText"));
        GridData gd = new GridData(4, 0, false, false);
        gd.widthHint = 100;
        this.addButton.setLayoutData((Object)gd);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GoalTableContentProvider contentProvider = (GoalTableContentProvider)ActorsAndGoalsViewer.this.viewer.getContentProvider();
                SelectGoalDialog selectGoalDialog = new SelectGoalDialog(ActorsAndGoalsViewer.this.addButton.getShell(), ActorsAndGoalsViewer.this.modelController.getAllItems("ucm.Actor"), contentProvider.getActors(), Messages.getString("ActorsAndGoalsViewer.SelectGoalDialogTitle"), Messages.getString("ActorsAndGoalsViewer.SelectGoalDialogMessage"), ActorsAndGoalsViewer.this.projectUID);
                if (selectGoalDialog.open() == 0) {
                    GoalWrapper gw = selectGoalDialog.getSelectedGoal();
                    contentProvider.addGoal(gw);
                    ActorsAndGoalsViewer.this.callback.setDirty();
                    ActorsAndGoalsViewer.this.checkAddButton();
                    ActorsAndGoalsViewer.this.checkRemoveButton();
                    ActorsAndGoalsViewer.this.check(gw);
                }
            }
        });
        this.removeButton = new Button(buttonComposite, 8);
        this.removeButton.setText(Messages.getString("ActorsAndGoalsViewer.RemoveButtonText"));
        this.removeButton.setLayoutData((Object)new GridData(4, 0, false, false));
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GoalTableContentProvider contentProvider = (GoalTableContentProvider)ActorsAndGoalsViewer.this.viewer.getContentProvider();
                Collection selectedGoals = ActorsAndGoalsViewer.this.getSelectedGoals();
                for (GoalWrapper goal : selectedGoals) {
                    contentProvider.removeGoal(goal);
                    if (!goal.isMainActor) continue;
                    contentProvider.setMainGoal(null);
                }
                ActorsAndGoalsViewer.this.callback.setDirty();
                ActorsAndGoalsViewer.this.checkAddButton();
                ActorsAndGoalsViewer.this.checkRemoveButton();
                ActorsAndGoalsViewer.this.check(null);
            }
        });
        this.removeButton.setEnabled(this.enabled);
        Button editActorsButton = new Button(buttonComposite, 8);
        editActorsButton.setText(Messages.getString("ActorsAndGoalsViewer.EditActorsButtonText"));
        editActorsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GoalTableContentProvider contentProvider = (GoalTableContentProvider)ActorsAndGoalsViewer.this.viewer.getContentProvider();
                ActionEditActors editAction = new ActionEditActors(ActorsAndGoalsViewer.this.modelController, contentProvider.getActors());
                editAction.run();
                ActorsAndGoalsViewer.this.checkAddButton();
                ActorsAndGoalsViewer.this.useCaseAdapter.actorsNamesChanged();
                ActorsAndGoalsViewer.this.viewer.refresh();
            }
        });
        editActorsButton.setEnabled(this.enabled && this.modelController.getProjectAgent().getModulePermissionChecker().hasPermission("operationEditGlobalActors", null, (IPermissionOperand)UseCasePermissionRootNode.getSingleton()));
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ActorsAndGoalsViewer.this.callback.setDirty();
                ActorsAndGoalsViewer.this.checkRemoveButton();
            }
        });
        parent.pack();
        parent.layout();
        parent.redraw();
    }

    private void checkRemoveButton() {
        if (!this.enabled) {
            this.removeButton.setEnabled(false);
            return;
        }
        boolean enablement = true;
        Collection selectedGoals = this.getSelectedGoals();
        enablement = !selectedGoals.isEmpty();
        for (GoalWrapper goal : selectedGoals) {
            if (!this.usedActors.contains(goal)) continue;
            enablement = false;
            break;
        }
        this.removeButton.setEnabled(enablement);
    }

    private void checkAddButton() {
        Collection<Actor> actors = ((GoalTableContentProvider)this.viewer.getContentProvider()).getActors();
        this.addButton.setEnabled(this.enabled && this.modelController.getAllItems("ucm.Actor").size() > actors.size());
    }

    private Collection getSelectedGoals() {
        ISelection selection = this.viewer.getSelection();
        List selectedGoals = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toList() : Collections.EMPTY_LIST;
        return selectedGoals;
    }

    void check(GoalWrapper goal) {
        String errMsg = "";
        boolean err = false;
        GoalTableContentProvider contentProvider = (GoalTableContentProvider)this.viewer.getContentProvider();
        if (contentProvider.getActors().isEmpty()) {
            errMsg = ERROR_EMPTY_VIEW;
            err = true;
        } else if (contentProvider.getCurrentMainActorsGoal() == null) {
            errMsg = ERROR_NO_MAIN_ACTOR;
            err = true;
        }
        if (err) {
            this.callback.setErrMsg(errMsg);
        } else {
            this.callback.clearErrorMessage();
        }
        this.useCaseAdapter.actorsAvailable(!((GoalTableContentProvider)this.viewer.getContentProvider()).getActors().isEmpty());
    }

    public CheckboxTableViewer getViewer() {
        return this.viewer;
    }

    void initialized() {
        this.check(null);
        this.checkAddButton();
    }

    public void checkStateChanged() {
        this.callback.setDirty();
        this.checkRemoveButton();
        this.check(null);
    }

    public void actorAdded() {
        this.callback.setDirty();
        this.checkAddButton();
    }

    public void setUsedActors(Collection goalWrappers) {
        this.usedActors = new HashSet(goalWrappers);
        this.checkRemoveButton();
    }

    public void setCallback(IEditDialogErrorCallback callback) {
        assert (callback != null) : "callback must not be null";
        this.callback = callback;
        this.check(null);
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            int column = ActorsAndGoalsViewer.this.columnProperties.indexOf(property);
            switch (column) {
                case 0: {
                    return !((GoalWrapper)element).isMainActor;
                }
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            GoalWrapper goalWrapper = (GoalWrapper)element;
            switch (ActorsAndGoalsViewer.this.columnProperties.indexOf(property)) {
                case 0: {
                    return goalWrapper.isMainActor;
                }
                case 2: {
                    return goalWrapper.goal.getDescription().getDisplayStringRepresentation();
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            GoalWrapper goalWrapper = element instanceof Item ? (GoalWrapper)((Item)element).getData() : (GoalWrapper)element;
            switch (ActorsAndGoalsViewer.this.columnProperties.indexOf(property)) {
                case 0: {
                    break;
                }
                case 2: {
                    String goalDescription = value == null ? "" : (String)value;
                    goalWrapper.goal.getDescription().setValueViaDisplayStringRepresentation(goalDescription);
                    ((GoalTableContentProvider)ActorsAndGoalsViewer.this.viewer.getContentProvider()).modifyGoal(goalWrapper);
                    break;
                }
            }
            ActorsAndGoalsViewer.this.check(goalWrapper);
        }
    }

    private class LabelProvider
    implements ITableLabelProvider {
        private LabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            GoalWrapper goalWrapper = (GoalWrapper)element;
            switch (columnIndex) {
                case 1: {
                    return goalWrapper.actor.getDisplayRepresentation();
                }
                case 2: {
                    return goalWrapper.goal.getDescription().getDisplayStringRepresentation();
                }
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

