/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.detailsviewprovider;

import com.arcway.cockpit.client.base.interfaces.frame.gui.DetailsElement;
import com.arcway.cockpit.frame.client.global.gui.views.details.CockpitProjectDataSelector;
import com.arcway.cockpit.frame.client.global.gui.views.details.DetailsView;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementMulti;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementSeparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementTable;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.DetailsElementTitle;
import com.arcway.cockpit.frame.client.global.gui.views.details.element.ListEntryParameter;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueList;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueMulti;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueSeparator;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueTable;
import com.arcway.cockpit.frame.client.global.gui.views.details.value.DetailsValueTitle;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.detailsviewprovider.ModuleDetailsProvider;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Extension;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.cockpit.usecasemodule.client.messages.description.ScenarioDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.IAction;

public class DetailsProviderScenario
extends ModuleDetailsProvider {
    protected List<DetailsElement> getTitleDetailsElements_internal(ICockpitProjectData itemToShow) {
        assert (itemToShow instanceof Scenario) : "element to be shown must be of type Scenario";
        Scenario scenario = (Scenario)itemToShow;
        ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(scenario.getProjectUID());
        return Collections.singletonList(new DetailsElementTitle(null, new DetailsValueTitle(modelController.getFullScenarioPrefix(scenario), this.getTitleImage((ICockpitProjectData)scenario))));
    }

    protected List<DetailsElement> getFixAttributeDetailsElements(ICockpitProjectData itemToShow) {
        assert (itemToShow instanceof Scenario) : "element to be shown must be of type Scenario";
        Scenario scenario = (Scenario)itemToShow;
        ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(scenario.getProjectUID());
        boolean isMainScenario = modelController.isMainScenario(scenario);
        ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>(4);
        if (!isMainScenario) {
            detailsElements.add((DetailsElement)new DetailsElementMulti(null, ScenarioDescription.NAME_TRIGGER, new DetailsValueMulti(scenario.getTrigger().getDisplayStringRepresentation()), true));
            detailsElements.add((DetailsElement)new DetailsElementMulti(null, ScenarioDescription.NAME_PRE, new DetailsValueMulti(scenario.getPrecondition().getDisplayStringRepresentation()), true));
            detailsElements.add((DetailsElement)new DetailsElementMulti(null, ScenarioDescription.NAME_POST_SUCC, new DetailsValueMulti(scenario.getSuccessPostcondition().getDisplayStringRepresentation()), true));
            detailsElements.add((DetailsElement)new DetailsElementMulti(null, ScenarioDescription.NAME_POST_FAIL, new DetailsValueMulti(scenario.getFailurePostcondition().getDisplayStringRepresentation()), true));
        }
        return detailsElements;
    }

    protected List<DetailsElement> getTypeSpecificAdditionalInformationDetailsElements(ICockpitProjectData itemToShow) {
        assert (itemToShow instanceof Scenario) : "element to be shown must be of type Scenario";
        Scenario scenario = (Scenario)itemToShow;
        ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(scenario.getProjectUID());
        DetailsView part = this.getContainingDetailsView();
        DetailsValueTable detailsValueExtendingItemsTable = new DetailsValueTable();
        detailsValueExtendingItemsTable.addColumn(Messages.getString("DetailsProviderScenario.ID"));
        detailsValueExtendingItemsTable.addColumn(Messages.getString("DetailsProviderScenario.BEGINNING_STEP"));
        detailsValueExtendingItemsTable.addColumn(Messages.getString("DetailsProviderScenario.FINAL_STEP"), 150);
        DetailsValueTable detailsValueActionStepTable = new DetailsValueTable();
        detailsValueActionStepTable.addColumn(Messages.getString("DetailsProviderScenario.Number"));
        detailsValueActionStepTable.addColumn(Messages.getString("DetailsProviderScenario.Title"), 220);
        boolean hasExtensions = false;
        List<ActionStep> steps = modelController.getActionSteps(scenario);
        int stepIndex = 0;
        for (ActionStep step : steps) {
            Iterator scenarios;
            if (++stepIndex != 1 && stepIndex != steps.size()) {
                DetailsValueList row = new DetailsValueList();
                row.addListElement(step.getNumber().getDisplayStringRepresentation(), null, new ListEntryParameter((Runnable)new CockpitProjectDataSelector((ICockpitProjectData)step, part), null, null));
                row.addListElement(step.getTitle().getDisplayStringRepresentation(), null, null);
                detailsValueActionStepTable.addTableRow(row);
            }
            if ((scenarios = modelController.getModuleData((IModuleData)step, "ScenarioBeginningStep").iterator()).hasNext()) {
                hasExtensions = true;
            }
            while (scenarios.hasNext()) {
                Scenario extendingScenario = (Scenario)((Object)scenarios.next());
                int kindOfFinalStep = modelController.getExtendingScenarioEndType(extendingScenario);
                String kindOfFinalStepText = Messages.getString("Scenario.ExtensionScenarioEndType_" + kindOfFinalStep);
                DetailsValueList row = new DetailsValueList();
                row.addListElement(modelController.getFullScenarioPrefix(extendingScenario), null, new ListEntryParameter((Runnable)new CockpitProjectDataSelector((ICockpitProjectData)extendingScenario, part), null, null));
                row.addListElement(modelController.getFullScenarioPrefixPlusStepNumber(step), null, null);
                row.addListElement(kindOfFinalStepText, null, null);
                detailsValueExtendingItemsTable.addTableRow(row);
            }
            Iterator extensions = modelController.getModuleData((IModuleData)step, "ExtensionBeginningStep").iterator();
            if (extensions.hasNext()) {
                hasExtensions = true;
            }
            while (extensions.hasNext()) {
                int kindOfFinalStep;
                Extension extension = (Extension)((Object)extensions.next());
                ActionStep finalStep = (ActionStep)((Object)modelController.getLinkableObjects((IModuleData)extension, "ExtensionFinalStep").iterator().next());
                if (finalStep == null) continue;
                block0 : switch (finalStep.getStepType().getValue()) {
                    case 0: {
                        kindOfFinalStep = 3;
                        break;
                    }
                    case 2: {
                        if (step.equals((Object)finalStep)) {
                            kindOfFinalStep = 1;
                            break;
                        }
                        kindOfFinalStep = 2;
                        break;
                    }
                    case 1: {
                        switch (extension.getSuccess().getValue()) {
                            case 0: {
                                kindOfFinalStep = 4;
                                break block0;
                            }
                            case 1: {
                                kindOfFinalStep = 5;
                                break block0;
                            }
                        }
                        kindOfFinalStep = 6;
                        break;
                    }
                    default: {
                        kindOfFinalStep = 7;
                    }
                }
                String kindOfFinalStepText = Messages.getString("Scenario.ExtensionScenarioEndType_" + kindOfFinalStep);
                UseCase extendingUseCase = (UseCase)((Object)modelController.getModuleData((IModuleData)extension, "UseCaseExtension").iterator().next());
                DetailsValueList row = new DetailsValueList();
                row.addListElement(extendingUseCase.getID().getDisplayStringRepresentation(), null, new ListEntryParameter((Runnable)new CockpitProjectDataSelector((ICockpitProjectData)extendingUseCase, part), null, null));
                row.addListElement(modelController.getFullScenarioPrefixPlusStepNumber(step), null, null);
                row.addListElement(kindOfFinalStepText, null, null);
                detailsValueExtendingItemsTable.addTableRow(row);
            }
        }
        ArrayList<DetailsElement> detailsElements = new ArrayList<DetailsElement>(3);
        detailsElements.add((DetailsElement)new DetailsElementTable(Messages.getString("DetailsProviderScenario.ActionStepTitle"), detailsValueActionStepTable));
        if (hasExtensions) {
            detailsElements.add((DetailsElement)new DetailsElementSeparator(null, 8, new DetailsValueSeparator()));
            detailsElements.add((DetailsElement)new DetailsElementTable(Messages.getString("DetailsProviderScenario.EXTENDING_USE_CASES"), detailsValueExtendingItemsTable));
        }
        return detailsElements;
    }

    public Collection<Class<?>> getDataTypesThatTriggerRefresh() {
        Collection types = super.getDataTypesThatTriggerRefresh();
        types.addAll(Arrays.asList(ActionStep.class, UseCase.class, Scenario.class, Extension.class));
        return types;
    }

    protected IModelController getModelController(String projectUID) {
        return UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
    }

    public IAction[] getToolbarActions() {
        return null;
    }

    public String getID() {
        return "ucm.Scenario";
    }

    public boolean canBeDisplayed(ICockpitProjectData item) {
        assert (item != null);
        if (!(item instanceof Scenario)) {
            return false;
        }
        Scenario scenario_ = (Scenario)item;
        IModelController modelController = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(scenario_.getProjectUID());
        return modelController.itemExists(scenario_.getTypeID(), scenario_.getUID());
    }
}

