/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.comparators;

import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.AbstractDataViewColumnComparator;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import de.plans.lib.util.StringComparatorFactory;
import java.util.Comparator;

public class NameComparator
extends AbstractDataViewColumnComparator {
    private final Comparator<String> stringComparator = StringComparatorFactory.getStringComparator((boolean)true);
    private static final NameComparator instance = new NameComparator();

    private NameComparator() {
    }

    public static synchronized NameComparator getDefault() {
        return instance;
    }

    public int compare(Object o1, Object o2) {
        if (o1 instanceof Category && o2 instanceof Category) {
            String name1 = ((Category)((Object)o1)).getName().getDisplayStringRepresentation();
            String name2 = ((Category)((Object)o2)).getName().getDisplayStringRepresentation();
            return this.stringComparator.compare(name1, name2);
        }
        if (o1 instanceof UseCase && o2 instanceof UseCase) {
            String name1 = ((UseCase)((Object)o1)).getID().getDisplayStringRepresentation();
            String name2 = ((UseCase)((Object)o2)).getID().getDisplayStringRepresentation();
            return this.stringComparator.compare(name1, name2);
        }
        if (o1 instanceof Scenario && o2 instanceof Scenario) {
            ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(((Scenario)((Object)o1)).getProjectUID());
            String prefix1 = modelController.getFullScenarioPrefix((Scenario)((Object)o1));
            String prefix2 = modelController.getFullScenarioPrefix((Scenario)((Object)o2));
            return this.stringComparator.compare(prefix1, prefix2);
        }
        if (o1 instanceof ActionStep && o2 instanceof ActionStep) {
            IModelController model = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(((ActionStep)((Object)o1)).getProjectUID());
            return ((ModelController)model).before((ActionStep)((Object)o1), (ActionStep)((Object)o2));
        }
        if (o1 instanceof ActionStep && o2 instanceof Scenario) {
            return -1;
        }
        if (o1 instanceof Scenario && o2 instanceof ActionStep) {
            return 1;
        }
        return 0;
    }
}

