/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.actions.IActionRunNotifier;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.licensetypes.ClientFunctionLicenseTypeUCMModifyItems;
import com.arcway.cockpit.usecasemodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.usecasemodule.client.gui.actions.UCMModuleAction;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.EditCategoryAdapter;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchPart;

public class ActionNewCategory
extends UCMModuleAction
implements IModuleProjectSwitchListener,
IActionRunNotifier {
    private IModelController model;

    public ActionNewCategory() {
        this.setText(Messages.getString("ActionNewCategory.NEW_CATEGORY"));
        this.setToolTipText(Messages.getString("ActionNewCategory.CREATE_NEW_USE_CASE_CATEGORY"));
        this.setImageDescriptor(UseCaseModulePlugin.getImageDescriptor("Category.gif"));
        this.setEnabled(false);
    }

    protected void handleProjectChanged(String projectUID) {
        boolean hasPermission = false;
        this.model = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
        if (this.model != null) {
            PermissionMgr permissionMgr = (PermissionMgr)this.model.getPermissionMgr();
            hasPermission = permissionMgr.mayModifyUseCaseCategories();
        }
        this.setEnabled(hasPermission);
    }

    public void modelRefreshed(IPropertyChanges changes, Class clazz) {
        assert (changes != null);
        if (this.model != null) {
            this.projectSwitched(this.model.getProjectUID());
        }
    }

    protected void handleSelectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    public void run() {
        assert (this.model != null) : "model must not be null";
        ModuleDataCreationWizard wizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)new EditCategoryAdapter(true), "ucm.category", this.model, Messages.getString("NewCategoryWizard.Message"));
        Category item = new Category();
        item.setProjectUID(this.model.getProjectUID());
        boolean creationPossible = wizard.initialiseWizard(new IModuleData[]{item}, new IModuleData[1]);
        if (!creationPossible) {
            return;
        }
        new WizardDialog(this.getContainingShell(), (IWizard)wizard).open();
        this.notifyRunListeners();
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeUCMModifyItems.getInstance();
    }
}

