/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChangesListener;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.licensetypes.ClientFunctionLicenseTypeUCMModifyItems;
import com.arcway.cockpit.usecasemodule.client.core.permissions.UseCasePermissionRootNode;
import com.arcway.cockpit.usecasemodule.client.gui.actions.UCMModuleAction;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.EditActorsDialogue;
import java.util.Collection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;

public class ActionEditActors
extends UCMModuleAction
implements IPropertyChangesListener {
    private final Collection additionalActors;
    private IModelController modelController;

    public ActionEditActors() {
        this.additionalActors = null;
        this.updateEnablement();
    }

    public ActionEditActors(IModelController modelController, Collection additionalActors) {
        this.modelController = modelController;
        this.additionalActors = additionalActors;
    }

    public void modelRefreshed(IPropertyChanges<?> changes, Class<?> clazz, String projectUID) {
        this.updateEnablement();
    }

    public void run() {
        EditActorsDialogue dialogue = this.additionalActors != null ? new EditActorsDialogue(this.getContainingShell(), this.modelController, this.additionalActors) : new EditActorsDialogue(this.getContainingShell(), this.modelController);
        dialogue.open();
    }

    protected void handleSelectionChanged(IWorkbenchPart part, ISelection selection) {
    }

    protected void handleProjectChanged(String projectUID) {
        this.modelController = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
        this.setEnabled(this.modelController != null && this.hasPermission());
    }

    private void updateEnablement() {
        this.setEnabled(this.modelController != null && this.hasPermission());
    }

    private boolean hasPermission() {
        return this.modelController.getProjectAgent().getModulePermissionChecker().hasPermission("operationEditGlobalActors", null, (IPermissionOperand)UseCasePermissionRootNode.getSingleton());
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeUCMModifyItems.getInstance();
    }
}

