/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.licensetypes.ClientFunctionLicenseTypeUCMModifyItems;
import com.arcway.cockpit.usecasemodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.usecasemodule.client.gui.DataView;
import com.arcway.cockpit.usecasemodule.client.gui.actions.UCMModuleActionDelegate;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.EditUseCaseAdapter;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.SelectSetDialogContentProvider;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.SelectSetDialogLabelProvider;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.cockpit.usecasemodule.shared.ModuleIdentification;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class ActionDelegateNewUseCaseViaUniqueElements
extends UCMModuleActionDelegate {
    private static final int STATUS_OK = 0;
    private static final int STATUS_NO_SELECTION = 1;
    private static final int STATUS_UNKNOWN = 2;
    private static final int STATUS_LOCKED = 3;
    private static final int STATUS_NO_PERMISSION = 4;
    private static final int[] SEVERITIES;
    private static final String[] STATUS_MESSAGES;
    private static String moduleID;
    private IModelController modelCtrl;
    private ArrayList selectedUniqueElements;
    private boolean enabled;

    static {
        int[] nArray = new int[5];
        nArray[1] = 4;
        nArray[2] = 4;
        nArray[3] = 4;
        nArray[4] = 4;
        SEVERITIES = nArray;
        STATUS_MESSAGES = new String[]{"", Messages.getString("ActionNewUseCase.StateNoSelection"), "", Messages.getString("ActionNewUseCase.StateLocked"), Messages.getString("ActionNewUseCase.NoPermission")};
        moduleID = ModuleIdentification.getModuleID();
    }

    protected boolean determineEnabledStatus(ISelection selection) {
        this.selectedUniqueElements = new ArrayList();
        if (selection instanceof IStructuredSelection) {
            for (Object selectedObject : (IStructuredSelection)selection) {
                if (!(selectedObject instanceof IUniqueElement)) continue;
                this.selectedUniqueElements.add(selectedObject);
            }
            if (this.selectedUniqueElements.size() > 0) {
                String projectUid = ((IUniqueElement)this.selectedUniqueElements.get(0)).getProjectUID();
                this.modelCtrl = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUid);
                this.enabled = true;
            } else {
                this.enabled = false;
            }
        } else {
            this.enabled = false;
        }
        return this.enabled;
    }

    public void run(IAction action) {
        assert (this.modelCtrl != null);
        SelectSetDialogContentProvider contentProvider = new SelectSetDialogContentProvider();
        SelectSetDialogLabelProvider labelProvider = new SelectSetDialogLabelProvider();
        ElementTreeSelectionDialog selectionDialog = new ElementTreeSelectionDialog(this.getIssuingShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
        selectionDialog.setAllowMultiple(false);
        selectionDialog.setDoubleClickSelects(true);
        selectionDialog.setMessage(Messages.getString("ActionNewUseCase.DialogMessage"));
        selectionDialog.setTitle(Messages.getString("ActionNewUseCase.DialogTitle"));
        List input = new ArrayList(this.modelCtrl.getAllRootItems());
        IViewPart dataView = this.getIssuingPart().getSite().getPage().findView("com.arcway.cockpit.usecasemodule.client.gui.dataview");
        if (dataView != null) {
            input = ((DataView)dataView).applySorters(input);
        }
        selectionDialog.setInput(input);
        ModuleLockManager lockManager = (ModuleLockManager)this.modelCtrl.getLockMgr();
        PermissionMgr permissionMgr = (PermissionMgr)this.modelCtrl.getPermissionMgr();
        SelectionStatusValidator validator = new SelectionStatusValidator(lockManager, permissionMgr);
        selectionDialog.setValidator((ISelectionStatusValidator)validator);
        if (selectionDialog.open() == 0) {
            Category newParent = (Category)((Object)selectionDialog.getFirstResult());
            EditUseCaseAdapter dialogProvider = new EditUseCaseAdapter(newParent);
            ModuleDataCreationWizard wizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)dialogProvider, "ucm.useCase", this.modelCtrl, Messages.getString("NewUseCaseWizard.Message"));
            UseCase newItem = new UseCase();
            newItem.setProjectUID(this.modelCtrl.getProjectUID());
            boolean creationPossible = wizard.initialiseWizard(new IModuleData[]{newItem}, new IModuleData[]{newParent});
            if (!creationPossible) {
                this.releaseInsertLock(validator);
                return;
            }
            WizardDialog dialog = new WizardDialog(this.getIssuingShell(), (IWizard)wizard);
            if (dialog.open() == 0) {
                final UseCase useCase = dialogProvider.getUseCase();
                if (this.selectedUniqueElements != null) {
                    final Iterator ueIterator = this.selectedUniqueElements.iterator();
                    this.modelCtrl.executeTransaction(new Runnable(){

                        @Override
                        public void run() {
                            while (ueIterator.hasNext()) {
                                IUniqueElement ue = (IUniqueElement)ueIterator.next();
                                ActionDelegateNewUseCaseViaUniqueElements.this.modelCtrl.createLink(ue.getUID(), (IModuleData)useCase, "UseCaseUniqueElement");
                            }
                        }
                    });
                }
            }
        } else {
            this.releaseInsertLock(validator);
        }
    }

    private void releaseInsertLock(SelectionStatusValidator validator) {
        LockAccess insertLock = validator.getLock();
        if (insertLock != null) {
            insertLock.releaseLocks();
        }
    }

    protected boolean determineEnabledStatus(String projectUID) {
        return this.enabled;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        return this.enabled;
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeUCMModifyItems.getInstance();
    }

    private class SelectionStatusValidator
    implements ISelectionStatusValidator {
        private LockAccess lock = null;
        private final ModuleLockManager lockMgr;
        private final PermissionMgr permissionMgr;

        public SelectionStatusValidator(ModuleLockManager lockManager, PermissionMgr permissionMgr) {
            this.lockMgr = lockManager;
            this.permissionMgr = permissionMgr;
        }

        public IStatus validate(Object[] selection) {
            if (this.lock != null) {
                this.lock.releaseLocks();
                this.lock = null;
            }
            int state = 2;
            if (selection.length == 0) {
                state = 1;
            } else {
                Category set = (Category)((Object)selection[0]);
                if (!this.permissionMgr.mayModifyUseCasesInCategory(set)) {
                    state = 4;
                } else {
                    this.lock = this.lockMgr.acquireInsertLock((ICockpitProjectData)set);
                    if (!this.lock.hasLock()) {
                        state = 3;
                        this.lock = null;
                    } else {
                        state = 0;
                    }
                }
            }
            return new Status(SEVERITIES[state], moduleID, state, STATUS_MESSAGES[state], null);
        }

        public LockAccess getLock() {
            return this.lock;
        }
    }
}

