/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.licensetypes.ClientFunctionLicenseTypeUCMModifyItems;
import com.arcway.cockpit.usecasemodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.usecasemodule.client.gui.actions.UCMModuleActionDelegate;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.EditUseCaseAdapter;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public class ActionDelegateNewUseCase
extends UCMModuleActionDelegate {
    private IModelController model = null;
    private Category singleSelectedCategory = null;
    private boolean enabled;

    protected boolean determineEnabledStatus(String projectUID) {
        this.model = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
        this.enabled = this.checkEnablement();
        return this.enabled;
    }

    private boolean checkEnablement() {
        boolean hasPermission = false;
        if (this.model != null && this.singleSelectedCategory != null) {
            PermissionMgr permissionMgr = (PermissionMgr)this.model.getPermissionMgr();
            hasPermission = permissionMgr.mayModifyUseCasesInCategory(this.singleSelectedCategory);
        }
        return hasPermission;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        this.enabled = this.checkEnablement();
        return this.enabled;
    }

    protected boolean determineEnabledStatus(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            String projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)selection);
            if (projectUID != null && ProjectMgr.getProjectMgr().getProjectAgent(projectUID).isOpened()) {
                this.model = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
                this.singleSelectedCategory = null;
                for (Object element : (IStructuredSelection)selection) {
                    if (!(element instanceof Category)) continue;
                    if (this.singleSelectedCategory == null) {
                        this.singleSelectedCategory = (Category)((Object)element);
                        continue;
                    }
                    this.singleSelectedCategory = null;
                    break;
                }
                this.enabled = this.checkEnablement();
            } else {
                this.singleSelectedCategory = null;
                this.enabled = false;
            }
        }
        return this.enabled;
    }

    public void run(IAction action) {
        assert (this.model != null) : "model must not be null";
        AbstractLockManager lockManager = this.model.getLockMgr();
        LockAccess lockAccess = lockManager.acquireInsertLock((ICockpitProjectData)this.singleSelectedCategory, true);
        if (!lockAccess.hasLock()) {
            return;
        }
        ModuleDataCreationWizard moduleDataEditWizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)new EditUseCaseAdapter(this.singleSelectedCategory), "ucm.useCase", this.model, Messages.getString("NewUseCaseWizard.Message"));
        UseCase item = new UseCase();
        item.setProjectUID(this.model.getProjectUID());
        boolean creationPossible = moduleDataEditWizard.initialiseWizard(new IModuleData[]{item}, new IModuleData[]{this.singleSelectedCategory});
        if (!creationPossible) {
            lockAccess.releaseLocks();
            return;
        }
        WizardDialog dialog = new WizardDialog(this.getIssuingShell(), (IWizard)moduleDataEditWizard);
        if (dialog.open() != 0) {
            lockAccess.releaseLocks();
        }
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeUCMModifyItems.getInstance();
    }
}

