/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataEditDialog;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.licensetypes.ClientFunctionLicenseTypeUCMModifyItems;
import com.arcway.cockpit.usecasemodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.usecasemodule.client.gui.actions.UCMModuleActionDelegate;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.EditScenarioAdapter;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.PlatformUI;

public class ActionDelegateNewExtensionScenario
extends UCMModuleActionDelegate {
    private IModelController model = null;
    private Scenario singleSelectedScenario = null;
    private ActionStep singleSelectedActionStep = null;
    private boolean enabled;

    protected boolean determineEnabledStatus(String projectUID) {
        this.model = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
        this.enabled = this.checkEnablement();
        return this.enabled;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        this.enabled = this.checkEnablement();
        return this.enabled;
    }

    private boolean checkEnablement() {
        boolean hasPermission = false;
        if (this.model != null) {
            PermissionMgr permissionMgr = (PermissionMgr)this.model.getPermissionMgr();
            if (this.singleSelectedScenario != null) {
                hasPermission = permissionMgr.mayModifyScenario(this.singleSelectedScenario);
            } else if (this.singleSelectedActionStep != null) {
                hasPermission = permissionMgr.mayModifyScenario((Scenario)this.model.getParent((IModuleData)this.singleSelectedActionStep));
            }
        }
        return hasPermission;
    }

    protected boolean determineEnabledStatus(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.singleSelectedScenario = null;
            this.singleSelectedActionStep = null;
            String projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)selection);
            if (projectUID != null && ProjectMgr.getProjectMgr().getProjectAgent(projectUID).isOpened()) {
                this.model = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (structuredSelection.size() == 1) {
                    Object selectedElement = structuredSelection.getFirstElement();
                    if (selectedElement instanceof Scenario) {
                        this.singleSelectedScenario = (Scenario)((Object)selectedElement);
                    } else if (selectedElement instanceof ActionStep) {
                        this.singleSelectedActionStep = (ActionStep)((Object)selectedElement);
                    }
                }
                this.enabled = this.checkEnablement();
                return this.enabled;
            }
            this.enabled = false;
            return this.enabled;
        }
        return this.enabled;
    }

    public void run(IAction action) {
        assert (this.model != null) : "model must not be null";
        Scenario scenario = this.singleSelectedScenario != null ? this.singleSelectedScenario : (Scenario)this.model.getParent((IModuleData)this.singleSelectedActionStep);
        AbstractLockManager lockManager = this.model.getLockMgr();
        LockAccess insertLock = lockManager.acquireInsertLock((ICockpitProjectData)scenario, true);
        if (!insertLock.hasLock()) {
            return;
        }
        LockAccess editLock = lockManager.acquireEditLock((ICockpitProjectData)scenario, true);
        if (!editLock.hasLock()) {
            insertLock.releaseLocks();
            return;
        }
        ModuleDataEditDialog moduleDataEditDialog = new ModuleDataEditDialog((IModuleDataEditDialogProvider)new EditScenarioAdapter(scenario, this.singleSelectedActionStep), PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        Scenario item = new Scenario();
        item.setProjectUID(this.model.getProjectUID());
        boolean creationPossible = moduleDataEditDialog.initialiseDialogue(new IModuleData[]{item});
        if (!creationPossible) {
            insertLock.releaseLocks();
            editLock.releaseLocks();
            return;
        }
        if (moduleDataEditDialog.open() != 0) {
            insertLock.releaseLocks();
            editLock.releaseLocks();
        }
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeUCMModifyItems.getInstance();
    }
}

