/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.licensetypes.ClientFunctionLicenseTypeUCMModifyItems;
import com.arcway.cockpit.usecasemodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.usecasemodule.client.gui.actions.UCMModuleActionDelegate;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.EditActionStepAdapter;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

public class ActionDelegateNewActionStep
extends UCMModuleActionDelegate {
    private IModelController model;
    private Scenario scenario = null;
    private boolean enabled;

    private boolean checkEnablement() {
        boolean hasPermission = false;
        if (this.model != null && this.scenario != null) {
            PermissionMgr permissionMgr = (PermissionMgr)this.model.getPermissionMgr();
            hasPermission = permissionMgr.mayModifyScenario(this.scenario);
        }
        return hasPermission;
    }

    protected boolean determineEnabledStatus(ISelection selection) {
        this.scenario = null;
        if (this.model != null && selection instanceof StructuredSelection) {
            String projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)selection);
            if (projectUID != null && ProjectMgr.getProjectMgr().getProjectAgent(projectUID).isOpened()) {
                StructuredSelection structuredSelection = (StructuredSelection)selection;
                Iterator it = structuredSelection.iterator();
                if (!it.hasNext()) {
                    this.enabled = false;
                } else {
                    Object object = it.next();
                    if (!(object instanceof Scenario)) {
                        this.enabled = false;
                    } else {
                        this.scenario = (Scenario)((Object)object);
                        PermissionMgr permissionMgr = (PermissionMgr)this.model.getPermissionMgr();
                        this.enabled = permissionMgr.mayModifyScenario(this.scenario) && !it.hasNext();
                    }
                }
            }
        } else {
            this.enabled = false;
        }
        return this.enabled;
    }

    public void run(IAction action) {
        assert (this.model != null) : "model must not be null";
        assert (this.scenario != null) : "scenario must not be null";
        AbstractLockManager lockManager = this.model.getLockMgr();
        LockAccess lockAccess = lockManager.acquireInsertLock((ICockpitProjectData)this.scenario, false);
        if (!lockAccess.hasLock()) {
            MessageDialog.openInformation((Shell)this.getIssuingShell(), (String)Messages.getString("ActionDelegateNewActionStep.LockTitle"), (String)Messages.getString("ActionDelegateNewActionStep.LockMessage"));
            return;
        }
        ModuleDataCreationWizard moduleDataEditWizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)new EditActionStepAdapter(true), "ucm.ActionStep", this.model, Messages.getString("NewActionStepWizard.Message"));
        ActionStep item = new ActionStep();
        item.setProjectUID(this.model.getProjectUID());
        boolean creationPossible = moduleDataEditWizard.initialiseWizard(new IModuleData[]{item}, new IModuleData[]{this.scenario});
        if (!creationPossible) {
            lockAccess.releaseLocks();
            return;
        }
        WizardDialog wizardDialog = new WizardDialog(this.getIssuingShell(), (IWizard)moduleDataEditWizard);
        if (wizardDialog.open() != 0) {
            lockAccess.releaseLocks();
        }
    }

    protected boolean determineEnabledStatus(String projectUID) {
        this.model = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
        this.enabled = this.checkEnablement();
        return this.enabled;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        this.enabled = this.checkEnablement();
        return this.enabled;
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeUCMModifyItems.getInstance();
    }
}

