/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccessWrapper;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataEditDialog;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.licensetypes.ClientFunctionLicenseTypeUCMModifyItems;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.usecasemodule.client.gui.actions.UCMModuleActionDelegate;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.EditUseCaseAdapter;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.GoalWrapper;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.SelectCategoryDialog;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Actor;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.Extension;
import com.arcway.cockpit.usecasemodule.client.messages.Goal;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.cockpit.usecasemodule.shared.ModuleIdentification;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class ActionDelegateExternalizeScenario
extends UCMModuleActionDelegate {
    private ModelController model;
    private Scenario singleSelectedScenario;
    private boolean enabled;
    private final Runnable link = new Runnable(){

        @Override
        public void run() {
            ActionDelegateExternalizeScenario.this.link();
        }
    };
    private UseCase item;
    private ActionStep beginningStep;
    private ActionStep finalStep;

    protected boolean determineEnabledStatus(String projectUID) {
        this.model = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
        this.enabled = this.checkEnablement();
        return this.enabled;
    }

    private boolean checkEnablement() {
        if (this.model != null) {
            PermissionMgr permissionMgr = (PermissionMgr)this.model.getPermissionMgr();
            return this.singleSelectedScenario != null && permissionMgr.mayModifyScenario(this.singleSelectedScenario);
        }
        return false;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        this.enabled = this.checkEnablement();
        return this.enabled;
    }

    protected boolean determineEnabledStatus(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            String projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)selection);
            if (projectUID != null && ProjectMgr.getProjectMgr().getProjectAgent(projectUID).isOpened()) {
                this.model = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
                this.singleSelectedScenario = null;
                for (Object element : (IStructuredSelection)selection) {
                    if (!(element instanceof Scenario)) continue;
                    if (this.singleSelectedScenario == null) {
                        Scenario scenario = (Scenario)((Object)element);
                        if (this.model.getLinkableObjects((IModuleData)scenario, "ScenarioBeginningStep").isEmpty()) continue;
                        this.singleSelectedScenario = scenario;
                        continue;
                    }
                    this.singleSelectedScenario = null;
                    break;
                }
                this.enabled = this.checkEnablement();
            } else {
                this.singleSelectedScenario = null;
                this.enabled = false;
            }
        }
        return this.enabled;
    }

    public void run(IAction action) {
        assert (this.model != null) : "model must not be null";
        AbstractLockManager lockManager = this.model.getLockMgr();
        Collection categories = this.model.getAllItems("ucm.category");
        Iterator i = categories.iterator();
        while (i.hasNext()) {
            Category category = (Category)((Object)i.next());
            if (((PermissionMgr)this.model.getPermissionMgr()).mayModifyUseCasesInCategory(category)) continue;
            i.remove();
        }
        if (categories.isEmpty()) {
            MessageDialog.openInformation((Shell)this.getIssuingShell(), (String)Messages.getString("ActionDelegateNewExtUseCase.NoPermissionsDialog.Title"), (String)Messages.getString("ActionDelegateNewExtUseCase.NoPermisionsDialog.Message"));
            return;
        }
        SelectCategoryDialog categoryDialog = new SelectCategoryDialog(this.getIssuingShell(), categories, Messages.getString("ActionDelegateNewExtUseCase.SelectCategoryDialog.Title"), Messages.getString("ActionDelegateNewExtUseCase.SelectCategoryDialog.Message"));
        if (categoryDialog.open() != 0) {
            return;
        }
        Category selectedCategory = categoryDialog.getSelectedCategory();
        LockAccess categoryLock = lockManager.acquireInsertLock((ICockpitProjectData)selectedCategory, false);
        if (!categoryLock.hasLock()) {
            MessageDialog.openInformation((Shell)this.getIssuingShell(), (String)Messages.getString("ActionDelegateExternalizeScenario.LockTitle"), (String)Messages.getString("ActionDelegateExternalizeScenario.LockMessage"));
            return;
        }
        LockAccess lockBeforeMoving = lockManager.acquireMoveLockBeforeMoving((ICockpitProjectData)this.singleSelectedScenario, ModuleIdentification.getModuleID());
        if (!lockBeforeMoving.hasLock()) {
            categoryLock.releaseLocks();
            return;
        }
        this.beginningStep = (ActionStep)((Object)this.model.getLinkableObjects((IModuleData)this.singleSelectedScenario, "ScenarioBeginningStep").iterator().next());
        this.finalStep = (ActionStep)((Object)this.model.getLinkableObjects((IModuleData)this.singleSelectedScenario, "ScenarioFinalStep").iterator().next());
        UseCase useCase = this.model.getUseCase(this.singleSelectedScenario);
        Collection goals = this.model.getGoals(useCase);
        ArrayList<GoalWrapper> goalWrappers = new ArrayList<GoalWrapper>(goals.size());
        for (Goal goal : goals) {
            Actor actor = this.model.getActor(goal);
            goalWrappers.add(new GoalWrapper(actor, goal));
        }
        Collection<Scenario> extendingScenarios = this.model.getExtendingScenarios(this.singleSelectedScenario);
        ModuleDataEditDialog moduleDataEditDialog = new ModuleDataEditDialog((IModuleDataEditDialogProvider)new EditUseCaseAdapter(selectedCategory, this.singleSelectedScenario, goalWrappers, extendingScenarios), this.getIssuingShell());
        this.item = new UseCase();
        this.item.setProjectUID(this.model.getProjectUID());
        LockAccessWrapper idLock = new LockAccessWrapper();
        try {
            String generatedID = this.model.getNewUseCaseID(selectedCategory, true, idLock);
            this.item.getID().setValue(generatedID);
            boolean creationPossible = moduleDataEditDialog.initialiseDialogue(new IModuleData[]{this.item});
            if (!creationPossible) {
                categoryLock.releaseLocks();
                lockBeforeMoving.releaseLocks();
                idLock.getLockAccess().releaseLocks();
            }
            if (moduleDataEditDialog.open() == 0) {
                this.model.executeTransaction(this.link);
                if (!generatedID.equals(this.item.getID().getValue())) {
                    idLock.getLockAccess().releaseLocks();
                }
            } else {
                lockBeforeMoving.releaseLocks();
                categoryLock.releaseLocks();
                idLock.getLockAccess().releaseLocks();
            }
        }
        catch (EXCockpitLockDenied e) {
            MessageDialog.openWarning((Shell)this.getIssuingShell(), (String)com.arcway.cockpit.modulelib2.client.Messages.getString((String)"CreationAction.ExclusiveProjectLock.Title"), (String)com.arcway.cockpit.modulelib2.client.Messages.getString((String)"CreationAction.ExclusiveProjectLock.Message"));
        }
    }

    private void link() {
        boolean linkingSuccessful = this.model.getProjectAgent().getLockManager().doWithBlockOfflineModeProjectLock(new Runnable(){

            @Override
            public void run() {
                Extension extension = new Extension();
                extension.setProjectUID(ActionDelegateExternalizeScenario.this.model.getProjectUID());
                ActionDelegateExternalizeScenario.this.model.addItem((IModuleData)extension);
                extension.getSuccess().setValue(ActionDelegateExternalizeScenario.this.singleSelectedScenario.getSuccess().getValue());
                ActionDelegateExternalizeScenario.this.model.createLink(extension.getUID(), (IModuleData)ActionDelegateExternalizeScenario.this.item, "UseCaseExtension");
                ActionDelegateExternalizeScenario.this.model.createLink(ActionDelegateExternalizeScenario.this.beginningStep.getUID(), (IModuleData)extension, "ExtensionBeginningStep");
                ActionDelegateExternalizeScenario.this.model.createLink(ActionDelegateExternalizeScenario.this.finalStep.getUID(), (IModuleData)extension, "ExtensionFinalStep");
            }
        });
        if (!linkingSuccessful) {
            MessageDialog.openError((Shell)this.getIssuingShell(), (String)Messages.getString("ActionExternaliseScenario.ExclusiveProjectLockMessage.Title"), (String)Messages.getString("ActionExternaliseScenario.ExclusiveProjectLockMessage.Message"));
        }
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeUCMModifyItems.getInstance();
    }
}

