/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleLockManager;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.licensetypes.ClientFunctionLicenseTypeUCMModifyItems;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.usecasemodule.client.gui.actions.UCMModuleActionDelegate;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.Extension;
import com.arcway.cockpit.usecasemodule.client.messages.Goal;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ActionDelegateDelete
extends UCMModuleActionDelegate {
    private ModelController model;
    private boolean enabled;
    private final Collection selectedElements = new HashSet();

    protected boolean determineEnabledStatus(String projectUID) {
        this.model = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
        this.clearModelReferenceAndBecomeDisabledIfProjectIsNotOpen();
        return this.enabled;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        this.selectedElements.removeAll(changes.getDeletedElements());
        return this.enabled;
    }

    public void run(IAction action) {
        this.clearModelReferenceAndBecomeDisabledIfProjectIsNotOpen();
        if (this.model != null) {
            this.model.executeTransaction(new DeleteRunnable(this.model, this.selectedElements, this.getIssuingShell()));
        }
    }

    private void clearModelReferenceAndBecomeDisabledIfProjectIsNotOpen() {
        if (this.model == null || this.model.getProjectAgent() == null || !this.model.getProjectAgent().isOpened()) {
            this.model = null;
            this.enabled = false;
            this.selectedElements.clear();
        }
    }

    protected boolean determineEnabledStatus(ISelection selection) {
        boolean enablement = false;
        HashSet useCases = new HashSet();
        HashSet mainScenarios = new HashSet();
        this.selectedElements.clear();
        String projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)selection);
        if (projectUID != null) {
            this.model = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
            this.clearModelReferenceAndBecomeDisabledIfProjectIsNotOpen();
            if (this.model != null && selection instanceof IStructuredSelection && ProjectMgr.getProjectMgr().getProjectAgent(projectUID).isOpened() && !selection.isEmpty()) {
                enablement = true;
                PermissionMgr permissionMgr = (PermissionMgr)this.model.getPermissionMgr();
                for (Object element : (StructuredSelection)selection) {
                    if (!(element instanceof IModuleData) || this.isValidDataType((IModuleData)element) && !this.model.itemExists(((IModuleData)element).getTypeID(), ((IModuleData)element).getUID())) {
                        this.enabled = enablement = false;
                        return enablement;
                    }
                    if (element instanceof Category) {
                        if (!permissionMgr.mayModifyUseCaseCategory((Category)((Object)element)) && !permissionMgr.mayModifyUseCaseCategories()) break;
                        this.selectedElements.add(element);
                        continue;
                    }
                    if (element instanceof UseCase) {
                        if (!permissionMgr.mayModifyUseCase((UseCase)((Object)element))) break;
                        this.selectedElements.add(element);
                        useCases.add(element);
                        continue;
                    }
                    if (element instanceof Scenario) {
                        if (!permissionMgr.mayModifyScenario((Scenario)((Object)element))) break;
                        this.selectedElements.add(element);
                        if (!this.model.isMainScenario((Scenario)((Object)element))) continue;
                        mainScenarios.add(element);
                        continue;
                    }
                    if (!(element instanceof ActionStep)) continue;
                    if (!permissionMgr.mayModifyActionStep((ActionStep)((Object)element))) break;
                    this.selectedElements.add(element);
                }
                for (Scenario scenario : mainScenarios) {
                    UseCase parent = this.model.getUseCase(scenario);
                    enablement &= useCases.contains((Object)parent);
                }
                enablement &= this.selectedElements.size() > 0;
            }
        }
        this.enabled = enablement;
        return enablement;
    }

    private boolean isValidDataType(IModuleData moduleData) {
        Collection moduleDataTypes = this.model.getDataTypesHelper().getDocumentationDataTypes();
        return moduleDataTypes.contains(moduleData.getTypeID());
    }

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeUCMModifyItems.getInstance();
    }

    private static void releaseLocks(Collection aquiredLocks) {
        for (LockAccess currentLock : aquiredLocks) {
            currentLock.releaseLocks();
        }
    }

    private static class DeleteRunnable
    implements Runnable {
        private final ModelController rModel;
        private final HashSet rElements;
        private final Shell rIssuingShell;

        public DeleteRunnable(ModelController model, Collection elements, Shell issuingShell) {
            assert (model != null);
            this.rModel = model;
            this.rElements = new HashSet(elements);
            this.rIssuingShell = issuingShell;
        }

        @Override
        public void run() {
            boolean bl;
            if (this.rElements.size() == 0) {
                return;
            }
            PermissionMgr permissionMgr = (PermissionMgr)this.rModel.getPermissionMgr();
            boolean hasPermission = permissionMgr.mayDeleteItems(this.rElements);
            if (!hasPermission) {
                permissionMgr.showNoPermissionMsg(this.rIssuingShell);
                return;
            }
            HashSet extensionsForInitialSelectedActionSteps = new HashSet();
            HashSet extensionsForSecondActionSteps = new HashSet();
            LinkedList<ActionStep> actionSteps = new LinkedList<ActionStep>();
            ModuleLockManager lockMgr = (ModuleLockManager)this.rModel.getLockMgr();
            LinkedList<LockAccess> acquiredLocks = new LinkedList<LockAccess>();
            Iterator iter = this.rElements.iterator();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof ICockpitProjectData)) continue;
                if (element instanceof ActionStep) {
                    ActionStep step = (ActionStep)((Object)element);
                    extensionsForInitialSelectedActionSteps.addAll(this.rModel.getModuleData((IModuleData)step, "ExtensionBeginningStep"));
                    extensionsForInitialSelectedActionSteps.addAll(this.rModel.getModuleData((IModuleData)step, "ExtensionFinalStep"));
                    actionSteps.add(step);
                    iter.remove();
                    continue;
                }
                ICockpitProjectData data = (ICockpitProjectData)element;
                LockAccess lock = lockMgr.acquireRemoveLock(data);
                if (!lock.hasLock()) {
                    ActionDelegateDelete.releaseLocks(acquiredLocks);
                    return;
                }
                acquiredLocks.add(lock);
            }
            MessageDialog messageDialog = new MessageDialog(this.rIssuingShell, Messages.getString("ActionDelegateDelete.DELETE_ITEMS"), null, Messages.getString("ActionDelegateDelete.CONFIRMATION"), 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
            if (messageDialog.open() != 0) {
                for (LockAccess lockAccess : acquiredLocks) {
                    lockAccess.releaseLocks();
                }
                return;
            }
            HashSet subItemsToBeDeleted = new HashSet();
            for (IModuleData toDelete : this.rElements) {
                subItemsToBeDeleted.addAll(this.rModel.getAllDescendants(toDelete));
            }
            this.rElements.addAll(subItemsToBeDeleted);
            HashSet<IModuleData> useCases = new HashSet<IModuleData>();
            for (IModuleData element : this.rElements) {
                if (element instanceof UseCase) {
                    useCases.add(element);
                }
                if (!(element instanceof ActionStep)) continue;
                ActionStep step = (ActionStep)element;
                extensionsForSecondActionSteps.addAll(this.rModel.getModuleData((IModuleData)step, "ExtensionBeginningStep"));
                extensionsForSecondActionSteps.addAll(this.rModel.getModuleData((IModuleData)step, "ExtensionFinalStep"));
            }
            HashSet<Extension> extensionsToBeDeleted = new HashSet<Extension>();
            for (UseCase useCase : useCases) {
                for (Extension extension : this.rModel.getLinkableObjects((IModuleData)useCase, "UseCaseExtension")) {
                    if (extensionsForInitialSelectedActionSteps.contains((Object)extension)) {
                        extensionsToBeDeleted.add(extension);
                        continue;
                    }
                    if (extensionsForSecondActionSteps.contains((Object)extension)) continue;
                    this.rModel.deleteItem((IModuleData)extension);
                }
                for (Goal goal : this.rModel.getModuleData((IModuleData)useCase, "GoalUseCase")) {
                    this.rModel.deleteItem((IModuleData)goal);
                }
                this.rModel.deleteItem((IModuleData)useCase);
            }
            this.rElements.removeAll(useCases);
            this.rModel.deleteItems(this.rElements);
            this.rModel.deleteItems(extensionsForSecondActionSteps);
            actionSteps.removeAll(this.rElements);
            boolean bl2 = false;
            for (ActionStep actionStep : actionSteps) {
                Scenario scenario = (Scenario)this.rModel.getParent((IModuleData)actionStep);
                LockAccess lock = lockMgr.acquireEditLock((ICockpitProjectData)scenario);
                if (lock.hasLock()) {
                    HashSet relatedExtensions = new HashSet();
                    relatedExtensions.addAll(this.rModel.getModuleData((IModuleData)actionStep, "ExtensionFinalStep"));
                    relatedExtensions.addAll(this.rModel.getModuleData((IModuleData)actionStep, "ExtensionBeginningStep"));
                    if (!this.rModel.removeStep(actionStep)) {
                        bl = true;
                        lock.releaseLocks();
                        continue;
                    }
                    this.rElements.add(actionStep);
                    extensionsToBeDeleted.removeAll(relatedExtensions);
                    continue;
                }
                bl = true;
            }
            this.rModel.deleteItems(extensionsToBeDeleted);
            if (bl) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("ActionDelegateDelete.REMOVE_PROBLEM"), (String)Messages.getString("ActionDelegateDelete.ACTION_STEP_DELETION_PROBLEM"));
            }
        }
    }
}

