/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui.actions;

import com.arcway.cockpit.client.base.interfaces.frame.propertychanges.IPropertyChanges;
import com.arcway.cockpit.frame.client.global.ProjectMgr;
import com.arcway.cockpit.frame.client.global.gui.ProjectSelectionAnalyser;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LockAccess;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.IModuleDataEditDialogProvider;
import com.arcway.cockpit.modulelib2.client.gui.editdialogs.ModuleDataCreationWizard;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.licensetypes.ClientFunctionLicenseTypeUCMModifyItems;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.core.project.PermissionMgr;
import com.arcway.cockpit.usecasemodule.client.gui.actions.UCMModuleActionDelegate;
import com.arcway.cockpit.usecasemodule.client.gui.dialogues.EditActionStepAdapter;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;

public abstract class AbstractActionDelegateNewActionStep
extends UCMModuleActionDelegate {
    private IModelController model = null;
    private ActionStep singleSelectedActionStep = null;
    private boolean enabled;

    protected boolean determineEnabledStatus(String projectUID) {
        this.model = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
        this.enabled = this.checkEnablement();
        return this.enabled;
    }

    private boolean checkEnablement() {
        boolean hasPermission = false;
        if (this.model != null && this.singleSelectedActionStep != null) {
            PermissionMgr permissionMgr = (PermissionMgr)this.model.getPermissionMgr();
            hasPermission = permissionMgr.mayModifyScenario((Scenario)this.model.getParent((IModuleData)this.singleSelectedActionStep));
        }
        return hasPermission;
    }

    protected boolean determineEnabledStatus(IPropertyChanges changes, Class clazz) {
        this.enabled = this.checkEnablement();
        return this.enabled;
    }

    protected boolean determineEnabledStatus(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            String projectUID = ProjectSelectionAnalyser.extractProjectUID((ISelection)selection);
            if (projectUID != null && ProjectMgr.getProjectMgr().getProjectAgent(projectUID).isOpened()) {
                this.model = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
                this.singleSelectedActionStep = null;
                if (((IStructuredSelection)selection).size() != 1) {
                    this.enabled = false;
                    return this.enabled;
                }
                Object element = ((IStructuredSelection)selection).iterator().next();
                if (element instanceof ActionStep) {
                    this.singleSelectedActionStep = (ActionStep)((Object)element);
                }
                this.enabled = this.checkEnablement();
            } else {
                this.enabled = false;
            }
        }
        return this.enabled;
    }

    public void run(IAction action) {
        assert (this.model != null) : "model must not be null";
        ActionStep item = new ActionStep();
        item.setProjectUID(this.model.getProjectUID());
        Scenario parent = (Scenario)this.model.getParent((IModuleData)this.singleSelectedActionStep);
        UseCase useCase = ((ModelController)this.model).getUseCase(this.singleSelectedActionStep);
        AbstractLockManager lockManager = this.model.getLockMgr();
        LockAccess lockAccess = lockManager.acquireEditLock((ICockpitProjectData)parent, true);
        if (!lockAccess.hasLock()) {
            return;
        }
        ModuleDataCreationWizard moduleDataEditWizard = new ModuleDataCreationWizard((IModuleDataEditDialogProvider)new EditActionStepAdapter(this.singleSelectedActionStep, this.insertedBefore(), useCase), "ucm.ActionStep", this.model, Messages.getString("NewActionStepWizard.Message"));
        boolean creationPossible = moduleDataEditWizard.initialiseWizard(new IModuleData[]{item}, new IModuleData[]{parent});
        if (!creationPossible) {
            lockAccess.releaseLocks();
            return;
        }
        if (new WizardDialog(this.getIssuingShell(), (IWizard)moduleDataEditWizard).open() != 0) {
            lockAccess.releaseLocks();
        }
    }

    protected abstract boolean insertedBefore();

    protected IClientFunctionLicenseType2 getRequiredLicenseType() {
        return ClientFunctionLicenseTypeUCMModifyItems.getInstance();
    }
}

