/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractBooleanValueFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractDateValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractDiscreteValueFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextListFilter;
import com.arcway.cockpit.cockpitlib.client.filter.AbstractTextValuesFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.BooleanFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.DateFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.DiscreteValueListFilterItem;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.global.gui.views.lib.dataview.filters.FilterHelper;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.ObjectTypeCategoryFilter;
import com.arcway.cockpit.frame.client.project.core.framedata.datatypes.filters.ObjectTypeCategoryTableListFilterItem;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.filters.AbstractStringValueFilter;
import com.arcway.cockpit.modulelib2.client.gui.filters.ModuleDataTableListFilterItem;
import com.arcway.cockpit.modulelib2.client.gui.filters.StringValueFilterItem;
import com.arcway.cockpit.modulelib2.client.messages.AbstractModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.attributes.ModuleDataAttributeTimestamp;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.gui.DataViewColumnConstants;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Actor;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.Goal;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.cockpit.usecasemodule.client.messages.description.CategoryDescription;
import com.arcway.cockpit.usecasemodule.client.messages.description.UseCaseDescription;
import com.arcway.cockpit.usecasemodule.shared.ModuleIdentification;
import com.arcway.lib.ui.editor.ObjectTypeCategoryLabels;
import de.plans.lib.util.valueranges.IString;
import de.plans.lib.util.valueranges.IValueRangeHelperText;
import de.plans.lib.util.valueranges.ValueRangeHelperString;
import de.plans.lib.util.valueranges.ValueRangeHelperTimestamp;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class UseCaseFilters
implements IModuleProjectSwitchListener {
    private final boolean useFixModel;
    private IModelController model;
    private IModuleProjectSwitchListenerManager projectSwitchListenerManager;
    private ModuleDataTableListFilterItem authorFilterItem;
    private ModuleDataTableListFilterItem initiatorFilterItem;
    private ModuleDataTableListFilterItem nameFilterItem;

    public UseCaseFilters(IModuleProjectSwitchListenerManager projectSwitchListenerManager) {
        assert (projectSwitchListenerManager != null) : "view facade must not be null";
        projectSwitchListenerManager.registerProjectSwitchListener((IModuleProjectSwitchListener)this);
        this.projectSwitchListenerManager = projectSwitchListenerManager;
        this.useFixModel = false;
    }

    public UseCaseFilters(IModelController model) {
        this.model = model;
        this.useFixModel = true;
    }

    public List<IFilterItem> createFilters() {
        ArrayList<IFilterItem> filterItems = new ArrayList<IFilterItem>(16);
        ObjectTypeCategoryTableListFilterItem filter = this.getObjectTypeCategoryFilter(UseCase.DATA_TYPE_DESCRIPTION);
        if (filter != null) {
            filterItems.add((IFilterItem)filter);
        }
        filterItems.add(this.createCategoryNameFilterItem());
        filterItems.add(this.createUseCaseDescriptionFilterItem());
        filterItems.add(this.createUseCaseScopeFilterItem());
        filterItems.add((IFilterItem)this.createUseCaseActorFilterItem());
        filterItems.add(this.createUseCaseLevelFilterItem());
        filterItems.add(this.createUseCaseStateFilterItem());
        filterItems.add(this.createUseCasePriorityFilterItem());
        filterItems.add(this.createUseCaseIsExtendedFilterItem());
        filterItems.add(this.createUseCaseHasOnlyLinkedActionStepsFilterItem());
        filterItems.add(this.createUseCaseInitiatorFilterItem());
        filterItems.add(this.createUseCaseAuthorFilterItem());
        filterItems.add(this.createUseCaseModificationDateFilterItem());
        filterItems.add(this.createUseCaseCreationDateFilterItem());
        return filterItems;
    }

    public IFilterItem createUseCaseIsExtendedFilterItem() {
        return new BooleanFilterItem(FilterHelper.getFilterName((String)UseCaseDescription.MODULE_DATA_NAME, (String)Messages.getString("UseCaseFilters.USE_CASE_EXTENDS_ANOTHER_ONE")), this.createUseCaseIsExtendingFilter());
    }

    public AbstractBooleanValueFilter createUseCaseIsExtendingFilter() {
        return new AbstractBooleanValueFilter(){

            protected boolean isValidObjectType(Object element) {
                return element instanceof UseCase;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "UseCaseIsExtendedFilter";
            }

            protected boolean getBooleanAttribute(Object element) {
                if (element instanceof UseCase) {
                    return UseCaseFilters.this.model.getLinksForModuleDataItem((IModuleData)((UseCase)((Object)element)), "UseCaseExtension").size() > 0;
                }
                return false;
            }
        };
    }

    public IFilterItem createUseCaseHasOnlyLinkedActionStepsFilterItem() {
        return new BooleanFilterItem(FilterHelper.getFilterName((String)UseCaseDescription.MODULE_DATA_NAME, (String)Messages.getString("UseCaseFilters.ALL_STEPS_ARE_LINKED_WITH_UNIQUE_ELEMENTS")), this.createUseCaseHasOnlyLinkedActionStepsFilter());
    }

    public AbstractBooleanValueFilter createUseCaseHasOnlyLinkedActionStepsFilter() {
        return new AbstractBooleanValueFilter(){

            protected boolean isValidObjectType(Object element) {
                return element instanceof UseCase;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "UseCaseHasOnlyLinkedActionStepsFilter";
            }

            protected boolean getBooleanAttribute(Object element) {
                for (IModuleData elem : UseCaseFilters.this.model.getAllDescendants((IModuleData)((UseCase)((Object)element)))) {
                    if (!(elem instanceof ActionStep) || ((ActionStep)elem).getStepType().getValue() != 2 || !UseCaseFilters.this.model.getLinksForModuleDataItem(elem, "StepUniqueElement").isEmpty()) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public IFilterItem createUseCaseScopeFilterItem() {
        return new StringValueFilterItem(FilterHelper.getFilterName((String)UseCaseDescription.MODULE_DATA_NAME, (String)UseCaseDescription.NAME_SCOPE), this.createUseCaseScopeFilter());
    }

    public AbstractStringValueFilter createUseCaseScopeFilter() {
        return new AbstractStringValueFilter(){

            protected IString getStringAttribute(Object element) {
                if (element instanceof UseCase) {
                    return ((UseCase)((Object)element)).getScope();
                }
                return null;
            }

            protected IValueRangeHelperText getValueRangeHelper() {
                return new ValueRangeHelperString(this.filterString);
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "UseCaseScopeFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof UseCase;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("ucm.useCase.scope");
            }
        };
    }

    public IFilterItem createUseCaseDescriptionFilterItem() {
        return new StringValueFilterItem(FilterHelper.getFilterName((String)UseCaseDescription.MODULE_DATA_NAME, (String)UseCaseDescription.NAME_DESCRIPTION), this.createUseCaseDescriptionFilter());
    }

    public AbstractStringValueFilter createUseCaseDescriptionFilter() {
        return new AbstractStringValueFilter(){

            protected IString getStringAttribute(Object element) {
                if (element instanceof UseCase) {
                    return ((UseCase)((Object)element)).getName();
                }
                return null;
            }

            protected IValueRangeHelperText getValueRangeHelper() {
                return new ValueRangeHelperString(this.filterString);
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "UseCaseDescriptionFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof UseCase;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("ucm.useCase.description");
            }
        };
    }

    public ModuleDataTableListFilterItem createUseCaseActorFilterItem() {
        if (this.useFixModel) {
            return new ModuleDataTableListFilterItem(FilterHelper.getFilterName((String)UseCaseDescription.MODULE_DATA_NAME, (String)Messages.getString("UseCaseFilters.HasActorsFilter")), "ucm.Actor", this.model, this.createUseCaseActorFilter(), false);
        }
        return new ModuleDataTableListFilterItem(FilterHelper.getFilterName((String)UseCaseDescription.MODULE_DATA_NAME, (String)Messages.getString("UseCaseFilters.HasActorsFilter")), "ucm.Actor", this.projectSwitchListenerManager, (IModelControllerProvider)UseCaseModulePlugin.getDefault().getProjectManager(), this.createUseCaseActorFilter(), false);
    }

    public AbstractTextValuesFilter createUseCaseActorFilter() {
        return new AbstractTextListFilter(){

            protected boolean isValidObjectType(Object element) {
                return element instanceof UseCase;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "ActorFilter";
            }

            protected String[] getStringAttributes(Object element) {
                if (element instanceof UseCase) {
                    UseCase useCase = (UseCase)((Object)element);
                    Collection goals = UseCaseFilters.this.model.getModuleData((IModuleData)useCase, "GoalUseCase");
                    String[] goalNames = new String[goals.size()];
                    int c = 0;
                    for (ICockpitProjectData singlePotentialGoal : goals) {
                        if (!$assertionsDisabled && !(singlePotentialGoal instanceof Goal)) {
                            throw new AssertionError((Object)"ICockpitProjectData should be of type Goal");
                        }
                        Goal goal = (Goal)singlePotentialGoal;
                        Actor actor = ((ModelController)UseCaseFilters.this.model).getActor(goal);
                        goalNames[c] = actor.getName().getDisplayStringRepresentation();
                        ++c;
                    }
                    return goalNames;
                }
                return null;
            }
        };
    }

    public IFilterItem createUseCaseAuthorFilterItem() {
        if (this.useFixModel) {
            this.authorFilterItem = new UseCaseAuthorFilterItem(this.model, this.createUseCaseAuthorFilter());
        } else {
            this.authorFilterItem = new UseCaseAuthorFilterItem(this.projectSwitchListenerManager, this.createUseCaseAuthorFilter());
            this.projectSwitchListenerManager.registerProjectSwitchListener((IModuleProjectSwitchListener)this.authorFilterItem);
        }
        return this.authorFilterItem;
    }

    public AbstractTextValuesFilter createUseCaseAuthorFilter() {
        return new AbstractTextListFilter(){

            protected String[] getStringAttributes(Object element) {
                if (element instanceof UseCase) {
                    return new String[]{((UseCase)((Object)element)).getCreator().getValue().trim()};
                }
                return null;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "UseCaseAuthorFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof UseCase;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("abstractmoduledata_creator");
            }
        };
    }

    public IFilterItem createUseCaseInitiatorFilterItem() {
        if (this.useFixModel) {
            this.initiatorFilterItem = new UseCaseInitiatorFilterItem(this.model, this.createUseCaseInitiatorFilter());
        } else {
            this.initiatorFilterItem = new UseCaseInitiatorFilterItem(this.projectSwitchListenerManager, this.createUseCaseInitiatorFilter());
            this.projectSwitchListenerManager.registerProjectSwitchListener((IModuleProjectSwitchListener)this.initiatorFilterItem);
        }
        return this.initiatorFilterItem;
    }

    public AbstractTextValuesFilter createUseCaseInitiatorFilter() {
        return new AbstractTextListFilter(){

            protected String[] getStringAttributes(Object element) {
                if (element instanceof UseCase) {
                    return new String[]{((UseCase)((Object)element)).getInitiator().getValue().trim()};
                }
                return null;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "UseCaseInitiatorFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof UseCase;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("ucm.useCase.initiator");
            }
        };
    }

    public IFilterItem createUseCaseCreationDateFilterItem() {
        return new DateFilterItem(FilterHelper.getFilterName((String)UseCaseDescription.MODULE_DATA_NAME, (String)AbstractModuleData.CDATE_NAME), this.createUseCaseCreationDateFilter());
    }

    public AbstractDateValuesFilter createUseCaseCreationDateFilter() {
        return new AbstractDateValuesFilter(){

            protected Timestamp getDateAttribute(Object element) {
                if (element instanceof UseCase) {
                    UseCase useCase = (UseCase)((Object)element);
                    ModuleDataAttributeTimestamp creationDate = useCase.getCreationTime();
                    return ((ValueRangeHelperTimestamp)creationDate.getValueRangeHelper()).getValue();
                }
                return null;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "UseCaseCreationDateFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof UseCase;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("ucm.useCase");
            }
        };
    }

    public IFilterItem createUseCaseModificationDateFilterItem() {
        return new DateFilterItem(FilterHelper.getFilterName((String)UseCaseDescription.MODULE_DATA_NAME, (String)AbstractModuleData.MDATE_NAME), this.createUseCaseModificationDateFilter());
    }

    public AbstractDateValuesFilter createUseCaseModificationDateFilter() {
        return new AbstractDateValuesFilter(){

            protected Timestamp getDateAttribute(Object element) {
                if (element instanceof UseCase) {
                    UseCase useCase = (UseCase)((Object)element);
                    ModuleDataAttributeTimestamp modificationDate = useCase.getModificationTime();
                    return ((ValueRangeHelperTimestamp)modificationDate.getValueRangeHelper()).getValue();
                }
                return null;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "UseCaseModificationDateFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof UseCase;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("ucm.useCase");
            }
        };
    }

    public IFilterItem createUseCasePriorityFilterItem() {
        return new DiscreteValueListFilterItem(FilterHelper.getFilterName((String)UseCaseDescription.MODULE_DATA_NAME, (String)UseCaseDescription.NAME_PRIORITY), Arrays.asList(UseCaseDescription.getPriorityKeys()), this.createUseCasePriorityFilter());
    }

    public AbstractDiscreteValueFilter createUseCasePriorityFilter() {
        return new AbstractDiscreteValueFilter(){

            protected int getDiscreteIndex(Object element) {
                if (element instanceof UseCase) {
                    return ((UseCase)((Object)element)).getPriority().getValue();
                }
                return -1;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "UseCasePriorityFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof UseCase;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("ucm.useCase.priority");
            }
        };
    }

    public IFilterItem createUseCaseLevelFilterItem() {
        return new DiscreteValueListFilterItem(FilterHelper.getFilterName((String)UseCaseDescription.MODULE_DATA_NAME, (String)UseCaseDescription.NAME_LEVEL), Arrays.asList(UseCaseDescription.getLevelKeys()), this.createUseCaseLevelFilter());
    }

    public AbstractDiscreteValueFilter createUseCaseLevelFilter() {
        return new AbstractDiscreteValueFilter(){

            protected int getDiscreteIndex(Object element) {
                if (element instanceof UseCase) {
                    return ((UseCase)((Object)element)).getLevel().getValue();
                }
                return -1;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "UseCaseLevelFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof UseCase;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("ucm.useCase.level");
            }
        };
    }

    public IFilterItem createUseCaseStateFilterItem() {
        return new DiscreteValueListFilterItem(FilterHelper.getFilterName((String)UseCaseDescription.MODULE_DATA_NAME, (String)UseCaseDescription.NAME_STATE), Arrays.asList(UseCaseDescription.getStateKeys()), this.createUseCaseStateFilter());
    }

    public AbstractDiscreteValueFilter createUseCaseStateFilter() {
        return new AbstractDiscreteValueFilter(){

            protected int getDiscreteIndex(Object element) {
                if (element instanceof UseCase) {
                    return ((UseCase)((Object)element)).getState().getValue();
                }
                return -1;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "UseCaseStateFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof UseCase;
            }

            public boolean isFilterProperty(Object element, String property) {
                return property.equals("ucm.useCase.state");
            }
        };
    }

    public IFilterItem createCategoryNameFilterItem() {
        if (this.useFixModel) {
            this.nameFilterItem = new CategoryNameFilterItem(this.model, this.createCategoryNameFilter());
        } else {
            this.nameFilterItem = new CategoryNameFilterItem(this.projectSwitchListenerManager, this.createCategoryNameFilter());
            this.projectSwitchListenerManager.registerProjectSwitchListener((IModuleProjectSwitchListener)this.nameFilterItem);
        }
        return this.nameFilterItem;
    }

    public AbstractTextValuesFilter createCategoryNameFilter() {
        return new AbstractTextListFilter(){

            protected String[] getStringAttributes(Object element) {
                Scenario scenario = null;
                UseCase useCase = null;
                Category category = null;
                if (element instanceof ActionStep) {
                    scenario = (Scenario)UseCaseFilters.this.model.getParent((IModuleData)((ActionStep)((Object)element)));
                } else if (element instanceof Scenario) {
                    scenario = (Scenario)((Object)element);
                }
                if (scenario != null) {
                    useCase = ((ModelController)UseCaseFilters.this.model).getUseCase(scenario);
                } else if (element instanceof UseCase) {
                    useCase = (UseCase)((Object)element);
                }
                if (useCase != null) {
                    category = (Category)UseCaseFilters.this.model.getParent((IModuleData)useCase);
                } else if (element instanceof Category) {
                    category = (Category)((Object)element);
                }
                if (category != null) {
                    return new String[]{category.getName().getValue().trim()};
                }
                return null;
            }

            public String getFilterID() {
                return String.valueOf(ModuleIdentification.getModuleID()) + "CategoryNameFilter";
            }

            protected boolean isValidObjectType(Object element) {
                return element instanceof Category || element instanceof UseCase || element instanceof Scenario || element instanceof ActionStep;
            }
        };
    }

    public ObjectTypeCategoryTableListFilterItem getObjectTypeCategoryFilter(IModuleDataTypeDescription type) {
        if (type.isSupportingCategories()) {
            String typeName = type.getModuleDataTypeDescriptionForFrame().getDisplayName();
            String objectsCockpitTypeID = type.getTypeID();
            String filterName = String.valueOf(typeName) + ": " + ObjectTypeCategoryLabels.LABEL_CATEGORY;
            ObjectTypeCategoryFilter filter = new ObjectTypeCategoryFilter(objectsCockpitTypeID);
            ObjectTypeCategoryTableListFilterItem filterItem = this.useFixModel ? new ObjectTypeCategoryTableListFilterItem(filterName, objectsCockpitTypeID, this.model.getProjectAgent(), (AbstractTextValuesFilter)filter) : new ObjectTypeCategoryTableListFilterItem(filterName, objectsCockpitTypeID, this.projectSwitchListenerManager, (AbstractTextValuesFilter)filter);
            return filterItem;
        }
        return null;
    }

    public void dispose() {
        if (this.projectSwitchListenerManager != null) {
            this.projectSwitchListenerManager.deregisterProjectSwitchListener((IModuleProjectSwitchListener)this);
        }
        this.model = null;
    }

    public void projectSwitched(String projectUID) {
        this.model = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
    }

    private static class CategoryNameFilterItem
    extends ModuleDataTableListFilterItem {
        public CategoryNameFilterItem(IModelController modelController, AbstractTextValuesFilter filter) {
            super(FilterHelper.getFilterName((String)CategoryDescription.MODULE_DATA_NAME, null), "ucm.category", modelController, filter, false);
        }

        public CategoryNameFilterItem(IModuleProjectSwitchListenerManager projectSwitchListenerManager, AbstractTextValuesFilter filter) {
            super(FilterHelper.getFilterName((String)CategoryDescription.MODULE_DATA_NAME, null), "ucm.category", projectSwitchListenerManager, (IModelControllerProvider)UseCaseModulePlugin.getDefault().getProjectManager(), filter, false);
        }

        protected String[] extractStringAttributes(IModuleData data) {
            return new String[]{((Category)data).getName().getDisplayStringRepresentation()};
        }
    }

    private static class UseCaseAuthorFilterItem
    extends ModuleDataTableListFilterItem {
        public UseCaseAuthorFilterItem(IModelController modelController, AbstractTextValuesFilter filter) {
            super(FilterHelper.getFilterName((String)UseCaseDescription.MODULE_DATA_NAME, (String)DataViewColumnConstants.COLUMN_NAME_AUTHOR), "ucm.useCase", modelController, filter);
        }

        public UseCaseAuthorFilterItem(IModuleProjectSwitchListenerManager projectSwitchListenerManager, AbstractTextValuesFilter filter) {
            super(FilterHelper.getFilterName((String)UseCaseDescription.MODULE_DATA_NAME, (String)DataViewColumnConstants.COLUMN_NAME_AUTHOR), "ucm.useCase", projectSwitchListenerManager, (IModelControllerProvider)UseCaseModulePlugin.getDefault().getProjectManager(), filter);
        }

        protected String[] extractStringAttributes(IModuleData data) {
            return new String[]{((UseCase)data).getCreator().getDisplayStringRepresentation()};
        }
    }

    private static class UseCaseInitiatorFilterItem
    extends ModuleDataTableListFilterItem {
        public UseCaseInitiatorFilterItem(IModelController modelController, AbstractTextValuesFilter filter) {
            super(FilterHelper.getFilterName((String)UseCaseDescription.MODULE_DATA_NAME, (String)UseCaseDescription.NAME_INITIATOR), "ucm.useCase", modelController, filter);
        }

        public UseCaseInitiatorFilterItem(IModuleProjectSwitchListenerManager projectSwitchListenerManager, AbstractTextValuesFilter filter) {
            super(FilterHelper.getFilterName((String)UseCaseDescription.MODULE_DATA_NAME, (String)UseCaseDescription.NAME_INITIATOR), "ucm.useCase", projectSwitchListenerManager, (IModelControllerProvider)UseCaseModulePlugin.getDefault().getProjectManager(), filter);
        }

        protected String[] extractStringAttributes(IModuleData data) {
            return new String[]{((UseCase)data).getInitiator().getDisplayStringRepresentation()};
        }
    }
}

