/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui;

import com.arcway.cockpit.frame.shared.message.EOLink;
import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.AbstractCopyManager;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.ClientDataFactory;
import com.arcway.cockpit.usecasemodule.client.messages.Extension;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UCMDataTypesHelper;
import com.arcway.cockpit.usecasemodule.shared.ModuleIdentification;
import com.arcway.cockpit.usecasemodule.shared.messages.UCMLinkTypeHelper_Shared;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UseCaseCopyManager
extends AbstractCopyManager {
    public UseCaseCopyManager() {
        super(ModuleIdentification.getModuleID(), (IClientDataFactory)new ClientDataFactory(), UCMLinkTypeHelper_Shared.getDefault());
        super.construct();
    }

    protected void customCopyOperations(IModuleData item, IModuleData parent, List rootItems, List items, Set links, Set mdLinksToContext, Set loLinksToContext, Set mdLinksToFrameContext, Set contextItems, Set linksToCopiedContext, IModelController modelController) {
        if (item instanceof Scenario) {
            Iterator finalStepLinkIterator = modelController.getLinksForModuleDataItem(item, "ScenarioFinalStep").iterator();
            if (finalStepLinkIterator.hasNext()) {
                EOLink finalStepLink = (EOLink)finalStepLinkIterator.next();
                links.add(finalStepLink);
            }
        } else if (item instanceof ActionStep) {
            Iterator previousStepLinkIterator;
            Iterator goalLinkIterator = modelController.getLinksForModuleDataItem(item, "ActionStepGoal").iterator();
            if (goalLinkIterator.hasNext()) {
                EOLink goalLink = (EOLink)goalLinkIterator.next();
                links.add(goalLink);
            }
            if ((previousStepLinkIterator = modelController.getLinksForModuleDataItem(item, "StepPreviousStep").iterator()).hasNext()) {
                EOLink previousStepLink = (EOLink)previousStepLinkIterator.next();
                links.add(previousStepLink);
            }
        } else if (item instanceof Extension) {
            EOLink endingExtensionLink = (EOLink)modelController.getLinksForModuleDataItem(item, "ExtensionFinalStep").iterator().next();
            links.add(endingExtensionLink);
        }
    }

    protected void customPasteOperations(IModuleData target, List rootItems, List items, List links, List mdLinksToContext, List loLinksToContext, List contextItems, List linksToCopiedContext, Map uidMap, IModelController modelController) {
        ModelController ucModelController = (ModelController)modelController;
        for (IModuleData item : items) {
            if (item instanceof Extension) {
                String newExtensionUID = (String)uidMap.get(item.getUID());
                if (!modelController.getLinksForLinkableObject(newExtensionUID, "UseCaseExtension").isEmpty()) continue;
                modelController.deleteItem(modelController.getItem("ucm.Extension", newExtensionUID));
                continue;
            }
            if (!(item instanceof Scenario)) continue;
            String newScenarioUID = (String)uidMap.get(item.getUID());
            Scenario newScenario = (Scenario)modelController.getItem("ucm.Scenario", newScenarioUID);
            ucModelController.recalculateScenarioOrder(newScenario);
        }
    }

    protected Collection getOptionalMDContextLinkTypes(String moduleDataCockpitTypeID) {
        return Collections.EMPTY_LIST;
    }

    protected Collection getOptionalLOContextLinkTypes(String moduleDataCockpitTypeID) {
        if (moduleDataCockpitTypeID.equals("ucm.Extension")) {
            return Arrays.asList("UseCaseExtension");
        }
        return Collections.EMPTY_LIST;
    }

    protected Collection getOptionalMDFrameContextLinkTypes(String moduleDataCockpitTypeID) {
        return Collections.EMPTY_LIST;
    }

    protected Collection getRequiredContextLinkTypes(String moduleDataCockpitTypeID) {
        if (moduleDataCockpitTypeID.equals("ucm.Goal")) {
            return Arrays.asList("GoalActor");
        }
        return Collections.EMPTY_LIST;
    }

    protected Collection getPossibleParentDataTypes(String typeID) {
        return UCMDataTypesHelper.getDefault().getParentTypeIDs(typeID);
    }

    protected Collection getAllCopyableDataTypes() {
        return Arrays.asList("ucm.category", "ucm.useCase");
    }
}

