/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui;

import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataViewHierarchy;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.gui.preferences.PreferenceManager;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UCMDataTypesHelper;
import com.arcway.cockpit.usecasemodule.client.messages.UCMUIDataTypesHelper;
import com.arcway.lib.java.collections.CollectionUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class UCMTreeDataViewHierarchy
extends StandardTreeDataViewHierarchy {
    public UCMTreeDataViewHierarchy() {
        super((IModelControllerProvider)UseCaseModulePlugin.getDefault().getProjectManager(), UCMDataTypesHelper.getDefault(), UCMUIDataTypesHelper.getDefault());
    }

    public List<?> getChildren(Object parentElement, ViewerFilter[] filters, Viewer viewer_, String projectUID) {
        IModelController modelController = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
        if (parentElement instanceof Scenario) {
            LinkedList<ActionStep> children = new LinkedList<ActionStep>(((ModelController)modelController).getRealActionSteps((Scenario)((Object)parentElement)));
            if (PreferenceManager.getScenarioMode().equals("inline")) {
                List<ActionStep> actionSteps = ((ModelController)modelController).getActionSteps((Scenario)((Object)parentElement));
                assert (actionSteps.size() >= 2) : "UCMTreeDataViewHierarchy: Less than 2 action steps in scenario";
                ActionStep beginningStep = actionSteps.get(0);
                assert (beginningStep.getStepType().getValue() == 0) : "UCMTreeDataViewHierarchy: First step is not a beginning step";
                ActionStep finalStep = actionSteps.get(actionSteps.size() - 1);
                assert (finalStep.getStepType().getValue() == 1) : "UCMTreeDataViewHierarchy: Last step is not an final step";
                children.addAll(CollectionUtils.getTypedCollection((Collection)modelController.getModuleData((IModuleData)beginningStep, "ScenarioBeginningStep"), Scenario.class));
                children.addAll(CollectionUtils.getTypedCollection((Collection)modelController.getModuleData((IModuleData)finalStep, "ScenarioBeginningStep"), Scenario.class));
            } else {
                children.addAll(((ModelController)modelController).getExtendingScenarios((Scenario)((Object)parentElement)));
            }
            return children;
        }
        if (parentElement instanceof ActionStep) {
            if (PreferenceManager.getScenarioMode().equals("inline")) {
                return super.getChildren(parentElement, filters, viewer_, projectUID);
            }
            return Collections.emptyList();
        }
        return super.getChildren(parentElement, filters, viewer_, projectUID);
    }

    public List<?> getParents(Object item, String projectUID) {
        assert (item instanceof IModuleData);
        IModuleData moduleDataItem = (IModuleData)item;
        IModelController modelController = UseCaseModulePlugin.getDefault().getProjectManager().getModelController(projectUID);
        if (item instanceof Scenario && !((ModelController)modelController).isMainScenario((Scenario)((Object)item))) {
            Collection beginningStepCollection = CollectionUtils.getTypedCollection((Collection)modelController.getLinkableObjects(moduleDataItem, "ScenarioBeginningStep"), ActionStep.class);
            ActionStep beginningStep = (ActionStep)((Object)beginningStepCollection.iterator().next());
            if (PreferenceManager.getScenarioMode().equals("separate") || beginningStep.getStepType().getValue() != 2) {
                return Collections.singletonList((Scenario)((Object)modelController.getLinkableObjects((IModuleData)beginningStep, "StepScenario").iterator().next()));
            }
        }
        return super.getParents(item, projectUID);
    }
}

