/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui;

import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.global.license.IClientFunctionLicenseType2;
import com.arcway.cockpit.frame.client.lib.dataviews.actions.ModuleActionDelegate;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DragSource;
import com.arcway.cockpit.frame.client.lib.dataviews.dnd.DropTarget;
import com.arcway.cockpit.frame.client.lib.dataviews.search.ICockpitSearchStringGenerator;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListener;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IModuleProjectSwitchListenerManager;
import com.arcway.cockpit.frame.client.lib.dataviews.util.IProjectAgentProvider;
import com.arcway.cockpit.frame.client.lib.dataviews.view.AbstractDataView;
import com.arcway.cockpit.frame.client.lib.dataviews.view.jfaceviewer.tree.TreeDataView;
import com.arcway.cockpit.modulelib2.client.core.IModelControllerProvider;
import com.arcway.cockpit.modulelib2.client.core.ProjectMgr;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.AttributeHandlerForCategories;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.AttributeHandlerForDiscreteValues;
import com.arcway.cockpit.modulelib2.client.gui.actions.discreteattributes.IDiscreteAttributeHandler;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.IFixColumnDescriptionProvider;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.IModuleFixColumnProvider;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataView;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.StandardTreeDataViewProvider;
import com.arcway.cockpit.modulelib2.client.gui.dnd.ICopyDragNDropExecuter;
import com.arcway.cockpit.modulelib2.client.gui.dnd.IMoveDragNDropExecuter;
import com.arcway.cockpit.modulelib2.client.gui.dnd.ItemEditorDragSupport;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.usecasemodule.client.IHelpContextIDs;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.licensetypes.ClientFunctionLicenseTypeUCMModifyItems;
import com.arcway.cockpit.usecasemodule.client.core.licensetypes.ClientFunctionLicenseTypeUCMSearch;
import com.arcway.cockpit.usecasemodule.client.gui.DataViewLabelProvider;
import com.arcway.cockpit.usecasemodule.client.gui.UCMFixColumnDescriptionProvider;
import com.arcway.cockpit.usecasemodule.client.gui.UseCaseFilters;
import com.arcway.cockpit.usecasemodule.client.gui.actions.ActionDelegateCopy;
import com.arcway.cockpit.usecasemodule.client.gui.actions.ActionDelegateDelete;
import com.arcway.cockpit.usecasemodule.client.gui.actions.ActionDelegatePaste;
import com.arcway.cockpit.usecasemodule.client.gui.actions.ActionEditActors;
import com.arcway.cockpit.usecasemodule.client.gui.dnd.ReorderActionStepsDragNDropSupport;
import com.arcway.cockpit.usecasemodule.client.gui.dnd.UseCaseCopyDragNDropSupport;
import com.arcway.cockpit.usecasemodule.client.gui.dnd.UseCaseEditorDragSupport;
import com.arcway.cockpit.usecasemodule.client.gui.dnd.UseCaseMoveDragNDropSupport;
import com.arcway.cockpit.usecasemodule.client.gui.dnd.UseCaseNaturalOrderDragNDropSupport;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStepSearchStringGenerator;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.CategorySearchStringGenerator;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.ScenarioSearchStringGenerator;
import com.arcway.cockpit.usecasemodule.client.messages.UCMDataTypesHelper;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.cockpit.usecasemodule.client.messages.UseCaseSearchStringGenerator;
import com.arcway.cockpit.usecasemodule.client.messages.description.UseCaseDescription;
import com.arcway.cockpit.usecasemodule.shared.ModuleIdentification;
import com.arcway.lib.java.EitherOr;
import com.arcway.lib.java.collectionmaps.ListMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.ui.IWorkbenchPart;

public class UCMDataViewProvider
extends StandardTreeDataViewProvider {
    private ActionDelegateCopy actionDelegateCopy;
    private ActionDelegateDelete actionDelegateDelete;
    private ActionDelegatePaste actionDelegatePaste;
    private UseCaseFilters filterFactory;
    private ActionEditActors actionEditActors;
    private ListMap<String, IDiscreteAttributeHandler> attributeHandlers;
    private final UseCaseEditorDragSupport editorDnDSupport;
    private final UseCaseMoveDragNDropSupport moveDnDSupport;
    private final UseCaseCopyDragNDropSupport copyDnDSupport;
    private final ReorderActionStepsDragNDropSupport reorderActionStepDnDSupport;
    private final UseCaseNaturalOrderDragNDropSupport naturalOrderDnDSupport;
    private final ItemEditorDragSupport itemEditorDragSupport;
    private static final IModuleDataTypeDescription[] dataTypesForAttributeHandlers = new IModuleDataTypeDescription[]{Category.DATA_TYPE_DESCRIPTION, UseCase.DATA_TYPE_DESCRIPTION, ActionStep.DATA_TYPE_DESCRIPTION, Scenario.DATA_TYPE_DESCRIPTION};

    public UCMDataViewProvider(StandardTreeDataView dataView, Collection<String> dataTypes) {
        super(dataView, dataTypes, (IFixColumnDescriptionProvider)new UCMFixColumnDescriptionProvider(), (IModuleFixColumnProvider)new DataViewLabelProvider());
        assert (dataView != null) : "dataView must not be null";
        this.editorDnDSupport = new UseCaseEditorDragSupport(null);
        this.moveDnDSupport = new UseCaseMoveDragNDropSupport(null);
        this.copyDnDSupport = new UseCaseCopyDragNDropSupport(null);
        this.naturalOrderDnDSupport = new UseCaseNaturalOrderDragNDropSupport(null, (TreeDataView<?>)dataView, (IMoveDragNDropExecuter)this.moveDnDSupport, (ICopyDragNDropExecuter)this.copyDnDSupport);
        this.reorderActionStepDnDSupport = new ReorderActionStepsDragNDropSupport(null, (AbstractDataView)dataView);
        this.itemEditorDragSupport = new ItemEditorDragSupport((IProjectAgentProvider)UseCaseModulePlugin.getDefault().getProjectManager(), null);
        dataView.registerProjectSwitchListener((IModuleProjectSwitchListener)this.moveDnDSupport);
        dataView.registerProjectSwitchListener((IModuleProjectSwitchListener)this.copyDnDSupport);
        dataView.registerProjectSwitchListener((IModuleProjectSwitchListener)this.naturalOrderDnDSupport);
        dataView.registerProjectSwitchListener((IModuleProjectSwitchListener)this.reorderActionStepDnDSupport);
        dataView.registerProjectSwitchListener((IModuleProjectSwitchListener)this.editorDnDSupport);
        dataView.registerProjectSwitchListener((IModuleProjectSwitchListener)this.itemEditorDragSupport);
        this.createActions();
    }

    private void createActions() {
        this.actionDelegateCopy = new ActionDelegateCopy();
        this.actionDelegatePaste = new ActionDelegatePaste();
        this.actionDelegateDelete = new ActionDelegateDelete();
        this.actionEditActors = new ActionEditActors();
        this.actionEditActors.setContainingPart((IWorkbenchPart)this.dataView);
        this.actionEditActors.setText(Messages.getString("DataViewProvider.ActionEditActorsName"));
        this.createAttributeHandlers();
    }

    public DragSource[] createDragSources() {
        DragSource[] allSources = new DragSource[]{this.moveDnDSupport.getDragSource(), this.editorDnDSupport.getDragSource(), this.reorderActionStepDnDSupport.getDragSource(), this.copyDnDSupport.getDragSource(), this.naturalOrderDnDSupport.getDragSource(), this.itemEditorDragSupport.getDragSource()};
        return allSources;
    }

    public DropTarget[] createDropTargets() {
        DropTarget[] allTargets = new DropTarget[]{this.moveDnDSupport.getDropTarget(), this.reorderActionStepDnDSupport.getDropTarget(), this.copyDnDSupport.getDropTarget(), this.naturalOrderDnDSupport.getDropTarget()};
        return allTargets;
    }

    public ModuleActionDelegate getDeleteActionDelegate() {
        return this.actionDelegateDelete;
    }

    public ModuleActionDelegate getCopyActionDelegate() {
        return this.actionDelegateCopy;
    }

    public ModuleActionDelegate getPasteActionDelegate() {
        return this.actionDelegatePaste;
    }

    public List<EitherOr<IAction, IContributionItem>> getAdditionalViewMenuActions() {
        ArrayList<EitherOr<IAction, IContributionItem>> viewMenuActions = new ArrayList<EitherOr<IAction, IContributionItem>>(super.getAdditionalViewMenuActions());
        viewMenuActions.add((EitherOr<IAction, IContributionItem>)new EitherOr.Either((Object)this.actionEditActors));
        return viewMenuActions;
    }

    public List<IFilterItem> createFilterItems() {
        this.filterFactory = new UseCaseFilters((IModuleProjectSwitchListenerManager)this.dataView);
        return this.filterFactory.createFilters();
    }

    public void dispose() {
        this.filterFactory.dispose();
    }

    public KeyListener createKeyListener() {
        return null;
    }

    public String getHelpContextId() {
        return IHelpContextIDs.USE_CASE_INDEX;
    }

    public String getFilterDialogueTitle() {
        return Messages.getString("DataViewProvider.FILTER_SETTINGS");
    }

    public String getFilterDialogueDescription() {
        return Messages.getString("DataViewProvider.FILTER_SETTINGS_FOR_USECASE_MODULE");
    }

    public boolean hasIncrementalSearch() {
        return true;
    }

    public Map<String, ICockpitSearchStringGenerator<IModuleData>> getSearchStringGenerators() {
        HashMap<String, ICockpitSearchStringGenerator<IModuleData>> searchStringGenerators = new HashMap<String, ICockpitSearchStringGenerator<IModuleData>>(3);
        searchStringGenerators.put("ucm.category", (ICockpitSearchStringGenerator<IModuleData>)new CategorySearchStringGenerator());
        searchStringGenerators.put("ucm.useCase", (ICockpitSearchStringGenerator<IModuleData>)new UseCaseSearchStringGenerator());
        searchStringGenerators.put("ucm.Scenario", (ICockpitSearchStringGenerator<IModuleData>)new ScenarioSearchStringGenerator());
        searchStringGenerators.put("ucm.ActionStep", (ICockpitSearchStringGenerator<IModuleData>)new ActionStepSearchStringGenerator());
        return searchStringGenerators;
    }

    public String getFullModuleID() {
        return ModuleIdentification.getModuleID();
    }

    public ListMap<String, IDiscreteAttributeHandler> getDiscreteAttributeHandlers() {
        return this.attributeHandlers;
    }

    private void createAttributeHandlers() {
        ProjectMgr pm = UseCaseModulePlugin.getDefault().getProjectManager();
        this.attributeHandlers = new ListMap(3);
        IModuleDataTypeDescription[] iModuleDataTypeDescriptionArray = dataTypesForAttributeHandlers;
        int n = dataTypesForAttributeHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            IModuleDataTypeDescription dataType = iModuleDataTypeDescriptionArray[n2];
            if (dataType.isSupportingCategories()) {
                this.attributeHandlers.add((Object)dataType.getTypeID(), (Object)new AttributeHandlerForCategories((IModuleProjectSwitchListenerManager)this.dataView, (IModelControllerProvider)pm, dataType.getTypeID(), true));
            }
            ++n2;
        }
        this.attributeHandlers.add((Object)"ucm.useCase", (Object)new AttributeHandlerForDiscreteValues((IModuleProjectSwitchListenerManager)this.dataView, (IModelControllerProvider)pm, "ucm.useCase.level", UseCaseDescription.NAME_LEVEL, "ucm.useCase", UseCaseDescription.getLevelKeys()));
        this.attributeHandlers.add((Object)"ucm.useCase", (Object)new AttributeHandlerForDiscreteValues((IModuleProjectSwitchListenerManager)this.dataView, (IModelControllerProvider)pm, "ucm.useCase.priority", UseCaseDescription.NAME_PRIORITY, "ucm.useCase", UseCaseDescription.getPriorityKeys()));
        this.attributeHandlers.add((Object)"ucm.useCase", (Object)new AttributeHandlerForDiscreteValues((IModuleProjectSwitchListenerManager)this.dataView, (IModelControllerProvider)pm, "ucm.useCase.state", UseCaseDescription.NAME_STATE, "ucm.useCase", UseCaseDescription.getStateKeys()));
    }

    public IClientFunctionLicenseType2 getRequiredLicenseTypeForSearch() {
        return ClientFunctionLicenseTypeUCMSearch.getInstance();
    }

    public IClientFunctionLicenseType2 getRequiredLicenseTypeForChangeValueActions() {
        return ClientFunctionLicenseTypeUCMModifyItems.getInstance();
    }

    public final ActionEditActors getEditActorsAction() {
        return this.actionEditActors;
    }

    protected boolean isObjectTypeCategoryColumnNeeded() {
        return true;
    }

    protected Collection<Class<?>> getAdditionalClassesThatTriggerRefresh() {
        return Collections.emptySet();
    }

    protected ProjectMgr getProjectAssociationManager() {
        return UseCaseModulePlugin.getDefault().getProjectManager();
    }

    protected IDataTypesHelper getDataTypesHelper() {
        return UCMDataTypesHelper.getDefault();
    }
}

