/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.gui;

import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.gui.dataview.jfaceviewer.tree.standard.IModuleFixColumnProvider;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Actor;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.lib.stringtools.StringUtil;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class DataViewLabelProvider
implements IModuleFixColumnProvider {
    private final ImageDescriptorRegistry imageDescriptorRegistry = UseCaseModulePlugin.getDefault().getImageDescriptorRegistry();
    private final ImageDescriptor actionStepImageDescriptorUnlinked = UseCaseModulePlugin.getImageDescriptor("BrokenLink.gif");

    public Image getColumnImage(IModuleData element, String columnID) {
        if (columnID.equals("name")) {
            return element.getStatusDependentIcon().getImage();
        }
        if (columnID.equals("icon_and_description")) {
            ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(element.getProjectUID());
            if (element instanceof ActionStep) {
                return modelController.getLinksForModuleDataItem(element, "StepUniqueElement").size() > 0 ? null : this.imageDescriptorRegistry.get(this.actionStepImageDescriptorUnlinked);
            }
        } else if (columnID.equals("level")) {
            if (element instanceof UseCase) {
                return this.imageDescriptorRegistry.get(((UseCase)element).getLevel().getDisplayImageDescriptor());
            }
            return null;
        }
        return null;
    }

    public String getColumnText(IModuleData element, String columnID) {
        if (element instanceof Category) {
            return this.getColumnText((Category)element, columnID);
        }
        if (element instanceof UseCase) {
            return this.getColumnText((UseCase)element, columnID);
        }
        if (element instanceof Scenario) {
            return this.getColumnText((Scenario)element, columnID);
        }
        if (element instanceof ActionStep) {
            return this.getColumnText((ActionStep)element, columnID);
        }
        return null;
    }

    private String getColumnText(ActionStep step, String columnID) {
        ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(step.getProjectUID());
        if (columnID.equals("name")) {
            return modelController.getDisplayRepresentation_ActionStepWithActor(step);
        }
        if (columnID.equals("title")) {
            return StringUtil.removeNewlinesAndTrim((String)step.getDescription().getDisplayStringRepresentation());
        }
        if (columnID.equals("actors")) {
            Actor actor = modelController.getActor(step);
            return actor.getName().getDisplayStringRepresentation();
        }
        if (columnID.equals("author")) {
            return step.getCreator().getDisplayStringRepresentation();
        }
        if (columnID.equals("creation_date")) {
            return step.getCreationTime().getDisplayStringRepresentation();
        }
        if (columnID.equals("modification_date")) {
            return step.getModificationTime().getDisplayStringRepresentation();
        }
        return null;
    }

    private String getColumnText(Scenario scenario, String columnID) {
        ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(scenario.getProjectUID());
        if (columnID.equals("name")) {
            return modelController.getFullScenarioPrefix(scenario);
        }
        if (columnID.equals("author")) {
            return scenario.getCreator().getDisplayStringRepresentation();
        }
        if (columnID.equals("creation_date")) {
            return scenario.getCreationTime().getDisplayStringRepresentation();
        }
        if (columnID.equals("modification_date")) {
            return scenario.getModificationTime().getDisplayStringRepresentation();
        }
        return null;
    }

    private String getColumnText(UseCase useCase, String columnID) {
        ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(useCase.getProjectUID());
        if (columnID.equals("name")) {
            return useCase.getID().getDisplayStringRepresentation();
        }
        if (columnID.equals("title")) {
            return useCase.getName().getDisplayStringRepresentation();
        }
        if (columnID.equals("actors")) {
            return modelController.getSortedActorString(useCase);
        }
        if (columnID.equals("scope")) {
            return useCase.getScope().getDisplayStringRepresentation();
        }
        if (columnID.equals("priority")) {
            return useCase.getPriority().getDisplayStringRepresentation();
        }
        if (columnID.equals("status")) {
            return useCase.getState().getDisplayStringRepresentation();
        }
        if (columnID.equals("initiator")) {
            return useCase.getInitiator().getDisplayStringRepresentation();
        }
        if (columnID.equals("author")) {
            return useCase.getCreator().getDisplayStringRepresentation();
        }
        if (columnID.equals("creation_date")) {
            return useCase.getCreationTime().getDisplayStringRepresentation();
        }
        if (columnID.equals("modification_date")) {
            return useCase.getModificationTime().getDisplayStringRepresentation();
        }
        return null;
    }

    private String getColumnText(Category category, String columnID) {
        if (columnID.equals("name")) {
            return category.getName().getDisplayStringRepresentation();
        }
        if (columnID.equals("author")) {
            return category.getCreator().getDisplayStringRepresentation();
        }
        if (columnID.equals("creation_date")) {
            return category.getCreationTime().getDisplayStringRepresentation();
        }
        if (columnID.equals("modification_date")) {
            return category.getModificationTime().getDisplayStringRepresentation();
        }
        return null;
    }
}

