/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.core.project.datafacade;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.core.project.IModel;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractDataFacade;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.core.project.ActionStepSorter;
import com.arcway.cockpit.usecasemodule.client.core.project.DataManager;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExActionStep;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExActionStepEnd;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExActionStepStart;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExCategory;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExExtension;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExGoal;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExScenario;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExUseCase;
import com.arcway.cockpit.usecasemodule.client.gui.UseCaseFilters;
import com.arcway.cockpit.usecasemodule.client.gui.preferences.PreferenceManager;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Actor;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.Extension;
import com.arcway.cockpit.usecasemodule.client.messages.Goal;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class DataFacade
extends AbstractDataFacade {
    private DataManager concreteDataManager;

    public void construct(IModel dataManager, IModelController modelController, IClientDataFactory clientDataFactory) {
        super.construct(dataManager, modelController, clientDataFactory);
        this.concreteDataManager = (DataManager)dataManager;
    }

    public List<ImExCategory> getAllUseCaseCategories(Collection filters, Locale locale) {
        ArrayList useCaseCategories = new ArrayList(this.concreteDataManager.getAllItems("ucm.category"));
        this.sortByNaturalOrder(useCaseCategories);
        return this.getFilteredExportableCategories(useCaseCategories, filters, locale);
    }

    public ImExCategory getCategory(ImExUseCase useCase, Locale locale) {
        UseCase realUseCase = (UseCase)((Object)this.concreteDataManager.getItem("ucm.useCase", useCase.internalIdentifier));
        return this.getExportableCategory((Category)this.concreteDataManager.getParent((IModuleData)realUseCase), locale);
    }

    public Collection getUseCases(ImExCategory category, Collection filters, Locale locale) {
        Category realCategory = (Category)((Object)this.concreteDataManager.getItem("ucm.category", category.internalIdentifier));
        ArrayList children = new ArrayList(this.concreteDataManager.getChildren((IModuleData)realCategory));
        this.sortByNaturalOrder(children);
        return this.getFilteredExportableUseCases(children, filters, locale);
    }

    public ImExScenario getMainScenario(ImExUseCase useCase, Locale locale) {
        UseCase realUseCase = (UseCase)((Object)this.concreteDataManager.getItem("ucm.useCase", useCase.internalIdentifier));
        return this.getExportableScenario(this.concreteDataManager.getMainScenario(realUseCase), locale);
    }

    public ImExActionStep getBeginningStepOfExtendingScenario(ImExScenario scenario, Locale locale) {
        Scenario realScenario = (Scenario)((Object)this.concreteDataManager.getItem("ucm.Scenario", scenario.internalIdentifier));
        return this.getExportableActionStep(this.concreteDataManager.getBeginningStepOfExtension(realScenario), locale);
    }

    public ImExActionStep getFinalStepOfExtendingScenario(ImExScenario scenario, Locale locale) {
        Scenario realScenario = (Scenario)((Object)this.concreteDataManager.getItem("ucm.Scenario", scenario.internalIdentifier));
        return this.getExportableActionStep(this.concreteDataManager.getFinalStepOfExtension(realScenario), locale);
    }

    public ImExActionStep getFinalStepOfExtendingUseCase(ImExUseCase useCase, ImExScenario scenario, Locale locale) {
        Scenario realScenario = (Scenario)((Object)this.concreteDataManager.getItem("ucm.Scenario", scenario.internalIdentifier));
        UseCase realUseCase = (UseCase)((Object)this.concreteDataManager.getItem("ucm.useCase", useCase.internalIdentifier));
        return this.getExportableActionStep(this.concreteDataManager.getFinalStep(realUseCase, realScenario), locale);
    }

    public ImExActionStep getBeginningStepOfExtendingUseCase(ImExUseCase useCase, ImExScenario scenario, Locale locale) {
        Scenario realScenario = (Scenario)((Object)this.concreteDataManager.getItem("ucm.Scenario", scenario.internalIdentifier));
        UseCase realUseCase = (UseCase)((Object)this.concreteDataManager.getItem("ucm.useCase", useCase.internalIdentifier));
        return this.getExportableActionStep(this.concreteDataManager.getBeginningStep(realUseCase, realScenario), locale);
    }

    public List getActionSteps(ImExScenario scenario, Locale locale) {
        Scenario realScenario = (Scenario)((Object)this.concreteDataManager.getItem("ucm.Scenario", scenario.internalIdentifier));
        List<ActionStep> actionSteps = this.concreteDataManager.getActionSteps(realScenario);
        if (actionSteps.size() >= 2) {
            actionSteps.remove(0);
            actionSteps.remove(actionSteps.size() - 1);
        }
        return this.getExportableActionSteps(actionSteps, locale);
    }

    public ImExActionStepStart getStartingStep(ImExScenario scenario, Locale locale) {
        Scenario realScenario = (Scenario)((Object)this.concreteDataManager.getItem("ucm.Scenario", scenario.internalIdentifier));
        ActionStep step = this.concreteDataManager.getActionSteps(realScenario).get(0);
        return (ImExActionStepStart)this.getExportableActionStep(step, locale);
    }

    public ImExActionStepEnd getFinalStep(ImExScenario scenario, Locale locale) {
        Scenario realScenario = (Scenario)((Object)this.concreteDataManager.getItem("ucm.Scenario", scenario.internalIdentifier));
        List<ActionStep> actionSteps = this.concreteDataManager.getActionSteps(realScenario);
        ActionStep step = actionSteps.get(actionSteps.size() - 1);
        return (ImExActionStepEnd)this.getExportableActionStep(step, locale);
    }

    public Collection getExtendingUseCases(ImExScenario scenario, Collection filters, Locale locale) {
        Scenario realScenario = (Scenario)((Object)this.concreteDataManager.getItem("ucm.Scenario", scenario.internalIdentifier));
        return this.getFilteredExportableUseCases(this.concreteDataManager.getExtendingUseCases(realScenario), filters, locale);
    }

    public Collection getExtendedScenarios(ImExUseCase useCase, Locale locale) {
        UseCase realUseCase = (UseCase)((Object)this.concreteDataManager.getItem("ucm.useCase", useCase.internalIdentifier));
        return this.getExportableScenarios(this.concreteDataManager.getExtendedScenarios(realUseCase), locale);
    }

    public ImExScenario getExtendedScenario(ImExScenario scenario, Locale locale) {
        Scenario realScenario = (Scenario)((Object)this.concreteDataManager.getItem("ucm.Scenario", scenario.internalIdentifier));
        return this.getExportableScenario(this.concreteDataManager.getExtendedScenario(realScenario), locale);
    }

    public List getExtendingScenarios(ImExScenario scenario, Locale locale) {
        Scenario realScenario = (Scenario)((Object)this.concreteDataManager.getItem("ucm.Scenario", scenario.internalIdentifier));
        ArrayList extScenario = new ArrayList(this.concreteDataManager.getExtendingScenarios(realScenario));
        return this.getExportableScenarios(extScenario, locale);
    }

    public Collection<ImExUseCase> getAllUseCases(Collection filters, Locale locale) {
        Collection useCases = this.concreteDataManager.getAllItems("ucm.useCase");
        return this.getFilteredExportableUseCases(useCases, filters, locale);
    }

    public Collection<ImExScenario> getAllScenarios(Locale locale) {
        Collection scenarios = this.concreteDataManager.getAllItems("ucm.Scenario");
        return this.getExportableScenarios(scenarios, locale);
    }

    public Collection<ImExActionStep> getAllActionSteps(Locale locale) {
        Collection actionSteps = this.concreteDataManager.getAllItems("ucm.ActionStep");
        return this.getExportableActionSteps(actionSteps, locale);
    }

    public String getScenarioID(ImExScenario scenario) {
        Scenario modelScenario = (Scenario)((Object)this.concreteDataManager.getItem("ucm.Scenario", scenario.internalIdentifier));
        return this.concreteDataManager.getFullScenarioPrefix(modelScenario);
    }

    public String getStepID(ImExActionStep step) {
        ActionStep modelStep = (ActionStep)((Object)this.concreteDataManager.getItem("ucm.ActionStep", step.internalIdentifier));
        return this.concreteDataManager.getDisplayRepresentation_ActionStepNumberWithFullScenarioPrefix(modelStep);
    }

    private List<ImExCategory> getFilteredExportableCategories(Collection setCollection, Collection filters, Locale locale) {
        ArrayList<ImExCategory> exportableSets = new ArrayList<ImExCategory>();
        Collection filteredCategories = DataFacade.filter((Collection)setCollection, (Collection)filters);
        Iterator iterator = filteredCategories.iterator();
        while (iterator.hasNext()) {
            exportableSets.add(this.getExportableCategory((Category)((Object)iterator.next()), locale));
        }
        return exportableSets;
    }

    private List<ImExUseCase> getFilteredExportableUseCases(Collection useCaseCollection, Collection<AbstractFilter> filters, Locale locale) {
        ArrayList<ImExUseCase> exportableSets = new ArrayList<ImExUseCase>();
        Collection filteredUseCases = DataFacade.filter((Collection)useCaseCollection, filters);
        Iterator iterator = filteredUseCases.iterator();
        while (iterator.hasNext()) {
            exportableSets.add(this.getExportableUseCase((UseCase)((Object)iterator.next()), locale));
        }
        return exportableSets;
    }

    private List<ImExActionStep> getExportableActionSteps(Collection setCollection, Locale locale) {
        ArrayList<ImExActionStep> exportableSets = new ArrayList<ImExActionStep>();
        Iterator iterator = setCollection.iterator();
        while (iterator.hasNext()) {
            exportableSets.add(this.getExportableActionStep((ActionStep)((Object)iterator.next()), locale));
        }
        return exportableSets;
    }

    private List<ImExScenario> getExportableScenarios(Collection setCollection, Locale locale) {
        ArrayList<ImExScenario> exportableSets = new ArrayList<ImExScenario>();
        Iterator iterator = setCollection.iterator();
        while (iterator.hasNext()) {
            exportableSets.add(this.getExportableScenario((Scenario)((Object)iterator.next()), locale));
        }
        return exportableSets;
    }

    private List<ImExGoal> getExportableGoals(Collection setCollection, Locale locale) {
        ArrayList<ImExGoal> exportableSets = new ArrayList<ImExGoal>();
        Iterator iterator = setCollection.iterator();
        while (iterator.hasNext()) {
            exportableSets.add(this.getExportableGoal((Goal)((Object)iterator.next()), locale));
        }
        return exportableSets;
    }

    private List<ImExExtension> getExportableExtensions(Collection setCollection, Locale locale) {
        ArrayList<ImExExtension> exportableSets = new ArrayList<ImExExtension>();
        Iterator iterator = setCollection.iterator();
        while (iterator.hasNext()) {
            exportableSets.add(this.getExportableExtension((Extension)((Object)iterator.next()), locale));
        }
        return exportableSets;
    }

    private ImExCategory getExportableCategory(Category category, Locale locale) {
        if (category == null) {
            return null;
        }
        ImExCategory exportableCategory = new ImExCategory(category, this.concreteDataManager.getModelController(), locale);
        exportableCategory.name = category.getName().getDisplayStringRepresentation();
        exportableCategory.internalIdentifier = category.getUID();
        return exportableCategory;
    }

    private ImExUseCase getExportableUseCase(UseCase useCase, Locale locale) {
        if (useCase == null) {
            return null;
        }
        ImExUseCase exportableUseCase = new ImExUseCase(useCase, this.concreteDataManager.getModelController(), locale);
        exportableUseCase.initiator = useCase.getInitiator().getDisplayStringRepresentation();
        exportableUseCase.level = useCase.getLevel().getDisplayStringRepresentation(locale);
        exportableUseCase.levelIndex = useCase.getLevel().getValue();
        exportableUseCase.id = useCase.getID().getDisplayStringRepresentation();
        exportableUseCase.name = useCase.getName().getDisplayStringRepresentation();
        exportableUseCase.notes = useCase.getNotes().getDisplayStringRepresentation();
        exportableUseCase.priorityIndex = useCase.getPriority().getValue();
        exportableUseCase.priority = useCase.getPriority().getDisplayStringRepresentation(locale);
        exportableUseCase.scope = useCase.getScope().getDisplayStringRepresentation();
        exportableUseCase.state = useCase.getState().getDisplayStringRepresentation(locale);
        exportableUseCase.stateIndex = useCase.getState().getValue();
        exportableUseCase.main_actor = ((ModelController)this.modelController).getMainActor(useCase).getName().getDisplayStringRepresentation();
        exportableUseCase.internalIdentifier = useCase.getUID();
        return exportableUseCase;
    }

    private ImExActionStep getExportableActionStep(ActionStep actionStep, Locale locale) {
        ImExActionStep exportableActionStep;
        if (actionStep == null) {
            return null;
        }
        switch (actionStep.getStepType().getValue()) {
            case 0: {
                exportableActionStep = new ImExActionStepStart(actionStep, this.concreteDataManager.getModelController(), locale);
                break;
            }
            case 1: {
                exportableActionStep = new ImExActionStepEnd(actionStep, this.concreteDataManager.getModelController(), locale);
                break;
            }
            default: {
                exportableActionStep = new ImExActionStep(actionStep, this.concreteDataManager.getModelController(), locale);
            }
        }
        exportableActionStep.title = actionStep.getTitle().getDisplayStringRepresentation();
        exportableActionStep.internalIdentifier = actionStep.getUID();
        exportableActionStep.description = actionStep.getDescription().getDisplayStringRepresentation();
        exportableActionStep.number = actionStep.getNumber().getValue();
        exportableActionStep.ID = this.getStepID(exportableActionStep);
        if (actionStep.getStepType().getValue() == 2) {
            Actor actor = this.concreteDataManager.getActor(actionStep);
            exportableActionStep.actor = actor.getName().getDisplayStringRepresentation();
        }
        return exportableActionStep;
    }

    private ImExScenario getExportableScenario(Scenario scenario, Locale locale) {
        if (scenario == null) {
            return null;
        }
        ImExScenario exportableScenario = new ImExScenario(scenario, this.concreteDataManager.getModelController(), locale);
        exportableScenario.internalIdentifier = scenario.getUID();
        exportableScenario.ID = scenario.getID().getDisplayStringRepresentation();
        exportableScenario.fullID = this.getScenarioID(exportableScenario);
        exportableScenario.goal = scenario.getGoal().getDisplayStringRepresentation();
        exportableScenario.postConditionOnFailure = scenario.getFailurePostcondition().getDisplayStringRepresentation();
        exportableScenario.postconditionOnSuccess = scenario.getSuccessPostcondition().getDisplayStringRepresentation();
        exportableScenario.precondition = scenario.getPrecondition().getDisplayStringRepresentation();
        exportableScenario.trigger = scenario.getTrigger().getDisplayStringRepresentation();
        exportableScenario.finish = scenario.getSuccess().getValue();
        return exportableScenario;
    }

    private ImExGoal getExportableGoal(Goal goal, Locale locale) {
        if (goal == null) {
            return null;
        }
        ImExGoal exportableGoal = new ImExGoal(goal, this.concreteDataManager.getModelController(), locale);
        exportableGoal.description = goal.getDescription().getDisplayStringRepresentation();
        exportableGoal.isMainActorsGoal = goal.isMainActor();
        Actor actor = this.concreteDataManager.getActor(goal);
        exportableGoal.actor = actor.getName().getDisplayStringRepresentation();
        exportableGoal.internalIdentifier = goal.getUID();
        return exportableGoal;
    }

    private ImExExtension getExportableExtension(Extension extension, Locale locale) {
        if (extension == null) {
            return null;
        }
        ImExExtension exportableExtension = new ImExExtension(extension, this.concreteDataManager.getModelController(), locale);
        exportableExtension.internalIdentifier = extension.getUID();
        return exportableExtension;
    }

    public String getInlineScenarioPreference() {
        return PreferenceManager.getScenarioMode();
    }

    public Collection getLinkedSteps(String UniqueElementUID, Locale locale) {
        LinkedList<ActionStep> linkedSteps = new LinkedList<ActionStep>(this.concreteDataManager.getModuleData(UniqueElementUID, "StepUniqueElement"));
        ActionStepSorter.sortStepsAccordingToUseCaseScenarioAndID(linkedSteps, this.concreteDataManager);
        return this.getExportableActionSteps(linkedSteps, locale);
    }

    public Collection getUseCasesForUniqueElement(String uniqueElementUID, Collection filters, Locale locale) {
        Collection linkedUseCases = this.concreteDataManager.getModuleData(uniqueElementUID, "UseCaseUniqueElement");
        return this.getFilteredExportableUseCases(linkedUseCases, filters, locale);
    }

    public ImExUseCase getUseCase(ImExScenario scenario, Locale locale) {
        IModuleData parent = this.concreteDataManager.getParent((IModuleData)this.concreteDataManager.getScenario(scenario.internalIdentifier));
        while (!(parent instanceof UseCase)) {
            parent = this.concreteDataManager.getParent(parent);
        }
        return this.getExportableUseCase((UseCase)parent, locale);
    }

    public List getExtendingScenarios(ImExActionStep actionStep, Locale locale) {
        ActionStep modelStep = this.concreteDataManager.getStep(actionStep.internalIdentifier);
        ArrayList extScenario = new ArrayList(this.concreteDataManager.getForkingScenarios(modelStep));
        return this.getExportableScenarios(extScenario, locale);
    }

    public Collection getExtendingUseCases(ImExActionStep actionStep, Collection filters, Locale locale) {
        ActionStep modelStep = this.concreteDataManager.getStep(actionStep.internalIdentifier);
        return this.getFilteredExportableUseCases(this.concreteDataManager.getForkingUseCases(modelStep), filters, locale);
    }

    public UseCaseFilters getFilterFactory() {
        return new UseCaseFilters(this.modelController);
    }

    public String getExtendingScenarioEndType(ImExScenario scenario) {
        Scenario modelScenario = this.concreteDataManager.getScenario(scenario.internalIdentifier);
        int kindOfFinalStep = this.concreteDataManager.getExtendingScenarioEndType(modelScenario);
        Locale locale = this.concreteDataManager.getProjectLanguage();
        String kindOfFinalStepText = Messages.getString("Scenario.ExtensionScenarioEndType_" + kindOfFinalStep, locale);
        return kindOfFinalStepText;
    }

    public Collection getGoalsForUseCase(ImExUseCase useCase, Locale locale) {
        UseCase modelUseCase = this.concreteDataManager.getUseCase(useCase.internalIdentifier);
        return this.getExportableGoals(this.concreteDataManager.getGoals(modelUseCase), locale);
    }

    public ImExUseCase getUseCase(ImExGoal goal, Locale locale) {
        Goal modelGoal = this.concreteDataManager.getGoal(goal.internalIdentifier);
        return this.getExportableUseCase(this.concreteDataManager.getUseCase(modelGoal), locale);
    }

    public boolean isExtensionScenario(ImExScenario scenario) {
        Scenario modelScenario = this.concreteDataManager.getScenario(scenario.internalIdentifier);
        return !this.concreteDataManager.isMainScenario(modelScenario);
    }

    public ImExScenario getScenario(ImExActionStep actionStep, Locale locale) {
        ActionStep modelActionStep = this.concreteDataManager.getStep(actionStep.internalIdentifier);
        return this.getExportableScenario(this.concreteDataManager.getScenario(modelActionStep), locale);
    }

    public Collection getEndingExtendingScenarios(ImExActionStep actionStep, Locale locale) {
        ActionStep modelStep = this.concreteDataManager.getStep(actionStep.internalIdentifier);
        return this.getExportableScenarios(this.concreteDataManager.getJoiningScenarios(modelStep), locale);
    }

    public Collection getEndingExtendingUseCases(ImExActionStep actionStep, Collection filters, Locale locale) {
        ActionStep modelStep = this.concreteDataManager.getStep(actionStep.internalIdentifier);
        return this.getFilteredExportableUseCases(this.concreteDataManager.getJoiningUseCases(modelStep), filters, locale);
    }

    public List getExtensions(ImExUseCase useCase, Locale locale) {
        UseCase modelUseCase = this.concreteDataManager.getUseCase(useCase.internalIdentifier);
        return this.getExportableExtensions(this.concreteDataManager.getLinkMgr().getLinkableObjects((IModuleData)modelUseCase, "UseCaseExtension"), locale);
    }

    public ImExUseCase getUseCase(ImExExtension extension, Locale locale) {
        Extension modelExtension = (Extension)((Object)this.concreteDataManager.getItem("ucm.Extension", extension.internalIdentifier));
        return this.getExportableUseCase(this.concreteDataManager.getUseCase(modelExtension), locale);
    }

    public ImExScenario getScenario(ImExExtension extension, Locale locale) {
        Extension modelExtension = (Extension)((Object)this.concreteDataManager.getItem("ucm.Extension", extension.internalIdentifier));
        ActionStep beginningStep = (ActionStep)((Object)this.concreteDataManager.getLinkMgr().getLinkableObjects((IModuleData)modelExtension, "ExtensionBeginningStep").iterator().next());
        return this.getExportableScenario(this.concreteDataManager.getScenario(beginningStep), locale);
    }

    public ImExActionStep getForkingStep(ImExExtension extension, Locale locale) {
        Extension modelExtension = (Extension)((Object)this.concreteDataManager.getItem("ucm.Extension", extension.internalIdentifier));
        return this.getExportableActionStep((ActionStep)((Object)this.concreteDataManager.getLinkMgr().getLinkableObjects((IModuleData)modelExtension, "ExtensionBeginningStep").iterator().next()), locale);
    }

    public ImExActionStep getJoiningStep(ImExExtension extension, Locale locale) {
        Extension modelExtension = (Extension)((Object)this.concreteDataManager.getItem("ucm.Extension", extension.internalIdentifier));
        return this.getExportableActionStep((ActionStep)((Object)this.concreteDataManager.getLinkMgr().getLinkableObjects((IModuleData)modelExtension, "ExtensionFinalStep").iterator().next()), locale);
    }

    public String getExtensionEndType(ImExExtension extension) {
        Extension modelExtension = (Extension)((Object)this.concreteDataManager.getItem("ucm.Extension", extension.internalIdentifier));
        int kindOfFinalStep = this.concreteDataManager.getExtendingUseCaseEndType(modelExtension);
        String kindOfFinalStepText = Messages.getString("Scenario.ExtensionScenarioEndType_" + kindOfFinalStep);
        return kindOfFinalStepText;
    }

    public boolean isLinkedWithUniqueElements(ImExActionStep actionStep) {
        Collection ues = this.concreteDataManager.getLinkableObjects(this.getModuleDataItemForImExItem(actionStep), "StepUniqueElement");
        return ues.size() > 0;
    }

    public boolean isLinkedWithUniqueElements(ImExUseCase useCase) {
        Collection ues = this.concreteDataManager.getLinkableObjects(this.getModuleDataItemForImExItem(useCase), "UseCaseUniqueElement");
        return ues.size() > 0;
    }

    public Collection getLinkedUniqueElements(ImExActionStep actionStep) {
        Collection ues = this.concreteDataManager.getLinkableObjects(this.getModuleDataItemForImExItem(actionStep), "StepUniqueElement");
        return ues;
    }

    public Collection getLinkedUniqueElements(ImExUseCase useCase) {
        Collection ues = this.concreteDataManager.getLinkableObjects(this.getModuleDataItemForImExItem(useCase), "UseCaseUniqueElement");
        return ues;
    }

    public AbstractImExModuleData getExportableItem(IModuleData item, Locale locale, Collection filters) {
        if (item instanceof Category) {
            return this.getExportableCategory((Category)item, locale);
        }
        if (item instanceof UseCase) {
            return this.getExportableUseCase((UseCase)item, locale);
        }
        if (item instanceof Scenario) {
            return this.getExportableScenario((Scenario)item, locale);
        }
        if (item instanceof ActionStep) {
            return this.getExportableActionStep((ActionStep)item, locale);
        }
        if (item instanceof Extension) {
            return this.getExportableExtension((Extension)item, locale);
        }
        if (item instanceof Goal) {
            return this.getExportableGoal((Goal)item, locale);
        }
        return null;
    }

    public IModelController getModelController() {
        return this.modelController;
    }
}

