/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.core.project;

import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.core.permissions.UseCasePermissionRootNode;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Actor;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.Extension;
import com.arcway.cockpit.usecasemodule.client.messages.Goal;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import java.util.Collection;

public class PermissionMgr
extends AbstractPermissionMgr {
    public boolean mayModifyUseCaseCategories() {
        return this.internal_mayModifyUseCaseCategories();
    }

    private boolean internal_mayModifyUseCaseCategories() {
        return this.getProjectAgent().hasPermission("operationEditCategory", (IPermissionOperand)UseCasePermissionRootNode.getSingleton());
    }

    public boolean mayModifyUseCaseCategory(Category category) {
        return this.getProjectAgent().hasPermission("operationEditCategory", (IPermissionOperand)category);
    }

    public boolean mayModifyUseCasesInCategory(Category category) {
        return this.internal_mayModifyUseCasesInCategorie(category);
    }

    private boolean internal_mayModifyUseCasesInCategorie(Category category) {
        return this.getProjectAgent().hasPermission("operationEditUseCasesInCategory", (IPermissionOperand)UseCasePermissionRootNode.getSingleton()) || this.getProjectAgent().hasPermission("operationEditUseCasesInCategory", (IPermissionOperand)category);
    }

    public boolean mayModifyUseCase(UseCase useCase) {
        return this.internal_mayModifyUseCase(useCase, (Category)this.getDataMgr().getParent((IModuleData)useCase));
    }

    public boolean mayModifyScenario(Scenario scenario) {
        return this.internal_mayModifyScenario(scenario, this.getDataMgr().getParent((IModuleData)scenario));
    }

    public boolean mayModifyActionStep(ActionStep actionStep) {
        return this.internal_mayModifyActionStep(actionStep, this.getDataMgr().getParent((IModuleData)actionStep));
    }

    private boolean internal_mayModifyActionStep(ActionStep actionStep, IModuleData parent) {
        if (parent instanceof Scenario) {
            return this.internal_mayModifyScenario((Scenario)parent, this.getDataMgr().getParent(parent));
        }
        if (parent instanceof UseCase) {
            return this.internal_mayModifyUseCase((UseCase)parent, (Category)this.getDataMgr().getParent(parent));
        }
        if (parent instanceof Category) {
            return this.mayModifyUseCasesInCategory((Category)parent);
        }
        return false;
    }

    private boolean internal_mayModifyScenario(Scenario scenario, IModuleData parent) {
        if (parent instanceof Scenario) {
            return this.internal_mayModifyScenario((Scenario)parent, this.getDataMgr().getParent(parent));
        }
        if (parent instanceof UseCase) {
            return this.internal_mayModifyUseCase((UseCase)parent, (Category)this.getDataMgr().getParent(parent));
        }
        if (parent instanceof Category) {
            return this.internal_mayModifyUseCasesInCategorie((Category)parent);
        }
        if (parent instanceof ActionStep) {
            return this.internal_mayModifyActionStep((ActionStep)parent, this.getDataMgr().getParent(parent));
        }
        return false;
    }

    private boolean internal_mayModifyUseCase(UseCase useCase, Category parent) {
        if (this.getProjectAgent().hasPermission("operationEditCertainUseCase", (IPermissionOperand)useCase)) {
            return true;
        }
        return this.internal_mayModifyUseCasesInCategorie(parent);
    }

    public boolean mayDeleteItem(IModuleData moduleData) {
        if (moduleData instanceof Category) {
            return this.mayModifyUseCaseCategories();
        }
        if (moduleData instanceof UseCase) {
            return this.mayModifyUseCase((UseCase)moduleData);
        }
        if (moduleData instanceof Scenario) {
            return this.mayModifyScenario((Scenario)moduleData);
        }
        if (moduleData instanceof ActionStep) {
            return this.mayModifyActionStep((ActionStep)moduleData);
        }
        return false;
    }

    public boolean mayDeleteItems(Collection items) {
        assert (items != null);
        for (Object item : items) {
            if (!(item instanceof IModuleData) || this.mayDeleteItem((IModuleData)item)) continue;
            return false;
        }
        return true;
    }

    public boolean mayEditItemStructurally(IModuleData moduleData, IModuleData parent) {
        return moduleData instanceof Category && (this.mayModifyUseCaseCategories() || this.mayModifyUseCaseCategory((Category)moduleData)) || moduleData instanceof UseCase && this.mayModifyUseCase((UseCase)moduleData, (Category)parent) || moduleData instanceof Scenario && this.mayModifyScenario((Scenario)moduleData, parent) || moduleData instanceof ActionStep && this.mayModifyActionStep((ActionStep)moduleData, parent) || moduleData instanceof Actor && this.mayEditActors() || moduleData instanceof Goal || moduleData instanceof Extension;
    }

    public boolean mayLinkItemToPlanElement(String linkableItemTypeID, IModuleData permissionOperand) {
        return linkableItemTypeID.equals("ucm.useCase") || linkableItemTypeID.equals("ucm.ActionStep");
    }

    private boolean mayModifyActionStep(ActionStep step, IModuleData parent) {
        return this.internal_mayModifyActionStep(step, parent);
    }

    private boolean mayModifyScenario(Scenario scenario, IModuleData parent) {
        return this.internal_mayModifyScenario(scenario, parent);
    }

    private boolean mayModifyUseCase(UseCase case1, Category parent) {
        return this.internal_mayModifyUseCase(case1, parent);
    }

    public boolean mayCreateChildren(IModuleData parent, String childDataType) {
        if (parent == null && childDataType.equals("ucm.category")) {
            return this.mayModifyUseCaseCategories();
        }
        if (parent instanceof Category && childDataType.equals("ucm.useCase")) {
            return this.mayModifyUseCasesInCategory((Category)parent);
        }
        if (parent instanceof UseCase && childDataType.equals("ucm.Scenario")) {
            return this.mayModifyUseCase((UseCase)parent);
        }
        if (parent instanceof Scenario && childDataType.equals("ucm.Scenario")) {
            return this.mayModifyScenario((Scenario)parent);
        }
        if (parent instanceof Scenario && childDataType.equals("ucm.ActionStep")) {
            return this.mayModifyScenario((Scenario)parent);
        }
        if (parent == null && childDataType.equals("ucm.Actor")) {
            return this.mayEditActors();
        }
        if (parent == null && childDataType.equals("ucm.Goal")) {
            return true;
        }
        return parent == null && childDataType.equals("ucm.Extension");
    }

    public boolean mayEditActors() {
        return this.getProjectAgent().getModulePermissionChecker().hasPermission("operationEditGlobalActors", null, (IPermissionOperand)UseCasePermissionRootNode.getSingleton());
    }
}

