/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.core.project;

import com.arcway.cockpit.modulelib2.client.core.project.LockAccessWrapper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.usecasemodule.client.core.project.DataManager;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Actor;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.Extension;
import com.arcway.cockpit.usecasemodule.client.messages.Goal;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.cockpit.usecasemodule.client.messages.description.CategoryDescription;
import com.arcway.cockpit.usecasemodule.client.messages.description.UseCaseDescription;
import com.arcway.cockpit.usecasemodule.shared.ModuleIdentification;
import com.arcway.lib.java.collections.CollectionUtils;
import com.arcway.repository.clientadapter.interFace.EXCockpitLockDenied;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;

public class ModelController
extends com.arcway.cockpit.modulelib2.client.core.project.ModelController {
    public String getModuleID() {
        return ModuleIdentification.getModuleID();
    }

    public String getNewUseCaseID(Category category, boolean acquireLock, LockAccessWrapper lockAccessWrapper) throws EXCockpitLockDenied {
        UseCaseDescription useCaseDescription = new UseCaseDescription();
        return this.getModel().generateNewID((IModuleDataTypeDescription)useCaseDescription, 0, (IModuleData)category, acquireLock, lockAccessWrapper);
    }

    public String buildUseCaseID(String prefix, String pattern, int number) {
        String separator = CategoryDescription.getPrefixSeparator();
        DecimalFormat formater = new DecimalFormat(pattern);
        return String.valueOf(prefix) + separator + formater.format(number);
    }

    public String getFullScenarioPrefix(Scenario scenario) {
        return ((DataManager)this.getModel()).getFullScenarioPrefix(scenario);
    }

    public String getFullScenarioPrefixPlusStepNumber(ActionStep actionStep) {
        return ((DataManager)this.getModel()).getDisplayRepresentation_ActionStepNumberWithFullScenarioPrefix(actionStep);
    }

    public void addStep(ActionStep step, ActionStep previousStep) {
        ((DataManager)this.getModel()).addStep(step, previousStep);
    }

    public boolean removeStep(ActionStep step) {
        return ((DataManager)this.getModel()).removeStep(step);
    }

    public int before(ActionStep step1, ActionStep step2) throws IllegalArgumentException {
        return ((DataManager)this.getModel()).before(step1, step2);
    }

    public Collection<Scenario> getExtendingScenarios(Scenario scenario) {
        return ((DataManager)this.getModel()).getExtendingScenarios(scenario);
    }

    public Scenario getExtendedScenario(Scenario scenario) {
        return ((DataManager)this.getModel()).getExtendedScenario(scenario);
    }

    public Collection<Scenario> getExtendedScenarios(UseCase useCase) {
        return ((DataManager)this.getModel()).getExtendedScenarios(useCase);
    }

    public Scenario getMainScenario(UseCase useCase) {
        return ((DataManager)this.getModel()).getMainScenario(useCase);
    }

    public UseCase getUseCase(Scenario scenario) {
        return ((DataManager)this.getModel()).getUseCase(scenario);
    }

    public UseCase getUseCase(ActionStep actionStep) {
        return ((DataManager)this.getModel()).getUseCase(actionStep);
    }

    public Collection getAllScenarios(UseCase useCase) {
        return ((DataManager)this.getModel()).getAllScenarios(useCase);
    }

    public boolean isMainScenario(Scenario s) {
        return ((DataManager)this.getModel()).isMainScenario(s);
    }

    public List<ActionStep> getActionSteps(Scenario scenario) {
        return CollectionUtils.getTypedList(((DataManager)this.getModel()).getActionSteps(scenario), ActionStep.class);
    }

    public List<ActionStep> getRealActionSteps(Scenario scenario) {
        return ((DataManager)this.getModel()).getRealActionSteps(scenario);
    }

    public void recalculateScenarioOrder(Scenario scenario) {
        ((DataManager)this.getModel()).recalculateScenarioOrder(scenario);
    }

    public int getExtendingScenarioEndType(Scenario scenario) {
        return ((DataManager)this.getModel()).getExtendingScenarioEndType(scenario);
    }

    public int getExtendingUseCaseEndType(Extension extension) {
        return ((DataManager)this.getModel()).getExtendingUseCaseEndType(extension);
    }

    public int getExtendingEndType(ActionStep startingStep, ActionStep finalStep, Scenario scenario) {
        return ((DataManager)this.getModel()).getExtendingEndType(startingStep, finalStep, scenario);
    }

    public Collection getBeginningSetpsOfExtensions(UseCase useCase) {
        return ((DataManager)this.getModel()).getBeginningStepsOfExtensions(useCase);
    }

    public Collection getFinalStepsOfExtensions(UseCase useCase) {
        return ((DataManager)this.getModel()).getFinalStepsOfExtensions(useCase);
    }

    public Collection getForkingUseCases(ActionStep actionStep) {
        return ((DataManager)this.getModel()).getForkingUseCases(actionStep);
    }

    public Collection getJoiningUseCases(ActionStep actionStep) {
        return ((DataManager)this.getModel()).getJoiningUseCases(actionStep);
    }

    public Collection getAllExtensions(Scenario scenario) {
        return ((DataManager)this.getModel()).getAllExtensions(scenario);
    }

    public UseCase getUseCase(Extension extension) {
        return ((DataManager)this.getModel()).getUseCase(extension);
    }

    public Actor getMainActor(UseCase useCase) {
        return ((DataManager)this.getModel()).getMainActor(useCase);
    }

    public Goal getMainGoal(UseCase useCase) {
        return ((DataManager)this.getModel()).getMainGoal(useCase);
    }

    public Actor getActor(Goal goal) {
        return ((DataManager)this.getModel()).getActor(goal);
    }

    public Actor getActor(ActionStep actionStep) {
        assert (actionStep != null) : "actionStep must not be null";
        return this.getActor(this.getGoal(actionStep));
    }

    public Goal getGoal(ActionStep actionStep) {
        assert (actionStep != null) : "actionStep must not be null";
        return (Goal)((Object)this.getLinkableObjects((IModuleData)actionStep, "ActionStepGoal").iterator().next());
    }

    public Collection getAllUsedGoals(UseCase useCase) {
        return ((DataManager)this.getModel()).getAllUsedGoals(useCase);
    }

    public Collection getGoals(UseCase useCase) {
        return ((DataManager)this.getModel()).getGoals(useCase);
    }

    public Collection getActors(UseCase useCase) {
        return ((DataManager)this.getModel()).getActors(useCase);
    }

    public List getSortedActors(UseCase useCase) {
        return ((DataManager)this.getModel()).getSortedActors(useCase);
    }

    public String getSortedActorString(UseCase useCase) {
        assert (useCase != null) : "useCase must not be null";
        List actors = this.getSortedActors(useCase);
        StringBuffer actorNames = new StringBuffer();
        for (Actor actor : actors) {
            actorNames.append(actor.getName().getDisplayStringRepresentation());
            actorNames.append(", ");
        }
        if (actorNames.length() > 1) {
            actorNames.delete(actorNames.length() - 2, actorNames.length());
        }
        return actorNames.toString();
    }

    public Collection<Goal> getAllUsedGoals(Scenario scenario) {
        assert (scenario != null) : "scenario must not be null";
        return ((DataManager)this.getModel()).getAllGoals(scenario);
    }

    public ActionStep getPreviousStep(ActionStep step) {
        return ((DataManager)this.getModel()).getPreviousStep(step);
    }

    public ActionStep getNextStep(ActionStep step) {
        return ((DataManager)this.getModel()).getNextStep(step);
    }

    public String getDisplayRepresentation_ActionStepWithActor(ActionStep step) {
        return ((DataManager)this.getModel()).getDisplayRepresentation_ActionStepWithActor(step);
    }
}

