/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.core.project;

import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.core.project.DataManager;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.lib.java.collections.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class ExportDataProvider
extends com.arcway.cockpit.modulelib2.client.core.project.ExportDataProvider {
    private final ArrayList<Scenario> importedScenarios = new ArrayList();

    protected Collection<? extends IModuleData> checkItemsBeforeExport(Collection<? extends IModuleData> items, String dataTypeUID) {
        return items;
    }

    protected IModuleData checkItemBeforeImport(IModuleData item, Map<Object, Object> replacementMap, boolean generateNewUIDs) {
        String dataTypeID = item.getTypeID();
        if (dataTypeID.equals("ucm.category")) {
            Collection existingCategories = CollectionUtils.getTypedCollection((Collection)this.modelManager.getAllItems(dataTypeID), Category.class);
            for (Category oldCategory : existingCategories) {
                if (!oldCategory.getDisplayRepresentation().equals(((Category)item).getDisplayRepresentation())) continue;
                replacementMap.put(item, (Object)oldCategory);
                return null;
            }
        }
        IModuleData effectiveItem = generateNewUIDs ? ExportDataProvider.copyItemAndReplaceUid((IModuleData)item, (boolean)true) : item;
        replacementMap.put(item, effectiveItem);
        if (dataTypeID.equals("ucm.Scenario")) {
            this.importedScenarios.add((Scenario)effectiveItem);
        }
        return effectiveItem;
    }

    public void importFinished() {
        super.importFinished();
        for (Scenario scenario : this.importedScenarios) {
            ((DataManager)this.modelManager).recalculateScenarioOrder(scenario);
        }
        this.importedScenarios.clear();
    }
}

