/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.core.project;

import com.arcway.cockpit.client.base.datamanager.PropertyChangesManager;
import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.IDataLabelProvider2;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.modulelib2.client.core.IClientDataFactory;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractLockManager;
import com.arcway.cockpit.modulelib2.client.core.project.IModelController;
import com.arcway.cockpit.modulelib2.client.core.project.LinkMgr;
import com.arcway.cockpit.modulelib2.client.core.project.ModuleFacade;
import com.arcway.cockpit.modulelib2.client.core.project.ProjectionMgr;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionMgr;
import com.arcway.cockpit.modulelib2.client.messages.IDataTypesHelper;
import com.arcway.cockpit.modulelib2.client.messages.ILinkTypeHelper;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.description.IModuleDataTypeDescription;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.core.permissions.UseCasePermissionRootNode;
import com.arcway.cockpit.usecasemodule.client.core.project.DataLabelProvider;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Actor;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.Extension;
import com.arcway.cockpit.usecasemodule.client.messages.Goal;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UCMDataTypesHelper;
import com.arcway.cockpit.usecasemodule.client.messages.UCMLinkTypeHelper;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.cockpit.usecasemodule.client.messages.description.CategoryDescription;
import com.arcway.lib.java.collections.CollectionUtils;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import de.plans.lib.xml.encoding.AbstractEncodableObjectFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.graphics.Image;

public class DataManager
extends AbstractDataMgr {
    private static final ILogger logger = Logger.getLogger(DataManager.class);
    public static final int ENDING_TYPE_START = 3;
    public static final int ENDING_TYPE_END_WITH_SUCCESS = 4;
    public static final int ENDING_TYPE_END_WITH_FAILURE = 5;
    public static final int ENDING_TYPE_END_WITH_UNKNOWN_RESULT = 6;
    public static final int ENDING_TYPE_BEFORE_FORKING_STEP = 1;
    public static final int ENDING_TYPE_AFTER_FORKING_STEP = 2;
    public static final int ENDING_TYPE_UNKNOWN = 7;
    private IDataLabelProvider2<String> dataLabelProvider;

    public void construct(String projectUid, IFrameProjectAgent project, IModelController modelControllerP, AbstractPermissionMgr permissionMgrP, AbstractLockManager lockMgrP, ProjectionMgr projectionMgrP, LinkMgr linkMgrP, PropertyChangesManager propertyChangesManager, ModuleFacade moduleFacade, IClientDataFactory clientDataFactory, AbstractEncodableObjectFactory p_eoFactory) {
        super.construct(projectUid, project, modelControllerP, permissionMgrP, lockMgrP, projectionMgrP, linkMgrP, propertyChangesManager, moduleFacade, clientDataFactory, p_eoFactory);
    }

    public Collection getChildren(IModuleData item) {
        if (item == null) {
            return super.getChildren(null);
        }
        HashSet children = new HashSet();
        if (item instanceof Category) {
            children.addAll(this.getLinkMgr().getModuleData(item, "UseCaseCategory"));
        } else if (item instanceof UseCase) {
            children.addAll(this.getLinkMgr().getModuleData(item, "MainScenarioUseCase"));
            children.addAll(this.getLinkMgr().getModuleData(item, "GoalUseCase"));
        } else if (item instanceof Scenario) {
            children.addAll(this.getLinkMgr().getModuleData(item, "StepScenario"));
        } else if (item instanceof ActionStep) {
            children.addAll(this.getLinkMgr().getModuleData(item, "ExtensionBeginningStep"));
            children.addAll(this.getLinkMgr().getModuleData(item, "ScenarioBeginningStep"));
        }
        return children;
    }

    public IModuleData getParent(IModuleData item) {
        assert (item != null) : "item must not be null";
        if (item instanceof UseCase) {
            Iterator i = this.getLinkMgr().getLinkableObjects(item, "UseCaseCategory").iterator();
            assert (i.hasNext());
            return (Category)((Object)i.next());
        }
        if (item instanceof Scenario) {
            Iterator i = this.getLinkMgr().getLinkableObjects(item, "MainScenarioUseCase").iterator();
            if (i.hasNext()) {
                return (UseCase)((Object)i.next());
            }
            i = this.getLinkMgr().getLinkableObjects(item, "ScenarioBeginningStep").iterator();
            assert (i.hasNext());
            return (ActionStep)((Object)i.next());
        }
        if (item instanceof Extension) {
            Iterator i = this.getLinkMgr().getLinkableObjects(item, "ExtensionBeginningStep").iterator();
            assert (i.hasNext());
            return (ActionStep)((Object)i.next());
        }
        if (item instanceof ActionStep) {
            Iterator i = this.getLinkMgr().getLinkableObjects(item, "StepScenario").iterator();
            assert (i.hasNext());
            return (Scenario)((Object)i.next());
        }
        if (item instanceof Goal) {
            Iterator i = this.getLinkMgr().getLinkableObjects(item, "GoalUseCase").iterator();
            assert (i.hasNext());
            return (UseCase)((Object)i.next());
        }
        return null;
    }

    public String getFullScenarioPrefix(Scenario scenario) {
        Collection forkingSteps = this.getLinkableObjects((IModuleData)scenario, "ScenarioBeginningStep");
        if (forkingSteps.isEmpty()) {
            return Messages.getString("DataViewLabelProvider.MainScenarioTitle");
        }
        ActionStep forkingStep = (ActionStep)((Object)forkingSteps.iterator().next());
        return String.valueOf(this.getDisplayRepresentation_ActionStepNumberWithFullScenarioPrefix(forkingStep)) + scenario.getID().getDisplayStringRepresentation();
    }

    public String getDisplayRepresentation_ActionStepNumberWithFullScenarioPrefix(ActionStep actionStep) {
        Scenario scenario = (Scenario)this.getParent((IModuleData)actionStep);
        if (this.getParent((IModuleData)scenario) instanceof UseCase) {
            return actionStep.getNumber().getDisplayStringRepresentation();
        }
        return String.valueOf(this.getFullScenarioPrefix(scenario)) + actionStep.getNumber().getDisplayStringRepresentation();
    }

    public Collection getExtendingScenarios(Scenario scenario) {
        assert (scenario != null) : "scenario must not be null";
        HashSet<Scenario> children = new HashSet<Scenario>();
        for (ActionStep step : this.getLinkMgr().getModuleData((IModuleData)scenario, "StepScenario")) {
            for (Scenario extendingScenario : this.getLinkMgr().getModuleData((IModuleData)step, "ScenarioBeginningStep")) {
                children.add(extendingScenario);
            }
        }
        return children;
    }

    public Collection getExtendingUseCases(Scenario scenario) {
        HashSet extendingUseCases = new HashSet();
        for (Extension extension : this.getAllExtensions(scenario)) {
            extendingUseCases.addAll(this.getLinkMgr().getModuleData((IModuleData)extension, "UseCaseExtension"));
        }
        return extendingUseCases;
    }

    public Collection getAllExtensions(Scenario scenario) {
        ArrayList extensions = new ArrayList();
        for (ActionStep step : this.getLinkMgr().getModuleData((IModuleData)scenario, "StepScenario")) {
            extensions.addAll(this.getLinkMgr().getModuleData((IModuleData)step, "ExtensionBeginningStep"));
        }
        return extensions;
    }

    public Collection getAllExtensions(UseCase useCase) {
        return this.getLinkMgr().getLinkableObjects((IModuleData)useCase, "UseCaseExtension");
    }

    public Scenario getExtendedScenario(Scenario scenario) {
        assert (scenario != null) : "scenario must not be null";
        Iterator i = this.getLinkMgr().getLinkableObjects((IModuleData)scenario, "ScenarioBeginningStep").iterator();
        if (i.hasNext()) {
            ActionStep beginningStep = (ActionStep)((Object)i.next());
            Iterator j = this.getLinkMgr().getLinkableObjects((IModuleData)beginningStep, "StepScenario").iterator();
            if (j.hasNext()) {
                return (Scenario)((Object)j.next());
            }
            logger.error("Step without scenario");
        }
        return null;
    }

    public ActionStep getBeginningStepOfExtension(Scenario scenario) {
        Iterator i = this.getLinkMgr().getLinkableObjects((IModuleData)scenario, "ScenarioBeginningStep").iterator();
        if (i.hasNext()) {
            return (ActionStep)((Object)i.next());
        }
        return null;
    }

    public ActionStep getFinalStepOfExtension(Scenario scenario) {
        Iterator i = this.getLinkMgr().getLinkableObjects((IModuleData)scenario, "ScenarioFinalStep").iterator();
        if (i.hasNext()) {
            return (ActionStep)((Object)i.next());
        }
        return null;
    }

    public Collection getExtendedScenarios(UseCase useCase) {
        HashSet<IModuleData> extendedScenarios = new HashSet<IModuleData>();
        for (Extension extension : this.getAllExtensions(useCase)) {
            ActionStep beginningStep = (ActionStep)((Object)this.getLinkMgr().getLinkableObjects((IModuleData)extension, "ExtensionBeginningStep").iterator().next());
            extendedScenarios.add(this.getParent((IModuleData)beginningStep));
        }
        return extendedScenarios;
    }

    public Collection getBeginningStepsOfExtensions(UseCase useCase) {
        Collection extensions = this.getAllExtensions(useCase);
        HashSet steps = new HashSet(extensions.size());
        for (Extension extension : extensions) {
            steps.addAll(this.getLinkableObjects((IModuleData)extension, "ExtensionBeginningStep"));
        }
        return steps;
    }

    public Collection getFinalStepsOfExtensions(UseCase useCase) {
        Collection extensions = this.getAllExtensions(useCase);
        HashSet steps = new HashSet(extensions.size());
        for (Extension extension : extensions) {
            steps.addAll(this.getLinkableObjects((IModuleData)extension, "ExtensionFinalStep"));
        }
        return steps;
    }

    @Deprecated
    public ActionStep getBeginningStep(UseCase extendingUseCase, Scenario extendedScenario) {
        for (Extension extension : this.getAllExtensions(extendingUseCase)) {
            ActionStep beginningStep = (ActionStep)((Object)this.getLinkMgr().getLinkableObjects((IModuleData)extension, "ExtensionBeginningStep").iterator().next());
            if (!this.getParent((IModuleData)beginningStep).equals((Object)extendedScenario)) continue;
            return beginningStep;
        }
        return null;
    }

    public ActionStep getFinalStep(UseCase extendingUseCase, Scenario extendedScenario) {
        for (Extension extension : this.getAllExtensions(extendingUseCase)) {
            ActionStep finalStep = (ActionStep)((Object)this.getLinkMgr().getLinkableObjects((IModuleData)extension, "ExtensionFinalStep").iterator().next());
            if (!this.getParent((IModuleData)finalStep).equals((Object)extendedScenario)) continue;
            return finalStep;
        }
        return null;
    }

    public Scenario getMainScenario(UseCase useCase) {
        if (this.itemExists(useCase.getUID(), "ucm.useCase")) {
            return (Scenario)((Object)this.getLinkMgr().getModuleData((IModuleData)useCase, "MainScenarioUseCase").iterator().next());
        }
        return null;
    }

    public UseCase getUseCase(Scenario scenario) {
        assert (scenario != null);
        Scenario parent = scenario;
        do {
            parent = this.getParent((IModuleData)parent);
            assert (parent != null);
        } while (!(parent instanceof UseCase));
        return (UseCase)((Object)parent);
    }

    public UseCase getUseCase(ActionStep actionStep) {
        assert (actionStep != null) : "actionStep must not be null";
        return this.getUseCase(this.getScenario(actionStep));
    }

    public Category getCategory(UseCase useCase) {
        assert (useCase != null);
        return (Category)this.getParent((IModuleData)useCase);
    }

    public Category getCategory(Scenario scenario) {
        assert (scenario != null);
        return this.getCategory(this.getUseCase(scenario));
    }

    public Category getCategory(ActionStep actionStep) {
        assert (actionStep != null);
        Scenario scenario = (Scenario)this.getParent((IModuleData)actionStep);
        return this.getCategory(this.getUseCase(scenario));
    }

    public Category getCategory(String categoryUID) {
        return (Category)((Object)this.getItem("ucm.category", categoryUID));
    }

    public UseCase getUseCase(String useCaseUID) {
        return (UseCase)((Object)this.getItem("ucm.useCase", useCaseUID));
    }

    public Scenario getScenario(String scenarioUID) {
        return (Scenario)((Object)this.getItem("ucm.Scenario", scenarioUID));
    }

    public ActionStep getStep(String stepUID) {
        return (ActionStep)((Object)this.getItem("ucm.ActionStep", stepUID));
    }

    void recalculateScenarioOrder(Scenario scenario) {
        Collection stepsUnsorted = this.getModuleData((IModuleData)scenario, "StepScenario");
        ArrayList<ActionStep> stepOrder = new ArrayList<ActionStep>(stepsUnsorted.size());
        ActionStep virtualBeginningStep = null;
        ActionStep virtualEndStep = null;
        for (Object stepAsObject : stepsUnsorted) {
            if (((ActionStep)((Object)stepAsObject)).getStepType().getValue() == 0) {
                if (virtualBeginningStep == null) {
                    virtualBeginningStep = (ActionStep)((Object)stepAsObject);
                    continue;
                }
                logger.warn("Scenario with 2 virtual beginning steps (" + scenario.getID().getDisplayStringRepresentation() + ")");
                continue;
            }
            if (((ActionStep)((Object)stepAsObject)).getStepType().getValue() != 1) continue;
            if (virtualEndStep == null) {
                virtualEndStep = (ActionStep)((Object)stepAsObject);
                continue;
            }
            logger.warn("Scenario with 2 virtual end steps (" + scenario.getID().getDisplayStringRepresentation() + ")");
        }
        if (virtualBeginningStep != null) {
            stepsUnsorted.remove((Object)virtualBeginningStep);
        } else {
            logger.warn("Scenario without virtual beginning step (" + scenario.getID().getDisplayStringRepresentation() + ")");
        }
        if (virtualEndStep != null) {
            stepsUnsorted.remove((Object)virtualEndStep);
        } else {
            logger.warn("Scenario without virtual end step (" + scenario.getID().getDisplayStringRepresentation() + ")");
        }
        ActionStep currentStep = virtualBeginningStep;
        while (currentStep != null && currentStep.getStepType().getValue() != 1) {
            stepOrder.add(currentStep);
            stepsUnsorted.remove((Object)currentStep);
            Collection successorCollection = this.getModuleData((IModuleData)currentStep, "StepPreviousStep");
            currentStep = !successorCollection.isEmpty() ? (ActionStep)((Object)successorCollection.iterator().next()) : null;
        }
        for (Object step : stepsUnsorted) {
            logger.warn("Scenario with broken step order (" + scenario.getID().getDisplayStringRepresentation() + " / Step out of order: " + ((ActionStep)((Object)step)).getTitle().getDisplayStringRepresentation() + ")");
            stepOrder.add((ActionStep)((Object)step));
        }
        if (virtualEndStep != null) {
            stepOrder.add(virtualEndStep);
        }
        int index = virtualBeginningStep != null ? 0 : 1;
        for (ActionStep step : stepOrder) {
            step.getNumber().setValue(index);
            ++index;
        }
    }

    void addStep(final ActionStep step, ActionStep previousStep) {
        this.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                DataManager.this.addItem((Object)step);
            }
        });
        Scenario scenario = (Scenario)((Object)this.getLinkableObjects((IModuleData)previousStep, "StepScenario").iterator().next());
        this.getLinkMgr().createLink(scenario.getUID(), step.getUID(), "StepScenario");
        Collection nextSteps = this.getModuleData((IModuleData)previousStep, "StepPreviousStep");
        ActionStep nextStep = null;
        if (!nextSteps.isEmpty()) {
            nextStep = (ActionStep)((Object)nextSteps.iterator().next());
            this.getLinkMgr().deleteLink(previousStep.getUID(), nextStep.getUID(), "StepPreviousStep");
            this.getLinkMgr().createLink(step.getUID(), nextStep.getUID(), "StepPreviousStep");
        }
        this.getLinkMgr().createLink(previousStep.getUID(), step.getUID(), "StepPreviousStep");
        if (nextStep != null && nextStep.getStepType().getValue() != 1) {
            Collection joiningScenarios = this.getModuleData((IModuleData)nextStep, "ScenarioFinalStep");
            for (Scenario extScenario : joiningScenarios) {
                if (!this.getBeginningStepOfExtension(extScenario).equals((Object)previousStep)) continue;
                this.getLinkMgr().deleteLink(nextStep.getUID(), extScenario.getUID(), "ScenarioFinalStep");
                this.getLinkMgr().createLink(step.getUID(), extScenario.getUID(), "ScenarioFinalStep");
            }
            Collection joiningExtensions = this.getModuleData((IModuleData)nextStep, "ExtensionFinalStep");
            for (Extension extension : joiningExtensions) {
                ActionStep beginningStep = (ActionStep)((Object)this.getLinkableObjects((IModuleData)extension, "ExtensionBeginningStep").iterator().next());
                if (!beginningStep.equals((Object)previousStep)) continue;
                this.getLinkMgr().deleteLink(nextStep.getUID(), extension.getUID(), "ExtensionFinalStep");
                this.getLinkMgr().createLink(step.getUID(), extension.getUID(), "ExtensionFinalStep");
            }
        }
        this.recalculateScenarioOrder(scenario);
    }

    boolean removeStep(final ActionStep step) {
        HashSet scenarios = new HashSet();
        final HashSet extensions = new HashSet();
        scenarios.addAll(this.getModuleData((IModuleData)step, "ScenarioBeginningStep"));
        scenarios.addAll(this.getModuleData((IModuleData)step, "ScenarioFinalStep"));
        extensions.addAll(this.getModuleData((IModuleData)step, "ExtensionBeginningStep"));
        extensions.addAll(this.getModuleData((IModuleData)step, "ExtensionFinalStep"));
        if (!scenarios.isEmpty() || !extensions.isEmpty()) {
            return false;
        }
        this.getModelTransactionManager().executeTransaction(new Runnable(){

            @Override
            public void run() {
                DataManager.this.removeItems(extensions);
                Scenario scenario = (Scenario)((Object)DataManager.this.getLinkableObjects((IModuleData)step, "StepScenario").iterator().next());
                ActionStep previousStep = null;
                Collection previousSteps = DataManager.this.getLinkableObjects((IModuleData)step, "StepPreviousStep");
                if (!previousSteps.isEmpty()) {
                    previousStep = (ActionStep)((Object)previousSteps.iterator().next());
                }
                ActionStep nextStep = null;
                Collection nextSteps = DataManager.this.getModuleData((IModuleData)step, "StepPreviousStep");
                if (!nextSteps.isEmpty()) {
                    nextStep = (ActionStep)((Object)nextSteps.iterator().next());
                }
                DataManager.this.removeItem((Object)step);
                if (previousStep != null && nextStep != null) {
                    DataManager.this.getLinkMgr().createLink(previousStep.getUID(), nextStep.getUID(), "StepPreviousStep");
                }
                DataManager.this.recalculateScenarioOrder(scenario);
            }
        });
        return true;
    }

    public Collection getAllRootItems() {
        return this.getAllItems("ucm.category");
    }

    public Collection getRootItems(String cockpitTypeID) {
        if (cockpitTypeID.equals("ucm.category")) {
            return this.getAllItems("ucm.category");
        }
        return Collections.EMPTY_SET;
    }

    public List<IModuleData> filterSelection(List<?> selection) {
        ArrayList<IModuleData> filteredSelection = new ArrayList<IModuleData>();
        HashSet moduleDataTypes = new HashSet(this.getDataTypesHelper().getAllTrueDataTypes());
        for (Object element : selection) {
            if (!(element instanceof IModuleData) || !moduleDataTypes.contains(((IModuleData)element).getTypeID())) continue;
            filteredSelection.add((IModuleData)element);
        }
        return filteredSelection;
    }

    public void callbackAsynchronousUpdateStarted() {
        super.callbackAsynchronousUpdateStarted();
        this.rememberLinksOfType(Arrays.asList("GoalActor"));
    }

    public void asynchronousUpdateHook_post_addedItems(String dataTypeId, Collection<IModuleData> addedItems) {
        if (dataTypeId.equals("ucm.Actor")) {
            this.mergeAttributeItemsOnAsynchronousUpdate(addedItems, "ucm.Actor", Arrays.asList("GoalActor"));
        }
    }

    public void asynchronousUpdateHook_post_modifiedItems(String dataTypeId, Collection<IModuleData> modifiedItems) {
    }

    public void asynchronousUpdateHook_pre_removedItems(String dataTypeId, Collection<IModuleData> removedItems) {
        if (dataTypeId.equals("ucm.Actor")) {
            this.restoreAttributeItemsOnAsynchronousUpdate(removedItems, Arrays.asList("GoalActor"));
        }
    }

    public void callbackAsynchronousUpdateCompleted() {
        this.recalculateAllScenarios();
        super.callbackAsynchronousUpdateCompleted();
    }

    public void projectInitialized_callbackForSubClasses() {
        this.recalculateAllScenarios();
    }

    private void recalculateAllScenarios() {
        for (Scenario scenario : this.getAllItems("ucm.Scenario")) {
            this.recalculateScenarioOrder(scenario);
        }
    }

    public IDataLabelProvider2<String> getDataLabelProvider2() {
        if (this.dataLabelProvider == null) {
            this.dataLabelProvider = new DataLabelProvider(this);
        }
        return this.dataLabelProvider;
    }

    public Image getImageForData() {
        return this.getDataLabelProvider2().getImageForType((Object)"ucm.useCase");
    }

    public String getDisplayNameForData() {
        return this.getDataLabelProvider2().getDisplayNameForType((Object)"ucm.useCase");
    }

    public int before(ActionStep step1, ActionStep step2) throws IllegalArgumentException {
        Scenario scenario2;
        assert (step1 != null) : "step1 must not be null";
        assert (step2 != null) : "step2 must not be null";
        Scenario scenario1 = (Scenario)this.getParent((IModuleData)step1);
        if (!scenario1.equals((Object)(scenario2 = (Scenario)this.getParent((IModuleData)step2)))) {
            throw new IllegalArgumentException("Both steps must belong to the same scenario");
        }
        return step1.getNumber().getValue() - step2.getNumber().getValue();
    }

    public Collection getForkingScenarios(ActionStep step) {
        return this.getModuleData((IModuleData)step, "ScenarioBeginningStep");
    }

    public Collection getJoiningScenarios(ActionStep step) {
        return this.getModuleData((IModuleData)step, "ScenarioFinalStep");
    }

    public Collection getAllScenarios(UseCase useCase) {
        HashSet<Scenario> scenarios = new HashSet<Scenario>();
        Scenario scenario = this.getMainScenario(useCase);
        scenarios.add(scenario);
        Collection childScenarios = this.getExtendingScenarios(scenario);
        while (!childScenarios.isEmpty()) {
            scenarios.addAll(childScenarios);
            HashSet copy = new HashSet(scenarios);
            scenarios.clear();
            for (Scenario element : copy) {
                childScenarios.addAll(this.getExtendingScenarios(element));
            }
        }
        return scenarios;
    }

    public boolean isMainScenario(Scenario s) {
        return !this.getLinkableObjects((IModuleData)s, "MainScenarioUseCase").isEmpty();
    }

    public List<ActionStep> getActionSteps(Scenario scenario) {
        ArrayList<ActionStep> actionSteps = new ArrayList<ActionStep>(CollectionUtils.getTypedCollection((Collection)this.getModuleData((IModuleData)scenario, "StepScenario"), ActionStep.class));
        Collections.sort(actionSteps, new Comparator<ActionStep>(){

            @Override
            public int compare(ActionStep o1, ActionStep o2) {
                return DataManager.this.before(o1, o2);
            }
        });
        return actionSteps;
    }

    public List getRealActionSteps(Scenario scenario) {
        List<ActionStep> actionSteps = this.getActionSteps(scenario);
        assert (this.isValid(actionSteps));
        if (this.isValid(actionSteps)) {
            actionSteps.remove(0);
            actionSteps.remove(actionSteps.size() - 1);
        } else {
            logger.error("Scenario without beginning or ending step");
        }
        return actionSteps;
    }

    private boolean isValid(List actionSteps) {
        return actionSteps.size() >= 2 && ((ActionStep)((Object)actionSteps.get(0))).getStepType().getValue() == 0 && ((ActionStep)((Object)actionSteps.get(actionSteps.size() - 1))).getStepType().getValue() == 1;
    }

    protected String getIDPrefix(IModuleData object, IModuleDataTypeDescription dataTypeOfItemToBeCreated) {
        if (object instanceof Category) {
            return ((Category)object).getEffectivePrefix();
        }
        return super.getIDPrefix(object, dataTypeOfItemToBeCreated);
    }

    protected String getPrefixSeparator(IModuleData object, IModuleDataTypeDescription dataTypeOfItemToBeCreated) {
        if (object instanceof Category) {
            return CategoryDescription.getPrefixSeparator();
        }
        return super.getPrefixSeparator(object, dataTypeOfItemToBeCreated);
    }

    protected String getPattern(IModuleData object, IModuleDataTypeDescription dataTypeOfItemToBeCreated) {
        if (object instanceof Category) {
            return ((Category)object).getPattern().getDisplayStringRepresentation();
        }
        return super.getPattern(object, dataTypeOfItemToBeCreated);
    }

    public int getExtendingScenarioEndType(Scenario scenario) {
        Collection startingSteps = this.getLinkableObjects((IModuleData)scenario, "ScenarioBeginningStep");
        Collection finalSteps = this.getLinkableObjects((IModuleData)scenario, "ScenarioFinalStep");
        if (startingSteps.isEmpty() || finalSteps.isEmpty()) {
            return 7;
        }
        ActionStep startingStep = (ActionStep)((Object)startingSteps.iterator().next());
        ActionStep finalStep = (ActionStep)((Object)finalSteps.iterator().next());
        return this.getExtendingEndType(startingStep, finalStep, scenario);
    }

    public int getExtendingUseCaseEndType(Extension extension) {
        ActionStep startingStep = (ActionStep)((Object)this.getLinkableObjects((IModuleData)extension, "ExtensionBeginningStep").iterator().next());
        ActionStep finalStep = (ActionStep)((Object)this.getLinkableObjects((IModuleData)extension, "ExtensionFinalStep").iterator().next());
        return this.getExtendingEndType(startingStep, finalStep, extension);
    }

    public int getExtendingEndType(ActionStep startingStep, ActionStep finalStep, Scenario scenario) {
        int numberStep = startingStep.getNumber().getValue();
        int numberFinalStep = finalStep.getNumber().getValue();
        int kindOfFinalStep = finalStep.getStepType().getValue() == 0 ? 3 : (finalStep.getStepType().getValue() == 1 ? (scenario.getSuccess().getValue() == 0 ? 4 : (scenario.getSuccess().getValue() == 1 ? 5 : 6)) : (numberStep == numberFinalStep ? 1 : (numberStep == numberFinalStep - 1 ? 2 : 7)));
        return kindOfFinalStep;
    }

    public int getExtendingEndType(ActionStep startingStep, ActionStep finalStep, Extension extension) {
        int numberStep = startingStep.getNumber().getValue();
        int numberFinalStep = finalStep.getNumber().getValue();
        int kindOfFinalStep = finalStep.getStepType().getValue() == 0 ? 3 : (finalStep.getStepType().getValue() == 1 ? (extension.getSuccess().getValue() == 0 ? 4 : (extension.getSuccess().getValue() == 1 ? 5 : 6)) : (numberStep == numberFinalStep ? 1 : (numberStep == numberFinalStep - 1 ? 2 : 7)));
        return kindOfFinalStep;
    }

    public void newProjectCreated() {
        super.newProjectCreated();
        this.getPermissionMgr().addStandardPermissions((IPermissionOperand)UseCasePermissionRootNode.getSingleton());
    }

    public Collection getForkingUseCases(ActionStep actionStep) {
        Collection extensions = this.getModuleData((IModuleData)actionStep, "ExtensionBeginningStep");
        HashSet useCases = new HashSet(extensions.size());
        for (Extension extension : extensions) {
            useCases.addAll(this.getModuleData((IModuleData)extension, "UseCaseExtension"));
        }
        return useCases;
    }

    public Collection getJoiningUseCases(ActionStep actionStep) {
        Collection extensions = this.getModuleData((IModuleData)actionStep, "ExtensionFinalStep");
        HashSet useCases = new HashSet(extensions.size());
        for (Extension extension : extensions) {
            useCases.addAll(this.getModuleData((IModuleData)extension, "UseCaseExtension"));
        }
        return useCases;
    }

    public UseCase getUseCase(Extension extension) {
        Collection useCaseCollection = this.getLinkMgr().getModuleData((IModuleData)extension, "UseCaseExtension");
        if (useCaseCollection.size() == 1) {
            return (UseCase)((Object)useCaseCollection.iterator().next());
        }
        return null;
    }

    public Goal getMainGoal(UseCase useCase) {
        Collection goals = this.getModuleData((IModuleData)useCase, "GoalUseCase");
        for (Goal goal : goals) {
            if (!goal.isMainActor()) continue;
            return goal;
        }
        return null;
    }

    public Actor getMainActor(UseCase useCase) {
        return (Actor)((Object)this.getLinkMgr().getLinkableObjects((IModuleData)this.getMainGoal(useCase), "GoalActor").iterator().next());
    }

    public Actor getActor(Goal goal) {
        return (Actor)((Object)this.getLinkableObjects((IModuleData)goal, "GoalActor").iterator().next());
    }

    public Collection getGoals(UseCase useCase) {
        return this.getLinkMgr().getModuleData((IModuleData)useCase, "GoalUseCase");
    }

    public UseCase getUseCase(Goal goal) {
        Collection goalCollection = this.getLinkMgr().getLinkableObjects((IModuleData)goal, "GoalUseCase");
        assert (goalCollection.size() == 1);
        return (UseCase)((Object)goalCollection.iterator().next());
    }

    public Goal getGoal(String UUID) {
        return (Goal)((Object)this.getItem("ucm.Goal", UUID));
    }

    public Scenario getScenario(ActionStep actionStep) {
        Collection scenarioCollection = this.getLinkMgr().getLinkableObjects((IModuleData)actionStep, "StepScenario");
        return (Scenario)((Object)scenarioCollection.iterator().next());
    }

    public Actor getActor(ActionStep actionStep) {
        Goal goal = (Goal)((Object)this.getLinkMgr().getLinkableObjects((IModuleData)actionStep, "ActionStepGoal").iterator().next());
        return (Actor)((Object)this.getLinkMgr().getLinkableObjects((IModuleData)goal, "GoalActor").iterator().next());
    }

    public Collection getAllUsedGoals(UseCase useCase) {
        Collection goals = this.getGoals(useCase);
        Iterator i = goals.iterator();
        while (i.hasNext()) {
            Goal goal = (Goal)((Object)i.next());
            if (!this.getModuleData((IModuleData)goal, "ActionStepGoal").isEmpty()) continue;
            i.remove();
        }
        return goals;
    }

    public Collection getActors(UseCase useCase) {
        assert (useCase != null) : "useCase must not be null";
        Collection goals = this.getGoals(useCase);
        HashSet<Actor> actors = new HashSet<Actor>(goals.size());
        for (Goal goal : goals) {
            Actor actor = (Actor)((Object)this.getLinkableObjects((IModuleData)goal, "GoalActor").iterator().next());
            actors.add(actor);
        }
        return actors;
    }

    public List getSortedActors(UseCase useCase) {
        ArrayList actors = new ArrayList(this.getActors(useCase));
        final Actor mainActor = this.getMainActor(useCase);
        Collections.sort(actors, new Comparator(){

            public int compare(Object o1, Object o2) {
                Actor a1 = (Actor)((Object)o1);
                Actor a2 = (Actor)((Object)o2);
                if (a1.equals((Object)mainActor)) {
                    return -1;
                }
                if (a2.equals((Object)mainActor)) {
                    return 1;
                }
                return a1.getName().getDisplayStringRepresentation().compareToIgnoreCase(a2.getName().getDisplayStringRepresentation());
            }
        });
        return actors;
    }

    public Collection<Goal> getAllGoals(Scenario scenario) {
        HashSet<Goal> goals = new HashSet<Goal>();
        List actionSteps = this.getRealActionSteps(scenario);
        for (ActionStep step : actionSteps) {
            goals.addAll(CollectionUtils.getTypedCollection((Collection)this.getLinkableObjects((IModuleData)step, "ActionStepGoal"), Goal.class));
        }
        return goals;
    }

    public ActionStep getPreviousStep(ActionStep step) {
        Collection previousSteps = this.getLinkableObjects((IModuleData)step, "StepPreviousStep");
        if (!previousSteps.isEmpty()) {
            return (ActionStep)((Object)previousSteps.iterator().next());
        }
        return null;
    }

    public ActionStep getNextStep(ActionStep step) {
        Collection nextSteps = this.getModuleData((IModuleData)step, "StepPreviousStep");
        if (!nextSteps.isEmpty()) {
            return (ActionStep)((Object)nextSteps.iterator().next());
        }
        return null;
    }

    public String getDisplayRepresentation_ActionStepWithActor(ActionStep step) {
        switch (step.getStepType().getValue()) {
            case 0: {
                return Messages.getString("ActionStep.Type.Beginning");
            }
            case 2: {
                Actor actor = this.getActor(step);
                String actorName = "";
                if (actor != null) {
                    actorName = actor.getDisplayRepresentation();
                }
                String displayRepresentation = "";
                displayRepresentation = actorName.equals("") ? String.valueOf(this.getDisplayRepresentation_ActionStepNumberWithFullScenarioPrefix(step)) + ": " + step.getTitle().getDisplayStringRepresentation() : String.valueOf(this.getDisplayRepresentation_ActionStepNumberWithFullScenarioPrefix(step)) + ": " + actorName + " " + step.getTitle().getDisplayStringRepresentation();
                return displayRepresentation;
            }
            case 1: {
                return Messages.getString("ActionStep.Type.End");
            }
        }
        return null;
    }

    public IDataTypesHelper getDataTypesHelper() {
        return UCMDataTypesHelper.getDefault();
    }

    protected ILinkTypeHelper getLinkTypesHelper() {
        return UCMLinkTypeHelper.getDefault();
    }

    protected boolean isDataTypeWithID(String dataTypeID) {
        return dataTypeID.equals("ucm.useCase");
    }

    protected void removeNonDisplayableModifications(Collection items) {
        Iterator i = items.iterator();
        while (i.hasNext()) {
            IModuleData item = (IModuleData)i.next();
            if (item instanceof ActionStep) {
                ActionStep step = (ActionStep)item;
                if (step.getStepType().getValue() != 0 && step.getStepType().getValue() != 1) continue;
                i.remove();
                continue;
            }
            if (item instanceof Goal) {
                i.remove();
                continue;
            }
            if (!(item instanceof Extension)) continue;
            i.remove();
        }
    }
}

