/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.core.project;

import com.arcway.cockpit.modulelib2.client.core.project.AbstractDataMgr;
import com.arcway.cockpit.modulelib2.client.core.project.AbstractModuleDataLabelProvider;
import com.arcway.cockpit.modulelib2.client.gui.ImageDescriptorRegistry;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.project.DataManager;
import com.arcway.cockpit.usecasemodule.client.core.project.ModelController;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Image;

public class DataLabelProvider
extends AbstractModuleDataLabelProvider {
    private static Map typeImages = new HashMap();

    static {
        ImageDescriptorRegistry imDescRes = UseCaseModulePlugin.getDefault().getImageDescriptorRegistry();
        typeImages.put("ucm.category", imDescRes.get(UseCaseModulePlugin.getImageDescriptor("Category.gif")));
        typeImages.put("ucm.useCase", imDescRes.get(UseCaseModulePlugin.getImageDescriptor("UseCase.gif")));
        typeImages.put("ucm.Scenario", imDescRes.get(UseCaseModulePlugin.getImageDescriptor("Scenario.gif")));
        typeImages.put("ucm.ActionStep", imDescRes.get(UseCaseModulePlugin.getImageDescriptor("ActionStep.gif")));
    }

    public DataLabelProvider(DataManager dataManager) {
        super((AbstractDataMgr)dataManager);
    }

    public Image getImageForType(String dataTypeID) {
        return (Image)typeImages.get(dataTypeID);
    }

    public String getDisplayNameForType(String dataTypeID) {
        if (dataTypeID.equals("ucm.category")) {
            return Messages.getString("DataLabelProvider.CATEGORIES");
        }
        if (dataTypeID.equals("ucm.useCase")) {
            return Messages.getString("DataLabelProvider.USE_CASES");
        }
        if (dataTypeID.equals("ucm.Scenario")) {
            return Messages.getString("DataLabelProvider.SCENARIOS");
        }
        if (dataTypeID.equals("ucm.ActionStep")) {
            return Messages.getString("DataLabelProvider.ACTIONSTEPS");
        }
        if (dataTypeID.equals("ucm.Extension")) {
            return Messages.getString("DataLabelProvider.ExtensionsLabel");
        }
        if (dataTypeID.equals("ucm.Actor")) {
            return Messages.getString("DataLabelProvider.ActorsLabel");
        }
        if (dataTypeID.equals("ucm.Goal")) {
            return Messages.getString("DataLabelProvider.GoalsLabel");
        }
        return null;
    }

    public Image getImageForItem_internal(IModuleData element) {
        return this.getImageForType(element.getTypeID());
    }

    public String getLabelForItem_internal(IModuleData element) {
        if (element instanceof Scenario) {
            Scenario scenario = (Scenario)element;
            ModelController modelController = (ModelController)UseCaseModulePlugin.getDefault().getProjectManager().getModelController(scenario.getProjectUID());
            if (modelController.isMainScenario(scenario)) {
                return Messages.getString("DataViewLabelProvider.MainScenarioTitle");
            }
            return modelController.getFullScenarioPrefix(scenario);
        }
        return element.getDisplayRepresentation();
    }
}

