/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.core.project;

import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.usecasemodule.client.core.project.DataManager;
import com.arcway.cockpit.usecasemodule.client.messages.ActionStep;
import com.arcway.cockpit.usecasemodule.client.messages.Scenario;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class ActionStepSorter {
    public static List<ActionStep> sortStepsAccordingToUseCaseScenarioAndID(List<ActionStep> steps, final DataManager dataManager) {
        final HashMap<ActionStep, Scenario> map_actionstep_scenario = new HashMap<ActionStep, Scenario>();
        final HashMap<ActionStep, UseCase> map_actionstep_usecase = new HashMap<ActionStep, UseCase>();
        for (ActionStep step : steps) {
            Scenario parentScenario = (Scenario)dataManager.getParent((IModuleData)step);
            map_actionstep_scenario.put(step, parentScenario);
            UseCase ancestorUsecase = dataManager.getUseCase(step);
            map_actionstep_usecase.put(step, ancestorUsecase);
        }
        Collections.sort(steps, new Comparator<ActionStep>(){

            @Override
            public int compare(ActionStep a1, ActionStep a2) {
                UseCase u1 = (UseCase)((Object)map_actionstep_usecase.get((Object)a1));
                UseCase u2 = (UseCase)((Object)map_actionstep_usecase.get((Object)a2));
                if (!u1.getUID().equals(u2.getUID())) {
                    return u1.getID().getDisplayStringRepresentation().compareToIgnoreCase(u2.getID().getDisplayStringRepresentation());
                }
                Scenario s1 = (Scenario)((Object)map_actionstep_scenario.get((Object)a1));
                Scenario s2 = (Scenario)((Object)map_actionstep_scenario.get((Object)a2));
                if (!s1.getUID().equals(s2.getUID())) {
                    String prefS1 = dataManager.isMainScenario(s1) ? "" : dataManager.getFullScenarioPrefix(s1);
                    String prefS2 = dataManager.isMainScenario(s2) ? "" : dataManager.getFullScenarioPrefix(s2);
                    return prefS1.compareToIgnoreCase(prefS2);
                }
                return dataManager.before(a1, a2);
            }
        });
        return steps;
    }
}

