/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.core.permissions;

import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.permissions.AllAttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.AttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.frame.client.project.modules.IModuleProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionOperandTreeContentProvider;
import com.arcway.cockpit.frame.client.project.modules.permissionproviders.IPermissionTemplateCategory;
import com.arcway.cockpit.frame.shared.IPermissionOperand;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.AbstractPermissionTemplateProvider;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.ModulePermissionTemplate;
import com.arcway.cockpit.modulelib2.client.messages.IModuleData;
import com.arcway.cockpit.modulelib2.client.messages.description.ModuleDataTypeDescriptionForFrame;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.UseCaseModulePlugin;
import com.arcway.cockpit.usecasemodule.client.core.permissions.ModulePermissionConstants;
import com.arcway.cockpit.usecasemodule.client.core.permissions.UseCasePermissionRootNode;
import com.arcway.cockpit.usecasemodule.client.messages.Category;
import com.arcway.cockpit.usecasemodule.client.messages.UCMDataTypesHelper;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.cockpit.usecasemodule.client.messages.description.ActionStepDescription;
import com.arcway.cockpit.usecasemodule.client.messages.description.CategoryDescription;
import com.arcway.cockpit.usecasemodule.client.messages.description.ScenarioDescription;
import com.arcway.cockpit.usecasemodule.client.messages.description.UseCaseDescription;
import com.arcway.cockpit.usecasemodule.shared.ModuleIdentification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;

public class UseCasePermissionTemplateProvider
extends AbstractPermissionTemplateProvider {
    private static final String PERMISSION_DIALOG_NAME = Messages.getString("UseCasePermissionTemplateProvider.USE_CASE_CATEGORIES");
    private static final String PERMISSION_DIALOG_DESCRIPTION = Messages.getString("UseCasePermissionTemplateProvider.DIALOG_DESCRIPTION");
    private static final HashMap categoryMap = new HashMap();
    private static final String CATEGORY_KEY = "ucm.category";
    private static final String USE_CASE_KEY = "ucm.useCase";
    private static final String SCENARIO_KEY = "ucm.Scenario";
    private static final String ACTION_STEP_KEY = "ucm.ActionStep";

    public UseCasePermissionTemplateProvider() {
        super(UCMDataTypesHelper.getDefault());
    }

    public String getName() {
        return PERMISSION_DIALOG_NAME;
    }

    public String getDescription() {
        return PERMISSION_DIALOG_DESCRIPTION;
    }

    public Object getTreeViewerInput(IModuleProjectAgent projectAgent) {
        return this;
    }

    public IPermissionOperandTreeContentProvider getTreeContentProvider(IModuleProjectAgent projectAgent) {
        return new TreeContentProvider(projectAgent);
    }

    public ILabelProvider getTreeLabelProvider(IModuleProjectAgent projectAgent) {
        return new TreeLabelProvider();
    }

    public ViewerSorter getTreeSorter() {
        return null;
    }

    public IPermissionTemplateCategory getCategory(IFrameProjectAgent projectAgent, CockpitPermissionTemplate template) {
        AllAttributeModificationPermissionTemplate attrTemplate;
        if (template.getOperation().equals("operationEditCategory")) {
            return this.getCategoryForCategory();
        }
        if (template.getOperation().equals("operationEditCertainUseCase") || template.getOperation().equals("operationEditUseCasesInCategory")) {
            return this.getCategoryForUseCase();
        }
        if (template.getOperation().equals("operationEditGlobalActors")) {
            return this.getCategoryForUseCase();
        }
        if (template instanceof AllAttributeModificationPermissionTemplate) {
            attrTemplate = (AllAttributeModificationPermissionTemplate)template;
            if (attrTemplate.getCockpitDataTypeID().equals(CategoryDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                return this.getCategoryForCategory();
            }
            if (attrTemplate.getCockpitDataTypeID().equals(UseCaseDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                return this.getCategoryForUseCase();
            }
            if (attrTemplate.getCockpitDataTypeID().equals(ScenarioDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                return this.getCategoryForScenario();
            }
            if (attrTemplate.getCockpitDataTypeID().equals(ActionStepDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                return this.getCategoryForActionStep();
            }
        }
        if (template instanceof AttributeModificationPermissionTemplate) {
            attrTemplate = (AttributeModificationPermissionTemplate)template;
            if (attrTemplate.getCockpitDataTypeID().equals(CategoryDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                return this.getCategoryForCategory();
            }
            if (attrTemplate.getCockpitDataTypeID().equals(UseCaseDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                return this.getCategoryForUseCase();
            }
            if (attrTemplate.getCockpitDataTypeID().equals(ScenarioDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                return this.getCategoryForScenario();
            }
            if (attrTemplate.getCockpitDataTypeID().equals(ActionStepDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                return this.getCategoryForActionStep();
            }
        }
        return null;
    }

    private IPermissionTemplateCategory getCategoryForCategory() {
        if (!categoryMap.containsKey(CATEGORY_KEY)) {
            categoryMap.put(CATEGORY_KEY, new IPermissionTemplateCategory(){

                public String getID() {
                    return UseCasePermissionTemplateProvider.CATEGORY_KEY;
                }

                public String getDisplayName() {
                    return Messages.getString("UseCasePermissionTemplateProvider.CatgoryPermissions");
                }
            });
        }
        return (IPermissionTemplateCategory)categoryMap.get(CATEGORY_KEY);
    }

    private IPermissionTemplateCategory getCategoryForUseCase() {
        if (!categoryMap.containsKey(USE_CASE_KEY)) {
            categoryMap.put(USE_CASE_KEY, new IPermissionTemplateCategory(){

                public String getID() {
                    return UseCasePermissionTemplateProvider.USE_CASE_KEY;
                }

                public String getDisplayName() {
                    return Messages.getString("UseCasePermissionTemplateProvider.UseCasePermissions");
                }
            });
        }
        return (IPermissionTemplateCategory)categoryMap.get(USE_CASE_KEY);
    }

    private IPermissionTemplateCategory getCategoryForScenario() {
        if (!categoryMap.containsKey(SCENARIO_KEY)) {
            categoryMap.put(SCENARIO_KEY, new IPermissionTemplateCategory(){

                public String getID() {
                    return UseCasePermissionTemplateProvider.SCENARIO_KEY;
                }

                public String getDisplayName() {
                    return Messages.getString("UseCasePermissionTemplateProvider.ScenarioPermissions");
                }
            });
        }
        return (IPermissionTemplateCategory)categoryMap.get(SCENARIO_KEY);
    }

    private IPermissionTemplateCategory getCategoryForActionStep() {
        if (!categoryMap.containsKey(ACTION_STEP_KEY)) {
            categoryMap.put(ACTION_STEP_KEY, new IPermissionTemplateCategory(){

                public String getID() {
                    return UseCasePermissionTemplateProvider.ACTION_STEP_KEY;
                }

                public String getDisplayName() {
                    return Messages.getString("UseCasePermissionTemplateProvider.ActionStepPermissions");
                }
            });
        }
        return (IPermissionTemplateCategory)categoryMap.get(ACTION_STEP_KEY);
    }

    public Collection getTemplates(IFrameProjectAgent projectAgent) {
        ArrayList<CockpitPermissionTemplate> operationTemplates = new ArrayList<CockpitPermissionTemplate>(ModulePermissionConstants.getTemplates());
        operationTemplates.addAll(UseCasePermissionTemplateProvider.getAttributeModificationTemplates((IModuleProjectAgent)projectAgent, (ModuleDataTypeDescriptionForFrame)CategoryDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)CATEGORY_KEY));
        operationTemplates.addAll(UseCasePermissionTemplateProvider.getAttributeModificationTemplates((IModuleProjectAgent)projectAgent, (ModuleDataTypeDescriptionForFrame)UseCaseDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)CATEGORY_KEY));
        operationTemplates.addAll(UseCasePermissionTemplateProvider.getAttributeModificationTemplates((IModuleProjectAgent)projectAgent, (ModuleDataTypeDescriptionForFrame)UseCaseDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)USE_CASE_KEY));
        operationTemplates.addAll(UseCasePermissionTemplateProvider.getAttributeModificationTemplates((IModuleProjectAgent)projectAgent, (ModuleDataTypeDescriptionForFrame)ActionStepDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)CATEGORY_KEY));
        operationTemplates.addAll(UseCasePermissionTemplateProvider.getAttributeModificationTemplates((IModuleProjectAgent)projectAgent, (ModuleDataTypeDescriptionForFrame)ActionStepDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)USE_CASE_KEY));
        operationTemplates.addAll(UseCasePermissionTemplateProvider.getAttributeModificationTemplates((IModuleProjectAgent)projectAgent, (ModuleDataTypeDescriptionForFrame)ScenarioDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)CATEGORY_KEY));
        operationTemplates.addAll(UseCasePermissionTemplateProvider.getAttributeModificationTemplates((IModuleProjectAgent)projectAgent, (ModuleDataTypeDescriptionForFrame)ScenarioDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)USE_CASE_KEY));
        return operationTemplates;
    }

    public ILabelProvider getTemplatesLabelProvider(IFrameProjectAgent projectAgent) {
        return new TemplateLabelProvider(projectAgent);
    }

    private static class TemplateLabelProvider
    extends AbstractPermissionTemplateProvider.AbstractTemplateLabelProvider {
        public TemplateLabelProvider(IFrameProjectAgent projectAgent) {
            super(projectAgent, UCMDataTypesHelper.getDefault());
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (!(element instanceof ModulePermissionTemplate)) {
                return null;
            }
            ModulePermissionTemplate template = (ModulePermissionTemplate)element;
            if (template.getBaseTemplate() instanceof AllAttributeModificationPermissionTemplate) {
                return ((AllAttributeModificationPermissionTemplate)template.getBaseTemplate()).getPermissionName();
            }
            if (template.getBaseTemplate() instanceof AttributeModificationPermissionTemplate) {
                AttributeModificationPermissionTemplate attrTemplate = (AttributeModificationPermissionTemplate)template.getBaseTemplate();
                String label = this.getAttributePermissionTemplateLabel(attrTemplate);
                if (label != null) {
                    return label;
                }
                if (attrTemplate.getCockpitDataTypeID().equals(CategoryDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                    String attributeName = CategoryDescription.getAttributeDisplayName(attrTemplate.getAttributeTypeUID());
                    return "\"" + attributeName + "\"" + Messages.getString("UseCasePermissionTemplateProvider.ofCategory");
                }
                if (attrTemplate.getCockpitDataTypeID().equals(UseCaseDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                    String attributeName = UseCaseDescription.getAttributeDisplayName(attrTemplate.getAttributeTypeUID());
                    return "\"" + attributeName + "\"" + Messages.getString("UseCasePermissionTemplateProvider.ofUseCase");
                }
                if (attrTemplate.getCockpitDataTypeID().equals(ScenarioDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                    String attributeName = ScenarioDescription.getAttributeDisplayName(attrTemplate.getAttributeTypeUID());
                    return "\"" + attributeName + "\"" + Messages.getString("UseCasePermissionTemplateProvider.ofScenario");
                }
                if (attrTemplate.getCockpitDataTypeID().equals(ActionStepDescription.MODULEDATATYPEDESCRIPTION_FORFRAME.getCockpitDataTypeID())) {
                    String attributeName = ActionStepDescription.getAttributeDisplayName(attrTemplate.getAttributeTypeUID());
                    return "\"" + attributeName + "\"" + Messages.getString("UseCasePermissionTemplateProvider.ofActionStep");
                }
                return "TODO!!!!";
            }
            return ModulePermissionConstants.getName((CockpitPermissionTemplate)template);
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static class TreeContentProvider
    extends AbstractPermissionTemplateProvider.AbstractTreeContentProvider {
        public TreeContentProvider(IModuleProjectAgent projectAgent) {
            super(projectAgent, ModuleIdentification.getModuleID());
        }

        public IPermissionOperand[] getElements(Object element) {
            return new IPermissionOperand[]{UseCasePermissionRootNode.getSingleton()};
        }

        public boolean hasChildren(IPermissionOperand element) {
            boolean hasChildren = false;
            if (element instanceof UseCasePermissionRootNode) {
                hasChildren = !this.getModelController().getAllItems(UseCasePermissionTemplateProvider.CATEGORY_KEY).isEmpty();
            } else if (element instanceof Category) {
                hasChildren = false;
                Iterator childrenIterator = this.getModelController().getChildren((IModuleData)((Category)element)).iterator();
                while (childrenIterator.hasNext()) {
                    if (!(childrenIterator.next() instanceof UseCase)) continue;
                    hasChildren = true;
                    break;
                }
            } else {
                hasChildren = false;
            }
            return hasChildren;
        }

        public IPermissionOperand getParent(IPermissionOperand element) {
            IPermissionOperand parent;
            if (element instanceof UseCasePermissionRootNode) {
                parent = null;
            } else {
                if (element instanceof Category) {
                    return UseCasePermissionRootNode.getSingleton();
                }
                if (element instanceof UseCase) {
                    Category parentCat = (Category)this.getModelController().getParent((IModuleData)((UseCase)element));
                    if (parentCat != null) {
                        parent = parentCat;
                    } else {
                        assert (false);
                        parent = UseCasePermissionRootNode.getSingleton();
                    }
                } else {
                    assert (false);
                    parent = null;
                }
            }
            return parent;
        }

        public IPermissionOperand[] getChildren(IPermissionOperand parentElement) {
            Collection children = Collections.EMPTY_SET;
            if (parentElement instanceof UseCasePermissionRootNode) {
                Collection allSets = this.getModelController().getAllItems(UseCasePermissionTemplateProvider.CATEGORY_KEY);
                children = allSets;
            } else if (parentElement instanceof Category) {
                Collection allChildren = this.getModelController().getChildren((IModuleData)((Category)parentElement));
                children = allChildren;
            }
            IPermissionOperand[] childrenArray = new IPermissionOperand[children.size()];
            children.toArray(childrenArray);
            return childrenArray;
        }

        public IPermissionOperand getTreeRootNode() {
            return UseCasePermissionRootNode.getSingleton();
        }
    }

    private static class TreeLabelProvider
    implements ILabelProvider {
        private TreeLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof UseCasePermissionRootNode || element instanceof Category) {
                ImageDescriptor desc = UseCaseModulePlugin.getImageDescriptor("Category.gif");
                return UseCaseModulePlugin.getDefault().getImageDescriptorRegistry().get(desc);
            }
            if (element instanceof UseCase) {
                ImageDescriptor desc = UseCaseModulePlugin.getImageDescriptor("UseCase.gif");
                return UseCaseModulePlugin.getDefault().getImageDescriptorRegistry().get(desc);
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof UseCasePermissionRootNode) {
                return Messages.getString("UseCasePermissionTemplateProvider.ALL_CATEGORIES");
            }
            if (element instanceof Category) {
                return ((Category)((Object)element)).getDisplayRepresentation();
            }
            if (element instanceof UseCase) {
                return ((UseCase)((Object)element)).getDisplayRepresentation();
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

