/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.client.core.permissions;

import com.arcway.cockpit.client.base.interfaces.frame.datamanagement.ICockpitDataType;
import com.arcway.cockpit.frame.client.project.core.permissions.AllAttributeModificationPermissionTemplate;
import com.arcway.cockpit.frame.client.project.core.permissions.CockpitPermissionTemplate;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.ModulePermissionTemplate;
import com.arcway.cockpit.modulelib2.client.core.project.permissions.PermissionOperationDescription;
import com.arcway.cockpit.usecasemodule.client.Messages;
import com.arcway.cockpit.usecasemodule.client.core.permissions.UseCasePermissionRootNode;
import com.arcway.cockpit.usecasemodule.client.messages.description.ActionStepDescription;
import com.arcway.cockpit.usecasemodule.client.messages.description.CategoryDescription;
import com.arcway.cockpit.usecasemodule.client.messages.description.ScenarioDescription;
import com.arcway.cockpit.usecasemodule.client.messages.description.UseCaseDescription;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ModulePermissionConstants {
    public static final String OPERAND_TYPE_USE_CASE_CATEGORY = "ucm.category";
    public static final String OPERAND_TYPE_USE_CASE = "ucm.useCase";
    public static final String OPERATION_EDIT_USE_CASES_IN_CATEGORY = "operationEditUseCasesInCategory";
    public static final String OPERATION_EDIT_CERTAIN_USE_CASE = "operationEditCertainUseCase";
    public static final String OPERATION_EDIT_USE_CASE_CATEGORY = "operationEditCategory";
    public static final String OPERATION_EDIT_GLOBAL_ACTORS = "operationEditGlobalActors";
    public static final CockpitPermissionTemplate EDIT_CATEGORY = new ModulePermissionTemplate("operationEditCategory", Arrays.asList(new PermissionOperationDescription("Create", "ucm.category"), new PermissionOperationDescription("Modify", "ucm.category"), new PermissionOperationDescription("Delete", "ucm.category")), "ucm.category");
    public static final CockpitPermissionTemplate EDIT_USE_CASES_IN_CATEGORY = new ModulePermissionTemplate("operationEditUseCasesInCategory", Arrays.asList(new PermissionOperationDescription("Create", "ucm.useCase"), new PermissionOperationDescription("Modify", "ucm.useCase"), new PermissionOperationDescription("Delete", "ucm.useCase")), "ucm.category");
    public static final CockpitPermissionTemplate EDIT_ALL_CATEGORY_ATTR_IN_CATEGORY = new ModulePermissionTemplate((CockpitPermissionTemplate)AllAttributeModificationPermissionTemplate.getAllAttrTemplate((ICockpitDataType)CategoryDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ucm.category"), Arrays.asList(new PermissionOperationDescription("ModifyAllAttributes", "ucm.category")));
    public static final CockpitPermissionTemplate EDIT_ALL_USE_CASE_ATTR_IN_CATEGORY = new ModulePermissionTemplate((CockpitPermissionTemplate)AllAttributeModificationPermissionTemplate.getAllAttrTemplate((ICockpitDataType)UseCaseDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ucm.category"), Arrays.asList(new PermissionOperationDescription("ModifyAllAttributes", "ucm.useCase")));
    public static final CockpitPermissionTemplate EDIT_ALL_SCENARIO_ATTR_IN_CATEGORY = new ModulePermissionTemplate((CockpitPermissionTemplate)AllAttributeModificationPermissionTemplate.getAllAttrTemplate((ICockpitDataType)ScenarioDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ucm.category"), Arrays.asList(new PermissionOperationDescription("ModifyAllAttributes", "ucm.Scenario")));
    public static final CockpitPermissionTemplate EDIT_ALL_ACTION_STEP_ATTR_IN_CATEGORY = new ModulePermissionTemplate((CockpitPermissionTemplate)AllAttributeModificationPermissionTemplate.getAllAttrTemplate((ICockpitDataType)ActionStepDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ucm.category"), Arrays.asList(new PermissionOperationDescription("ModifyAllAttributes", "ucm.ActionStep")));
    public static final CockpitPermissionTemplate EDIT_CERTAIN_USE_CASE = new ModulePermissionTemplate("operationEditCertainUseCase", Arrays.asList(new PermissionOperationDescription("Modify", "ucm.useCase"), new PermissionOperationDescription("Delete", "ucm.useCase")), "ucm.useCase");
    public static final CockpitPermissionTemplate EDIT_ALL_USE_CASE_ATTR = new ModulePermissionTemplate((CockpitPermissionTemplate)AllAttributeModificationPermissionTemplate.getAllAttrTemplate((ICockpitDataType)UseCaseDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ucm.useCase"), Arrays.asList(new PermissionOperationDescription("ModifyAllAttributes", "ucm.useCase")));
    public static final CockpitPermissionTemplate EDIT_ALL_SCENARIO_ATTR_IN_USE_CASE = new ModulePermissionTemplate((CockpitPermissionTemplate)AllAttributeModificationPermissionTemplate.getAllAttrTemplate((ICockpitDataType)ScenarioDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ucm.useCase"), Arrays.asList(new PermissionOperationDescription("ModifyAllAttributes", "ucm.Scenario")));
    public static final CockpitPermissionTemplate EDIT_ALL_ACTION_STEP_ATTR_IN_USE_CASE = new ModulePermissionTemplate((CockpitPermissionTemplate)AllAttributeModificationPermissionTemplate.getAllAttrTemplate((ICockpitDataType)ActionStepDescription.MODULEDATATYPEDESCRIPTION_FORFRAME, (String)"ucm.useCase"), Arrays.asList(new PermissionOperationDescription("ModifyAllAttributes", "ucm.ActionStep")));
    public static final CockpitPermissionTemplate EDIT_GLOBAL_ACTORS = new ModulePermissionTemplate("operationEditGlobalActors", Arrays.asList(new PermissionOperationDescription("Create", "ucm.Actor"), new PermissionOperationDescription("Modify", "ucm.Actor"), new PermissionOperationDescription("Delete", "ucm.Actor")), UseCasePermissionRootNode.getSingleton().getPermissionOperandType());
    private static List<CockpitPermissionTemplate> allTemplates = null;

    public static synchronized List<CockpitPermissionTemplate> getTemplates() {
        if (allTemplates == null) {
            allTemplates = new ArrayList<CockpitPermissionTemplate>();
            allTemplates.add(EDIT_CATEGORY);
            allTemplates.add(EDIT_CERTAIN_USE_CASE);
            allTemplates.add(EDIT_USE_CASES_IN_CATEGORY);
            allTemplates.add(EDIT_ALL_CATEGORY_ATTR_IN_CATEGORY);
            allTemplates.add(EDIT_ALL_USE_CASE_ATTR_IN_CATEGORY);
            allTemplates.add(EDIT_ALL_USE_CASE_ATTR);
            allTemplates.add(EDIT_ALL_SCENARIO_ATTR_IN_CATEGORY);
            allTemplates.add(EDIT_ALL_SCENARIO_ATTR_IN_USE_CASE);
            allTemplates.add(EDIT_ALL_ACTION_STEP_ATTR_IN_CATEGORY);
            allTemplates.add(EDIT_ALL_ACTION_STEP_ATTR_IN_USE_CASE);
            allTemplates.add(EDIT_GLOBAL_ACTORS);
        }
        return allTemplates;
    }

    public static List<CockpitPermissionTemplate> getTemplates(String operandType) {
        assert (operandType != null);
        ArrayList<CockpitPermissionTemplate> result = new ArrayList<CockpitPermissionTemplate>();
        for (CockpitPermissionTemplate permission : ModulePermissionConstants.getTemplates()) {
            if (!permission.getOperandType().equals(operandType)) continue;
            result.add(permission);
        }
        return result;
    }

    public static String getName(CockpitPermissionTemplate template) {
        assert (template != null);
        if (template.getOperation().equals(OPERATION_EDIT_USE_CASE_CATEGORY)) {
            return Messages.getString("ModulePermissionConstants.EDIT_USE_CASE_CATEGORY");
        }
        if (template.getOperation().equals(OPERATION_EDIT_USE_CASES_IN_CATEGORY)) {
            return Messages.getString("ModulePermissionConstants.EDIT_USE_CASES_IN_CATEGORY");
        }
        if (template.getOperation().equals(OPERATION_EDIT_CERTAIN_USE_CASE)) {
            return Messages.getString("ModulePermissionConstants.EDIT_USE_CASE");
        }
        if (template == EDIT_GLOBAL_ACTORS) {
            return Messages.getString("ModulePermissionConstants.edit_actors_projectwide");
        }
        return null;
    }
}

