/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.docgen.provider;

import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractAttributeOwnerDocGenProxy;
import com.arcway.cockpit.docgen.provider.HistoryEntry;
import com.arcway.cockpit.docgen.provider.UniqueElementDocGenProxy;
import com.arcway.cockpit.docgen.provider.interfaces.IModelElement;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.docgen.provider.utils.MultilineTextOutputHelper;
import com.arcway.cockpit.frame.client.lib.relationviews.GraphNodeLayoutProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IGraphNodeLayoutProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IGraphicProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationGraphProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationViewGraphBuilder;
import com.arcway.cockpit.frame.client.lib.relationviews.IRelationViewViewPartFactory;
import com.arcway.cockpit.frame.client.lib.relationviews.ITextExtendCalculator;
import com.arcway.cockpit.frame.client.lib.relationviews.LabelCreator;
import com.arcway.cockpit.frame.client.lib.relationviews.RelationViewGraphicProvider;
import com.arcway.cockpit.frame.client.lib.relationviews.RelationViewViewPartFactory;
import com.arcway.cockpit.frame.client.lib.relationviews.ViewPartTextExtendCalculator;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementComparator;
import com.arcway.cockpit.frame.client.project.docgenerator.DocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.interFace.ICockpitProjectData;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleDataDocGenProxy;
import com.arcway.cockpit.modulelib2.client.docgen.provider.AbstractGraphicsProvidingModuleDataDocGenProxy;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.DataFacade;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExCategory;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExGoal;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExScenario;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExUseCase;
import com.arcway.cockpit.usecasemodule.client.gui.usecaserelationview.UseCaseRelationGraphBuilder;
import com.arcway.cockpit.usecasemodule.client.gui.usecaserelationview.UseCaseRelationGraphLayoutProvider;
import com.arcway.cockpit.usecasemodule.client.messages.description.UseCaseDescription;
import com.arcway.cockpit.usecasemodule.docgen.provider.ExtensionDocGenProxy;
import com.arcway.cockpit.usecasemodule.docgen.provider.GoalComparator;
import com.arcway.cockpit.usecasemodule.docgen.provider.GoalDocGenProxy;
import com.arcway.cockpit.usecasemodule.docgen.provider.ScenarioComparator;
import com.arcway.cockpit.usecasemodule.docgen.provider.ScenarioDocGenProxy;
import com.arcway.cockpit.usecasemodule.docgen.provider.UseCaseCategoryDocGenProxy;
import com.arcway.cockpit.usecasemodule.docgen.provider.UseCaseComparator;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IExtension;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IGoal;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IScenario;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IUseCase;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IUseCaseCategory;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.ui.IWorkbenchPage;

public class UseCaseDocGenProxy
extends AbstractGraphicsProvidingModuleDataDocGenProxy
implements IModuleDataDocGenProxy,
IUseCase {
    private DataFacade dataFacade = null;
    private ImExUseCase useCase = null;
    private Collection filters = null;
    private final Locale locale;
    private final IWorkbenchPage currentPage;

    public UseCaseDocGenProxy(ImExUseCase useCase, IGraphicsAndFilesHelper graphicsProvider, DataFacade dataFacade, Collection filters, Locale locale, IWorkbenchPage currentPage) {
        super((AbstractImExModuleData)useCase, graphicsProvider, locale);
        this.useCase = useCase;
        this.dataFacade = dataFacade;
        this.filters = filters;
        this.locale = locale;
        this.currentPage = currentPage;
    }

    @Override
    public String getUniqueIdentifier() {
        return this.useCase.getUniqueIdentifier();
    }

    public String getDisplayName() {
        return HTMLEncoder.encode((String)(String.valueOf(this.useCase.id) + " - " + this.useCase.name));
    }

    public String getTypeID() {
        return "ucm.useCase";
    }

    public String getTypeName() {
        return new UseCaseDescription().getTypeName(this.locale);
    }

    @Override
    public String getAuthor() {
        return this.getCreator();
    }

    @Override
    public String getId() {
        return HTMLEncoder.encode((String)this.useCase.id);
    }

    @Override
    public String getName() {
        return HTMLEncoder.encode((String)this.useCase.name);
    }

    @Override
    public String getInitiator() {
        return HTMLEncoder.encode((String)this.useCase.initiator);
    }

    @Deprecated
    public String getModificationDate() {
        return this.getDateOfLastModification();
    }

    @Override
    public String getPriority() {
        return HTMLEncoder.encode((String)this.useCase.priority);
    }

    @Override
    public String getMainActor() {
        return HTMLEncoder.encode((String)this.useCase.main_actor);
    }

    @Override
    public List<String> getScope() {
        List scopeList = StringUtil.splitTextLines((String)this.useCase.scope);
        List resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput((List)scopeList);
        return resultAsList;
    }

    @Override
    public String getLevel() {
        return HTMLEncoder.encode((String)this.useCase.level);
    }

    @Override
    public String getState() {
        return HTMLEncoder.encode((String)this.useCase.state);
    }

    @Override
    public List<String> getNotes() {
        List notesList = StringUtil.splitTextLines((String)this.useCase.notes);
        List resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput((List)notesList);
        return resultAsList;
    }

    @Override
    public List<IGoal> getGoals() {
        ArrayList goals = new ArrayList(this.dataFacade.getGoalsForUseCase(this.useCase, this.locale));
        Collections.sort(goals, new GoalComparator(9));
        ArrayList<IGoal> result = new ArrayList<IGoal>(goals.size());
        for (ImExGoal goal : goals) {
            GoalDocGenProxy goalDesc = new GoalDocGenProxy(goal, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
            result.add(goalDesc);
        }
        return result;
    }

    @Override
    public IUseCaseCategory getCategory() {
        ImExCategory category = this.dataFacade.getCategory(this.useCase, this.locale);
        UseCaseCategoryDocGenProxy categoryDescription = new UseCaseCategoryDocGenProxy(category, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        return categoryDescription;
    }

    @Override
    public IScenario getMainScenario() {
        ImExScenario scenario = this.dataFacade.getMainScenario(this.useCase, this.locale);
        ScenarioDocGenProxy scenarioDescription = new ScenarioDocGenProxy(scenario, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        return scenarioDescription;
    }

    @Override
    public boolean hasExtensionScenarios() {
        boolean result = false;
        ImExScenario mainScenario = this.dataFacade.getMainScenario(this.useCase, this.locale);
        List extensions = this.dataFacade.getExtendingScenarios(mainScenario, this.locale);
        result = extensions.size() > 0;
        return result;
    }

    public List<IScenario> getExtensionScenarios() {
        List extensions = this.getExtensionScenarios_Internal();
        Collections.sort(extensions, new ScenarioComparator(7));
        return ScenarioDocGenProxy.transformScenarioList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IScenario> getExtensionScenarios(String sortingProperty) {
        List extensions = this.getExtensionScenarios_Internal();
        List<IScenario> transformedExtensions = ScenarioDocGenProxy.transformScenarioList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedExtensions, (String)sortingProperty);
        return transformedExtensions;
    }

    private List getExtensionScenarios_Internal() {
        ImExScenario mainScenario = this.dataFacade.getMainScenario(this.useCase, this.locale);
        return new ArrayList(this.dataFacade.getExtendingScenarios(mainScenario, this.locale));
    }

    @Override
    public boolean hasExtensionUseCases() {
        boolean result = false;
        ImExScenario mainScenario = this.dataFacade.getMainScenario(this.useCase, this.locale);
        Collection extensions = this.dataFacade.getExtendingUseCases(mainScenario, this.filters, this.locale);
        result = extensions.size() > 0;
        return result;
    }

    public List<IUseCase> getExtensionUseCases() {
        List extensions = this.getExtensionUseCases_Internal();
        Collections.sort(extensions, new UseCaseComparator(1));
        return UseCaseDocGenProxy.transformUseCaseList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IUseCase> getExtensionUseCases(int sortingCriterion) {
        List extensions = this.getExtensionUseCases_Internal();
        Collections.sort(extensions, new UseCaseComparator(sortingCriterion));
        return UseCaseDocGenProxy.transformUseCaseList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IUseCase> getExtensionUseCases(String sortingProperty) {
        List extensions = this.getExtensionUseCases_Internal();
        List<IUseCase> transformedExtensions = UseCaseDocGenProxy.transformUseCaseList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedExtensions, (String)sortingProperty);
        return transformedExtensions;
    }

    private List getExtensionUseCases_Internal() {
        ImExScenario mainScenario = this.dataFacade.getMainScenario(this.useCase, this.locale);
        return new ArrayList(this.dataFacade.getExtendingUseCases(mainScenario, this.filters, this.locale));
    }

    @Override
    public boolean isExtensionUseCase() {
        return this.dataFacade.getExtendedScenarios(this.useCase, this.locale).size() > 0;
    }

    public List<IScenario> getExtendedScenarios() {
        List extendedScenarios = this.getExtendedScenarios_Internal();
        return ScenarioDocGenProxy.transformScenarioList(extendedScenarios, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IScenario> getExtendedScenarios(String sortingProperty) {
        List extendedScenarios = this.getExtendedScenarios_Internal();
        List<IScenario> transformedExtendedScenarios = ScenarioDocGenProxy.transformScenarioList(extendedScenarios, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedExtendedScenarios, (String)sortingProperty);
        return transformedExtendedScenarios;
    }

    private List getExtendedScenarios_Internal() {
        return new ArrayList(this.dataFacade.getExtendedScenarios(this.useCase, this.locale));
    }

    protected static List<IUseCase> transformUseCaseList(List useCases, IGraphicsAndFilesHelper graphicsProvider, DataFacade dataFacade, Collection filters, Locale locale, IWorkbenchPage currentPage) {
        ArrayList<IUseCase> result = new ArrayList<IUseCase>(useCases.size());
        for (ImExUseCase useCase : useCases) {
            UseCaseDocGenProxy useCaseDescription = new UseCaseDocGenProxy(useCase, graphicsProvider, dataFacade, filters, locale, currentPage);
            result.add(useCaseDescription);
        }
        return result;
    }

    public List<IExtension> getExtensions() {
        List extendedExtensions = this.dataFacade.getExtensions(this.useCase, this.locale);
        List<IExtension> transformedExtensions = ExtensionDocGenProxy.transformExtensionList(extendedExtensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        return transformedExtensions;
    }

    @Override
    public boolean isLinkedWithUniqueElements() {
        return this.dataFacade.isLinkedWithUniqueElements(this.useCase);
    }

    public List<IModelElement> getLinkedUniqueElements() {
        ArrayList ues = new ArrayList(this.dataFacade.getLinkedUniqueElements(this.useCase));
        Collections.sort(ues, new UniqueElementComparator());
        ArrayList<IModelElement> ueProxies = new ArrayList<IModelElement>(ues.size());
        for (IUniqueElement ue : ues) {
            UniqueElementDocGenProxy ueProxy = new UniqueElementDocGenProxy(ue, (IDocGeneratorProjectAgent)new DocGeneratorProjectAgent((IFrameProjectAgent)this.dataFacade.getModelController().getProjectAgent()), (Collection)Collections.EMPTY_LIST, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
            ueProxies.add((IModelElement)ueProxy);
        }
        return ueProxies;
    }

    protected IGraphicProvider createGraphicProvider() {
        ViewPartTextExtendCalculator textExtendCalculator = new ViewPartTextExtendCalculator();
        UseCaseRelationGraphLayoutProvider relationGraphProvider = new UseCaseRelationGraphLayoutProvider();
        GraphNodeLayoutProvider layoutProvider = new GraphNodeLayoutProvider((ITextExtendCalculator)textExtendCalculator, (IRelationGraphProvider)relationGraphProvider);
        LabelCreator labelCreator = new LabelCreator((IGraphNodeLayoutProvider)layoutProvider);
        UseCaseRelationGraphBuilder graphBuilder = new UseCaseRelationGraphBuilder(labelCreator);
        RelationViewViewPartFactory viewPartFactory = new RelationViewViewPartFactory();
        return new RelationViewGraphicProvider((IRelationViewGraphBuilder)graphBuilder, (IRelationViewViewPartFactory)viewPartFactory, labelCreator, (ICockpitProjectData)this.useCase.getModuleData(), this.useCase.id);
    }

    public AbstractImExModuleData getWrappedExportableItem() {
        return this.useCase;
    }

    public String getCommitVersion() {
        int commitCount = this.useCase.getCommitCount();
        return HistoryEntry.getVersionForCommitCount((int)commitCount);
    }

    protected <T> Map<String, T> createMapOfPresentationElements(Map<String, T> mapOfRepresentedElements, boolean representedElementsArePresentationElements) {
        return mapOfRepresentedElements;
    }

    public IRecord toRecord(Set<String> keyWhiteList) {
        IRecord record = super.toRecord(keyWhiteList);
        if (keyWhiteList == null || keyWhiteList.contains("id")) {
            record.set("id", (Object)this.getId());
        }
        if (keyWhiteList == null || keyWhiteList.contains("title")) {
            record.set("name", (Object)this.getName());
        }
        return record;
    }
}

