/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.docgen.provider;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractAttributeOwnerDocGenProxy;
import com.arcway.cockpit.docgen.provider.AbstractCustomPropertiesAccessDocGenProxy;
import com.arcway.cockpit.docgen.provider.HistoryEntry;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleDataDocGenProxy;
import com.arcway.cockpit.modulelib2.client.docgen.provider.AbstractModuleDataDocGenProxy;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.DataFacade;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExCategory;
import com.arcway.cockpit.usecasemodule.client.messages.description.CategoryDescription;
import com.arcway.cockpit.usecasemodule.docgen.provider.UseCaseComparator;
import com.arcway.cockpit.usecasemodule.docgen.provider.UseCaseDocGenProxy;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IUseCase;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IUseCaseCategory;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.ui.IWorkbenchPage;

public class UseCaseCategoryDocGenProxy
extends AbstractModuleDataDocGenProxy
implements IModuleDataDocGenProxy,
IUseCaseCategory {
    private DataFacade dataFacade = null;
    private ImExCategory useCaseCategory = null;
    private Collection<AbstractFilter> filters = null;
    private final Locale locale;
    private final IWorkbenchPage currentPage;

    public UseCaseCategoryDocGenProxy(ImExCategory category, IGraphicsAndFilesHelper graphicsProvider, DataFacade dataFacade, Collection<AbstractFilter> filters, Locale locale, IWorkbenchPage currentPage) {
        super((AbstractImExModuleData)category, graphicsProvider, locale);
        this.useCaseCategory = category;
        this.dataFacade = dataFacade;
        this.filters = filters;
        this.locale = locale;
        this.currentPage = currentPage;
    }

    @Override
    public String getUniqueIdentifier() {
        return this.useCaseCategory.getUniqueIdentifier();
    }

    public String getDisplayName() {
        return HTMLEncoder.encode((String)this.useCaseCategory.name);
    }

    public String getTypeID() {
        return "ucm.useCaseSet";
    }

    public String getTypeName() {
        return new CategoryDescription().getTypeName(this.locale);
    }

    @Override
    public String getName() {
        return HTMLEncoder.encode((String)this.useCaseCategory.name);
    }

    @Override
    public boolean containsUseCases() {
        boolean result = false;
        Collection useCases = this.dataFacade.getUseCases(this.useCaseCategory, this.filters, this.locale);
        result = useCases.size() > 0;
        return result;
    }

    public List<IUseCase> getUseCases() {
        List useCases = this.getUseCases_Internal();
        return UseCaseDocGenProxy.transformUseCaseList(useCases, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IUseCase> getUseCasesWithCategory(String categoryID) {
        return AbstractCustomPropertiesAccessDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(this.getUseCases(), (String)categoryID);
    }

    public List<IUseCase> getUseCasesWithDefaultCategory() {
        return this.getUseCasesWithCategory(null);
    }

    public List<IUseCase> getUseCases(int sortingCriterion) {
        List useCases = this.getUseCases_Internal();
        Collections.sort(useCases, new UseCaseComparator(sortingCriterion));
        return UseCaseDocGenProxy.transformUseCaseList(useCases, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IUseCase> getUseCasesWithCategory(String categoryID, int sortingCriterion) {
        return AbstractCustomPropertiesAccessDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(this.getUseCases(sortingCriterion), (String)categoryID);
    }

    public List<IUseCase> getUseCasesWithDefaultCategory(int sortingCriterion) {
        return this.getUseCasesWithCategory(null, sortingCriterion);
    }

    public List<IUseCase> getUseCases(String sortingProperty) {
        List useCases = this.getUseCases_Internal();
        List<IUseCase> transformedUseCases = UseCaseDocGenProxy.transformUseCaseList(useCases, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedUseCases, (String)sortingProperty);
        return transformedUseCases;
    }

    public List<IUseCase> getUseCasesWithCategory(String categoryID, String sortingCriterion) {
        return AbstractCustomPropertiesAccessDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(this.getUseCases(sortingCriterion), (String)categoryID);
    }

    public List<IUseCase> getUseCasesWithDefaultCategory(String sortingCriterion) {
        return this.getUseCasesWithCategory(null, sortingCriterion);
    }

    private List getUseCases_Internal() {
        return new ArrayList(this.dataFacade.getUseCases(this.useCaseCategory, this.filters, this.locale));
    }

    protected static List<IUseCaseCategory> transformUseCaseCategoryList(List categoryCollection, IGraphicsAndFilesHelper graphicsProvider, DataFacade dataFacade, Collection filters, Locale locale, IWorkbenchPage currentPage) {
        ArrayList<IUseCaseCategory> result = new ArrayList<IUseCaseCategory>(categoryCollection.size());
        for (ImExCategory category : categoryCollection) {
            UseCaseCategoryDocGenProxy categoryDesc = new UseCaseCategoryDocGenProxy(category, graphicsProvider, dataFacade, filters, locale, currentPage);
            result.add(categoryDesc);
        }
        return result;
    }

    public AbstractImExModuleData getWrappedExportableItem() {
        return this.useCaseCategory;
    }

    public String getCommitVersion() {
        int commitCount = this.useCaseCategory.getCommitCount();
        return HistoryEntry.getVersionForCommitCount((int)commitCount);
    }

    public IRecord toRecord(Set<String> keyWhiteList) {
        IRecord record = super.toRecord(keyWhiteList);
        if (keyWhiteList == null || keyWhiteList.contains("title")) {
            record.set("name", (Object)this.getName());
        }
        return record;
    }
}

