/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.docgen.provider;

import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractAttributeOwnerDocGenProxy;
import com.arcway.cockpit.docgen.provider.HistoryEntry;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.docgen.provider.utils.MultilineTextOutputHelper;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleDataDocGenProxy;
import com.arcway.cockpit.modulelib2.client.docgen.provider.AbstractModuleDataDocGenProxy;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.DataFacade;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExActionStep;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExActionStepEnd;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExScenario;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExUseCase;
import com.arcway.cockpit.usecasemodule.client.messages.description.ScenarioDescription;
import com.arcway.cockpit.usecasemodule.docgen.provider.ActionStepComparator;
import com.arcway.cockpit.usecasemodule.docgen.provider.ActionStepDocGenProxy;
import com.arcway.cockpit.usecasemodule.docgen.provider.ActionStepEndDocGenProxy;
import com.arcway.cockpit.usecasemodule.docgen.provider.ScenarioComparator;
import com.arcway.cockpit.usecasemodule.docgen.provider.UseCaseComparator;
import com.arcway.cockpit.usecasemodule.docgen.provider.UseCaseDocGenProxy;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IActionStep;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IActionStepEnd;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IScenario;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IUseCase;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.ui.IWorkbenchPage;

public class ScenarioDocGenProxy
extends AbstractModuleDataDocGenProxy
implements IModuleDataDocGenProxy,
IScenario {
    private DataFacade dataFacade = null;
    private Collection filters = null;
    private ImExScenario scenario = null;
    private final Locale locale;
    private final IWorkbenchPage currentPage;

    public ScenarioDocGenProxy(ImExScenario scenario, IGraphicsAndFilesHelper graphicsProvider, DataFacade dataFacade, Collection filters, Locale locale, IWorkbenchPage currentPage) {
        super((AbstractImExModuleData)scenario, graphicsProvider, locale);
        this.scenario = scenario;
        this.dataFacade = dataFacade;
        this.filters = filters;
        this.locale = locale;
        this.currentPage = currentPage;
    }

    @Override
    public String getId() {
        return HTMLEncoder.encode((String)this.scenario.fullID);
    }

    public String getDisplayName() {
        return HTMLEncoder.encode((String)this.scenario.fullID);
    }

    public String getTypeID() {
        return "ucm.scenario";
    }

    public String getTypeName() {
        return new ScenarioDescription().getTypeName(this.locale);
    }

    @Override
    public List<String> getGoal() {
        List goalList = StringUtil.splitTextLines((String)this.scenario.goal);
        List resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput((List)goalList);
        return resultAsList;
    }

    @Override
    public List<String> getPrecondition() {
        List preconditionList = StringUtil.splitTextLines((String)this.scenario.precondition);
        List resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput((List)preconditionList);
        return resultAsList;
    }

    @Override
    public List<String> getPostconditionOnSuccess() {
        List postconditionOnSuccessList = StringUtil.splitTextLines((String)this.scenario.postconditionOnSuccess);
        List resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput((List)postconditionOnSuccessList);
        return resultAsList;
    }

    @Override
    public List<String> getPostconditionOnFailure() {
        List postconditionOnFailureList = StringUtil.splitTextLines((String)this.scenario.postConditionOnFailure);
        List resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput((List)postconditionOnFailureList);
        return resultAsList;
    }

    @Override
    public List<String> getTrigger() {
        List triggerList = StringUtil.splitTextLines((String)this.scenario.trigger);
        List resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput((List)triggerList);
        return resultAsList;
    }

    @Override
    public IUseCase getUseCase() {
        ImExUseCase useCase = this.dataFacade.getUseCase(this.scenario, this.locale);
        UseCaseDocGenProxy useCaseDescription = new UseCaseDocGenProxy(useCase, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        return useCaseDescription;
    }

    @Override
    public IActionStepEnd getActionStepEnd() {
        ImExActionStepEnd actionStep = this.dataFacade.getFinalStep(this.scenario, this.locale);
        ActionStepEndDocGenProxy actionStepEndDesc = new ActionStepEndDocGenProxy(actionStep, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        return actionStepEndDesc;
    }

    @Override
    public boolean hasActionSteps() {
        List actionSteps = this.dataFacade.getActionSteps(this.scenario, this.locale);
        return actionSteps.size() > 0;
    }

    public List<IActionStep> getActionSteps() {
        List actionSteps = this.dataFacade.getActionSteps(this.scenario, this.locale);
        Collections.sort(actionSteps, new ActionStepComparator(8));
        ArrayList<IActionStep> result = new ArrayList<IActionStep>(actionSteps.size());
        for (ImExActionStep actionStep : actionSteps) {
            ActionStepDocGenProxy actionStepDesc = new ActionStepDocGenProxy(actionStep, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
            result.add(actionStepDesc);
        }
        return result;
    }

    @Override
    public String getExtendingScenarioEndType() {
        return this.dataFacade.getExtendingScenarioEndType(this.scenario);
    }

    @Override
    public String getUniqueIdentifier() {
        return this.scenario.getUniqueIdentifier();
    }

    @Override
    public boolean isExtensionScenario() {
        return this.dataFacade.isExtensionScenario(this.scenario);
    }

    @Override
    public IScenario getExtendedScenario() {
        ImExScenario expScenario = this.dataFacade.getExtendedScenario(this.scenario, this.locale);
        if (expScenario == null) {
            return null;
        }
        ScenarioDocGenProxy scenarioDesc = new ScenarioDocGenProxy(expScenario, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        return scenarioDesc;
    }

    @Override
    public boolean hasExtensionScenarios() {
        boolean result = false;
        List extensions = this.dataFacade.getExtendingScenarios(this.scenario, this.locale);
        result = extensions.size() > 0;
        return result;
    }

    public List<IScenario> getExtensionScenarios() {
        List extensions = this.getExtensionScenarios_Internal();
        Collections.sort(extensions, new ScenarioComparator(7));
        return ScenarioDocGenProxy.transformScenarioList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IScenario> getExtensionScenarios(String sortingProperty) {
        List extensions = this.getExtensionScenarios_Internal();
        List<IScenario> transformedExtensions = ScenarioDocGenProxy.transformScenarioList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedExtensions, (String)sortingProperty);
        return transformedExtensions;
    }

    private List getExtensionScenarios_Internal() {
        return new ArrayList(this.dataFacade.getExtendingScenarios(this.scenario, this.locale));
    }

    @Override
    public boolean hasExtensionUseCases() {
        boolean result = false;
        Collection extensions = this.dataFacade.getExtendingUseCases(this.scenario, this.filters, this.locale);
        result = extensions.size() > 0;
        return result;
    }

    public List<IUseCase> getExtensionUseCases() {
        List extensions = this.getExtensionUseCases_Internal();
        Collections.sort(extensions, new UseCaseComparator(1));
        return UseCaseDocGenProxy.transformUseCaseList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IUseCase> getExtensionUseCases(int sortingCriterion) {
        List extensions = this.getExtensionUseCases_Internal();
        Collections.sort(extensions, new UseCaseComparator(sortingCriterion));
        return UseCaseDocGenProxy.transformUseCaseList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IUseCase> getExtensionUseCases(String sortingProperty) {
        List extensions = this.getExtensionUseCases_Internal();
        List<IUseCase> transformedExtensions = UseCaseDocGenProxy.transformUseCaseList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedExtensions, (String)sortingProperty);
        return transformedExtensions;
    }

    private List getExtensionUseCases_Internal() {
        return new ArrayList(this.dataFacade.getExtendingUseCases(this.scenario, this.filters, this.locale));
    }

    static List<IScenario> transformScenarioList(List scenarios, IGraphicsAndFilesHelper graphicsProvider, DataFacade dataFacade, Collection filters, Locale locale, IWorkbenchPage currentPage) {
        ArrayList<IScenario> result = new ArrayList<IScenario>(scenarios.size());
        for (ImExScenario scenario : scenarios) {
            ScenarioDocGenProxy scenarioDesc = new ScenarioDocGenProxy(scenario, graphicsProvider, dataFacade, filters, locale, currentPage);
            result.add(scenarioDesc);
        }
        return result;
    }

    public AbstractImExModuleData getWrappedExportableItem() {
        return this.scenario;
    }

    @Override
    public List<String> getFinalStateOnFailure() {
        return this.getPostconditionOnFailure();
    }

    @Override
    public List<String> getFinalStateOnSuccess() {
        return this.getPostconditionOnSuccess();
    }

    @Override
    public List<String> getInitialSituation() {
        return this.getPrecondition();
    }

    @Override
    public List<String> getTriggeringEvent() {
        return this.getTrigger();
    }

    public String getCommitVersion() {
        int commitCount = this.scenario.getCommitCount();
        return HistoryEntry.getVersionForCommitCount((int)commitCount);
    }

    public IRecord toRecord(Set<String> keyWhiteList) {
        IRecord record = super.toRecord(keyWhiteList);
        if (keyWhiteList == null || keyWhiteList.contains("id")) {
            record.set("id", (Object)this.getId());
        }
        return record;
    }
}

