/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.docgen.provider;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractAttributeOwnerDocGenProxy;
import com.arcway.cockpit.docgen.provider.AbstractCustomPropertiesAccessDocGenProxy;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportContext;
import com.arcway.cockpit.docgen.provider.IProjectRelatedReportProvider;
import com.arcway.cockpit.docgen.provider.interfaces.IHistoryEntry;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.modules.IFMCAModule;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleDataDocGenProxy;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleReportDataProvider;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.DataFacade;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExActionStep;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExCategory;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExExtension;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExGoal;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExScenario;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExUseCase;
import com.arcway.cockpit.usecasemodule.docgen.provider.ActionStepDocGenProxy;
import com.arcway.cockpit.usecasemodule.docgen.provider.ExtensionDocGenProxy;
import com.arcway.cockpit.usecasemodule.docgen.provider.GoalDocGenProxy;
import com.arcway.cockpit.usecasemodule.docgen.provider.ScenarioDocGenProxy;
import com.arcway.cockpit.usecasemodule.docgen.provider.UseCaseCategoryDocGenProxy;
import com.arcway.cockpit.usecasemodule.docgen.provider.UseCaseComparator;
import com.arcway.cockpit.usecasemodule.docgen.provider.UseCaseDocGenProxy;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IActionStep;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IScenario;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IUseCase;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IUseCaseCategory;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IUseCaseDataProvider;
import com.arcway.cockpit.usecasemodule.shared.ModuleIdentification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.ui.IWorkbenchPage;

public class ReportDataProvider
implements IModuleReportDataProvider,
IProjectRelatedReportProvider,
IUseCaseDataProvider {
    public static final int SORT_USECASECATEGORY_BY_NAME = 0;
    public static final int SORT_USECASE_BY_ID = 1;
    public static final int SORT_USECASE_BY_INITIATOR = 2;
    public static final int SORT_USECASE_BY_MAINACTOR = 3;
    public static final int SORT_USECASE_BY_LEVEL = 4;
    public static final int SORT_USECASE_BY_PRIORITY = 5;
    public static final int SORT_USECASE_BY_STATE = 6;
    public static final int SORT_SCENARIO_BY_ID = 7;
    public static final int SORT_ACTIONSTEP_BY_ORDINALNUMBER = 8;
    public static final int SORT_GOAL_MAINGOAL_FIRST = 9;
    private DataFacade dataFacade = null;
    private IGraphicsAndFilesHelper graphicsProvider;
    private Collection<AbstractFilter> filters = null;
    private Locale locale;
    private IWorkbenchPage currentPage;

    public void setup(IProjectRelatedReportContext reportContext) {
        IDocGeneratorProjectAgent projectAgent = reportContext.getProjectAgent();
        IFMCAModule module = projectAgent.getModule(ModuleIdentification.getModuleID());
        this.locale = new Locale(projectAgent.getLanguageID());
        this.dataFacade = (DataFacade)module.getModuleDataFacade();
        this.graphicsProvider = reportContext.getGraphicsProvider();
        this.filters = reportContext.getFilterCollection();
        this.currentPage = reportContext.getCurrentPage();
    }

    @Override
    public String getOutputFormat() {
        return this.dataFacade.getInlineScenarioPreference();
    }

    public List<IUseCaseCategory> getAllUseCaseCategories() {
        List<ImExCategory> useCaseCategories = this.getAllUseCaseCategories_Internal();
        return UseCaseCategoryDocGenProxy.transformUseCaseCategoryList(useCaseCategories, this.graphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IUseCaseCategory> getAllUseCaseCategoriesWithCategory(String categoryID) {
        return AbstractCustomPropertiesAccessDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(this.getAllUseCaseCategories(), (String)categoryID);
    }

    public List<IUseCaseCategory> getAllUseCaseCategoriesWithDefaultCategory() {
        return this.getAllUseCaseCategoriesWithCategory(null);
    }

    public List<IUseCaseCategory> getAllUseCaseCategories(String sortingProperty) {
        List<ImExCategory> useCaseCategories = this.getAllUseCaseCategories_Internal();
        List<IUseCaseCategory> transformedUseCaseCategories = UseCaseCategoryDocGenProxy.transformUseCaseCategoryList(useCaseCategories, this.graphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedUseCaseCategories, (String)sortingProperty);
        return transformedUseCaseCategories;
    }

    public List<IUseCaseCategory> getAllUseCaseCategoriesWithCategory(String categoryID, String sortingProperty) {
        return AbstractCustomPropertiesAccessDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(this.getAllUseCaseCategories(sortingProperty), (String)categoryID);
    }

    public List<IUseCaseCategory> getAllUseCaseCategoriesWithDefaultCategory(String sortingProperty) {
        return this.getAllUseCaseCategoriesWithCategory(sortingProperty, null);
    }

    private List<ImExCategory> getAllUseCaseCategories_Internal() {
        return new ArrayList<ImExCategory>(this.dataFacade.getAllUseCaseCategories(this.filters, this.locale));
    }

    public List<IUseCase> getAllUseCases() {
        List<ImExUseCase> useCases = this.getAllUseCases_Internal();
        Collections.sort(useCases, new UseCaseComparator(1));
        return UseCaseDocGenProxy.transformUseCaseList(useCases, this.graphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IUseCase> getAllUseCasesWithCategory(String categoryID) {
        return AbstractCustomPropertiesAccessDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(this.getAllUseCases(), (String)categoryID);
    }

    public List<IUseCase> getAllUseCasesWithDefaultCategory() {
        return this.getAllUseCasesWithCategory(null);
    }

    public List<IUseCase> getAllUseCases(int sortingCriterion) {
        List<ImExUseCase> useCases = this.getAllUseCases_Internal();
        Collections.sort(useCases, new UseCaseComparator(sortingCriterion));
        return UseCaseDocGenProxy.transformUseCaseList(useCases, this.graphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IUseCase> getAllUseCasesWithCategory(String categoryID, int sortingCriterion) {
        return AbstractCustomPropertiesAccessDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(this.getAllUseCases(sortingCriterion), (String)categoryID);
    }

    public List<IUseCase> getAllUseCasesWithDefaultCategory(int sortingCriterion) {
        return this.getAllUseCasesWithCategory(null, sortingCriterion);
    }

    public List<IUseCase> getAllUseCases(String sortingProperty) {
        List<ImExUseCase> useCases = this.getAllUseCases_Internal();
        List<IUseCase> transformedUseCases = UseCaseDocGenProxy.transformUseCaseList(useCases, this.graphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedUseCases, (String)sortingProperty);
        return transformedUseCases;
    }

    public List<IUseCase> getAllUseCasesWithCategory(String categoryID, String sortingCriterion) {
        return AbstractCustomPropertiesAccessDocGenProxy.filterByCategoryIDAsCustomPropertiesAccess(this.getAllUseCases(sortingCriterion), (String)categoryID);
    }

    public List<IUseCase> getAllUseCasesWithDefaultCategory(String sortingCriterion) {
        return this.getAllUseCasesWithCategory(null, sortingCriterion);
    }

    private List<ImExUseCase> getAllUseCases_Internal() {
        return new ArrayList<ImExUseCase>(this.dataFacade.getAllUseCases(this.filters, this.locale));
    }

    public List<IScenario> getAllScenarios() {
        List<ImExScenario> scenarios = this.getAllScenarios_Internal();
        List<IScenario> transformedUseCases = ScenarioDocGenProxy.transformScenarioList(scenarios, this.graphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        return transformedUseCases;
    }

    private List<ImExScenario> getAllScenarios_Internal() {
        return new ArrayList<ImExScenario>(this.dataFacade.getAllScenarios(this.locale));
    }

    public List<IActionStep> getAllActionSteps() {
        List<ImExActionStep> actionSteps = this.getAllActionSteps_Internal();
        List<IActionStep> transformedActionSteps = ActionStepDocGenProxy.transformActionStepList(actionSteps, this.graphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        return transformedActionSteps;
    }

    private List<ImExActionStep> getAllActionSteps_Internal() {
        return new ArrayList<ImExActionStep>(this.dataFacade.getAllActionSteps(this.locale));
    }

    @Override
    public boolean hasUseCasesForUniqueElement(String uniqueElementUID) {
        boolean result = false;
        Collection useCases = this.dataFacade.getUseCasesForUniqueElement(uniqueElementUID, this.filters, this.locale);
        result = useCases.size() > 0;
        return result;
    }

    @Override
    public boolean hasActionStepsForUniqueElement(String uniqueElementUID) {
        boolean result = false;
        Collection actionSteps = this.dataFacade.getLinkedSteps(uniqueElementUID, this.locale);
        result = actionSteps.size() > 0;
        return result;
    }

    public List<IUseCase> getUseCasesForUniqueElement(String uniqueElementUID) {
        return this.getUseCasesForUniqueElement(uniqueElementUID, 1);
    }

    public List<IUseCase> getUseCasesForUniqueElement(String uniqueElementUID, int sortingCriterion) {
        List useCases = this.getUseCasesForUniqueElement_Internal(uniqueElementUID);
        Collections.sort(useCases, new UseCaseComparator(sortingCriterion));
        return UseCaseDocGenProxy.transformUseCaseList(useCases, this.graphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IUseCase> getUseCasesForUniqueElement(String uniqueElementUID, String sortingProperty) {
        List useCases = this.getUseCasesForUniqueElement_Internal(uniqueElementUID);
        List<IUseCase> transformedUseCases = UseCaseDocGenProxy.transformUseCaseList(useCases, this.graphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedUseCases, (String)sortingProperty);
        return transformedUseCases;
    }

    private List getUseCasesForUniqueElement_Internal(String uniqueElementUID) {
        return new ArrayList(this.dataFacade.getUseCasesForUniqueElement(uniqueElementUID, this.filters, this.locale));
    }

    public List<IActionStep> getActionStepsForUniqueElement(String uniqueElementUID) {
        Collection actionSteps = this.dataFacade.getLinkedSteps(uniqueElementUID, this.locale);
        ArrayList<IActionStep> result = new ArrayList<IActionStep>(actionSteps.size());
        for (ImExActionStep actionStep : actionSteps) {
            ActionStepDocGenProxy actionStepDescription = new ActionStepDocGenProxy(actionStep, this.graphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
            result.add(actionStepDescription);
        }
        return result;
    }

    @Override
    public int getSORT_USECASE_BY_ID() {
        return 1;
    }

    @Override
    public int getSORT_USECASE_BY_INITIATOR() {
        return 2;
    }

    @Override
    public int getSORT_USECASE_BY_MAINACTOR() {
        return 3;
    }

    @Override
    public int getSORT_USECASE_BY_LEVEL() {
        return 4;
    }

    @Override
    public int getSORT_USECASE_BY_PRIORITY() {
        return 5;
    }

    @Override
    public int getSORT_USECASE_BY_STATE() {
        return 6;
    }

    public boolean isResponsibleFor(AbstractImExModuleData exportableItem) {
        return exportableItem instanceof ImExCategory || exportableItem instanceof ImExUseCase || exportableItem instanceof ImExScenario || exportableItem instanceof ImExActionStep || exportableItem instanceof ImExExtension || exportableItem instanceof ImExGoal;
    }

    public IModuleDataDocGenProxy getDocGenProxy(AbstractImExModuleData exportableItem) {
        if (exportableItem instanceof ImExCategory) {
            return new UseCaseCategoryDocGenProxy((ImExCategory)exportableItem, this.graphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        }
        if (exportableItem instanceof ImExUseCase) {
            return new UseCaseDocGenProxy((ImExUseCase)exportableItem, this.graphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        }
        if (exportableItem instanceof ImExScenario) {
            return new ScenarioDocGenProxy((ImExScenario)exportableItem, this.graphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        }
        if (exportableItem instanceof ImExActionStep) {
            return new ActionStepDocGenProxy((ImExActionStep)exportableItem, this.graphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        }
        if (exportableItem instanceof ImExExtension) {
            return new ExtensionDocGenProxy((ImExExtension)exportableItem, this.graphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        }
        if (exportableItem instanceof ImExGoal) {
            return new GoalDocGenProxy((ImExGoal)exportableItem, this.graphicsProvider, this.dataFacade, this.filters, this.locale, this.currentPage);
        }
        return null;
    }

    @Override
    public List<? extends IUseCaseCategory> getAllUseCaseCategoriesForHistoryItem(IHistoryEntry historyEntry) {
        ArrayList<IUseCaseCategory> useCaseCategoriesForHistoryItem = new ArrayList<IUseCaseCategory>();
        String commitVersion = historyEntry.getVersion();
        if (commitVersion != null) {
            List<IUseCaseCategory> useCaseCategories = this.getAllUseCaseCategories();
            for (IUseCaseCategory useCaseCategory : useCaseCategories) {
                if (!commitVersion.equals(useCaseCategory.getCommitVersion())) continue;
                useCaseCategoriesForHistoryItem.add(useCaseCategory);
            }
        }
        return useCaseCategoriesForHistoryItem;
    }

    @Override
    public List<? extends IUseCase> getAllUseCasesForHistoryItem(IHistoryEntry historyEntry) {
        ArrayList<IUseCase> useCasesForHistoryItem = new ArrayList<IUseCase>();
        String commitVersion = historyEntry.getVersion();
        if (commitVersion != null) {
            List<IUseCase> useCases = this.getAllUseCases();
            for (IUseCase useCase : useCases) {
                if (!commitVersion.equals(useCase.getCommitVersion())) continue;
                useCasesForHistoryItem.add(useCase);
            }
        }
        return useCasesForHistoryItem;
    }

    @Override
    public List<? extends IScenario> getAllScenariosForHistoryItem(IHistoryEntry historyEntry) {
        ArrayList<IScenario> scenariosForHistoryItem = new ArrayList<IScenario>();
        String commitVersion = historyEntry.getVersion();
        if (commitVersion != null) {
            List<IScenario> scenarios = this.getAllScenarios();
            for (IScenario scenario : scenarios) {
                if (!commitVersion.equals(scenario.getCommitVersion())) continue;
                scenariosForHistoryItem.add(scenario);
            }
        }
        return scenariosForHistoryItem;
    }

    @Override
    public List<? extends IActionStep> getAllActionStepsForHistoryItem(IHistoryEntry historyEntry) {
        ArrayList<IActionStep> actionStepsForHistoryItem = new ArrayList<IActionStep>();
        String commitVersion = historyEntry.getVersion();
        if (commitVersion != null) {
            List<IScenario> scenarios = this.getAllScenarios();
            for (IScenario scenario : scenarios) {
                List<? extends IActionStep> actionSteps = scenario.getActionSteps();
                for (IActionStep iActionStep : actionSteps) {
                    if (!commitVersion.equals(iActionStep.getCommitVersion())) continue;
                    actionStepsForHistoryItem.add(iActionStep);
                }
            }
        }
        return actionStepsForHistoryItem;
    }
}

