/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.docgen.provider;

import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.HistoryEntry;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.docgen.provider.utils.MultilineTextOutputHelper;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleDataDocGenProxy;
import com.arcway.cockpit.modulelib2.client.docgen.provider.AbstractModuleDataWithoutCustomPropertiesDocGenProxy;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.DataFacade;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExGoal;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExUseCase;
import com.arcway.cockpit.usecasemodule.client.messages.description.GoalDescription;
import com.arcway.cockpit.usecasemodule.docgen.provider.UseCaseDocGenProxy;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IGoal;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IUseCase;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.HTMLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.ui.IWorkbenchPage;

public class GoalDocGenProxy
extends AbstractModuleDataWithoutCustomPropertiesDocGenProxy
implements IModuleDataDocGenProxy,
IGoal {
    private DataFacade dataFacade = null;
    private ImExGoal goal = null;
    private Collection filters = null;
    private final Locale locale;
    private final IWorkbenchPage currentPage;

    public GoalDocGenProxy(ImExGoal goal, IGraphicsAndFilesHelper graphicsProvider, DataFacade dataFacade, Collection filters, Locale locale, IWorkbenchPage currentPage) {
        super((AbstractImExModuleData)goal, graphicsProvider, locale);
        this.goal = goal;
        this.dataFacade = dataFacade;
        this.filters = filters;
        this.locale = locale;
        this.currentPage = currentPage;
    }

    public String getUniqueIdentifier() {
        return this.goal.getUniqueIdentifier();
    }

    public String getDisplayName() {
        return HTMLEncoder.encode((String)this.goal.description);
    }

    public String getTypeID() {
        return "ucm.goal";
    }

    public String getTypeName() {
        return new GoalDescription().getTypeName(this.locale);
    }

    @Override
    public List<String> getDescription() {
        List descriptionList = StringUtil.splitTextLines((String)this.goal.description);
        List resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput((List)descriptionList);
        return resultAsList;
    }

    @Override
    public String getActor() {
        return HTMLEncoder.encode((String)this.goal.actor);
    }

    @Override
    public boolean isMainActorsGoal() {
        return this.goal.isMainActorsGoal;
    }

    public List<String> getCommitVersions() {
        return null;
    }

    @Override
    public IUseCase getUseCase() {
        ImExUseCase useCase = this.dataFacade.getUseCase(this.goal, this.locale);
        UseCaseDocGenProxy useCaseDescription = new UseCaseDocGenProxy(useCase, this.getGraphicsProvider(), this.dataFacade, this.filters, this.locale, this.currentPage);
        return useCaseDescription;
    }

    public AbstractImExModuleData getWrappedExportableItem() {
        return this.goal;
    }

    public String getCommitVersion() {
        int commitCount = this.goal.getCommitCount();
        return HistoryEntry.getVersionForCommitCount((int)commitCount);
    }

    public IRecord toRecord(Set<String> keyWhiteList) {
        IRecord record = super.toRecord(keyWhiteList);
        if (keyWhiteList == null || keyWhiteList.contains("description")) {
            record.set("description", this.getDescription());
        }
        return record;
    }
}

