/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.docgen.provider;

import com.arcway.cockpit.docgen.graphicsandfiles.IGraphicsAndFilesHelper;
import com.arcway.cockpit.docgen.provider.AbstractAttributeOwnerDocGenProxy;
import com.arcway.cockpit.docgen.provider.HistoryEntry;
import com.arcway.cockpit.docgen.provider.UniqueElementDocGenProxy;
import com.arcway.cockpit.docgen.provider.interfaces.IModelElement;
import com.arcway.cockpit.docgen.provider.interfaces.IRecord;
import com.arcway.cockpit.docgen.provider.utils.MultilineTextOutputHelper;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.IUniqueElement;
import com.arcway.cockpit.frame.client.project.core.uniqueelements.UniqueElementComparator;
import com.arcway.cockpit.frame.client.project.docgenerator.DocGeneratorProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.IDocGeneratorProjectAgent;
import com.arcway.cockpit.modulelib2.client.dataexchange.AbstractImExModuleData;
import com.arcway.cockpit.modulelib2.client.docgen.interfaces.IModuleDataDocGenProxy;
import com.arcway.cockpit.modulelib2.client.docgen.provider.AbstractModuleDataDocGenProxy;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.DataFacade;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExActionStep;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.ImExScenario;
import com.arcway.cockpit.usecasemodule.client.messages.description.ActionStepDescription;
import com.arcway.cockpit.usecasemodule.docgen.provider.ScenarioComparator;
import com.arcway.cockpit.usecasemodule.docgen.provider.ScenarioDocGenProxy;
import com.arcway.cockpit.usecasemodule.docgen.provider.UseCaseComparator;
import com.arcway.cockpit.usecasemodule.docgen.provider.UseCaseDocGenProxy;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IActionStep;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IScenario;
import com.arcway.cockpit.usecasemodule.docgen.provider.interfaces.IUseCase;
import com.arcway.lib.stringtools.StringUtil;
import de.plans.lib.util.HTMLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.ui.IWorkbenchPage;

public class ActionStepDocGenProxy
extends AbstractModuleDataDocGenProxy
implements IModuleDataDocGenProxy,
IActionStep {
    private DataFacade dataFacade = null;
    private Collection filters = null;
    private ImExActionStep actionStep = null;
    private final Locale locale;
    private final IWorkbenchPage currentPage;

    public ActionStepDocGenProxy(ImExActionStep actionStep, IGraphicsAndFilesHelper graphicsProvider, DataFacade dataFacade, Collection filters, Locale locale, IWorkbenchPage currentPage) {
        super((AbstractImExModuleData)actionStep, graphicsProvider, locale);
        this.actionStep = actionStep;
        this.locale = locale;
        this.dataFacade = dataFacade;
        this.filters = filters;
        this.currentPage = currentPage;
    }

    @Override
    public String getId() {
        return HTMLEncoder.encode((String)this.actionStep.ID);
    }

    @Override
    public String getUniqueIdentifier() {
        return this.actionStep.getUniqueIdentifier();
    }

    public String getDisplayName() {
        return HTMLEncoder.encode((String)(String.valueOf(this.actionStep.number) + ": " + this.actionStep.title));
    }

    public String getTypeID() {
        return "ucm.actionStep";
    }

    public String getTypeName() {
        return new ActionStepDescription().getTypeName(this.locale);
    }

    @Override
    public List<String> getDescription() {
        List descriptionList = StringUtil.splitTextLines((String)this.actionStep.description);
        List resultAsList = MultilineTextOutputHelper.getHTMLEncodedNormalisedMultilineTextOutput((List)descriptionList);
        return resultAsList;
    }

    @Override
    public String getTitle() {
        return HTMLEncoder.encode((String)this.actionStep.title);
    }

    @Override
    public String getActor() {
        return HTMLEncoder.encode((String)this.actionStep.actor);
    }

    @Override
    public IScenario getScenario() {
        ImExScenario scenario = this.dataFacade.getScenario(this.actionStep, this.locale);
        ScenarioDocGenProxy scenarioDescription = new ScenarioDocGenProxy(scenario, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        return scenarioDescription;
    }

    @Override
    public boolean isStartOfExtensionScenarios() {
        boolean result = false;
        List extensions = this.dataFacade.getExtendingScenarios(this.actionStep, this.locale);
        result = extensions.size() > 0;
        return result;
    }

    public List<IScenario> getStartingExtensionScenarios() {
        List extensions = this.getStartingExtensionScenarios_Internal();
        Collections.sort(extensions, new ScenarioComparator(7));
        return ScenarioDocGenProxy.transformScenarioList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IScenario> getStartingExtensionScenarios(String sortingProperty) {
        List extensions = this.getStartingExtensionScenarios_Internal();
        List<IScenario> transformedExtensions = ScenarioDocGenProxy.transformScenarioList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedExtensions, (String)sortingProperty);
        return transformedExtensions;
    }

    private List getStartingExtensionScenarios_Internal() {
        return new ArrayList(this.dataFacade.getExtendingScenarios(this.actionStep, this.locale));
    }

    @Override
    public boolean isStartOfExtensionUseCases() {
        boolean result = false;
        Collection extensions = this.dataFacade.getExtendingUseCases(this.actionStep, this.filters, this.locale);
        result = extensions.size() > 0;
        return result;
    }

    public List<IUseCase> getStartingExtensionUseCases() {
        List extensions = this.getStartingExtensionUseCases_Internal();
        Collections.sort(extensions, new UseCaseComparator(1));
        return UseCaseDocGenProxy.transformUseCaseList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IUseCase> getStartingExtensionUseCases(int sortingCriterion) {
        List extensions = this.getStartingExtensionUseCases_Internal();
        Collections.sort(extensions, new UseCaseComparator(sortingCriterion));
        return UseCaseDocGenProxy.transformUseCaseList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IUseCase> getStartingExtensionUseCases(String sortingProperty) {
        List extensions = this.getStartingExtensionUseCases_Internal();
        List<IUseCase> transformedExtensions = UseCaseDocGenProxy.transformUseCaseList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedExtensions, (String)sortingProperty);
        return transformedExtensions;
    }

    private List getStartingExtensionUseCases_Internal() {
        return new ArrayList(this.dataFacade.getExtendingUseCases(this.actionStep, this.filters, this.locale));
    }

    @Override
    public boolean isEndOfExtensionScenarios() {
        boolean result = false;
        Collection extensions = this.dataFacade.getEndingExtendingScenarios(this.actionStep, this.locale);
        result = extensions.size() > 0;
        return result;
    }

    public List<IScenario> getEndingExtensionScenarios() {
        List extensions = this.getEndingExtensionScenarios_Internal();
        Collections.sort(extensions, new ScenarioComparator(7));
        return ScenarioDocGenProxy.transformScenarioList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IScenario> getEndingExtensionScenarios(String sortingProperty) {
        List extensions = this.getEndingExtensionScenarios_Internal();
        List<IScenario> transformedExtensions = ScenarioDocGenProxy.transformScenarioList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedExtensions, (String)sortingProperty);
        return transformedExtensions;
    }

    private List getEndingExtensionScenarios_Internal() {
        return new ArrayList(this.dataFacade.getEndingExtendingScenarios(this.actionStep, this.locale));
    }

    @Override
    public boolean isEndOfExtensionUseCases() {
        boolean result = false;
        Collection extensions = this.dataFacade.getEndingExtendingUseCases(this.actionStep, this.filters, this.locale);
        result = extensions.size() > 0;
        return result;
    }

    public List<IUseCase> getEndingExtensionUseCases() {
        List extensions = this.getEndingExtensionUseCases_Internal();
        Collections.sort(extensions, new UseCaseComparator(1));
        return UseCaseDocGenProxy.transformUseCaseList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IUseCase> getEndingExtensionUseCases(int sortingCriterion) {
        List extensions = this.getEndingExtensionUseCases_Internal();
        Collections.sort(extensions, new UseCaseComparator(sortingCriterion));
        return UseCaseDocGenProxy.transformUseCaseList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
    }

    public List<IUseCase> getEndingExtensionUseCases(String sortingProperty) {
        List extensions = this.getEndingExtensionUseCases_Internal();
        List<IUseCase> transformedExtensions = UseCaseDocGenProxy.transformUseCaseList(extensions, this.getGraphicsAndFilesHelper(), this.dataFacade, this.filters, this.locale, this.currentPage);
        AbstractAttributeOwnerDocGenProxy.sortList(transformedExtensions, (String)sortingProperty);
        return transformedExtensions;
    }

    private List getEndingExtensionUseCases_Internal() {
        return new ArrayList(this.dataFacade.getEndingExtendingUseCases(this.actionStep, this.filters, this.locale));
    }

    @Override
    public boolean isLinkedWithUniqueElements() {
        return this.dataFacade.isLinkedWithUniqueElements(this.actionStep);
    }

    public List<IModelElement> getLinkedUniqueElements() {
        ArrayList ues = new ArrayList(this.dataFacade.getLinkedUniqueElements(this.actionStep));
        Collections.sort(ues, new UniqueElementComparator());
        ArrayList<IModelElement> ueProxies = new ArrayList<IModelElement>(ues.size());
        for (IUniqueElement ue : ues) {
            UniqueElementDocGenProxy ueProxy = new UniqueElementDocGenProxy(ue, (IDocGeneratorProjectAgent)new DocGeneratorProjectAgent((IFrameProjectAgent)this.dataFacade.getModelController().getProjectAgent()), (Collection)Collections.EMPTY_LIST, this.getGraphicsAndFilesHelper(), this.locale, this.currentPage);
            ueProxies.add((IModelElement)ueProxy);
        }
        return ueProxies;
    }

    public AbstractImExModuleData getWrappedExportableItem() {
        return this.actionStep;
    }

    public String getCommitVersion() {
        int commitCount = this.actionStep.getCommitCount();
        return HistoryEntry.getVersionForCommitCount((int)commitCount);
    }

    static List<IActionStep> transformActionStepList(List actionSteps, IGraphicsAndFilesHelper graphicsProvider, DataFacade dataFacade, Collection filters, Locale locale, IWorkbenchPage currentPage) {
        ArrayList<IActionStep> result = new ArrayList<IActionStep>(actionSteps.size());
        for (ImExActionStep actionStep : actionSteps) {
            ActionStepDocGenProxy actionStepDesc = new ActionStepDocGenProxy(actionStep, graphicsProvider, dataFacade, filters, locale, currentPage);
            result.add(actionStepDesc);
        }
        return result;
    }

    public IRecord toRecord(Set<String> keyWhiteList) {
        IRecord record = super.toRecord(keyWhiteList);
        if (keyWhiteList == null || keyWhiteList.contains("id")) {
            record.set("id", (Object)this.getId());
        }
        if (keyWhiteList == null || keyWhiteList.contains("title")) {
            record.set("title", (Object)this.getTitle());
        }
        if (keyWhiteList == null || keyWhiteList.contains("description")) {
            record.set("description", this.getDescription());
        }
        return record;
    }
}

