/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.usecasemodule.docgen.gui;

import com.arcway.cockpit.cockpitlib.client.filter.AbstractFilter;
import com.arcway.cockpit.cockpitlib.client.filter.gui.IFilterItem;
import com.arcway.cockpit.frame.client.project.IFrameProjectAgent;
import com.arcway.cockpit.frame.client.project.docgenerator.configuration.DocGenConfigurationPerReport;
import com.arcway.cockpit.frame.client.project.docgenerator.gui.AbstractFilterItemProvider;
import com.arcway.cockpit.frame.client.project.modules.IModuleDataFacade;
import com.arcway.cockpit.usecasemodule.client.core.project.datafacade.DataFacade;
import com.arcway.cockpit.usecasemodule.client.gui.UseCaseFilters;
import com.arcway.cockpit.usecasemodule.client.messages.UseCase;
import com.arcway.cockpit.usecasemodule.docgen.Messages;
import com.arcway.cockpit.usecasemodule.docgen.ModuleDocumentationConfiguration;
import com.arcway.cockpit.usecasemodule.shared.ModuleIdentification;
import java.util.ArrayList;
import java.util.List;

public class UseCaseFilterItemProvider
extends AbstractFilterItemProvider {
    private AbstractFilter categoryFilter;
    private AbstractFilter authorFilter;
    private AbstractFilter initiatorFilter;
    private AbstractFilter priorityFilter;
    private AbstractFilter statusFilter;
    private AbstractFilter levelFilter;
    private AbstractFilter dateOfCreationFilter;
    private AbstractFilter dateOfModificationFilter;
    private AbstractFilter scopeFilter;
    private AbstractFilter descriptionFilter;
    private AbstractFilter actorFilter;
    private AbstractFilter extendsAnotherUCFilter;
    private AbstractFilter onlyLinkedStepsFilter;
    private AbstractFilter useCaseObjectTypeCategoryFilter;
    private IFilterItem categoryFilterItem;
    private IFilterItem authorFilterItem;
    private IFilterItem initiatorFilterItem;
    private IFilterItem priorityFilterItem;
    private IFilterItem statusFilterItem;
    private IFilterItem levelFilterItem;
    private IFilterItem dateOfCreationFilterItem;
    private IFilterItem dateOfModificationFilterItem;
    private IFilterItem scopeFilterItem;
    private IFilterItem descriptionFilterItem;
    private IFilterItem actorFilterItem;
    private IFilterItem extendsAnotherUCFilterItem;
    private IFilterItem onlyLinkedStepsFilterItem;
    private IFilterItem useCaseObjectTypeCategoryFilterItem;

    public UseCaseFilterItemProvider() {
        super(ModuleIdentification.getModuleID(), Messages.getString("UseCaseFilterItemProvider"));
    }

    public void initialize(IModuleDataFacade moduleDataFacade, IFrameProjectAgent projectAgent) {
        if (moduleDataFacade instanceof DataFacade) {
            DataFacade dataFacade = (DataFacade)moduleDataFacade;
            UseCaseFilters filterFactory = dataFacade.getFilterFactory();
            this.categoryFilterItem = filterFactory.createCategoryNameFilterItem();
            this.authorFilterItem = filterFactory.createUseCaseAuthorFilterItem();
            this.initiatorFilterItem = filterFactory.createUseCaseInitiatorFilterItem();
            this.priorityFilterItem = filterFactory.createUseCasePriorityFilterItem();
            this.statusFilterItem = filterFactory.createUseCaseStateFilterItem();
            this.levelFilterItem = filterFactory.createUseCaseLevelFilterItem();
            this.scopeFilterItem = filterFactory.createUseCaseScopeFilterItem();
            this.descriptionFilterItem = filterFactory.createUseCaseDescriptionFilterItem();
            this.actorFilterItem = filterFactory.createUseCaseActorFilterItem();
            this.extendsAnotherUCFilterItem = filterFactory.createUseCaseIsExtendedFilterItem();
            this.onlyLinkedStepsFilterItem = filterFactory.createUseCaseHasOnlyLinkedActionStepsFilterItem();
            this.dateOfModificationFilterItem = filterFactory.createUseCaseModificationDateFilterItem();
            this.dateOfCreationFilterItem = filterFactory.createUseCaseCreationDateFilterItem();
            this.useCaseObjectTypeCategoryFilterItem = filterFactory.getObjectTypeCategoryFilter(UseCase.DATA_TYPE_DESCRIPTION);
            this.categoryFilter = this.categoryFilterItem.getFilter();
            this.authorFilter = this.authorFilterItem.getFilter();
            this.initiatorFilter = this.initiatorFilterItem.getFilter();
            this.priorityFilter = this.priorityFilterItem.getFilter();
            this.statusFilter = this.statusFilterItem.getFilter();
            this.levelFilter = this.levelFilterItem.getFilter();
            this.dateOfModificationFilter = this.dateOfModificationFilterItem.getFilter();
            this.dateOfCreationFilter = this.dateOfCreationFilterItem.getFilter();
            this.scopeFilter = this.scopeFilterItem.getFilter();
            this.descriptionFilter = this.descriptionFilterItem.getFilter();
            this.actorFilter = this.actorFilterItem.getFilter();
            this.extendsAnotherUCFilter = this.extendsAnotherUCFilterItem.getFilter();
            this.onlyLinkedStepsFilter = this.onlyLinkedStepsFilterItem.getFilter();
            if (this.useCaseObjectTypeCategoryFilterItem != null) {
                this.useCaseObjectTypeCategoryFilter = this.useCaseObjectTypeCategoryFilterItem.getFilter();
            }
        }
    }

    public boolean isOptionalProvider() {
        return true;
    }

    public List<IFilterItem> getItems() {
        ArrayList<IFilterItem> items = new ArrayList<IFilterItem>();
        items.add(this.categoryFilterItem);
        items.add(this.descriptionFilterItem);
        items.add(this.scopeFilterItem);
        items.add(this.actorFilterItem);
        items.add(this.levelFilterItem);
        items.add(this.statusFilterItem);
        items.add(this.priorityFilterItem);
        items.add(this.extendsAnotherUCFilterItem);
        items.add(this.onlyLinkedStepsFilterItem);
        items.add(this.initiatorFilterItem);
        items.add(this.authorFilterItem);
        items.add(this.dateOfModificationFilterItem);
        items.add(this.dateOfCreationFilterItem);
        if (this.useCaseObjectTypeCategoryFilterItem != null) {
            items.add(this.useCaseObjectTypeCategoryFilterItem);
        }
        return items;
    }

    public List<AbstractFilter> getFilters() {
        ArrayList<AbstractFilter> filterList = new ArrayList<AbstractFilter>();
        filterList.add(this.categoryFilter);
        filterList.add(this.descriptionFilter);
        filterList.add(this.scopeFilter);
        filterList.add(this.actorFilter);
        filterList.add(this.levelFilter);
        filterList.add(this.statusFilter);
        filterList.add(this.priorityFilter);
        filterList.add(this.extendsAnotherUCFilter);
        filterList.add(this.onlyLinkedStepsFilter);
        filterList.add(this.initiatorFilter);
        filterList.add(this.authorFilter);
        filterList.add(this.dateOfModificationFilter);
        filterList.add(this.dateOfCreationFilter);
        if (this.useCaseObjectTypeCategoryFilter != null) {
            filterList.add(this.useCaseObjectTypeCategoryFilter);
        }
        return filterList;
    }

    public void update(DocGenConfigurationPerReport configuration) {
        ModuleDocumentationConfiguration moduleConfig = new ModuleDocumentationConfiguration(configuration);
        this.authorFilter.setActive(moduleConfig.isFilterActive("ucmDocGen._FILTER_AUTHOR"));
        this.authorFilter.setFilterValue(moduleConfig.getFilterSettings("ucmDocGen._FILTER_AUTHOR"));
        this.authorFilterItem.filterChanged();
        this.initiatorFilter.setActive(moduleConfig.isFilterActive("ucmDocGen._FILTER_INITIATOR"));
        this.initiatorFilter.setFilterValue(moduleConfig.getFilterSettings("ucmDocGen._FILTER_INITIATOR"));
        this.initiatorFilterItem.filterChanged();
        this.priorityFilter.setActive(moduleConfig.isFilterActive("ucmDocGen._FILTER_PRIORITY"));
        this.priorityFilter.setFilterValue(moduleConfig.getFilterSettings("ucmDocGen._FILTER_PRIORITY"));
        this.priorityFilterItem.filterChanged();
        this.statusFilter.setActive(moduleConfig.isFilterActive("ucmDocGen._FILTER_STATUS"));
        this.statusFilter.setFilterValue(moduleConfig.getFilterSettings("ucmDocGen._FILTER_STATUS"));
        this.statusFilterItem.filterChanged();
        this.categoryFilter.setActive(moduleConfig.isFilterActive("ucmDocGen._FILTER_CATEGORY"));
        this.categoryFilter.setFilterValue(moduleConfig.getFilterSettings("ucmDocGen._FILTER_CATEGORY"));
        this.categoryFilterItem.filterChanged();
        this.dateOfCreationFilter.setActive(moduleConfig.isFilterActive("ucmDocGen._FILTER_DATE_OF_CREATION"));
        this.dateOfCreationFilter.setFilterValue(moduleConfig.getFilterSettings("ucmDocGen._FILTER_DATE_OF_CREATION"));
        this.dateOfCreationFilterItem.filterChanged();
        this.dateOfModificationFilter.setActive(moduleConfig.isFilterActive("ucmDocGen._FILTER_DATE_OF_MODIFICATION"));
        this.dateOfModificationFilter.setFilterValue(moduleConfig.getFilterSettings("ucmDocGen._FILTER_DATE_OF_MODIFICATION"));
        this.dateOfModificationFilterItem.filterChanged();
        this.levelFilter.setActive(moduleConfig.isFilterActive("ucmDocGen._FILTER_LEVEL"));
        this.levelFilter.setFilterValue(moduleConfig.getFilterSettings("ucmDocGen._FILTER_LEVEL"));
        this.levelFilterItem.filterChanged();
        this.scopeFilter.setActive(moduleConfig.isFilterActive("ucmDocGen._FILTER_SCOPE"));
        this.scopeFilter.setFilterValue(moduleConfig.getFilterSettings("ucmDocGen._FILTER_SCOPE"));
        this.scopeFilterItem.filterChanged();
        this.descriptionFilter.setActive(moduleConfig.isFilterActive("ucmDocGen._FILTER_DESCRIPTION"));
        this.descriptionFilter.setFilterValue(moduleConfig.getFilterSettings("ucmDocGen._FILTER_DESCRIPTION"));
        this.descriptionFilterItem.filterChanged();
        this.actorFilter.setActive(moduleConfig.isFilterActive("ucmDocGen._FILTER_ACTORS_AND_GOALS"));
        this.actorFilter.setFilterValue(moduleConfig.getFilterSettings("ucmDocGen._FILTER_ACTORS_AND_GOALS"));
        this.extendsAnotherUCFilter.setActive(moduleConfig.isFilterActive("ucmDocGen._FILTER_EXTENDS_ANOTHER_UC"));
        this.extendsAnotherUCFilter.setFilterValue(moduleConfig.getFilterSettings("ucmDocGen._FILTER_EXTENDS_ANOTHER_UC"));
        this.extendsAnotherUCFilterItem.filterChanged();
        this.onlyLinkedStepsFilter.setActive(moduleConfig.isFilterActive("ucmDocGen._FILTER_ONLY_LINKED_STEPS"));
        this.onlyLinkedStepsFilter.setFilterValue(moduleConfig.getFilterSettings("ucmDocGen._FILTER_ONLY_LINKED_STEPS"));
        this.onlyLinkedStepsFilterItem.filterChanged();
        if (this.useCaseObjectTypeCategoryFilter != null && this.useCaseObjectTypeCategoryFilterItem != null) {
            this.useCaseObjectTypeCategoryFilter.setActive(moduleConfig.isFilterActive("ucmDocGen._FILTER_USECASE_OBJECT_TYPE_CATEGORIES"));
            this.useCaseObjectTypeCategoryFilter.setFilterValue(moduleConfig.getFilterSettings("ucmDocGen._FILTER_USECASE_OBJECT_TYPE_CATEGORIES"));
            this.useCaseObjectTypeCategoryFilterItem.filterChanged();
        }
    }

    public void writeToConfiguration(DocGenConfigurationPerReport configuration) {
        ModuleDocumentationConfiguration moduleConfig = new ModuleDocumentationConfiguration(configuration);
        moduleConfig.addFilterSettings("ucmDocGen._FILTER_AUTHOR", this.authorFilter.isActive(), this.authorFilter.getFilterValue());
        moduleConfig.addFilterSettings("ucmDocGen._FILTER_INITIATOR", this.initiatorFilter.isActive(), this.initiatorFilter.getFilterValue());
        moduleConfig.addFilterSettings("ucmDocGen._FILTER_PRIORITY", this.priorityFilter.isActive(), this.priorityFilter.getFilterValue());
        moduleConfig.addFilterSettings("ucmDocGen._FILTER_STATUS", this.statusFilter.isActive(), this.statusFilter.getFilterValue());
        moduleConfig.addFilterSettings("ucmDocGen._FILTER_CATEGORY", this.categoryFilter.isActive(), this.categoryFilter.getFilterValue());
        moduleConfig.addFilterSettings("ucmDocGen._FILTER_LEVEL", this.levelFilter.isActive(), this.levelFilter.getFilterValue());
        moduleConfig.addFilterSettings("ucmDocGen._FILTER_DATE_OF_CREATION", this.dateOfCreationFilter.isActive(), this.dateOfCreationFilter.getFilterValue());
        moduleConfig.addFilterSettings("ucmDocGen._FILTER_DATE_OF_MODIFICATION", this.dateOfModificationFilter.isActive(), this.dateOfModificationFilter.getFilterValue());
        moduleConfig.addFilterSettings("ucmDocGen._FILTER_SCOPE", this.scopeFilter.isActive(), this.scopeFilter.getFilterValue());
        moduleConfig.addFilterSettings("ucmDocGen._FILTER_DESCRIPTION", this.descriptionFilter.isActive(), this.descriptionFilter.getFilterValue());
        moduleConfig.addFilterSettings("ucmDocGen._FILTER_ACTORS_AND_GOALS", this.actorFilter.isActive(), this.actorFilter.getFilterValue());
        moduleConfig.addFilterSettings("ucmDocGen._FILTER_EXTENDS_ANOTHER_UC", this.extendsAnotherUCFilter.isActive(), this.extendsAnotherUCFilter.getFilterValue());
        moduleConfig.addFilterSettings("ucmDocGen._FILTER_ONLY_LINKED_STEPS", this.onlyLinkedStepsFilter.isActive(), this.onlyLinkedStepsFilter.getFilterValue());
        if (this.useCaseObjectTypeCategoryFilter != null) {
            moduleConfig.addFilterSettings("ucmDocGen._FILTER_USECASE_OBJECT_TYPE_CATEGORIES", this.useCaseObjectTypeCategoryFilter.isActive(), this.useCaseObjectTypeCategoryFilter.getFilterValue());
        }
    }

    public boolean hasActiveFilters() {
        for (AbstractFilter singleFilter : this.getFilters()) {
            if (!singleFilter.isActive()) continue;
            return true;
        }
        return false;
    }
}

