/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.p2.ui;

import com.arcway.cockpit.frame.client.global.Icons;
import com.arcway.cockpit.p2.ui.Messages;
import com.arcway.lib.eclipse.gui.dialogs.MessageDialogWithHyperlink;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import java.io.File;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class UpdateUtil {
    private static final ILogger LOGGER = Logger.getLogger(UpdateUtil.class);

    private UpdateUtil() {
    }

    public static boolean isUnrestrictedInstallationChangePossible() {
        File installFolder = UpdateUtil.getInstallFolder();
        if (installFolder != null) {
            return FileHelper.isDirectoryWritableAndNotVirtual((File)UpdateUtil.getInstallFolder());
        }
        return false;
    }

    private static File getInstallFolder() {
        try {
            IProvisioningAgent provisioningAgent = ProvisioningUI.getDefaultUI().getSession().getProvisioningAgent();
            IProfileRegistry profileRegistry = (IProfileRegistry)provisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
            String profileId = ProvisioningUI.getDefaultUI().getProfileId();
            IProfile profile = profileRegistry.getProfile(profileId);
            String installFolderName = (String)profile.getProperties().get("org.eclipse.equinox.p2.installFolder");
            return new File(installFolderName);
        }
        catch (Throwable e) {
            LOGGER.debug("Unable to detect InstallFolder.", e);
            return null;
        }
    }

    public static boolean showUpdateRestrictionsDialogWithForkOption(Shell parentShell) {
        boolean isDirectoryInWindowsVistaOr7VirtualStore = false;
        try {
            File installFolder = UpdateUtil.getInstallFolder();
            if (installFolder != null) {
                isDirectoryInWindowsVistaOr7VirtualStore = FileHelper.isDirectoryInWindowsVistaOr7VirtualStore((File)installFolder);
            }
        }
        catch (Throwable e1) {
            LOGGER.error("unhandled catch block", e1);
        }
        if (!isDirectoryInWindowsVistaOr7VirtualStore) {
            MessageDialog.openInformation((Shell)parentShell, (String)Messages.getString("UnrestrictedUpdatesImpossibleDialog_title"), (String)Messages.getString("UnrestrictedUpdatesImpossibleDialog_message"));
            return false;
        }
        final boolean[] success = new boolean[]{true};
        final boolean[] forceInstallationFork = new boolean[1];
        final MessageDialog createInstallationForkDialog = new MessageDialog(parentShell, Messages.getString("CreateInstallationForkDialog_title"), Icons.getArcWayLogo(), Messages.getString("CreateInstallationForkDialog_message"), 4, new String[]{IDialogConstants.PROCEED_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
        IHyperlinkListener hyperlinkListener = new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
                Hyperlink hyperlink = (Hyperlink)e.getSource();
                hyperlink.setForeground(hyperlink.getDisplay().getSystemColor(1));
            }

            public void linkExited(HyperlinkEvent e) {
                Hyperlink hyperlink = (Hyperlink)e.getSource();
                hyperlink.setForeground(hyperlink.getDisplay().getSystemColor(9));
            }

            public void linkActivated(HyperlinkEvent e) {
                Hyperlink hyperlink = (Hyperlink)e.getSource();
                hyperlink.getShell().close();
                if (createInstallationForkDialog.open() == 1) {
                    success[0] = false;
                } else {
                    forceInstallationFork[0] = true;
                }
            }
        };
        MessageDialogWithHyperlink unrestrictedUpdatesImpossibleDialog = new MessageDialogWithHyperlink(parentShell, Messages.getString("UnrestrictedUpdatesImpossibleDialog_title"), Icons.getArcWayLogo(), Messages.getString("UnrestrictedUpdatesImpossibleDialog_message"), 2, new String[]{IDialogConstants.OK_LABEL}, 1, hyperlinkListener, Messages.getString("UnrestrictedUpdatesImpossibleDialog_hyperlinkLabel"), Messages.getString("UnrestrictedUpdatesImpossibleDialog_hyperlinkText"));
        unrestrictedUpdatesImpossibleDialog.open();
        return forceInstallationFork[0];
    }

    public static boolean showInstallRestrictionsDialogWithForkOption(Shell parentShell) {
        boolean isDirectoryInWindowsVistaOr7VirtualStore = false;
        try {
            File installFolder = UpdateUtil.getInstallFolder();
            if (installFolder != null) {
                isDirectoryInWindowsVistaOr7VirtualStore = FileHelper.isDirectoryInWindowsVistaOr7VirtualStore((File)installFolder);
            }
        }
        catch (Throwable e1) {
            LOGGER.error("unhandled catch block", e1);
        }
        if (!isDirectoryInWindowsVistaOr7VirtualStore) {
            MessageDialog.openInformation((Shell)parentShell, (String)Messages.getString("UnrestrictedInstallImpossibleDialog_title"), (String)Messages.getString("UnrestrictedInstallImpossibleDialog_message"));
            return false;
        }
        final boolean[] success = new boolean[]{true};
        final boolean[] forceInstallationFork = new boolean[1];
        final MessageDialog createInstallationForkDialog = new MessageDialog(parentShell, Messages.getString("CreateInstallationForkDialog_title"), Icons.getArcWayLogo(), Messages.getString("CreateInstallationForkDialog_message"), 4, new String[]{IDialogConstants.PROCEED_LABEL, IDialogConstants.CANCEL_LABEL}, 1);
        IHyperlinkListener hyperlinkListener = new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
                Hyperlink hyperlink = (Hyperlink)e.getSource();
                hyperlink.setForeground(hyperlink.getDisplay().getSystemColor(1));
            }

            public void linkExited(HyperlinkEvent e) {
                Hyperlink hyperlink = (Hyperlink)e.getSource();
                hyperlink.setForeground(hyperlink.getDisplay().getSystemColor(9));
            }

            public void linkActivated(HyperlinkEvent e) {
                Hyperlink hyperlink = (Hyperlink)e.getSource();
                hyperlink.getShell().close();
                if (createInstallationForkDialog.open() == 1) {
                    success[0] = false;
                } else {
                    forceInstallationFork[0] = true;
                }
            }
        };
        MessageDialogWithHyperlink unrestrictedUpdatesImpossibleDialog = new MessageDialogWithHyperlink(parentShell, Messages.getString("UnrestrictedInstallImpossibleDialog_title"), Icons.getArcWayLogo(), Messages.getString("UnrestrictedInstallImpossibleDialog_message"), 2, new String[]{IDialogConstants.OK_LABEL}, 1, hyperlinkListener, Messages.getString("UnrestrictedInstallImpossibleDialog_hyperlinkLabel"), Messages.getString("UnrestrictedInstallImpossibleDialog_hyperlinkText"));
        unrestrictedUpdatesImpossibleDialog.open();
        return forceInstallationFork[0];
    }

    public static void showInstallationModificationRestrictionsInfoDialog(Shell parent) {
        MessageDialog.openInformation((Shell)parent, (String)Messages.getString("InstallationModificationRestrictionsInfoDialog_title"), (String)Messages.getString("InstallationModificationRestrictionsInfoDialog_message"));
    }
}

