/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.p2.ui;

import com.arcway.cockpit.p2.ui.UpdateUtil;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.psc.eclipse.client.update.IClientUpdateProvisioningAgent;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ClientUpdateProvisioningAgent
implements IClientUpdateProvisioningAgent {
    private static final ILogger LOGGER = Logger.getLogger(ClientUpdateProvisioningAgent.class);

    private UpdateCheckResult continueWorkingWithUpdateOperation(ProfileChangeOperation operation) {
        assert (operation.getResolutionResult() != null);
        IStatus status = operation.getResolutionResult();
        if (status.getSeverity() == 8) {
            return UpdateCheckResult.CancelledByUser;
        }
        if (status.getCode() == 10000) {
            return UpdateCheckResult.NoUpdatesAvailable;
        }
        if (!status.isOK()) {
            return UpdateCheckResult.ProblemOccured;
        }
        IProvisioningPlan provisioningPlan = operation.getProvisioningPlan();
        if (provisioningPlan == null) {
            return UpdateCheckResult.ProblemOccured;
        }
        if (provisioningPlan.getStatus().getCode() == 0) {
            return UpdateCheckResult.ValidUpdatesAvailable;
        }
        return UpdateCheckResult.ProblemOccured;
    }

    public void installUpdatesAndNewFeatures(URI repositoryURI) {
        boolean checkForNewFeaturesToBeInstalled;
        Shell defaultParentShell = ProvUI.getDefaultParentShell();
        try {
            IProvisioningAgent provisioningAgent = ProvisioningUI.getDefaultUI().getSession().getProvisioningAgent();
            IProfileRegistry profileRegistry = (IProfileRegistry)provisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
            String profileId = ProvisioningUI.getDefaultUI().getProfileId();
            profileRegistry.getProfile(profileId);
        }
        catch (Throwable e) {
            LOGGER.debug("Unable to get p2 profile - aborting update/install now.", e);
            UpdateUtil.showInstallationModificationRestrictionsInfoDialog(defaultParentShell);
            return;
        }
        UpdateOperation updateOperation = this.getProvisioningUI().getUpdateOperation(null, new URI[]{repositoryURI});
        updateOperation.resolveModal(null);
        UpdateCheckResult updateCheckResult = this.continueWorkingWithUpdateOperation((ProfileChangeOperation)updateOperation);
        switch (updateCheckResult) {
            case CancelledByUser: {
                checkForNewFeaturesToBeInstalled = false;
                break;
            }
            case NoUpdatesAvailable: {
                checkForNewFeaturesToBeInstalled = true;
                break;
            }
            case ProblemOccured: {
                checkForNewFeaturesToBeInstalled = false;
                this.displayUpdateOrInstallProblemMessage();
                break;
            }
            case ValidUpdatesAvailable: {
                boolean openUpdateWizard = UpdateUtil.isUnrestrictedInstallationChangePossible() ? true : UpdateUtil.showUpdateRestrictionsDialogWithForkOption(defaultParentShell);
                if (openUpdateWizard) {
                    this.getProvisioningUI().openUpdateWizard(true, updateOperation, null);
                }
                checkForNewFeaturesToBeInstalled = false;
                break;
            }
            default: {
                checkForNewFeaturesToBeInstalled = false;
                assert (false);
                break;
            }
        }
        if (checkForNewFeaturesToBeInstalled) {
            try {
                IQueryResult queryResult;
                IQuery anyGroupQuery = QueryUtil.createIUGroupQuery();
                Set allAvailableFeatures = Collections.emptySet();
                IMetadataRepository repository = this.getProvisioningUI().loadMetadataRepository(repositoryURI, false, (IProgressMonitor)new NullProgressMonitor());
                if (repository != null && (queryResult = repository.query(anyGroupQuery, (IProgressMonitor)new NullProgressMonitor())) != null) {
                    allAvailableFeatures = queryResult.toUnmodifiableSet();
                }
                IProvisioningAgent provisioningAgent = ProvisioningUI.getDefaultUI().getSession().getProvisioningAgent();
                IProfileRegistry profileRegistry = (IProfileRegistry)provisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
                String profileId = ProvisioningUI.getDefaultUI().getProfileId();
                IProfile profile = profileRegistry.getProfile(profileId);
                Set profileFeatures = profile.available(anyGroupQuery, (IProgressMonitor)new NullProgressMonitor()).toUnmodifiableSet();
                HashSet featuresNotInProfile = new HashSet(allAvailableFeatures);
                featuresNotInProfile.removeAll(profileFeatures);
                if (featuresNotInProfile.size() > 0) {
                    boolean forceUpdate;
                    if (!UpdateUtil.isUnrestrictedInstallationChangePossible() && !(forceUpdate = UpdateUtil.showInstallRestrictionsDialogWithForkOption(defaultParentShell))) {
                        return;
                    }
                    InstallOperation installOperation = this.getProvisioningUI().getInstallOperation(featuresNotInProfile, new URI[]{repositoryURI});
                    IStatus result = installOperation.resolveModal((IProgressMonitor)new NullProgressMonitor());
                    if (result.isOK()) {
                        this.getProvisioningUI().openInstallWizard(featuresNotInProfile, installOperation, null);
                    } else {
                        this.displayUpdateOrInstallProblemMessage();
                    }
                } else {
                    this.displayUpdateOrInstallProblemMessage();
                }
            }
            catch (ProvisionException e) {
                LOGGER.error("unhandled catch block", (Throwable)e);
                UpdateUtil.showInstallationModificationRestrictionsInfoDialog(defaultParentShell);
            }
        }
    }

    private void displayUpdateOrInstallProblemMessage() {
        MessageDialog.openInformation((Shell)ProvUI.getDefaultParentShell(), (String)"Keine passenden Updates hinterlegt.", (String)"Auf dem ausgew\u00e4hlten Cockpit Server sind entweder keine Updates hinterlegt oder die hinterlegten Updates sind veraltet, unvollst\u00e4ndig oder unbrauchbar.");
    }

    protected ProvisioningUI getProvisioningUI() {
        return ProvisioningUI.getDefaultUI();
    }

    private static enum UpdateCheckResult {
        CancelledByUser,
        ProblemOccured,
        ValidUpdatesAvailable,
        NoUpdatesAvailable;

    }
}

