/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.ole.hpqc.impl;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AbstractOleEventsListener;
import com.arcway.ole.hpqc._DIProgressEvents;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.Variant;

public class _DIProgressEventsListener
extends AbstractOleEventsListener {
    private Set<_DIProgressEvents> listeners = new HashSet<_DIProgressEvents>();

    public _DIProgressEventsListener(ResourceManager resourceManager) {
        super(resourceManager);
    }

    public boolean addListener(_DIProgressEvents listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(_DIProgressEvents listener) {
        return this.listeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void handleEvent(OleEvent oleEvent) {
        switch (oleEvent.type) {
            case 1: {
                this.fireOnProgress(oleEvent);
                break;
            }
            case 2: {
                this.fireOnDataAvailable(oleEvent);
                break;
            }
            case 3: {
                this.fireOnServerProgress(oleEvent);
                break;
            }
            case 4: {
                this.fireOnMessage(oleEvent);
            }
        }
        Variant[] arguments = oleEvent.arguments;
        int i = 0;
        while (i < arguments.length) {
            arguments[i].dispose();
            ++i;
        }
    }

    private void fireOnProgress(OleEvent oleEvent) {
        int current = oleEvent.arguments[0].getInt();
        int total = oleEvent.arguments[1].getInt();
        String message = oleEvent.arguments[2].getString();
        for (_DIProgressEvents l : this.listeners) {
            l.OnProgress(current, total, message);
        }
    }

    private void fireOnDataAvailable(OleEvent oleEvent) {
        int errorCode = oleEvent.arguments[0].getInt();
        for (_DIProgressEvents l : this.listeners) {
            l.OnDataAvailable(errorCode);
        }
    }

    private void fireOnServerProgress(OleEvent oleEvent) {
        int time = oleEvent.arguments[0].getInt();
        String message = oleEvent.arguments[1].getString();
        for (_DIProgressEvents l : this.listeners) {
            l.OnServerProgress(time, message);
        }
    }

    private void fireOnMessage(OleEvent oleEvent) {
        String message = oleEvent.arguments[0].getString();
        for (_DIProgressEvents l : this.listeners) {
            l.OnMessage(message);
        }
    }
}

