/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.ole.hpqc.impl;

import au.com.swz.swttocom.swt.ResourceManager;
import au.com.swz.swttocom.swt.types.AbstractOleEventsListener;
import au.com.swz.swttocom.swt.types.pointer.VariantPointer;
import com.arcway.ole.hpqc._DIOtaEvents;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.swt.ole.win32.OleEvent;
import org.eclipse.swt.ole.win32.Variant;

public class _DIOtaEventsListener
extends AbstractOleEventsListener {
    private Set<_DIOtaEvents> listeners = new HashSet<_DIOtaEvents>();

    public _DIOtaEventsListener(ResourceManager resourceManager) {
        super(resourceManager);
    }

    public boolean addListener(_DIOtaEvents listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(_DIOtaEvents listener) {
        return this.listeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void handleEvent(OleEvent oleEvent) {
        switch (oleEvent.type) {
            case 1: {
                this.fireOnConnectingServer(oleEvent);
                break;
            }
            case 2: {
                this.fireOnConnectServer(oleEvent);
                break;
            }
            case 3: {
                this.fireOnConnectingProject(oleEvent);
                break;
            }
            case 4: {
                this.fireOnConnectProject(oleEvent);
                break;
            }
            case 5: {
                this.fireOnDisconnectingServer(oleEvent);
                break;
            }
            case 6: {
                this.fireOnDisconnectServer(oleEvent);
                break;
            }
            case 7: {
                this.fireOnDisconnectingProject(oleEvent);
                break;
            }
            case 8: {
                this.fireOnDisconnectProject(oleEvent);
                break;
            }
            case 9: {
                this.fireOnAddingItem(oleEvent);
                break;
            }
            case 10: {
                this.fireOnAddItem(oleEvent);
                break;
            }
            case 11: {
                this.fireOnDeletingItem(oleEvent);
                break;
            }
            case 12: {
                this.fireOnDeleteItem(oleEvent);
                break;
            }
            case 13: {
                this.fireOnSettingItemValue(oleEvent);
                break;
            }
            case 14: {
                this.fireOnSetItemValue(oleEvent);
                break;
            }
            case 15: {
                this.fireOnGettingItemValue(oleEvent);
                break;
            }
            case 16: {
                this.fireOnGetItemValue(oleEvent);
                break;
            }
            case 17: {
                this.fireOnUpdatingItem(oleEvent);
                break;
            }
            case 18: {
                this.fireOnUpdateItem(oleEvent);
                break;
            }
            case 19: {
                this.fireOnFetchingNewList(oleEvent);
                break;
            }
            case 20: {
                this.fireOnFetchNewList(oleEvent);
                break;
            }
            case 21: {
                this.fireOnServerErrRecieved(oleEvent);
            }
        }
        Variant[] arguments = oleEvent.arguments;
        int i = 0;
        while (i < arguments.length) {
            arguments[i].dispose();
            ++i;
        }
    }

    private void fireOnConnectingServer(OleEvent oleEvent) {
        String domain = oleEvent.arguments[0].getString();
        String server = oleEvent.arguments[1].getString();
        for (_DIOtaEvents l : this.listeners) {
            l.OnConnectingServer(domain, server);
        }
    }

    private void fireOnConnectServer(OleEvent oleEvent) {
        for (_DIOtaEvents l : this.listeners) {
            l.OnConnectServer();
        }
    }

    private void fireOnConnectingProject(OleEvent oleEvent) {
        String project = oleEvent.arguments[0].getString();
        String user = oleEvent.arguments[1].getString();
        String password = oleEvent.arguments[2].getString();
        for (_DIOtaEvents l : this.listeners) {
            l.OnConnectingProject(project, user, password);
        }
    }

    private void fireOnConnectProject(OleEvent oleEvent) {
        for (_DIOtaEvents l : this.listeners) {
            l.OnConnectProject();
        }
    }

    private void fireOnDisconnectingServer(OleEvent oleEvent) {
        for (_DIOtaEvents l : this.listeners) {
            l.OnDisconnectingServer();
        }
    }

    private void fireOnDisconnectServer(OleEvent oleEvent) {
        for (_DIOtaEvents l : this.listeners) {
            l.OnDisconnectServer();
        }
    }

    private void fireOnDisconnectingProject(OleEvent oleEvent) {
        for (_DIOtaEvents l : this.listeners) {
            l.OnDisconnectingProject();
        }
    }

    private void fireOnDisconnectProject(OleEvent oleEvent) {
        for (_DIOtaEvents l : this.listeners) {
            l.OnDisconnectProject();
        }
    }

    private void fireOnAddingItem(OleEvent oleEvent) {
        String objType = oleEvent.arguments[0].getString();
        Variant object_ = oleEvent.arguments[1];
        for (_DIOtaEvents l : this.listeners) {
            l.OnAddingItem(objType, object_);
        }
    }

    private void fireOnAddItem(OleEvent oleEvent) {
        String objType = oleEvent.arguments[0].getString();
        Variant object_ = oleEvent.arguments[1];
        for (_DIOtaEvents l : this.listeners) {
            l.OnAddItem(objType, object_);
        }
    }

    private void fireOnDeletingItem(OleEvent oleEvent) {
        String objType = oleEvent.arguments[0].getString();
        Variant object_ = oleEvent.arguments[1];
        for (_DIOtaEvents l : this.listeners) {
            l.OnDeletingItem(objType, object_);
        }
    }

    private void fireOnDeleteItem(OleEvent oleEvent) {
        String objType = oleEvent.arguments[0].getString();
        for (_DIOtaEvents l : this.listeners) {
            l.OnDeleteItem(objType);
        }
    }

    private void fireOnSettingItemValue(OleEvent oleEvent) {
        String objType = oleEvent.arguments[0].getString();
        Variant object_ = oleEvent.arguments[1];
        String fieldName = oleEvent.arguments[2].getString();
        VariantPointer fieldValue = new VariantPointer(oleEvent.arguments[3].getByRef(), this.getResourceManager());
        for (_DIOtaEvents l : this.listeners) {
            l.OnSettingItemValue(objType, object_, fieldName, fieldValue);
        }
        fieldValue.setAddress(0);
    }

    private void fireOnSetItemValue(OleEvent oleEvent) {
        String objType = oleEvent.arguments[0].getString();
        Variant object_ = oleEvent.arguments[1];
        String fieldName = oleEvent.arguments[2].getString();
        Variant fieldValue = oleEvent.arguments[3];
        for (_DIOtaEvents l : this.listeners) {
            l.OnSetItemValue(objType, object_, fieldName, fieldValue);
        }
    }

    private void fireOnGettingItemValue(OleEvent oleEvent) {
        String objType = oleEvent.arguments[0].getString();
        Variant object_ = oleEvent.arguments[1];
        String fieldName = oleEvent.arguments[2].getString();
        for (_DIOtaEvents l : this.listeners) {
            l.OnGettingItemValue(objType, object_, fieldName);
        }
    }

    private void fireOnGetItemValue(OleEvent oleEvent) {
        String objType = oleEvent.arguments[0].getString();
        Variant object_ = oleEvent.arguments[1];
        String fieldName = oleEvent.arguments[2].getString();
        VariantPointer fieldValue = new VariantPointer(oleEvent.arguments[3].getByRef(), this.getResourceManager());
        for (_DIOtaEvents l : this.listeners) {
            l.OnGetItemValue(objType, object_, fieldName, fieldValue);
        }
        fieldValue.setAddress(0);
    }

    private void fireOnUpdatingItem(OleEvent oleEvent) {
        String objType = oleEvent.arguments[0].getString();
        Variant object_ = oleEvent.arguments[1];
        for (_DIOtaEvents l : this.listeners) {
            l.OnUpdatingItem(objType, object_);
        }
    }

    private void fireOnUpdateItem(OleEvent oleEvent) {
        String objType = oleEvent.arguments[0].getString();
        Variant object_ = oleEvent.arguments[1];
        for (_DIOtaEvents l : this.listeners) {
            l.OnUpdateItem(objType, object_);
        }
    }

    private void fireOnFetchingNewList(OleEvent oleEvent) {
        Variant filter = oleEvent.arguments[0];
        for (_DIOtaEvents l : this.listeners) {
            l.OnFetchingNewList(filter);
        }
    }

    private void fireOnFetchNewList(OleEvent oleEvent) {
        Variant list = oleEvent.arguments[0];
        for (_DIOtaEvents l : this.listeners) {
            l.OnFetchNewList(list);
        }
    }

    private void fireOnServerErrRecieved(OleEvent oleEvent) {
        int errorCode = oleEvent.arguments[0].getInt();
        for (_DIOtaEvents l : this.listeners) {
            l.OnServerErrRecieved(errorCode);
        }
    }
}

