/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.implementation.qc10_com;

import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.FieldAndDatatypeHelper;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.implementation.qc10_com.Attachment;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.implementation.qc10_com.HPQCDataConverter;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.implementation.qc10_com.QualityCenter;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.CheckOutException;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.CommitException;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IFieldOfRequirementType;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IParameterForSetField;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IProject;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IRequirement;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IRequirementType;
import com.arcway.ole.hpqc.AttachmentFactory;
import com.arcway.ole.hpqc.IAttachment;
import com.arcway.ole.hpqc.IBaseFactory;
import com.arcway.ole.hpqc.IExtendedStorage;
import com.arcway.ole.hpqc.IList;
import com.arcway.ole.hpqc.IReqFactory4;
import com.arcway.ole.hpqc.ITDFilter;
import com.arcway.ole.hpqc.Req;
import com.arcway.ole.hpqc.ReqType;
import com.arcway.ole.hpqc.VersionControl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.ole.win32.Variant;

public class Requirement
implements IRequirement {
    private final Req req;
    private final IProject project;
    private final IReqFactory4 reqFactory;
    private AttachmentFactory attachmentFactory;
    private final VersionControl versionControl;
    private IRequirementType requirementType;
    private boolean isClean;
    private boolean isNewlyCreated;
    private boolean isUnderModification;
    private Long id = null;

    public Requirement(Req req, IProject project, IReqFactory4 reqFactory, boolean isNewlyCreated) {
        this.req = req;
        this.project = project;
        this.reqFactory = reqFactory;
        this.versionControl = (VersionControl)req.getAsIVersionedEntity().get_VC();
        this.isNewlyCreated = isNewlyCreated;
        this.isUnderModification = false;
        this.isClean = true;
    }

    public static List<IRequirement> convertRequirementList(IList rawList, IProject project_, IReqFactory4 reqFactory_) {
        ArrayList<IRequirement> result = new ArrayList<IRequirement>();
        int i = 1;
        while (i <= rawList.get_Count()) {
            Req requirementFromQC = new Req(rawList.get_Item(i).getAutomation(), rawList.getResourceManager());
            result.add(new Requirement(requirementFromQC, project_, reqFactory_, false));
            ++i;
        }
        return result;
    }

    @Override
    public void beginChange() throws CheckOutException {
        assert (!this.isNewlyCreated && !this.isUnderModification);
        try {
            if (this.versionControl == null) {
                this.req.LockObject();
            } else {
                this.versionControl.CheckOut("Requirement under change by Arcway Cockpit");
            }
        }
        catch (SWTException swtE) {
            throw new CheckOutException("Check out failed.");
        }
        this.isUnderModification = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void commit(String comment) throws CommitException {
        SWTException mainException;
        block24: {
            assert (this.isNewlyCreated || this.isUnderModification);
            mainException = null;
            try {
                try {
                    if (!this.isClean) {
                        this.req.Post();
                        this.isClean = true;
                    }
                }
                catch (SWTException e) {
                    mainException = e;
                    if (!this.isNewlyCreated) {
                        try {
                            if (this.versionControl == null) {
                                this.req.UnLockObject();
                            } else {
                                this.versionControl.CheckIn(comment);
                            }
                            this.isUnderModification = false;
                        }
                        catch (SWTException swtE) {
                            if (mainException == null) {
                                mainException = swtE;
                            }
                            break block24;
                        }
                    }
                    this.isNewlyCreated = false;
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (this.isNewlyCreated) {
                    this.isNewlyCreated = false;
                    throw throwable;
                }
                try {
                    if (this.versionControl == null) {
                        this.req.UnLockObject();
                    } else {
                        this.versionControl.CheckIn(comment);
                    }
                    this.isUnderModification = false;
                    throw throwable;
                }
                catch (SWTException swtE) {
                    if (mainException != null) throw throwable;
                    mainException = swtE;
                    throw throwable;
                }
            }
            if (!this.isNewlyCreated) {
                try {
                    if (this.versionControl == null) {
                        this.req.UnLockObject();
                    } else {
                        this.versionControl.CheckIn(comment);
                    }
                    this.isUnderModification = false;
                }
                catch (SWTException swtE) {
                    if (mainException == null) {
                        mainException = swtE;
                    }
                    break block24;
                }
            }
            this.isNewlyCreated = false;
        }
        if (mainException == null) return;
        throw new CommitException("Changes could not be posted to QualityCenter.", mainException);
    }

    @Override
    public void discard() {
        assert (this.isUnderModification);
        if (!this.isClean) {
            this.req.Undo();
            this.isClean = true;
        }
        if (this.versionControl == null) {
            this.req.UnLockObject();
        } else {
            this.versionControl.UndoCheckout();
        }
        this.isUnderModification = false;
    }

    @Override
    public long getId() {
        if (this.id == null) {
            this.id = this.req.get_ID().getLong();
        }
        return this.id;
    }

    @Override
    public long getParentId() {
        return this.req.get_ParentId();
    }

    @Override
    public void setParentId(long id) {
        assert (this.isUnderModification || this.isNewlyCreated);
        if (id != (long)this.req.get_ParentId()) {
            this.req.set_ParentId((int)id);
            this.isClean = false;
        }
    }

    @Override
    public IRequirementType getType() {
        if (this.requirementType == null) {
            this.requirementType = this.project.getRequirementType(((ReqType)this.req.get_RequirementType()).get_ID());
        }
        return this.requirementType;
    }

    @Override
    public void setType(IRequirementType type) {
        String newTypeName;
        assert (this.isUnderModification || this.isNewlyCreated);
        if (type != null && !(newTypeName = type.getName()).equals(this.req.get_TypeId())) {
            this.req.set_TypeId(type.getName());
            this.isClean = false;
        }
    }

    @Override
    public String getName() {
        return (String)this.getFieldValue("RQ_REQ_NAME");
    }

    @Override
    public Object getFieldValue(String fieldName) {
        Variant field = this.req.get_Field(fieldName);
        switch (this.getType().getField(fieldName).getDataType()) {
            case 0: 
            case 1: {
                return new Integer(field.getInt());
            }
            case 2: {
                return new Double(field.getDouble());
            }
        }
        if (field == null) {
            return null;
        }
        return field.getString();
    }

    @Override
    public void setFieldValue(String fieldName, Object value) {
        assert (this.isUnderModification || this.isNewlyCreated);
        if (value != null) {
            this.req.set_Field(fieldName, value);
            this.isClean = false;
        }
    }

    @Override
    public void setFieldValue(String fieldName, IParameterForSetField valueToSet) {
        assert (this.isUnderModification || this.isNewlyCreated);
        IFieldOfRequirementType field = this.getType().getField(fieldName);
        this.setFieldValue(fieldName, HPQCDataConverter.convertAttribute(valueToSet, field.getDataType(), field.getListValues()));
    }

    @Override
    public void fillMandatoryAttributesWithDefaultValues(String defaultStringValue) {
        for (IFieldOfRequirementType field : this.getType().getFields()) {
            String fieldId = field.getID();
            if (!field.isMandatory() || !field.isEditable() || FieldAndDatatypeHelper.QC_SYSTEM_FIELDS.contains(fieldId)) continue;
            this.setFieldValue(fieldId, HPQCDataConverter.getDefaultValue(field.getDataType(), field.getListValues(), defaultStringValue));
        }
    }

    @Override
    public List<IRequirement> getChildren() {
        IList list = this.reqFactory.GetChildrenList((int)this.getId());
        return Requirement.convertRequirementList(list, this.project, this.reqFactory);
    }

    @Override
    public List<IRequirement> getChildren(Properties filterCriterions) {
        IList list = this.reqFactory.GetFilteredChildrenList((int)this.getId(), (ITDFilter)QualityCenter.createFilter((IBaseFactory)this.reqFactory, filterCriterions));
        return Requirement.convertRequirementList(list, this.project, this.reqFactory);
    }

    @Override
    public List<com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IAttachment> getAttachments() {
        IList list = this.getAttachmentFactory().NewList("");
        ArrayList<com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IAttachment> attachments = new ArrayList<com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IAttachment>();
        int index = 1;
        while (index <= list.get_Count()) {
            com.arcway.ole.hpqc.Attachment qcAttachment = new com.arcway.ole.hpqc.Attachment(list.get_Item(index), list.getResourceManager());
            attachments.add(new Attachment((IAttachment)qcAttachment));
            ++index;
        }
        return attachments;
    }

    @Override
    public com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IAttachment addAttachment(File file, String name) {
        com.arcway.ole.hpqc.Attachment addedAttachment = (com.arcway.ole.hpqc.Attachment)this.getAttachmentFactory().AddItem((Object)new Variant(file.getName()));
        addedAttachment.Post();
        IExtendedStorage storage = (IExtendedStorage)addedAttachment.get_AttachmentStorage();
        storage.set_ClientPath(file.getParent());
        storage.Save(file.getName(), true);
        storage.GetLastError();
        addedAttachment.Rename(name);
        return new Attachment((IAttachment)addedAttachment);
    }

    @Override
    public void deleteAttachment(com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IAttachment attachment) {
        this.getAttachmentFactory().RemoveItem((Object)attachment.getID());
    }

    private AttachmentFactory getAttachmentFactory() {
        if (this.attachmentFactory == null) {
            this.attachmentFactory = (AttachmentFactory)this.req.get_Attachments();
        }
        return this.attachmentFactory;
    }
}

