/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.implementation.qc10_com;

import au.com.swz.swttocom.swt.NullVariant;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.implementation.qc10_com.Field;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.implementation.qc10_com.QualityCenter;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.implementation.qc10_com.Requirement;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.implementation.qc10_com.RequirementType;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.CommitException;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IField;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IProject;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IRequirement;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IRequirementType;
import com.arcway.ole.hpqc.Customization;
import com.arcway.ole.hpqc.CustomizationField;
import com.arcway.ole.hpqc.CustomizationReqType;
import com.arcway.ole.hpqc.CustomizationTypes;
import com.arcway.ole.hpqc.CustomizationUsersGroup;
import com.arcway.ole.hpqc.ICustomizationField3;
import com.arcway.ole.hpqc.ICustomizationFields;
import com.arcway.ole.hpqc.ICustomizationPermissions;
import com.arcway.ole.hpqc.ICustomizationUser;
import com.arcway.ole.hpqc.ICustomizationUsers3;
import com.arcway.ole.hpqc.IList;
import com.arcway.ole.hpqc.IReqFactory4;
import com.arcway.ole.hpqc.ITDConnection4;
import com.arcway.ole.hpqc.Req;
import com.arcway.ole.hpqc.ReqFactory;
import com.arcway.ole.hpqc.enums.tagTDAPI_ENTITIES;
import com.arcway.ole.hpqc.enums.tagTDAPI_GRANT_MODIFY;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;

public class Project
implements IProject {
    public static final String TABLENAME_REQUIREMENTS = "REQ";
    private final ITDConnection4 connection;
    private final Customization customisation;
    private final ICustomizationPermissions permissionManager;
    private final ReqFactory reqFactory;
    private Collection<CustomizationUsersGroup> groupsOfConnectedUser;

    public Project(ITDConnection4 connection) {
        this.connection = connection;
        this.customisation = (Customization)connection.get_Customization();
        this.permissionManager = (ICustomizationPermissions)this.customisation.get_Permissions();
        this.reqFactory = (ReqFactory)connection.get_ReqFactory();
    }

    protected ITDConnection4 getConnection() {
        return this.connection;
    }

    @Override
    public List<IRequirementType> getRequirementTypes() {
        CustomizationTypes customisationTypes = (CustomizationTypes)this.customisation.get_Types();
        IList reqCustomTypes = customisationTypes.GetEntityCustomizationTypes(tagTDAPI_ENTITIES.ENTITY_REQUIREMENT.getValue());
        int reqTypeCount = reqCustomTypes.get_Count();
        ArrayList<IRequirementType> reqTypes = new ArrayList<IRequirementType>(reqTypeCount);
        int index = 1;
        while (index <= reqTypeCount) {
            CustomizationReqType reqType = new CustomizationReqType(reqCustomTypes.get_Item(index).getAutomation(), this.customisation.getResourceManager());
            reqTypes.add(new RequirementType(this, reqType));
            ++index;
        }
        return reqTypes;
    }

    @Override
    public IRequirementType getRequirementType(long id) {
        CustomizationTypes customisationTypes = (CustomizationTypes)this.customisation.get_Types();
        CustomizationReqType reqType = (CustomizationReqType)customisationTypes.GetEntityCustomizationType(tagTDAPI_ENTITIES.ENTITY_REQUIREMENT.getValue(), (int)id);
        return new RequirementType(this, reqType);
    }

    @Override
    public IRequirementType getRequirementType(String name) {
        for (IRequirementType reqType : this.getRequirementTypes()) {
            if (!reqType.getName().equals(name)) continue;
            return reqType;
        }
        return null;
    }

    @Override
    public List<IField> getAllRequirementFields() {
        IList fieldList = ((ICustomizationFields)this.customisation.get_Fields()).get_Fields(TABLENAME_REQUIREMENTS);
        int fieldCount = fieldList.get_Count();
        ArrayList<IField> fields = new ArrayList<IField>(fieldList.get_Count());
        int index = 1;
        while (index <= fieldCount) {
            CustomizationField qcField = new CustomizationField(fieldList.get_Item(index).getAutomation(), this.customisation.getResourceManager());
            fields.add(new Field((ICustomizationField3)qcField, this));
            ++index;
        }
        return fields;
    }

    @Override
    public IField getRequirementField(String id) {
        ICustomizationField3 field = (ICustomizationField3)((ICustomizationFields)this.customisation.get_Fields()).get_Field(TABLENAME_REQUIREMENTS, id);
        return new Field(field, this);
    }

    @Override
    public List<String> getUserListValues() {
        IList userList = this.connection.get_UsersList();
        int userCount = userList.get_Count();
        ArrayList<String> users = new ArrayList<String>(userList.get_Count());
        int index = 1;
        while (index <= userCount) {
            String userName = userList.get_Item(index).getString();
            users.add(userName);
            ++index;
        }
        return users;
    }

    @Override
    public IRequirement getRootRequirement() {
        Req rootRequirementFromQC = (Req)this.reqFactory.get_Item((Object)new Long(0L));
        return new Requirement(rootRequirementFromQC, this, (IReqFactory4)this.reqFactory, false);
    }

    @Override
    public List<IRequirement> findRequirements(Properties filterCriterions) {
        IList list = this.reqFactory.NewList(QualityCenter.createFilterText((IReqFactory4)this.reqFactory, filterCriterions));
        return Requirement.convertRequirementList(list, this, (IReqFactory4)this.reqFactory);
    }

    @Override
    public IRequirement createRequirement(IRequirement father, IRequirementType type) throws CommitException {
        Req newReq = (Req)this.reqFactory.AddItem((Object)NullVariant.getNullVariant());
        if (newReq != null) {
            Requirement requirement = new Requirement(newReq, this, (IReqFactory4)this.reqFactory, true);
            requirement.setParentId(father.getId());
            requirement.setType(type);
            return requirement;
        }
        return null;
    }

    @Override
    public String getConnectedUser() {
        return this.connection.get_UserName();
    }

    @Override
    public boolean hasConnectedUserRightToAddRequirements() {
        Collection<CustomizationUsersGroup> groupsOfConnectedUser_ = this.getGroupsOfConnectedUser();
        for (CustomizationUsersGroup group : groupsOfConnectedUser_) {
            if (!this.permissionManager.get_CanAddItem(TABLENAME_REQUIREMENTS, (Object)group)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasConnectedUserRightToModifyRequirements() {
        Collection<CustomizationUsersGroup> groupsOfConnectedUser_ = this.getGroupsOfConnectedUser();
        for (CustomizationUsersGroup group : groupsOfConnectedUser_) {
            if (!this.permissionManager.get_CanModifyItem(TABLENAME_REQUIREMENTS, (Object)group)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasConnectedUserRightToModifyRequirementField(String fieldID) {
        Collection<CustomizationUsersGroup> groupsOfConnectedUser_ = this.getGroupsOfConnectedUser();
        for (CustomizationUsersGroup group : groupsOfConnectedUser_) {
            if (this.permissionManager.get_CanModifyField(TABLENAME_REQUIREMENTS, (Object)fieldID, (Object)group) != tagTDAPI_GRANT_MODIFY.GRANT_MODIFY_PERMIT.getValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasConnectedUserRightToModifyRequirementAttachments() {
        Collection<CustomizationUsersGroup> groupsOfConnectedUser_ = this.getGroupsOfConnectedUser();
        for (CustomizationUsersGroup group : groupsOfConnectedUser_) {
            if (this.permissionManager.get_CanAllowAttachment(TABLENAME_REQUIREMENTS, (Object)group) != tagTDAPI_GRANT_MODIFY.GRANT_MODIFY_PERMIT.getValue()) continue;
            return true;
        }
        return false;
    }

    private Collection<CustomizationUsersGroup> getGroupsOfConnectedUser() {
        if (this.groupsOfConnectedUser == null) {
            this.groupsOfConnectedUser = new ArrayList<CustomizationUsersGroup>();
            ICustomizationUsers3 userCustomisation = (ICustomizationUsers3)this.customisation.get_Users();
            ICustomizationUser user = (ICustomizationUser)userCustomisation.get_User(this.getConnectedUser());
            IList groupList = user.GroupsList();
            int index = 1;
            while (index <= groupList.get_Count()) {
                CustomizationUsersGroup group = new CustomizationUsersGroup(groupList.get_Item(index), groupList.getResourceManager());
                this.groupsOfConnectedUser.add(group);
                ++index;
            }
        }
        return this.groupsOfConnectedUser;
    }
}

