/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.qualitycenteradapter.exporter.ui;

import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.IExporterOrImporterSpecificWizardPage;
import com.arcway.cockpit.rqm3.qualitycenteradapter.Messages;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.IConfigurationRO;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.QualityCenterFacade;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IProject;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IQualityCenter;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.QualityCenterFacadeException;
import com.arcway.lib.memento.IArcwayMemento;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class QCLoginPage
extends WizardPage
implements IExporterOrImporterSpecificWizardPage {
    private static final String pageID = "com.arcway.cockpit.rqm3.qualitycenter.QCLoginPage";
    private Text usernameWidget;
    private Text passwordWidget;
    private Button checkButton;
    private final IConfigurationRO configuration;
    private String usernameFromSettingsStore;
    private static final String SETTING_KEY_USERNAME = "username";

    public QCLoginPage(IConfigurationRO configuration) {
        super(pageID, Messages.getString("QCExportWizard.QCLoginPage.Title"), null);
        this.configuration = configuration;
        this.setDescription(Messages.getString("QCExportWizard.QCLoginPage.Instruction"));
        this.setPageComplete(true);
    }

    public String getKey() {
        return this.getName();
    }

    public void createControl(Composite parent) {
        Composite qcLoginComposite = new Composite(parent, 0);
        GridLayout qcLoginLayout = new GridLayout(2, false);
        qcLoginLayout.verticalSpacing = 20;
        qcLoginLayout.marginHeight = 20;
        qcLoginLayout.marginWidth = 20;
        qcLoginComposite.setLayout((Layout)qcLoginLayout);
        Label usernameLabel = new Label(qcLoginComposite, 0);
        usernameLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        usernameLabel.setText(String.valueOf(Messages.getString("QCExportWizard.QCLoginPage.Username.Label")) + ":");
        this.usernameWidget = new Text(qcLoginComposite, 2052);
        this.usernameWidget.setLayoutData((Object)new GridData(4, 2, true, false));
        Label passwordLabel = new Label(qcLoginComposite, 0);
        passwordLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        passwordLabel.setText(String.valueOf(Messages.getString("QCExportWizard.QCLoginPage.Password.Label")) + ":");
        this.passwordWidget = new Text(qcLoginComposite, 2052);
        this.passwordWidget.setEchoChar('*');
        this.passwordWidget.setLayoutData((Object)new GridData(4, 2, true, false));
        this.checkButton = new Button(qcLoginComposite, 0);
        GridData checkButtonGridData = new GridData(3, 2, false, false);
        checkButtonGridData.horizontalSpan = 2;
        checkButtonGridData.verticalSpan = 2;
        this.checkButton.setLayoutData((Object)checkButtonGridData);
        this.checkButton.setText(Messages.getString("QCExportWizard.QCLoginPage.CheckButton.Label"));
        this.checkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QCLoginPage.this.checkLoginData();
            }
        });
        this.setControl((Control)qcLoginComposite);
        if (this.usernameFromSettingsStore != null) {
            this.usernameWidget.setText(this.usernameFromSettingsStore);
        }
    }

    private void checkLoginData() {
        IProject project;
        IQualityCenter qualityCenter = QualityCenterFacade.getQualityCenter();
        try {
            project = qualityCenter.connect(this.configuration.getURL(), this.configuration.getDomain(), this.configuration.getProject(), this.usernameWidget.getText(), this.passwordWidget.getText());
        }
        catch (QualityCenterFacadeException hpqcE) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("QCExportWizard.QCLoginPage.LoginCheck.Error.Title"), (String)NLS.bind((String)Messages.getString("QCExportWizard.QCLoginPage.LoginCheck.Error.Message"), (Object)hpqcE.getLocalizedMessage()));
            return;
        }
        qualityCenter.disconnect(project);
        MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.getString("QCExportWizard.QCLoginPage.LoginCheck.Confirmation.Title"), (String)Messages.getString("QCExportWizard.QCLoginPage.LoginCheck.Confirmation.Message"));
    }

    public void setEnabled(boolean enabled) {
        this.usernameWidget.setEnabled(enabled);
        this.passwordWidget.setEnabled(enabled);
    }

    public String getUsername() {
        return this.usernameWidget.getText();
    }

    public String getPassword() {
        return this.passwordWidget.getText();
    }

    public Object getParameter() {
        return new Parameter(this.getUsername(), this.getPassword());
    }

    public void readSettings(IArcwayMemento settingsStore) {
        String fileName = settingsStore.getString(SETTING_KEY_USERNAME);
        if (fileName != null && fileName.trim().length() > 0) {
            this.usernameFromSettingsStore = fileName;
        }
    }

    public void storeSettings(IArcwayMemento settingsStore) {
        settingsStore.putString(SETTING_KEY_USERNAME, this.getUsername());
    }

    public class Parameter {
        public final String username;
        public final String password;

        public Parameter(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

