/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.qualitycenteradapter.exporter;

import au.com.swz.swttocom.swt.types.TypeUtils;
import com.arcway.cockpit.genericmodule.client.core.ClientDataFactory_TypesHelper;
import com.arcway.cockpit.genericmodule.client.core.ModuleIdentification;
import com.arcway.cockpit.genericmodule.client.gui.adapter.GenericModuleExportableData;
import com.arcway.cockpit.genericmodule.client.gui.adapter.IGenericModuleExportAdapter;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.SpecificationProvider;
import com.arcway.cockpit.genericmodule.client.infrastructure.specification.structure.ModuleSpecification;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportFailedException;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.ExportOrImportResult;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.IExportOrImportWizardContribution;
import com.arcway.cockpit.modulelib2.client.dataexchange.adapter.exporter.IExportableData;
import com.arcway.cockpit.modulelib2.client.platformadapter.helper.RepositoryIDCreator;
import com.arcway.cockpit.rqm3.qualitycenteradapter.Messages;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.CockpitAttributeReference;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.CockpitDataTypeReference;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.CockpitValueReference;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.Configuration;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.IConfigurationRO;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.ui.TargetAttributeDescription;
import com.arcway.cockpit.rqm3.qualitycenteradapter.exporter.ExportCache;
import com.arcway.cockpit.rqm3.qualitycenteradapter.exporter.GMExportSpecsHelper;
import com.arcway.cockpit.rqm3.qualitycenteradapter.exporter.QualityCenterConfigurationChecker;
import com.arcway.cockpit.rqm3.qualitycenteradapter.exporter.ui.ExportWizardContribution;
import com.arcway.cockpit.rqm3.qualitycenteradapter.exporter.ui.QCCommitCommentPage;
import com.arcway.cockpit.rqm3.qualitycenteradapter.exporter.ui.QCLoginPage;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.FieldAndDatatypeHelper;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.ParameterForSetField;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.QualityCenterFacade;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.CommitException;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IAttachment;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IFieldOfRequirementType;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IProject;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IQualityCenter;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IRequirement;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IRequirementNameChecker;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.IRequirementType;
import com.arcway.cockpit.rqm3.qualitycenteradapter.qcfacade.interFace.QualityCenterFacadeException;
import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.lib.codec.data.IDataType;
import com.arcway.lib.codec.data.codecs.canonicalstring.CanonicalStringCoDecForData;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValueMapping;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ITargetAttributeDescription;
import com.arcway.lib.io.FileHelper;
import com.arcway.lib.java.collections.ArrayList_;
import com.arcway.lib.java.collections.CollectionUtils;
import com.arcway.lib.java.collections.HashSet_;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.collections.IListIteratorRW_;
import com.arcway.lib.java.collections.IListRW_;
import com.arcway.lib.java.collections.IList_;
import com.arcway.lib.java.collections.ISetRW_;
import com.arcway.lib.java.collections.ISet_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.lib.java.maps.HashMap_;
import com.arcway.lib.java.maps.IEntry_;
import com.arcway.lib.java.maps.IMapRW_;
import com.arcway.lib.java.maps.IMap_;
import com.arcway.lib.java.tuples.Tuple;
import com.arcway.lib.logging.ILogger;
import com.arcway.lib.logging.Logger;
import com.arcway.lib.resource.JvmExternalResourceInteractionException;
import com.arcway.repository.interFace.data.RepositoryObjectTypes;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.data.IRepositoryData;
import com.arcway.repository.interFace.data.file.IRepositoryFileID;
import com.arcway.repository.interFace.data.object.DTRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.data.property.IRepositoryPropertySample;
import com.arcway.repository.interFace.dataaccess.locksandpermissions.ILocksAndPermissionsManagerDeprecated;
import com.arcway.repository.interFace.declaration.type.object.IRepositoryObjectTypeID;
import com.arcway.repository.interFace.declaration.type.property.IRepositoryPropertyTypeID;
import com.arcway.repository.interFace.declaration.type.relation.IRepositoryRelationTypeID;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.importexport.IFileArchiveSnippetFile;
import com.arcway.repository.interFace.importexport.IRepositorySnippetRO;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RepositoryObjectSampleWithParentObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import com.arcway.repository.lib.high.registration.data.lib.RDTFile;
import de.plans.lib.util.gui.IProgressDisplay;
import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;

public class QualityCenterExporter
implements IGenericModuleExportAdapter {
    private static final ILogger logger = Logger.getLogger(QualityCenterExporter.class);
    private static final int QCTYPE_OF_FOLDER = 1;
    private static final String QCFIELDID_OF_FOLDER_LABELFIELD = "RQ_REQ_NAME";
    private static final String NAME_OF_ROOTFOLDER = "Arcway Cockpit";
    private static final DateFormat QC_CREATIONTIME_FORMAT = new SimpleDateFormat("HH:mm");
    private String moduleID;
    private ModuleSpecification moduleSpecification;
    private ISet_<IRepositoryObjectTypeID> objectTypesToBeExported;
    private String dataName;
    private ImageDescriptor dataIcon;
    private IConfigurationRO currentConfiguration;
    private PresentationContext presentationContext;
    private IQualityCenter currentQCConnection;
    private IProject currentQCProject;
    private String commitComment;

    public void construct(String moduleID_, Collection<String> objectTypeIDs, String dataName_, ImageDescriptor dataIcon_) {
        this.moduleID = moduleID_;
        this.moduleSpecification = SpecificationProvider.getDefault().getModuleSpecification(moduleID_);
        RepositoryIDCreator repositoryIDCreator = new RepositoryIDCreator(ModuleIdentification.getModuleIDForPlatform((String)moduleID_), "declaration_module_coremodule");
        HashSet_ objectTypesToBeExported_ = new HashSet_(this.moduleSpecification.getModuleDataSpecification().getObjectTypeList().size(), IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER);
        for (String objectTypeID : objectTypeIDs) {
            objectTypesToBeExported_.add((Object)repositoryIDCreator.createObjectTypeIDForRealType(ClientDataFactory_TypesHelper.getDataTypeID((String)moduleID_, (String)objectTypeID)));
        }
        this.objectTypesToBeExported = objectTypesToBeExported_;
        this.dataName = dataName_;
        this.dataIcon = dataIcon_;
    }

    public void startExport(List<?> parameters, String configuration, PresentationContext presentationContext_, IProgressDisplay monitor, Shell shell) throws ExportOrImportFailedException {
        this.presentationContext = presentationContext_;
        this.currentConfiguration = Configuration.getConfiguration(configuration);
        QCLoginPage.Parameter loginParameter = (QCLoginPage.Parameter)parameters.get(0);
        this.currentQCConnection = QualityCenterFacade.getQualityCenter();
        try {
            this.currentQCProject = this.currentQCConnection.connect(this.currentConfiguration.getURL(), this.currentConfiguration.getDomain(), this.currentConfiguration.getProject(), loginParameter.username, loginParameter.password);
        }
        catch (QualityCenterFacadeException qcfE) {
            throw new ExportOrImportFailedException(2, qcfE.getLocalizedMessage());
        }
        QCCommitCommentPage.Parameter commitCommentParameter = (QCCommitCommentPage.Parameter)parameters.get(1);
        this.commitComment = commitCommentParameter.commitComment;
    }

    public void export(IExportableData dataToExport, IProgressDisplay monitor, Shell shell) throws ExportOrImportFailedException {
        assert (dataToExport instanceof GenericModuleExportableData);
        GenericModuleExportableData gmDataToExport = (GenericModuleExportableData)dataToExport;
        IRepositorySnippetRO snippet = gmDataToExport.repositorySnippet;
        IRepositoryTypeManagerRO typeManager = gmDataToExport.typeManager;
        ILocksAndPermissionsManagerDeprecated deprecationManager = gmDataToExport.deprecationManager;
        TargetAttributeDescription NO_MAPPING = new TargetAttributeDescription();
        ExportCache cache = new ExportCache(this.currentConfiguration, this.currentQCProject, snippet, (ICollection_<IRepositoryObjectTypeID>)this.objectTypesToBeExported, typeManager, deprecationManager, NO_MAPPING);
        IList_<IRepositoryObjectTypeID> objectTypesWhichMayBeExportedToHPQC = GMExportSpecsHelper.getObjectTypesWhichMayBeExportedToHPQC(this.moduleID);
        Tuple<String, String> problemAndWarningMessage = QualityCenterConfigurationChecker.checkConfiguration(this.currentConfiguration, cache, objectTypesWhichMayBeExportedToHPQC, this.currentQCProject);
        String message = null;
        if (problemAndWarningMessage.getT1() != null) {
            message = (String)problemAndWarningMessage.getT1();
        } else if (problemAndWarningMessage.getT2() != null) {
            message = (String)problemAndWarningMessage.getT2();
        }
        if (message != null) {
            throw new ExportOrImportFailedException(2, String.valueOf(message) + "\n\n" + Messages.getString("QualityCenterExporter.Failure.CheckConfiguration"));
        }
        IRequirement rootFolderForCockpitExports = null;
        try {
            rootFolderForCockpitExports = this.findOrCreateRootFolderForCockpitExports();
        }
        catch (CommitException cE) {
            throw new ExportOrImportFailedException(2, Messages.getString("QualityCenterExporter.Failure.CreatingRootFolderFailed"), (Throwable)cE);
        }
        RepositoryObjectSampleWithParentObjectReference projectRootObject = null;
        ArrayList<RepositoryObjectSampleWithParentObjectReference> rootObjects = new ArrayList<RepositoryObjectSampleWithParentObjectReference>();
        HashMap_ map_parentID_children = new HashMap_(IRepositoryObjectReference.REFERENCING_EQUAL_OBJECTS_HASHER);
        for (RepositoryObjectSampleWithParentObjectReference objectToBeExported : CollectionUtils.getMultiCollectionIterable((Collection[])new Collection[]{snippet.getExplicitObjects().asJavaCollection(), snippet.getImplicitObjects().asJavaCollection()})) {
            IRepositoryObjectReference parentReference = objectToBeExported.getParentObjectReference();
            if (parentReference != null) {
                IListRW_ children = (IListRW_)map_parentID_children.getByKey((Object)parentReference);
                if (children == null) {
                    children = new ArrayList_();
                    map_parentID_children.put((Object)parentReference, (Object)children);
                }
                children.add((Object)objectToBeExported);
                continue;
            }
            if (IRepositoryObjectTypeID.IS_EQUAL_OBJECT_TYPE_ID_HASHER.isEqual((Object)objectToBeExported.getObjectSample().getObjectTypeID(), (Object)typeManager.getRootModuleType().getRootObjectType().getRepositoryObjectTypeID())) {
                assert (projectRootObject == null);
                projectRootObject = objectToBeExported;
                continue;
            }
            rootObjects.add(objectToBeExported);
        }
        assert (projectRootObject != null);
        IRepositoryObjectReference projectRootObjectReference = projectRootObject.getObjectSample().getObjectReference(typeManager);
        IListRW_ children = (IListRW_)map_parentID_children.getByKey((Object)projectRootObjectReference);
        if (children == null) {
            children = new ArrayList_();
            map_parentID_children.put((Object)projectRootObjectReference, (Object)children);
        }
        children.addAll(rootObjects);
        boolean containsAnyRelevantChildren = this.removeParentsWithoutRelevantChildrenRecursively((IMapRW_<IRepositoryObjectReference, IListRW_<RepositoryObjectSampleWithParentObjectReference>>)map_parentID_children, projectRootObject, this.objectTypesToBeExported, typeManager);
        if (!containsAnyRelevantChildren) {
            throw new ExportOrImportFailedException(2, Messages.getString("QualityCenterExporter.Failure.NoDataToExport"));
        }
        String projectName = FrontendTypeManager.getFrontendTypeManager((IRepositoryTypeManagerRO)typeManager).getLabelForObject(projectRootObject.getObjectSample(), this.presentationContext).getText();
        IRequirement rootFolderForProject = QualityCenterExporter.findFolder(rootFolderForCockpitExports, projectName);
        try {
            if (rootFolderForProject != null) {
                cache.setupRequirementsCache(rootFolderForProject);
                this.checkOutRequirementsRecursively(projectRootObject, (IMap_<IRepositoryObjectReference, ? extends IList_<RepositoryObjectSampleWithParentObjectReference>>)map_parentID_children, cache, snippet);
            } else {
                try {
                    rootFolderForProject = this.createFolder(rootFolderForCockpitExports, projectName);
                }
                catch (CommitException cE) {
                    throw new ExportOrImportFailedException(2, Messages.getString("QualityCenterExporter.Failure.CreatingFolderForProjectFailed"), (Throwable)cE);
                }
            }
            this.exportObjectsRecursively(projectRootObject, rootFolderForProject, (IMap_<IRepositoryObjectReference, ? extends IList_<RepositoryObjectSampleWithParentObjectReference>>)map_parentID_children, cache, snippet);
        }
        finally {
            cache.checkInAllRequirements();
        }
    }

    public void closeExport(IProgressDisplay monitor, Shell shell) throws ExportOrImportFailedException {
        this.currentQCConnection.disconnect(this.currentQCProject);
    }

    public ExportOrImportResult.OpenExportConfiguration getOpenExportConfiguration() {
        return null;
    }

    public IExportOrImportWizardContribution getWizardContribution() {
        return new ExportWizardContribution(this.moduleSpecification, this.dataName, this.dataIcon);
    }

    public String getConfigurationKey() {
        return "qualitycenteradapter";
    }

    private IRequirement findOrCreateRootFolderForCockpitExports() throws CommitException {
        IRequirement rootRequirement = this.currentQCProject.getRootRequirement();
        IRequirement folder = QualityCenterExporter.findFolder(rootRequirement, NAME_OF_ROOTFOLDER);
        if (folder == null) {
            folder = this.createFolder(rootRequirement, NAME_OF_ROOTFOLDER);
        }
        return folder;
    }

    private static IRequirement findFolder(IRequirement parentFolder, String folderName) {
        Properties filterCriterions = new Properties();
        filterCriterions.setProperty(QCFIELDID_OF_FOLDER_LABELFIELD, folderName);
        List<IRequirement> folderList = parentFolder.getChildren(filterCriterions);
        if (folderList.isEmpty()) {
            return null;
        }
        return folderList.get(0);
    }

    private IRequirement createFolder(IRequirement parentFolder, String folderName) throws CommitException {
        IRequirementType requirementTypeFolder = this.currentQCProject.getRequirementType(1L);
        IRequirement folder = this.currentQCProject.createRequirement(parentFolder, requirementTypeFolder);
        folder.setFieldValue(QCFIELDID_OF_FOLDER_LABELFIELD, folderName);
        folder.commit("Requirement created by Arcway Cockpit");
        return folder;
    }

    private boolean removeParentsWithoutRelevantChildrenRecursively(IMapRW_<IRepositoryObjectReference, IListRW_<RepositoryObjectSampleWithParentObjectReference>> map_parentID_children, RepositoryObjectSampleWithParentObjectReference parentInQuestion, ISet_<IRepositoryObjectTypeID> objectTypesToBeExported_, IRepositoryTypeManagerRO typeManager) {
        IRepositoryObjectSample parentSample = parentInQuestion.getObjectSample();
        IListRW_ children = (IListRW_)map_parentID_children.getByKey((Object)new RepositoryObjectReference(parentSample.getObjectTypeID(), parentSample.getObjectID(typeManager)));
        if (children != null) {
            IListIteratorRW_ childrenIterator = children.iterator();
            while (childrenIterator.hasNext()) {
                RepositoryObjectSampleWithParentObjectReference child = (RepositoryObjectSampleWithParentObjectReference)childrenIterator.next();
                if (this.removeParentsWithoutRelevantChildrenRecursively(map_parentID_children, child, objectTypesToBeExported_, typeManager)) continue;
                childrenIterator.remove();
            }
        }
        if (children == null || children.isEmpty()) {
            return RepositoryObjectTypes.findMostSpecificSuperObjectType((IRepositoryObjectType)typeManager.findObjectType(parentSample.getObjectTypeID()), objectTypesToBeExported_) != null;
        }
        return true;
    }

    private void checkOutRequirementsRecursively(RepositoryObjectSampleWithParentObjectReference objectInCockpit, IMap_<IRepositoryObjectReference, ? extends IList_<RepositoryObjectSampleWithParentObjectReference>> map_parentID_children, ExportCache cache, IRepositorySnippetRO snippet) throws ExportOrImportFailedException {
        IRepositoryObjectSample sampleOfObjectInCockpit = objectInCockpit.getObjectSample();
        IRepositoryObjectReference referenceOfObjectInCockpit = sampleOfObjectInCockpit.getObjectReference(cache.getTypeManager());
        IList_ children = (IList_)map_parentID_children.getByKey((Object)referenceOfObjectInCockpit);
        if (children != null) {
            for (RepositoryObjectSampleWithParentObjectReference child : children) {
                IRepositoryObjectSample childObjectSample = child.getObjectSample();
                cache.checkOutQCRequirement(childObjectSample);
                this.checkOutRequirementsRecursively(child, map_parentID_children, cache, snippet);
            }
        }
    }

    private void exportObjectsRecursively(RepositoryObjectSampleWithParentObjectReference objectInCockpit, IRequirement objectInQC, IMap_<IRepositoryObjectReference, ? extends IList_<RepositoryObjectSampleWithParentObjectReference>> map_parentID_children, ExportCache cache, IRepositorySnippetRO snippet) throws ExportOrImportFailedException {
        IRepositoryObjectSample sampleOfObjectInCockpit = objectInCockpit.getObjectSample();
        IRepositoryObjectReference referenceOfObjectInCockpit = sampleOfObjectInCockpit.getObjectReference(cache.getTypeManager());
        IList_ children = (IList_)map_parentID_children.getByKey((Object)referenceOfObjectInCockpit);
        if (children != null) {
            for (RepositoryObjectSampleWithParentObjectReference child : children) {
                IRepositoryObjectSample childObjectSample = child.getObjectSample();
                IRepositoryObjectTypeID childObjectTypeID = childObjectSample.getObjectTypeID();
                cache.setObjectTypeID(childObjectTypeID);
                IRequirementType qcRequirementType = cache.getRequirementType();
                if (qcRequirementType != null) {
                    IRequirement childInQC = this.exportObject(childObjectSample, objectInQC, qcRequirementType, cache, snippet);
                    this.exportObjectsRecursively(child, childInQC, map_parentID_children, cache, snippet);
                    continue;
                }
                assert (false);
                throw new ExportOrImportFailedException(2, "Unknown QC requirement type configured.");
            }
        }
    }

    private IRequirement exportObject(IRepositoryObjectSample objectSample, IRequirement parent, IRequirementType qcRequirementType, ExportCache cache, IRepositorySnippetRO snippet) throws ExportOrImportFailedException {
        IRepositoryObjectReference referenceOfObjectInCockpit;
        IRepositoryObjectReference cockpitTechnicalID = referenceOfObjectInCockpit = objectSample.getObjectReference(cache.getTypeManager());
        String cockpitTechnicalIDAsString = QualityCenterExporter.getSerialisedCockpitTechnicalID(cockpitTechnicalID, cache);
        IRequirement matchingQCRequirement = cache.getRequirement(cockpitTechnicalIDAsString);
        try {
            ISetRW_<String> reqNamesInUse;
            if (matchingQCRequirement != null) {
                reqNamesInUse = cache.getRequirementNamesInUseByChildren(matchingQCRequirement.getParentId());
                reqNamesInUse.remove((Object)matchingQCRequirement.getName());
            } else {
                matchingQCRequirement = this.currentQCProject.createRequirement(parent, qcRequirementType);
                if (matchingQCRequirement != null) {
                    QualityCenterExporter.fillMandatoryAttributes(matchingQCRequirement, Messages.getString("QualityCenterExporter.DefaultStringValue"));
                    matchingQCRequirement.setFieldValue(cache.getQcFieldIDForCockpitTechnicalID(), cockpitTechnicalIDAsString);
                    QualityCenterExporter.setMetaAttributes(matchingQCRequirement, this.currentQCProject, objectSample, cache);
                    matchingQCRequirement.commit(null);
                    cache.checkOutQCRequirement(matchingQCRequirement);
                    reqNamesInUse = cache.getRequirementNamesInUseByChildren(parent.getId());
                } else {
                    throw new ExportOrImportFailedException(2, Messages.getString("QualityCenterExporter.Failure.CreateFailed"));
                }
            }
            DuplicateRequirementNameHandler duplicateRequirementNameHandler = new DuplicateRequirementNameHandler(reqNamesInUse);
            IRepositoryPropertySetSample propertySet = objectSample.getPropertySetSample();
            for (IEntry_ attributeMappingEntry : cache.getAttributeMap()) {
                CockpitAttributeReference cockpitAttribute = (CockpitAttributeReference)attributeMappingEntry.getKey();
                ITargetAttributeDescription qcFieldDescription = (ITargetAttributeDescription)attributeMappingEntry.getValue();
                if (qcFieldDescription == null || qcFieldDescription == cache.getMarkerFor_NoMapping_()) continue;
                if ((Integer)qcFieldDescription.getDataTypeKey() == 1000) {
                    IRepositoryPropertyTypeID propertyTypeID = cockpitAttribute.getPropertyAttributeID();
                    IRepositoryPropertySample propertySample = propertySet.getPropertySample(propertyTypeID);
                    IRepositoryData propertyValue = propertySample.getValue();
                    IRepositoryFileID idOfFileToExport = RDTFile.getInstance().dataToFileID(propertyValue);
                    if (idOfFileToExport == null) continue;
                    File fileToExport = null;
                    String fileName = null;
                    for (IFileArchiveSnippetFile snippetFile : snippet.getFiles()) {
                        if (!IRepositoryFileID.IS_EQUAL_FILE_ID_HASHER.isEqual((Object)snippetFile.getFileID(), (Object)idOfFileToExport)) continue;
                        fileToExport = snippetFile.getContent();
                        fileName = snippetFile.getName();
                    }
                    if (fileToExport != null) {
                        String attributeNameWithoutInvalidCharacters = FileHelper.convertStringToPortableFileName((String)cache.getSourceAttributeDescription(cockpitAttribute).getName());
                        String attachmentNamePrefix = String.valueOf(attributeNameWithoutInvalidCharacters) + " - ";
                        String attachmentName = String.valueOf(attachmentNamePrefix) + fileName;
                        boolean attachmentExistsAlready = false;
                        List<IAttachment> attachments = matchingQCRequirement.getAttachments();
                        for (IAttachment attachment : attachments) {
                            if (!attachment.getName().startsWith(attachmentNamePrefix)) continue;
                            if (attachment.getName().equals(attachmentName) && QualityCenterExporter.compareCustomPropertyFileWithAttachmentFile(fileToExport, attachment.getFile())) {
                                attachmentExistsAlready = true;
                                continue;
                            }
                            matchingQCRequirement.deleteAttachment(attachment);
                        }
                        if (attachmentExistsAlready) continue;
                        matchingQCRequirement.addAttachment(fileToExport, attachmentName);
                        continue;
                    }
                    throw new ExportOrImportFailedException(2, "File for Cockpit file attribute is not contained in snippet: " + cockpitAttribute.getPropertyAttributeID() + ")");
                }
                String qcFieldName = (String)qcFieldDescription.getKey();
                IFieldOfRequirementType qcField = qcRequirementType.getField(qcFieldName);
                if (qcField != null) {
                    CockpitDataTypeReference propertyDataType;
                    int qcFieldDataType = qcField.getDataType();
                    boolean isNameField = qcFieldName.equals(QCFIELDID_OF_FOLDER_LABELFIELD);
                    if (cockpitAttribute.getAttributeType() == CockpitAttributeReference.AttributeType.Property) {
                        IRepositoryPropertyTypeID propertyTypeID = cockpitAttribute.getPropertyAttributeID();
                        IRepositoryPropertySample propertySample = propertySet.getPropertySample(propertyTypeID);
                        IRepositoryData propertyValue = propertySample.getValue();
                        CockpitDataTypeReference propertyDataType2 = new CockpitDataTypeReference(CockpitDataTypeReference.DataTypeType.Property, propertyValue.getDataType().getRepositoryDataTypeID());
                        if (!((ISet_)FieldAndDatatypeHelper.ALLOWED_MAPPINGS.getByKey((Object)propertyDataType2)).contains((Object)qcFieldDataType)) continue;
                        matchingQCRequirement.setFieldValue(qcFieldName, new ParameterForSetField(referenceOfObjectInCockpit.getObjectTypeID(), propertyTypeID, propertySample, (EnumValueMapping<CockpitValueReference, String>)((EnumValueMapping)cache.getEnumValueMappingMap().getByKey((Object)cockpitAttribute)), isNameField, duplicateRequirementNameHandler, cache.getTypeManager(), this.presentationContext));
                        continue;
                    }
                    if (cockpitAttribute.getAttributeType() != CockpitAttributeReference.AttributeType.LinkedAttribute || !((ISet_)FieldAndDatatypeHelper.ALLOWED_MAPPINGS.getByKey((Object)(propertyDataType = new CockpitDataTypeReference(CockpitDataTypeReference.DataTypeType.LinkedAttribute, null)))).contains((Object)qcFieldDataType)) continue;
                    IRepositoryRelationTypeID relationTypeID = cockpitAttribute.getLinkedAttributeID().getRelationTypeID();
                    IRepositoryRelationContributionRoleID roleID = cockpitAttribute.getLinkedAttributeID().getRelationContributionRoleID();
                    matchingQCRequirement.setFieldValue(qcFieldName, new ParameterForSetField(referenceOfObjectInCockpit.getObjectID(), relationTypeID, roleID, snippet, (EnumValueMapping<CockpitValueReference, String>)((EnumValueMapping)cache.getEnumValueMappingMap().getByKey((Object)cockpitAttribute)), isNameField, duplicateRequirementNameHandler, cache.getTypeManager(), this.presentationContext));
                    continue;
                }
                throw new ExportOrImportFailedException(2, "QC requirement field could not be found (reqType: " + qcRequirementType.getName() + "/fieldID: " + qcFieldName + ")");
            }
            cache.markRequirementAsCheckedIn(matchingQCRequirement);
            matchingQCRequirement.commit(this.commitComment);
            return matchingQCRequirement;
        }
        catch (CommitException e) {
            throw new ExportOrImportFailedException(2, Messages.getString("QualityCenterExporter.Failure.CommitFailed"), (Throwable)e);
        }
    }

    private static void fillMandatoryAttributes(IRequirement requirement, String defaultStringValue) {
        requirement.fillMandatoryAttributesWithDefaultValues(defaultStringValue);
    }

    private static void setMetaAttributes(IRequirement requirementToCreate, IProject project, IRepositoryObjectSample requirementToExport, ExportCache cache) {
        String authorName = null;
        Date creationDate = null;
        if (cache.isUsingCockpitMetaAttributes()) {
            String cockpitAuthorName = null;
            if (cache.isUsingCockpitModificationMetaAttributes()) {
                cockpitAuthorName = cache.getDeprecationManager().getLastModifierOfObject(requirementToExport);
                creationDate = cache.getDeprecationManager().getDateOfLastModificationOfObject(requirementToExport);
            } else {
                cockpitAuthorName = cache.getDeprecationManager().getAuthorOfObject(requirementToExport);
                creationDate = cache.getDeprecationManager().getCreationDateOfObject(requirementToExport);
            }
            if (cache.isUsingAuthorMapping()) {
                authorName = (String)cache.getAuthorMapping().getByKey((Object)cockpitAuthorName);
                if (authorName == null) {
                    assert (false);
                    authorName = project.getConnectedUser();
                }
            } else {
                authorName = cockpitAuthorName;
            }
        } else {
            authorName = project.getConnectedUser();
            creationDate = new Date(System.currentTimeMillis());
        }
        requirementToCreate.setFieldValue("RQ_REQ_AUTHOR", authorName);
        requirementToCreate.setFieldValue("RQ_REQ_DATE", TypeUtils.convertFromDate((Date)creationDate));
        requirementToCreate.setFieldValue("RQ_REQ_TIME", QC_CREATIONTIME_FORMAT.format(creationDate));
    }

    public static String getSerialisedCockpitTechnicalID(IRepositoryObjectReference cockpitTechnicalID, ExportCache cache) {
        String cockpitTechnicalIDAsString = CanonicalStringCoDecForData.encodeIntoCanonicalString((IDataType)DTRepositoryObjectReference.getInstance((IRepositoryTypeManagerRO)cache.getTypeManager()), (Object)cockpitTechnicalID);
        assert (cockpitTechnicalIDAsString.length() <= 255);
        if (cockpitTechnicalIDAsString.length() > 255) {
            cockpitTechnicalIDAsString = cockpitTechnicalIDAsString.substring(0, 255);
        }
        return cockpitTechnicalIDAsString;
    }

    private static boolean compareCustomPropertyFileWithAttachmentFile(File customPropertyFile, File attachmentFile) {
        try {
            return FileHelper.compareFiles((File)customPropertyFile, (File)attachmentFile, (boolean)false);
        }
        catch (JvmExternalResourceInteractionException jeriE) {
            logger.warn("Exception comparing a custom property file with an attachment content.", (Throwable)jeriE);
            return false;
        }
    }

    private static class DuplicateRequirementNameHandler
    implements IRequirementNameChecker {
        private final ISetRW_<String> requirementNamesInUse;

        public DuplicateRequirementNameHandler(ISetRW_<String> requirementNamesInUse) {
            this.requirementNamesInUse = requirementNamesInUse;
        }

        @Override
        public String checkRequirementName(String actualRequirementName) {
            int index = 1;
            String replacementName = actualRequirementName;
            while (this.requirementNamesInUse.contains((Object)replacementName)) {
                replacementName = String.valueOf(actualRequirementName) + " (" + Integer.toString(++index) + ")";
            }
            this.requirementNamesInUse.add((Object)replacementName);
            return replacementName;
        }
    }
}

