/*
 * Decompiled with CFR 0.152.
 */
package com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.ui;

import com.arcway.cockpit.rqm3.qualitycenteradapter.Messages;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.CockpitAttributeReference;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.CockpitDataTypeReference;
import com.arcway.cockpit.rqm3.qualitycenteradapter.configuration.CockpitValueReference;
import com.arcway.frontend.definition.lib.implementation.type.manager.FrontendTypeManager;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataType;
import com.arcway.frontend.definition.lib.interFace.datatype.IFrontendDataTypeParameters;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendPropertyType;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendRelationContributionType;
import com.arcway.frontend.definition.lib.interFace.type.IFrontendRelationType;
import com.arcway.frontend.definition.lib.interFace.type.manager.IFrontendTypeManager;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.EnumValue;
import com.arcway.lib.eclipse.gui.widgets.attributemapping.ISourceAttributeDescription;
import com.arcway.lib.java.collections.ICollection_;
import com.arcway.lib.java.locale.PresentationContext;
import com.arcway.repository.interFace.data.attributeset.IRepositoryPropertySetSample;
import com.arcway.repository.interFace.data.object.IRepositoryIterator_IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObject;
import com.arcway.repository.interFace.data.object.IRepositoryObjectReference;
import com.arcway.repository.interFace.data.object.IRepositoryObjectSample;
import com.arcway.repository.interFace.dataaccess.EXNotReproducibleSnapshot;
import com.arcway.repository.interFace.dataaccess.IRepositoryInterfaceRO;
import com.arcway.repository.interFace.dataaccess.IRepositorySnapshotRO;
import com.arcway.repository.interFace.dataaccess.IWithCurrentSnapshotProcessor;
import com.arcway.repository.interFace.dataaccess.RepositoryInterfaces;
import com.arcway.repository.interFace.declaration.type.relationcontribution.IRepositoryRelationContributionRoleID;
import com.arcway.repository.interFace.importexport.IRepositorySnippetRO;
import com.arcway.repository.interFace.registration.type.IRepositoryTypeManagerRO;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataType;
import com.arcway.repository.interFace.registration.type.data.IRepositoryDataTypeParameters;
import com.arcway.repository.interFace.registration.type.object.IRepositoryObjectType;
import com.arcway.repository.interFace.registration.type.property.IRepositoryPropertyType;
import com.arcway.repository.interFace.registration.type.relation.ICrossLinkRepositoryRelationType;
import com.arcway.repository.interFace.registration.type.relationcontribution.ICrossLinkRepositoryRelationContributionType;
import com.arcway.repository.lib.high.genericmodifications.interFace.transactions.RepositoryObjectSampleWithParentObjectReference;
import com.arcway.repository.lib.high.implementation.access.RepositoryObjectReference;
import com.arcway.repository.lib.high.registration.data.lib.AbstractRepositoryDataTypeEnumeration;
import com.arcway.repository.lib.high.registration.data.lib.RDTBoolean;
import com.arcway.repository.lib.high.registration.data.lib.RDTSingleChoice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SourceAttributeDescription
implements ISourceAttributeDescription<CockpitAttributeReference, CockpitDataTypeReference, CockpitValueReference> {
    private static final String EmptyEnumValueLabel = Messages.getString("SourceAttributeDescription.EmptyEnumValue.Label");
    private final CockpitAttributeReference cockpitAttribute;
    private final CockpitDataTypeReference cockpitDataType;
    private final IRepositoryTypeManagerRO typeManager;
    private IRepositoryPropertyType propertyType;
    private ICrossLinkRepositoryRelationType relationType;
    private IRepositoryRelationContributionRoleID roleID;
    private ILinkedAttributeValueRetriever linkedAttributeRetriever;
    private ICrossLinkRepositoryRelationContributionType linkedAttributeContributionType;
    private static final Comparator<EnumValue<CockpitValueReference>> LINKED_ATTRIBUTE_VALUE_COMPARATOR = new Comparator<EnumValue<CockpitValueReference>>(){

        @Override
        public int compare(EnumValue<CockpitValueReference> o1, EnumValue<CockpitValueReference> o2) {
            return o1.getLabel().compareToIgnoreCase(o2.getLabel());
        }
    };

    public SourceAttributeDescription(IRepositoryPropertyType cockpitProperty, IRepositoryTypeManagerRO typeManager) {
        this.cockpitAttribute = new CockpitAttributeReference(CockpitAttributeReference.AttributeType.Property, cockpitProperty.getRepositoryPropertyTypeID());
        this.cockpitDataType = new CockpitDataTypeReference(CockpitDataTypeReference.DataTypeType.Property, cockpitProperty.getDataType().getRepositoryDataTypeID());
        this.propertyType = cockpitProperty;
        this.typeManager = typeManager;
    }

    public SourceAttributeDescription(ICrossLinkRepositoryRelationType cockpitLinkedAttribute, IRepositoryRelationContributionRoleID roleID, IRepositoryInterfaceRO repositoryInterface, IRepositoryTypeManagerRO typeManager) {
        this.cockpitAttribute = new CockpitAttributeReference(CockpitAttributeReference.AttributeType.LinkedAttribute, new CockpitAttributeReference.RelationTypeAndContribution(cockpitLinkedAttribute.getRepositoryRelationTypeID(), roleID));
        this.cockpitDataType = new CockpitDataTypeReference(CockpitDataTypeReference.DataTypeType.LinkedAttribute, null);
        this.relationType = cockpitLinkedAttribute;
        this.roleID = roleID;
        this.linkedAttributeRetriever = new LinkedAttributeRetriever_ByRepositoryInterface(repositoryInterface);
        this.typeManager = typeManager;
        this.determineLinkedAttributeContributionType();
    }

    public SourceAttributeDescription(ICrossLinkRepositoryRelationType cockpitLinkedAttribute, IRepositoryRelationContributionRoleID roleID, IRepositorySnippetRO repositorySnippet, IRepositoryTypeManagerRO typeManager) {
        this.cockpitAttribute = new CockpitAttributeReference(CockpitAttributeReference.AttributeType.LinkedAttribute, new CockpitAttributeReference.RelationTypeAndContribution(cockpitLinkedAttribute.getRepositoryRelationTypeID(), roleID));
        this.cockpitDataType = new CockpitDataTypeReference(CockpitDataTypeReference.DataTypeType.LinkedAttribute, null);
        this.relationType = cockpitLinkedAttribute;
        this.roleID = roleID;
        this.linkedAttributeRetriever = new LinkedAttributeRetriever_ByRepositorySnippet(repositorySnippet);
        this.typeManager = typeManager;
        this.determineLinkedAttributeContributionType();
    }

    private void determineLinkedAttributeContributionType() {
        ICollection_ contributionTypes = this.relationType.getAllRelationContributionTypes();
        assert (contributionTypes.size() == 2);
        for (ICrossLinkRepositoryRelationContributionType contributionType : contributionTypes) {
            if (IRepositoryRelationContributionRoleID.IS_EQUAL_RELATION_CONTRIBUTION_ROLE_ID_HASHER.isEqual((Object)contributionType.getRepositoryRelationContributionRoleID(), (Object)this.roleID)) continue;
            this.linkedAttributeContributionType = contributionType;
            break;
        }
    }

    public CockpitAttributeReference getKey() {
        return this.cockpitAttribute;
    }

    public CockpitDataTypeReference getDataTypeKey() {
        return this.cockpitDataType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<EnumValue<CockpitValueReference>> getValueRange() {
        ArrayList<EnumValue<CockpitValueReference>> valueRange = new ArrayList<EnumValue<CockpitValueReference>>();
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager((IRepositoryTypeManagerRO)this.typeManager);
        PresentationContext presentationContext = PresentationContext.getVirtualMachineUserLocaleForNow();
        if (this.cockpitAttribute.getAttributeType() == CockpitAttributeReference.AttributeType.Property) {
            IRepositoryDataType dataType = this.propertyType.getDataType();
            IFrontendPropertyType frontendPropertyType = frontendTypeManager.getFrontendPropertyType(this.propertyType);
            IFrontendDataType frontendDataType = frontendTypeManager.getFrontendDataType(dataType);
            IFrontendDataTypeParameters frontendDataTypeParameters = frontendPropertyType.getFrontendDataTypeParameters();
            if (dataType instanceof RDTSingleChoice) {
                RDTSingleChoice singleChoiceDataType = (RDTSingleChoice)dataType;
                AbstractRepositoryDataTypeEnumeration.EnumerationParameters singleChoiceParameters = (AbstractRepositoryDataTypeEnumeration.EnumerationParameters)this.propertyType.getDataTypeParameters();
                if (!singleChoiceParameters.isSetAlways()) {
                    valueRange.add((EnumValue<CockpitValueReference>)new EnumValue((Object)new CockpitValueReference(CockpitValueReference.ValueType.Enumeration, null), "", EmptyEnumValueLabel, EmptyEnumValueLabel));
                }
                for (String value : singleChoiceParameters.getValues()) {
                    String label = frontendDataType.getLabelForValue(singleChoiceDataType.createData(value), (IRepositoryDataTypeParameters)singleChoiceParameters, frontendDataTypeParameters, presentationContext).getText();
                    valueRange.add((EnumValue<CockpitValueReference>)new EnumValue((Object)new CockpitValueReference(CockpitValueReference.ValueType.Enumeration, value), label, label));
                }
                return valueRange;
            } else {
                if (!(dataType instanceof RDTBoolean)) return null;
                RDTBoolean booleanDataType = (RDTBoolean)dataType;
                RDTBoolean.Parameters booleanParameters = (RDTBoolean.Parameters)this.propertyType.getDataTypeParameters();
                if (!booleanParameters.isSetAlways()) {
                    valueRange.add((EnumValue<CockpitValueReference>)new EnumValue((Object)new CockpitValueReference(CockpitValueReference.ValueType.Boolean, null), "", EmptyEnumValueLabel, EmptyEnumValueLabel));
                }
                String trueLabel = frontendDataType.getLabelForValue(booleanDataType.createData(Boolean.TRUE), (IRepositoryDataTypeParameters)booleanParameters, frontendDataTypeParameters, presentationContext).getText();
                EnumValue trueEnumValue = new EnumValue((Object)new CockpitValueReference(CockpitValueReference.ValueType.Boolean, Boolean.TRUE), trueLabel, trueLabel);
                String falseLabel = frontendDataType.getLabelForValue(booleanDataType.createData(Boolean.FALSE), (IRepositoryDataTypeParameters)booleanParameters, frontendDataTypeParameters, presentationContext).getText();
                EnumValue falseEnumValue = new EnumValue((Object)new CockpitValueReference(CockpitValueReference.ValueType.Boolean, Boolean.FALSE), falseLabel, falseLabel);
                valueRange.add((EnumValue<CockpitValueReference>)trueEnumValue);
                valueRange.add((EnumValue<CockpitValueReference>)falseEnumValue);
            }
            return valueRange;
        } else {
            boolean isMandatory;
            if (this.cockpitAttribute.getAttributeType() != CockpitAttributeReference.AttributeType.LinkedAttribute) return valueRange;
            boolean bl = isMandatory = this.relationType.getRelationContributionType(this.roleID).getCardinality().getMinimum() > 0;
            if (!isMandatory) {
                valueRange.add((EnumValue<CockpitValueReference>)new EnumValue((Object)new CockpitValueReference(CockpitValueReference.ValueType.LinkedAttribute, null), "", EmptyEnumValueLabel, EmptyEnumValueLabel));
            }
            ArrayList<EnumValue<CockpitValueReference>> nonEmptyLinkedAttributeValues = new ArrayList<EnumValue<CockpitValueReference>>(this.linkedAttributeRetriever.retrieveLinkedAttributeValues(this.linkedAttributeContributionType.getRelatedObjectType(), frontendTypeManager, presentationContext));
            Collections.sort(nonEmptyLinkedAttributeValues, LINKED_ATTRIBUTE_VALUE_COMPARATOR);
            valueRange.addAll(nonEmptyLinkedAttributeValues);
        }
        return valueRange;
    }

    public String getName() {
        IFrontendTypeManager frontendTypeManager = FrontendTypeManager.getFrontendTypeManager((IRepositoryTypeManagerRO)this.typeManager);
        if (this.cockpitAttribute.getAttributeType() == CockpitAttributeReference.AttributeType.Property) {
            IFrontendPropertyType frontendPropertyType = frontendTypeManager.getFrontendPropertyType(this.propertyType);
            return frontendPropertyType.getLabel().getText();
        }
        if (this.cockpitAttribute.getAttributeType() == CockpitAttributeReference.AttributeType.LinkedAttribute) {
            IFrontendRelationType frontendRelationType = frontendTypeManager.getFrontendRelationType(this.relationType);
            IFrontendRelationContributionType frontendContributionType = frontendRelationType.getFrontendRelationContributionType(this.linkedAttributeContributionType);
            return frontendContributionType.getLabel().getText();
        }
        assert (false);
        return "";
    }

    public String getLabel() {
        return this.getName();
    }

    public String getTooltip() {
        return this.getName();
    }

    private static interface ILinkedAttributeValueRetriever {
        public Collection<EnumValue<CockpitValueReference>> retrieveLinkedAttributeValues(IRepositoryObjectType var1, IFrontendTypeManager var2, PresentationContext var3);
    }

    private static class LinkedAttributeRetriever_ByRepositoryInterface
    implements ILinkedAttributeValueRetriever {
        private final IRepositoryInterfaceRO repositoryInterface;

        public LinkedAttributeRetriever_ByRepositoryInterface(IRepositoryInterfaceRO repositoryInterface) {
            this.repositoryInterface = repositoryInterface;
        }

        @Override
        public Collection<EnumValue<CockpitValueReference>> retrieveLinkedAttributeValues(final IRepositoryObjectType linkedAttributeObjectType, final IFrontendTypeManager frontendTypeManager, final PresentationContext presentationContext) {
            final ArrayList<EnumValue<CockpitValueReference>> valueRange = new ArrayList<EnumValue<CockpitValueReference>>();
            RepositoryInterfaces.doWithCurrentSnapshot((IRepositoryInterfaceRO)this.repositoryInterface, (IWithCurrentSnapshotProcessor)new IWithCurrentSnapshotProcessor(){

                public void doWithCurrentSnapshot(IRepositorySnapshotRO repositorySnapshot) throws EXNotReproducibleSnapshot {
                    IRepositoryIterator_IRepositoryObject linkedAttributeObjectsIterator = repositorySnapshot.findAllObjectOfType(linkedAttributeObjectType);
                    while (linkedAttributeObjectsIterator.hasNext()) {
                        IRepositoryObject linkedAttributeObject = linkedAttributeObjectsIterator.nextIRepositoryObject();
                        RepositoryObjectReference linkedAttributeObjectReference = new RepositoryObjectReference(linkedAttributeObject);
                        String linkedAttributeObjectLabel = frontendTypeManager.getLabelForObject(linkedAttributeObject, presentationContext).getText();
                        EnumValue enumValue = new EnumValue((Object)new CockpitValueReference(CockpitValueReference.ValueType.LinkedAttribute, new CockpitValueReference.ObjectReferenceAndTypeManager((IRepositoryObjectReference)linkedAttributeObjectReference, repositoryInterface.getTypeManager())), linkedAttributeObjectLabel, linkedAttributeObjectLabel);
                        valueRange.add(enumValue);
                    }
                }
            });
            return valueRange;
        }
    }

    private static class LinkedAttributeRetriever_ByRepositorySnippet
    implements ILinkedAttributeValueRetriever {
        private final IRepositorySnippetRO repositorySnippet;

        public LinkedAttributeRetriever_ByRepositorySnippet(IRepositorySnippetRO repositorySnippet) {
            this.repositorySnippet = repositorySnippet;
        }

        @Override
        public Collection<EnumValue<CockpitValueReference>> retrieveLinkedAttributeValues(IRepositoryObjectType linkedAttributeObjectType, IFrontendTypeManager frontendTypeManager, PresentationContext presentationContext) {
            ArrayList<EnumValue<CockpitValueReference>> valueRange = new ArrayList<EnumValue<CockpitValueReference>>();
            for (RepositoryObjectSampleWithParentObjectReference objectSample : this.repositorySnippet.getExplicitObjects()) {
                this.handleObjectSample(objectSample.getObjectSample(), linkedAttributeObjectType, valueRange, frontendTypeManager, presentationContext);
            }
            for (RepositoryObjectSampleWithParentObjectReference objectSample : this.repositorySnippet.getImplicitObjects()) {
                this.handleObjectSample(objectSample.getObjectSample(), linkedAttributeObjectType, valueRange, frontendTypeManager, presentationContext);
            }
            for (RepositoryObjectSampleWithParentObjectReference objectSample : this.repositorySnippet.getContextObjects()) {
                this.handleObjectSample((IRepositoryObjectSample)objectSample, linkedAttributeObjectType, valueRange, frontendTypeManager, presentationContext);
            }
            return valueRange;
        }

        private void handleObjectSample(IRepositoryObjectSample objectSample, IRepositoryObjectType objectType, Collection<EnumValue<CockpitValueReference>> valueRange, IFrontendTypeManager frontendTypeManager, PresentationContext presentationContext) {
            IRepositoryObjectType objectTypeOfSample = frontendTypeManager.getRepositoryTypeManager().findObjectType(objectSample.getObjectTypeID());
            if (objectType.isSuperTypeOf(objectTypeOfSample)) {
                IRepositoryPropertySetSample linkedAttributeObjectID = objectSample.getObjectID(frontendTypeManager.getRepositoryTypeManager());
                RepositoryObjectReference linkedAttributeObjectReference = new RepositoryObjectReference(objectTypeOfSample.getRepositoryObjectTypeID(), linkedAttributeObjectID);
                String linkedAttributeObjectLabel = frontendTypeManager.getLabelForObject(objectSample, presentationContext).getText();
                EnumValue enumValue = new EnumValue((Object)new CockpitValueReference(CockpitValueReference.ValueType.LinkedAttribute, new CockpitValueReference.ObjectReferenceAndTypeManager((IRepositoryObjectReference)linkedAttributeObjectReference, frontendTypeManager.getRepositoryTypeManager())), linkedAttributeObjectLabel, linkedAttributeObjectLabel);
                valueRange.add((EnumValue<CockpitValueReference>)enumValue);
            }
        }
    }
}

